<!doctype html>
<?php $locale = app()->getLocale(); ?>
<html class="no-js <?php echo e($locale === 'ar' ? 'rtl' : 'ltr'); ?>" lang="<?php echo e($locale); ?>" dir="<?php echo e($locale === 'ar' ? 'rtl' : 'ltr'); ?>">
<!-- Current Locale: <?php echo e($locale); ?> -->

<head>
   <meta charset="utf-8">
   <meta http-equiv="x-ua-compatible" content="ie=edge">
   <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
   <title> وزارة الشباب والرياضة</title>
   <meta name="description" content="">
   <meta name="viewport" content="width=device-width, initial-scale=1">
   <link rel="shortcut icon" type="image/x-icon" href="assets/img/logo/favicon.png">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/swiper-bundle.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/swiper-bundle.css')); ?>">
   <script src="<?php echo e(asset('assets/js/swiper-bundle.js')); ?>"></script>
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.min.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/slick.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/custom-animation.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/nice-select.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/font-awesome-pro.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/line-awesome.min.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/magnific-popup.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/spacing.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/main.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/direction.css')); ?>">
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/room-cards.css')); ?>"> 
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/language-selector.css')); ?>">
   <?php if(app()->getLocale() === 'ar'): ?>
   <link rel="stylesheet" href="<?php echo e(asset('assets/css/rtl.css')); ?>"> 
   <?php endif; ?>
   <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
   <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <?php echo $__env->yieldContent('styles'); ?>
</head>

<body id="body" class="it-magic-cursor">
    <div class="page-wrapper">
        <?php echo $__env->make('layouts.header', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        
        <main class="main-content">
            <?php echo $__env->yieldContent('content'); ?>
        </main>
        
        <?php echo $__env->make('layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    </div>
    


<script src="<?php echo e(asset('assets/js/jquery.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/bootstrap.bundle.min.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/ordain-it.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/three.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/hover-img-effect.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/magnific-popup.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/purecounter.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/range-slider.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/nice-select.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/swiper-bundle.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/isotope-pkgd.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/imagesloaded-pkgd.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/slider.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/wow.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/main.js')); ?>"></script>
   <script src="<?php echo e(asset('assets/js/app.js')); ?>"></script>
    <?php echo $__env->yieldContent('scripts'); ?>


   <script>
      document.addEventListener('DOMContentLoaded', function() {
         const MAX_LENGTH = 100;
         const links = document.querySelectorAll(".news-title");
         links.forEach(link => {
            const text = link.textContent.trim();
            if (text.length > MAX_LENGTH) {
               link.textContent = text.substring(0, MAX_LENGTH) + "…";
            }
         });

         const languageDropdown = document.querySelector('.language-dropdown');
         const languageButton = languageDropdown.querySelector('button');
         const languageOptions = languageDropdown.querySelector('.language-options');

         languageButton.addEventListener('click', function(e) {
            e.stopPropagation();
            languageOptions.style.display = languageOptions.style.display === 'none' ? 'block' : 'none';
         });

         document.addEventListener('click', function() {
            languageOptions.style.display = 'none';
         });

         languageOptions.addEventListener('click', function(e) {
            e.stopPropagation();
         });

         const languageOptionLinks = languageOptions.querySelectorAll('.language-option');
         languageOptionLinks.forEach(link => {
            link.addEventListener('click', function(e) {
               e.preventDefault();
               const selectedLang = this.getAttribute('data-lang');
               languageOptions.style.display = 'none';
            });
         });
      });
   </script>
   <script>
      document.addEventListener('DOMContentLoaded', function() {
         new Swiper('.hero-slider', {
            slidesPerView: 1,
            loop: true,
            autoplay: {
               delay: 5000,
            },
            pagination: {
               el: '.swiper-pagination',
               clickable: true,
            },
         });

         const mapPoints = [
            { top: '20%', left: '55%', title: 'دار الشباب تونس' },
            { top: '45%', left: '35%', title: 'دار الشباب سوسة' },
            { top: '40%', left: '49%', title: 'دار الشباب صفاقس' },
            { top: '35%', left: '40%', title: 'دار الشباب القيروان' },
            { top: '55%', left: '45%', title: 'دار الشباب قفصة' }
         ];

         const mapContainer = document.getElementById('map-points');
         mapPoints.forEach(point => {
            const pointDiv = document.createElement('div');
            pointDiv.className = 'map-point';
            pointDiv.style.top = point.top;
            pointDiv.style.left = point.left;
            
            const tooltip = document.createElement('div');
            tooltip.className = 'tooltip';
            tooltip.textContent = point.title;
            tooltip.style.bottom = '20px';
            
            pointDiv.appendChild(tooltip);
            mapContainer.appendChild(pointDiv);
         });
      });
   </script> 
  <script>
   function toggleProfileDropdown() {
       const dropdown = document.getElementById('ProfileDropdown');
       if (dropdown.style.display === 'none' || dropdown.style.display === '') {
           dropdown.style.display = 'block';
       } else {
           dropdown.style.display = 'none';
       }
   }

   document.addEventListener('click', function(event) {
       const dropdown = document.getElementById('ProfileDropdown');
       const button = document.querySelector('.profil-dropdown button');

       if (!dropdown.contains(event.target) && !button.contains(event.target)) {
           dropdown.style.display = 'none';
       }
   });
</script>



</body>

</html>
<?php /**PATH /home/preprov/www/mjs/front/resources/views/layouts/app.blade.php ENDPATH**/ ?>