<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<style>
.stylish-btn {
    padding: 10px 25px;
    font-size: 1rem;
    border-radius: 12px;
    transition: all 0.3s ease;
    font-weight: bold;
    box-shadow: 0 3px 8px rgba(0, 0, 0, 0.15);
}

.stylish-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.25);
}

@media print {
    .action-buttons,
    .navbar,
    .footer,
    header,
    footer {
        display: none !important;
    }

    @page {
        margin: 0;
    }

    body {
        margin: 1cm;
        font-size: 14px;
        line-height: 1.6;
    }

    * {
        color: #000 !important;
        background: transparent !important;
        box-shadow: none !important;
    }
}

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span><?php echo e(__('site.breadcrumb_home')); ?></span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span><?php echo e(__('site.breadcrumb_investment')); ?></span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('jeune_enfant.index')); ?>">
                <span><?php echo e(__('site.project_spaces_title')); ?></span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('site.page_show_form')); ?></li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4" action="<?php echo e(route('jeune_enfant.update', $projet->id_projet)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?> 
        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
        <div class="text-center mb-4">
            
            <h3 class="fw-bold"><?php echo e(trans_field($formulaire, 'type')); ?></h3>
        </div>
<br>
        <div>
            <div class="d-flex align-items-center mb-3">
                <h5 class="mb-0 fw-bold me-2"><?php echo e(__('site.start_activity.current_status')); ?></h5>

                <?php
                    // prefer translation from related statut record when available
                    $statutText = trans_field($projet->statut, 'statut') ?? null;
                ?>

                <?php if($projet->id_statut == 1): ?>
                    <span><strong><?php echo e($statutText ?? __('site.start_activity.status.accepted')); ?></strong></span>
                <?php elseif($projet->id_statut == 3): ?>
                    <span><strong><?php echo e($statutText ?? __('site.start_activity.status.rejected')); ?></strong></span>
                <?php else: ?>
                    <span><strong><?php echo e($statutText ?? __('site.start_activity.status.pending')); ?></strong></span>
                <?php endif; ?>
            </div>

            <?php if($projet->id_statut == 3 && !empty($projet->commentaire_motif)): ?>
                <div class="d-flex align-items-center mb-3">
                    <label class="fw-bold text-danger me-2 mb-0"><?php echo e(__('site.start_activity.rejection_reason_label')); ?></label>
                    <p class="mb-0 border p-2 rounded shadow-sm text-muted"><?php echo e($projet->commentaire_motif); ?></p>
                </div>
            <?php endif; ?>
        </div>

        <div class="form-section">
            <h4><?php echo e(__('site.start_activity.owner_identity_title')); ?></h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.full_name_label')); ?></label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0"><?php echo e($projet->investissements->first()?->utilisateur->nom_prenom ?? __('site.not_specified')); ?></div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.place_of_birth')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->investissements->first()?->utilisateur->lieu_naissance ?? __('site.not_specified')); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.date_of_birth')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->investissements->first()?->utilisateur->date_naissance ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.identity_type_label')); ?></label>
               <div class="col-sm-4"> 
    <div class="form-control bg-white border-0">
        <?php echo e(trans_field($projet->investissements->first()?->utilisateur?->typeIdentite, 'type') ?? __('site.not_specified')); ?>

    </div>
</div>


                <?php
                    $typeIdentite = $projet->investissements->first()?->utilisateur->id_type_identite;
                ?>

                <?php if($typeIdentite == 1): ?>
                    <div class="col-sm-6">
                        <div class="form-control bg-white border-0">
                            <?php echo e($projet->investissements->first()?->utilisateur->cin ?? __('site.not_specified')); ?>

                        </div>
                    </div>
                <?php elseif($typeIdentite == 2): ?>
                    <div class="col-sm-6">
                        <div class="form-control bg-white border-0">
                            <?php echo e($projet->investissements->first()?->utilisateur->passport ?? __('site.not_specified')); ?>

                        </div>
                    </div>
                <?php elseif($typeIdentite == 3): ?>
                    <div class="col-sm-6">
                        <div class="form-control bg-white border-0">
                            <?php echo e($projet->investissements->first()?->utilisateur->num_fiscal ?? __('site.not_specified')); ?>

                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <?php
                $user = $projet->investissements->first()?->utilisateur;
            ?>

            <?php if($user && $user->id_type_identite == 1): ?>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_issue_date_label')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->date_delivrance_cin ?? __('site.not_specified')); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_issue_place_label')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->lieu_delivrance_cin ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.personal_address')); ?></label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->adresse ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.education_level')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->niveau_etude ?? __('site.not_specified')); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.last_degree')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->dernier_diplome ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.experience_label')); ?></label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->investissements->first()?->utilisateur->experience ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>
        </div>

        
        <div class="form-section mt-4">
            <h4><?php echo e(__('site.project_characteristics')); ?></h4>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_spectacle" value="0"> 
                <input class="form-check-input me-2 bg-white" type="checkbox" id="espace_spectacle" name="espace_spectacle" value="1"
                    <?php echo e($projet->espace_spectacle ? 'checked' : ''); ?> disabled>
                <label class="col-sm-6 col-form-label" for="espace_spectacle">
                    <?php echo e(__('site.espace_spectacle_label')); ?>

                </label>
            </div>

            <div class="mt-3" id="caracteristique_group" style="display:<?php echo e($projet->espace_spectacle ? 'block' : 'none'); ?>;">
                <textarea class="form-control shadow-sm rounded-3 bg-white" readonly 
                        placeholder="<?php echo e(__('site.characteristics_placeholder')); ?>" rows="3"><?php echo e($projet->caracteristique_spec); ?></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input readonly type="hidden" name="espace_sportif" value="0"> 
                <input readonly class="form-check-input me-2 bg-white" type="checkbox" id="espace_sportif" name="espace_sportif" value="1" disabled
                       <?php echo e(old('espace_sportif', $projet->espace_sportif) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="espace_sportif"><?php echo e(__('site.espace_sportif_label')); ?></label>
            </div>
            <div class="mt-3" id="caracteristique_sportif_group" style="display:<?php echo e($projet->espace_sportif ? 'block' : 'none'); ?>;">
                <textarea readonly class="form-control shadow-sm rounded-3 bg-white" name="caracteristique_sportif" rows="3"><?php echo e(old('caracteristique_sportif', $projet->caracteristique_sportif)); ?></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input readonly type="hidden" name="espace_activite_service" value="0"> 
                <input readonly class="form-check-input me-2 bg-white" type="checkbox" id="espace_activite_service" name="espace_activite_service" value="1" disabled
                       <?php echo e(old('espace_activite_service', $projet->espace_activite_service) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="espace_activite_service"><?php echo e(__('site.espace_service_label')); ?></label>
            </div>
            <div class="mt-3" id="caracteristique_activite_serv_group" style="display:<?php echo e($projet->espace_activite_service ? 'block' : 'none'); ?>;">
                <textarea readonly class="form-control shadow-sm rounded-3 bg-white" name="caracteristique_activite_serv" rows="3"><?php echo e(old('caracteristique_activite_serv', $projet->caracteristique_activite_serv)); ?></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input readonly type="hidden" name="espace_activite_culturelle" value="0"> 
                <input readonly class="form-check-input me-2 bg-white" type="checkbox" id="espace_activite_culturelle" name="espace_activite_culturelle" value="1" disabled
                       <?php echo e(old('espace_activite_culturelle', $projet->espace_activite_culturelle) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="espace_activite_culturelle"><?php echo e(__('site.espace_culturel_label')); ?></label>
            </div>
            <div class="mt-3" id="caracteristique_activite_cult_group" style="display:<?php echo e($projet->espace_activite_culturelle ? 'block' : 'none'); ?>;">
                <textarea readonly class="form-control shadow-sm rounded-3 bg-white" name="caracteristique_activite_cult" rows="3"><?php echo e(old('caracteristique_activite_cult', $projet->caracteristique_activite_cult)); ?></textarea>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4><?php echo e(__('site.table_project_nature')); ?></h4>
            <div class="row align-items-center">
                <div class="col-sm-2">
                    <label class="col-sm-10 col-form-label"><?php echo e(__('site.select_project_nature')); ?></label>
                </div>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        
                        <?php echo e(trans_field($projet->natureProjet, 'nature') ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4><?php echo e(__('site.number_positions_title')); ?></h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.holders_degree_label')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->nbr_diplome_universitaire ?? __('site.not_specified')); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.others_label')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->nbr_autre ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4><?php echo e(__('site.director_title')); ?></h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.full_name_label')); ?></label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->directeur->nom_prenom_d ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_label')); ?></label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->directeur->num_cin ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_issue_date_label')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->directeur->date_delivrance ?? __('site.not_specified')); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_issue_place_label')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->directeur->lieu_delivrance ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.education_level')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->directeur->niveau_etude ?? __('site.not_specified')); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.last_degree')); ?></label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($projet->directeur->dernier_diplome_obtenu ?? __('site.not_specified')); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4><?php echo e(__('site.investment_finance_title')); ?></h4>
            <table class="custom-table">
                <thead>
                    <tr>
                        <th><?php echo e(__('site.investment_label')); ?></th>
                        <th><?php echo e(__('site.amount_label')); ?></th>
                        <th><?php echo e(__('site.fund_sources_label')); ?></th>
                        <th><?php echo e(__('site.notes_label')); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $projet->investissements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td><?php echo e(trans_field($inv, 'secteur_ar') ?? $inv->secteur_invest_id); ?></td>
                        <td><?php echo e($inv->montant_inv); ?></td>
                        <td><?php echo e($inv->source); ?></td>
                        <td><?php echo e($inv->remarques); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <span class="text-muted"><?php echo e(__('site.funds_examples')); ?></span>

        <div class="mt-3">
            <h4><?php echo e(__('site.declaration_title')); ?></h4>
            <span>
                <?php echo e(__('site.declaration_text')); ?>

            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4><?php echo e(__('site.remarks_title')); ?></h4>
            <textarea class="form-control mt-2 bg-white" name="remarques" readonly rows="6" placeholder="<?php echo e(__('site.write_remarks_placeholder')); ?>"><?php echo e(old('remarques', $projet->remarques)); ?></textarea>
        </div> 

        <div class="form-group row justify-content-center action-buttons d-print-none" style="padding-top:50px;">
            <div class="col-auto">
                <button type="button" onclick="window.print()" 
    class="btn btn-success" 
    style="width:120px; height:40px; display:flex; align-items:center; justify-content:center; gap:6px;">
    <i class="fa fa-print"></i> <?php echo e(__('site.print')); ?>

</button>
            </div>
           
        </div>
    </form>
</div>
</div>
<?php else: ?>
<script>
    window.location.href = "<?php echo e(route('login')); ?>";
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_jeune_enfant/show.blade.php ENDPATH**/ ?>