<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('jeune_enfant.index')); ?>">
                <span>الفضاءات الترفيهية للشباب و الطفولة</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">إضافة استمارة</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4" action="<?php echo e(route('jeune_enfant.store')); ?>" method="POST" enctype="multipart/form-data" lang="ar">
        <?php echo csrf_field(); ?>
            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
            
              <div class="text-center mb-4">

            <h3 class="fw-bold"><?php echo e($formulaire->type_ar); ?></h3>
        </div>
            
            <div class="form-section">
                <h4>المستثمر</h4>
                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" name="nom_prenom" value="<?php echo e(old('nom_prenom', Auth::user()->nom_prenom ?? '')); ?>" readonly>
                    </div>
                </div>


                        <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="lieu_naissance" value="<?php echo e(old('lieu_naissance', Auth::user()->lieu_naissance ?? '')); ?>" readonly>
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" name="date_naissance"  value="<?php echo e(old('date_naissance', Auth::user()->date_naissance ?? '')); ?>" readonly>
                </div>
            </div>
            
           <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <input type="text" class="form-control" 
                        value="<?php echo e(Auth::user()->typeIdentite->type_ar ?? ''); ?>" 
                        readonly>
                </div>

                    <?php $user = Auth::user(); ?>

                    <?php if($user->id_type_identite == 1): ?>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" value="<?php echo e($user->cin ?? ''); ?>" readonly>
                        </div>
                    <?php elseif($user->id_type_identite == 2): ?>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" value="<?php echo e($user->passport ?? ''); ?>" readonly>
                        </div>
                    <?php elseif($user->id_type_identite == 3): ?>
                        <div class="col-sm-6">
                            <input type="text" class="form-control" value="<?php echo e($user->num_fiscal ?? ''); ?>" readonly>
                        </div>
                    <?php endif; ?>
                </div>

                <?php if($user->id_type_identite == 1): ?>
                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">تاريخ الإصدار</label>
                    <div class="col-sm-4">
                        <input type="date" class="form-control" 
                            value="<?php echo e($user->date_delivrance_cin ? \Carbon\Carbon::parse($user->date_delivrance_cin)->format('Y-m-d') : ''); ?>" 
                            readonly>
                    </div>

                    <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                    <div class="col-sm-4">
                        <input type="text" class="form-control" value="<?php echo e($user->lieu_delivrance_cin ?? ''); ?>" readonly>
                    </div>
                </div>
                <?php endif; ?>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" value="<?php echo e(old('adresse', Auth::user()->adresse ?? '')); ?>" readonly>
                </div>
            </div>
            

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" value="<?php echo e(old('niveau_etude', Auth::user()->niveau_etude ?? '')); ?>" readonly>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" value="<?php echo e(old('dernier_diplome', Auth::user()->dernier_diplome ?? '')); ?>" readonly>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" value="<?php echo e(old('experience', Auth::user()->experience ?? '')); ?>" readonly>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>خصائص المشروع الترفيهي</h4>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_spectacle" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_spectacle" name="espace_spectacle" value="1">
                <label class="col-sm-6 col-form-label" for="espace_spectacle">
                    فضاءات ترفيهية و الهواء الطلق و العروض
                </label>
            </div>
            <div class="mt-3" id="caracteristique_group" style="display:none;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_spec" placeholder="خصوصياتها" rows="3"></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_sportif" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_sportif" name="espace_sportif" value="1">
                <label class="col-sm-6 col-form-label" for="espace_sportif">
                    فضاءات ترفيهية رياضية
                </label>
            </div>
            <div class="mt-3" id="caracteristique_sportif_group" style="display:none;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_sportif" placeholder="خصوصياتها" rows="3"></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_service" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_service" name="espace_activite_service" value="1">
                <label class="col-sm-6 col-form-label" for="espace_activite_service">
                    فضاء الأنشطة الخدماتية
                </label>
            </div>
            <div class="mt-3" id="caracteristique_activite_serv_group" style="display:none;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_serv" placeholder="خصوصياتها" rows="3"></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_culturelle" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_culturelle" name="espace_activite_culturelle" value="1">
                <label class="col-sm-6 col-form-label" for="espace_activite_culturelle">
                    فضاء الأنشطة القافية و الفنية و العلمية
                </label>
            </div>
            <div class="mt-3" id="caracteristique_activite_cult_group" style="display:none;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_cult" placeholder="خصوصياتها" rows="3"></textarea>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>طبيعة المشروع</h4>
            <div class="row align-items-center">
                
                <div class="col-sm-2">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        الرجاء اختيار طبيعة المشروع
                    </label>
                </div>
            
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $naturesProjet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($nature->id_nature_p); ?>">
                                <?php echo e($nature->nature_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>


        <div class="form-section mt-4">
            <h4> عدد مواطن الشخل المؤملة </h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">من حاملي الشهادات العلمية</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_diplome_universitaire" placeholder="من حاملي الشهادات العلمية">
                </div>

                <label class="col-sm-2 col-form-label">اخرين</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_autre" placeholder="اخرين">
                </div>
            </div>
        </div>


        <div class="form-section mt-4">
            <h4> مدير المؤسسة </h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" placeholder="الاسم و اللقب   " maxlength="50">
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية  </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" maxlength="8">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance" name="date_delivrance" placeholder="تاريخ إصدار البطاقة">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance" name="lieu_delivrance" placeholder="مكان الإصدار">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome_obtenu" placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>
        </div>

        <h4>بيانات عن الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>المبلغ</th>
                        <th>مصادر التمويل</th>
                        <th>الملاحظات</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[0][secteur_invest_id]" id="secteur_invest_id_0">
                                <option value="" disabled selected>اختر...</option>
                                <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($secteur->id_secteur); ?>"><?php echo e($secteur->secteur_ar); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="المبلغ">
                            <input type="number" name="investissements[0][montant_inv]" class="form-control" placeholder="المبلغ">
                        </td>
                        <td data-label="مصادر التمويل">
                            <input type="text" name="investissements[0][source]" class="form-control" placeholder="مصادر التمويل" maxlength="100">
                        </td>
                        <td data-label="الملاحظات">
                            <input type="text" name="investissements[0][remarques]" class="form-control" placeholder="الملاحظات" maxlength="200">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"> <i class="la la-trash"></i>حذف</button>
                        </td>
                    </tr>
                </tbody>
            </table>
            <button type="button" class="btn btn-success" onclick="addInvestissementRow()">
                إضافة صف
            </button>
        </div>
        <span class="text-muted">(*) اموال ذاتية, قروض طويلة المدى, قروض متوسطة المدى, قروض صغيرة المدى, منح, مواد اخرى.</span>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا..."></textarea>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-success font-weight-medium" >إرسال</button>
            </div>
          
        </div>
    </form>
</div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeune-enfant-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });

        // Initialiser les toggles des zones de texte
        initializeToggles();
    });

    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
        
        const updateVisibility = () => {
            textareaGroup.style.display = checkbox.checked ? 'block' : 'none';
        };
        
        checkbox.addEventListener('change', updateVisibility);
        updateVisibility(); // État initial
    }

    function initializeToggles() {
        toggleTextarea('espace_spectacle', 'caracteristique_group');
        toggleTextarea('espace_sportif', 'caracteristique_sportif_group');
        toggleTextarea('espace_activite_service', 'caracteristique_activite_serv_group');
        toggleTextarea('espace_activite_culturelle', 'caracteristique_activite_cult_group');
    }

    let investIndex = 1;
    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($secteur->id_secteur); ?>"><?php echo e($secteur->secteur_ar); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td data-label="المبلغ">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" placeholder="المبلغ">
                </td>
                <td data-label="مصادر التمويل">
                    <input type="text" name="investissements[${investIndex}][source]" class="form-control" placeholder="مصادر التمويل" maxlength="100">
                </td>
                <td data-label="الملاحظات">
                    <input type="text" name="investissements[${investIndex}][remarques]" class="form-control" placeholder="الملاحظات" maxlength="200">
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"> <i class="la la-trash"></i>حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>
</script>

<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_jeune_enfant/create.blade.php ENDPATH**/ ?>