<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>

<?php if(auth()->guard()->check()): ?>


<div class="salle-sport-edit" >
<div class="container">
    <form action="" method="POST" id="myForm"  enctype="multipart/form-data">
        <?php echo csrf_field(); ?>

    <div class="header-print-container mb-4">
        <div class="header-center text-center">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="text-start">
                    <strong><?php echo e(__('site.start_activity.form_number_label')); ?></strong>
                    <?php echo e('00' . $debutActivite->id_debut . '_' .
                        (
                            $debutActivite->immobilier->utilisateur->cin ??
                            $debutActivite->immobilier->utilisateur->passport ??
                            $debutActivite->immobilier->utilisateur->num_fiscal ??
                            '---'
                        ) . '_' . \Carbon\Carbon::now()->format('Y')); ?>

                </div>

                <div class="text-center flex-grow-1 header-center">
                    <h2 class="mb-0"><?php echo e(__('site.republic')); ?></h2>
                    <h2 class="mb-0"><?php echo e(__('site.ministry_name')); ?></h2>
                    <h3 class="mb-0"><?php echo e(__('site.start_activity.form_title')); ?></h3>
                </div>

                <div style="width: 150px;"></div>
            </div>
        </div>

        <div class="header-side header-right no-print">
            <button type="button" onclick="window.print()" class="btn btn-success">
                <i class="fas fa-print" ></i> <?php echo e(__('site.print')); ?>

            </button>
        </div>
    </div>

    
    <div class="card shadow-lg border-0 mb-4 rounded-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-bold"><?php echo e(__('site.start_activity.current_status')); ?></h5>
            <?php if($debutActivite->id_statut == 1): ?>
                <span class="badge bg-success fs-6"><?php echo e(__('site.start_activity.status.accepted')); ?></span>
            <?php elseif($debutActivite->id_statut == 3): ?>
                <span class="badge bg-danger fs-6"><?php echo e(__('site.start_activity.status.rejected')); ?></span>
            <?php else: ?>
                <span class="badge bg-warning text-dark fs-6"><?php echo e(__('site.start_activity.status.pending')); ?></span>
            <?php endif; ?>
        </div>

        <?php if($debutActivite->id_statut == 3 && $debutActivite->commentaire_motif): ?>
            <div class="card-body">
                <p class="text-danger fw-bold"><?php echo e(__('site.start_activity.rejection_reason_label')); ?></p>
                <p><?php echo e($debutActivite->commentaire_motif); ?></p>
            </div>
        <?php endif; ?>
    </div>

    
    <h4 class="mb-3 fw-bold"><?php echo e(__('site.start_activity.owner_identity_title')); ?></h4>
    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold"><?php echo e(__('site.investment.form.label.full_name')); ?></label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->nom_prenom ?? __('site.not_specified')); ?>" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold"><?php echo e(__('site.start_activity.owner_identity_number')); ?></label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? __('site.not_specified')); ?>" readonly>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold"><?php echo e(__('site.investment.form.label.phone')); ?></label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->tel ?? __('site.not_specified')); ?>" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold"><?php echo e(__('site.investment.form.label.email')); ?></label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->email ?? __('site.not_specified')); ?>" readonly>
        </div>
    </div>

    <h4><?php echo e(__('site.start_activity.start_date_label')); ?></h4>
    <div class="form-group row">
        <div class="col-sm-11">
            <input required type="date" class="form-control" id="date_debut_activite" name="date_debut_activite" value="<?php echo e($debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('Y-m-d') : ''); ?>" readonly>
        </div>
    </div>
    <span><?php echo e(__('site.start_activity.start_date_hint')); ?></span>

    
    <h4 class="mb-3 fw-bold"><?php echo e(__('site.start_activity.attached_documents')); ?></h4>

    <?php
        $docs = [
            'preuve_propriete_location',
            'plan_architectural',
            'declaration_investissement',
            'identification',
            'extrait_registre_national_entreprise',
            'certificat_prevention',
            'contrat_assurance',
            'approbation_autorite_minicipale'
        ];
    ?>

    <?php $__currentLoopData = $docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $label = __('site.start_activity.documents.' . $field . '.label');
            $desc  = __('site.start_activity.documents.' . $field . '.desc');
        ?>

        <div class="mb-2">
            <strong><?php echo e($label ?: ucfirst(str_replace('_', ' ', $field))); ?>: </strong>
            <?php if(!empty($debutActivite->$field)): ?>
                <a href="<?php echo e(asset('storage/'.$debutActivite->$field)); ?>" target="_blank"><?php echo e(__('site.view_file')); ?></a>
            <?php else: ?>
                <span><?php echo e(__('site.not_specified')); ?></span>
            <?php endif; ?>

            <?php if($desc && $desc !== ('site.start_activity.documents.' . $field . '.desc')): ?>
                <div class="small text-muted"><?php echo e($desc); ?></div>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="mt-4 no-print d-flex justify-content-center" style="gap: 10px;">
        <a href="<?php echo e(route('salle-sport.index2')); ?>" class="btn btn-primary d-flex align-items-center">
            <i class="bi bi-arrow-left me-1"></i> <?php echo e(__('site.back')); ?>

        </a>
        <button type="button" onclick="window.print()" class="btn btn-success d-flex align-items-center">
            <i class="fa fa-print me-1"></i> <?php echo e(__('site.print')); ?>

        </button>
    </div>

    </form>
</div>
</div>

<?php else: ?>
    <script>window.location.href = "<?php echo e(route('login')); ?>";</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_salle_sport/debut_activite/show.blade.php ENDPATH**/ ?>