<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('jeunesse2.index')); ?>">
                <span>تنظيم الأنشطة الترفيهية للشباب و الطفولة</span>
            </a>
        </li>
   <li class="breadcrumb-item active" aria-current="page">تعديل استمارة</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <form action="<?php echo e(route('jeunesse2.update', $activite->id_jeune_enfant)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

       <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
     
        <h3><?php echo e($formulaire->type_ar); ?></h3>

        <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="<?php echo e(old('nom_prenom', $activite->investissements->first()?->utilisateur->nom_prenom)); ?>" 
                            placeholder="الاسم و اللقب" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="<?php echo e(old('lieu_naissance', $activite->investissements->first()?->utilisateur->lieu_naissance)); ?>" 
                           placeholder="مكان الولادة">
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="<?php echo e(old('date_naissance', $activite->investissements->first()?->utilisateur->date_naissance)); ?>">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput3()">
                        <option value="" disabled>اختر...</option>
                        <?php $__currentLoopData = $typesIdentite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id_type); ?>" 
                                <?php echo e(old('id_type_identite', $activite->investissements->first()?->utilisateur->id_type_identite) == $type->id_type ? 'selected' : ''); ?>>
                                <?php echo e($type->type_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:<?php echo e($activite->investissements->first()?->utilisateur->id_type_identite == 1 ? 'block' : 'none'); ?>;">
                    <input type="text" class="form-control" id="cin_input" name="cin" 
                           value="<?php echo e(old('cin', $activite->investissements->first()?->utilisateur->cin)); ?>" 
                           placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:<?php echo e($activite->investissements->first()?->utilisateur->id_type_identite == 2 ? 'block' : 'none'); ?>;">
                    <input type="text" class="form-control" id="passport_input" name="passport" 
                           value="<?php echo e(old('passport', $activite->investissements->first()?->utilisateur->passport)); ?>" 
                           placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:<?php echo e($activite->investissements->first()?->utilisateur->id_type_identite == 3 ? 'block' : 'none'); ?>;">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" 
                           value="<?php echo e(old('num_fiscal', $activite->investissements->first()?->utilisateur->num_fiscal)); ?>" 
                           placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3" id="cin_extra_fields" style="display:<?php echo e($activite->investissements->first()?->utilisateur->id_type_identite == 1 ? 'flex' : 'none'); ?>;">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance_cin" name="date_delivrance_cin" 
                           value="<?php echo e(old('date_delivrance_cin', $activite->investissements->first()?->utilisateur->date_delivrance_cin)); ?>">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance_cin" name="lieu_delivrance_cin" 
                           value="<?php echo e(old('lieu_delivrance_cin', $activite->investissements->first()?->utilisateur->lieu_delivrance_cin)); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="<?php echo e(old('adresse', $activite->investissements->first()?->utilisateur->adresse)); ?>" 
                           placeholder=" العنوان الشخصي " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="<?php echo e(old('niveau_etude', $activite->investissements->first()?->utilisateur->niveau_etude)); ?>" 
                           placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" 
                           value="<?php echo e(old('dernier_diplome', $activite->investissements->first()?->utilisateur->dernier_diplome)); ?>" 
                           placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" 
                           value="<?php echo e(old('experience', $activite->investissements->first()?->utilisateur->experience)); ?>" 
                           placeholder="الاقدمية في تعاطي النشاط" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات النشاط </h4>
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> تنظيم الأنشطة الترفيهية للشباب و الطفولة  </strong>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><strong>الإستثمار في هذا النشاط</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" name="id_statut_inv">
                        <?php $__currentLoopData = $statut_inv; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statut): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($statut->id_status); ?>"
                                <?php echo e(old('id_statut_inv', $activite->id_statut_inv) == $statut->id_status ? 'selected' : ''); ?>>
                                <?php echo e($statut->statut_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <label class="col-sm-2 col-form-label"><strong>طبيعة الأنشطة</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" name="id_nature_activite">
                        <?php $__currentLoopData = $nature; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($nature->id_nature_ac); ?>"
                                <?php echo e(old('id_nature_activite', $activite->id_statut_inv) == $nature->id_nature_ac ? 'selected' : ''); ?>>
                                <?php echo e($nature->nature_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" 
                        name="nom_projet" 
                        placeholder="الاسم التجاري للمشروع" 
                        maxlength="100"
                        value="<?php echo e(old('nom_projet', $activite->nom_projet ?? '')); ?>">
                </div>

                <label class="col-sm-2 col-form-label">عنوان المقر الاجتماعي</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" 
                        name="adresse_siege" 
                        placeholder="عنوان المقر الاجتماعي" 
                        maxlength="100"
                        value="<?php echo e(old('adresse_siege', $activite->adresse_siege ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label"> الولاية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled <?php echo e(old('gouvernorat_id', $activite->id_gouvernorat ?? '') == '' ? 'selected' : ''); ?>>اختر...</option>
                        <?php $__currentLoopData = $gouvernorats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gouv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($gouv->id_gouver); ?>" 
                                <?php echo e(old('gouvernorat_id', $activite->id_gouvernorat ?? '') == $gouv->id_gouver ? 'selected' : ''); ?>>
                                <?php echo e($gouv->nom_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <label class="col-sm-2 col-form-label"> البلدية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id">
                        <option value="" disabled <?php echo e(old('delegation_id', $activite->id_delegation ?? '') == '' ? 'selected' : ''); ?>>اختر...</option>
                        <?php $__currentLoopData = $delegations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deleg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($deleg->id_delegation); ?>" 
                                <?php echo e(old('delegation_id', $activite->id_delegation ?? '') == $deleg->id_delegation ? 'selected' : ''); ?>>
                                <?php echo e($deleg->nom_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الترقيم البريدي </label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" 
                        name="code_postal"  value="<?php echo e(old('code_postal', $activite->code_postal ?? '')); ?>"  placeholder="أدخل الترقيم البريدي" >
                </div>
            </div>
        </div>

        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <?php $__currentLoopData = $activite->investissements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[<?php echo e($index); ?>][secteur_invest_id]" id="secteur_invest_id_<?php echo e($index); ?>">
                                <option value="" disabled>اختر...</option>
                                <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($secteur->id_secteur); ?>" 
                                        <?php echo e($inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : ''); ?>>
                                        <?php echo e($secteur->secteur_ar); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[<?php echo e($index); ?>][montant_inv]" 
                                class="form-control" min=1 value="<?php echo e($inv->montant_inv); ?>">
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[<?php echo e($index); ?>][id_source_financement]" id="id_source_financement_<?php echo e($index); ?>">
                                <option value="" disabled>اختر...</option>
                                <?php $__currentLoopData = $source_fin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($source->id_source); ?>" 
                                        <?php echo e($inv->id_source_financement == $source->id_source ? 'selected' : ''); ?>>
                                        <?php echo e($source->source_ar); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[<?php echo e($index); ?>][montant_fin]" 
                                class="form-control" min=1 value="<?php echo e($inv->montant_fin); ?>">
                        </td>
                        <td class="action-buttons">
                           <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <button type="button" class="btn btn-success" onclick="addInvestissementRow()">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا..."><?php echo e(old('remarques', $activite->remarques)); ?></textarea>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
       <div class="d-flex justify-content-end mb-4">
                              <button type="submit" class="btn btn-orange font-weight-medium" >
                    تحيين
                </button>
            </div>
          
        </div>
    </form>
</div>
</div>
<script>
    let investIndex = <?php echo e(count($activite->investissements)); ?>; 

    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($secteur->id_secteur); ?>"><?php echo e($secteur->secteur_ar); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td data-label="مبلغ الإستثمار">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $source_fin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($source->id_source); ?>"><?php echo e($source->source_ar); ?></option>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                <td class="action-buttons">
                   <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>
<script>document.addEventListener("DOMContentLoaded", function () {    const gouvSelect = document.getElementById('gouvernorat_id');    const delSelect  = document.getElementById('delegation_id');    gouvSelect.addEventListener('change', function () {        let gouvId = this.value;        delSelect.innerHTML = '';        delSelect.disabled = true;        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';        let url = "<?php echo e(route('delegations_jeunesse.get', ['gouvernoratId' => 'ID_PLACEHOLDER'])); ?>";        url = url.replace("ID_PLACEHOLDER", gouvId);        fetch(url)            .then(response => response.json())            .then(data => {                                delSelect.innerHTML = '<option disabled selected>اختر...</option>';                                data.forEach(d => {                    let option = document.createElement('option');                    option.value = d.id_delegation;                    option.text  = d.nom_ar;                    delSelect.appendChild(option);                });                delSelect.disabled = false;            });    });});</script>
<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_jeunesse/edit2.blade.php ENDPATH**/ ?>