<?php $__env->startSection('content'); ?>
<?php
    $locale = app()->getLocale();
    $dir = $locale === 'ar' ? 'rtl' : 'ltr';
?>

<section class="it-about-3-area p-relative pt-30 pb-125" dir="<?php echo e($dir); ?>" lang="<?php echo e($locale); ?>">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="<?php echo e(__('site.map_alt')); ?>">

    <div class="container">
        <nav class="breadcrumb-nav" aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(url('/')); ?>">
                        <i class="bi bi-house-fill"></i>
                        <span><?php echo e(__('site.breadcrumb_home')); ?></span>
                    </a>
                </li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('site.concours_page_title')); ?></li>
            </ol>
        </nav>
    </div>

    <div class="container">
        <div class="row">
            <div class="col-12 text-center mb-4">
                <span class="it-section-subtitle"><?php echo e(__('site.services_subtitle')); ?></span>
                <h4 class="it-section-title it-split-in-right mb-0"><?php echo e(__('site.concours_page_title')); ?></h4>
                <p class="text-muted mt-2"><?php echo e(__('site.concours_page_description')); ?></p>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-lg-8 mx-auto">
                <form method="GET" action="<?php echo e(route('concours.available')); ?>" class="d-flex gap-2 align-items-center">
                    <input
                        name="q"
                        value="<?php echo e(old('q', $q ?? '')); ?>"
                        class="conc-input form-control form-control-sm"
                        placeholder="<?php echo e(__('site.concours_search_placeholder')); ?>"
                    />
                    <div class="d-flex gap-2">
                        <button class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                            <?php echo e(__('site.search_button')); ?>

                        </button>

                        <a href="<?php echo e(route('concours.available')); ?>" style="width: 105px;" class="btn bg-rgb-primary1 font-weight-medium">
                            <?php echo e(__('site.reset_button')); ?>

                        </a>
                    </div>
                </form>
            </div>
        </div>

        
        <div class="services-grid">
            <?php $__empty_1 = true; $__currentLoopData = $concours; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="service-card">
                    <div class="service-iconn">
                        <i class="ri-file-list-line"></i>
                    </div>

                    
                    <h3 class="service-title">
                        <?php echo e(function_exists('trans_field') ? trans_field($c, 'titre') : ($c->titre ?? '')); ?>

                    </h3>

                    <p class="text-muted mb-3">
                        <?php echo e(__('site.registration_ends')); ?>:
                        <?php if(!empty($c->date_fin)): ?>
                            <?php echo e(\Carbon\Carbon::parse($c->date_fin)->format('Y-m-d')); ?>

                        <?php else: ?>
                            —
                        <?php endif; ?>
                    </p>

                    <?php
                        // try localized description (use trans_field if available)
                        $shortDesc = null;
                        if (function_exists('trans_field')) {
                            $raw = trans_field($c, 'description') ?? trans_field($c, 'resume') ?? ($c->description ?? null);
                        } else {
                            $raw = $c->description ?? null;
                        }
                        if ($raw) {
                            $shortDesc = \Illuminate\Support\Str::limit(strip_tags($raw), 120);
                        }
                    ?>

                    <?php if($shortDesc): ?>
                        <p class="text-muted mb-3"><?php echo e($shortDesc); ?></p>
                    <?php endif; ?>

                    <div class="service-actions">
                        <a href="<?php echo e(route('concours.show', $c)); ?>" class="service-link">
                            <?php echo e(__('site.register_button')); ?> <i class="<?php echo e($dir === 'rtl' ? 'ri-arrow-left-line' : 'ri-arrow-right-line'); ?>"></i>
                        </a>
                        <a href="<?php echo e(route('concours.results', $c)); ?>" class="service-link">
                            <?php echo e(__('site.results_button')); ?> <i class="<?php echo e($dir === 'rtl' ? 'ri-arrow-left-line' : 'ri-arrow-right-line'); ?>"></i>
                        </a>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12 text-center py-5">
                    <p class="mb-0 text-muted"><?php echo e(__('site.no_concours')); ?></p>
                </div>
            <?php endif; ?>
        </div>

        <div class="row mt-4">
            <div class="col-12 d-flex justify-content-center">
                <?php echo e($concours->appends(request()->except('page'))->links('pagination::bootstrap-5')); ?>

            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/concours_ext/index.blade.php ENDPATH**/ ?>