<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span><?php echo e(__('site.breadcrumb_home')); ?></span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span><?php echo e(__('site.breadcrumb_investment')); ?></span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('jeune_enfant.index')); ?>">
                <span><?php echo e(__('site.project_spaces_title')); ?></span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('site.page_show_form')); ?></li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4" action="<?php echo e(route('jeune_enfant.update', $projet->id_projet)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?> 
        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
        <div class="text-center mb-4">

                     <h3 class="fw-bold"><?php echo e(trans_field($formulaire, 'type')); ?></h3>
        </div>

        <div class="form-section">
            <h4><?php echo e(__('site.investment.form.label.identity.title') ?? __('site.investment')); ?></h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.investment.form.label.full_name')); ?></label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="<?php echo e(old('nom_prenom', $projet->investissements->first()?->utilisateur->nom_prenom)); ?>" 
                            placeholder="<?php echo e(__('site.investment.form.label.full_name')); ?>" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.place_of_birth')); ?></label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="<?php echo e(old('lieu_naissance', $projet->investissements->first()?->utilisateur->lieu_naissance)); ?>" 
                           placeholder="<?php echo e(__('site.place_of_birth')); ?>">
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.date_of_birth')); ?></label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="<?php echo e(old('date_naissance', $projet->investissements->first()?->utilisateur->date_naissance)); ?>">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.identity_type_label')); ?></label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput3()">
                        <option value="" disabled><?php echo e(__('site.investment.form.placeholder.choose')); ?></option>
                        <?php $__currentLoopData = $typesIdentite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id_type); ?>" 
                                <?php echo e(old('id_type_identite', $projet->investissements->first()?->utilisateur->id_type_identite) == $type->id_type ? 'selected' : ''); ?>>
                                <?php echo e(trans_field($type, 'type')); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:<?php echo e($projet->investissements->first()?->utilisateur->id_type_identite == 1 ? 'block' : 'none'); ?>;">
                    <input type="text" class="form-control" id="cin_input" name="cin" 
                           value="<?php echo e(old('cin', $projet->investissements->first()?->utilisateur->cin)); ?>" 
                           placeholder="<?php echo e(__('site.cin_placeholder')); ?>" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:<?php echo e($projet->investissements->first()?->utilisateur->id_type_identite == 2 ? 'block' : 'none'); ?>;">
                    <input type="text" class="form-control" id="passport_input" name="passport" 
                           value="<?php echo e(old('passport', $projet->investissements->first()?->utilisateur->passport)); ?>" 
                           placeholder="<?php echo e(__('site.passport_placeholder')); ?>" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:<?php echo e($projet->investissements->first()?->utilisateur->id_type_identite == 3 ? 'block' : 'none'); ?>;">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" 
                           value="<?php echo e(old('num_fiscal', $projet->investissements->first()?->utilisateur->num_fiscal)); ?>" 
                           placeholder="<?php echo e(__('site.fiscal_id_placeholder')); ?>" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3" id="cin_extra_fields" style="display:<?php echo e($projet->investissements->first()?->utilisateur->id_type_identite == 1 ? 'flex' : 'none'); ?>;">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_issue_date_label')); ?></label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance_cin" name="date_delivrance_cin" 
                           value="<?php echo e(old('date_delivrance_cin', $projet->investissements->first()?->utilisateur->date_delivrance_cin)); ?>">
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_issue_place_label')); ?></label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance_cin" name="lieu_delivrance_cin" 
                           value="<?php echo e(old('lieu_delivrance_cin', $projet->investissements->first()?->utilisateur->lieu_delivrance_cin)); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.personal_address')); ?></label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="<?php echo e(old('adresse', $projet->investissements->first()?->utilisateur->adresse)); ?>" 
                           placeholder="<?php echo e(__('site.personal_address')); ?>" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.education_level')); ?></label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="<?php echo e(old('niveau_etude', $projet->investissements->first()?->utilisateur->niveau_etude)); ?>" 
                           placeholder="<?php echo e(__('site.education_level')); ?>">
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.last_degree')); ?></label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" 
                           value="<?php echo e(old('dernier_diplome', $projet->investissements->first()?->utilisateur->dernier_diplome)); ?>" 
                           placeholder="<?php echo e(__('site.last_degree')); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.experience_label')); ?></label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" 
                           value="<?php echo e(old('experience', $projet->investissements->first()?->utilisateur->experience)); ?>" 
                           placeholder="<?php echo e(__('site.experience_label')); ?>" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4><?php echo e(__('site.project_characteristics')); ?></h4>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_spectacle" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_spectacle" name="espace_spectacle" value="1"
                       <?php echo e(old('espace_spectacle', $projet->espace_spectacle) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="espace_spectacle">
                    <?php echo e(__('site.espace_spectacle_label')); ?>

                </label>
            </div>
            <div class="mt-3" id="caracteristique_group" style="display:<?php echo e($projet->espace_spectacle ? 'block' : 'none'); ?>;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_spec" placeholder="<?php echo e(__('site.characteristics_placeholder')); ?>" rows="3"><?php echo e(old('caracteristique_spec', $projet->caracteristique_spec)); ?></textarea>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_sportif" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_sportif" name="espace_sportif" value="1"
                       <?php echo e(old('espace_sportif', $projet->espace_sportif) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="espace_sportif"><?php echo e(__('site.espace_sportif_label')); ?></label>
            </div>
            <div class="mt-3" id="caracteristique_sportif_group" style="display:<?php echo e($projet->espace_sportif ? 'block' : 'none'); ?>;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_sportif" rows="3"><?php echo e(old('caracteristique_sportif', $projet->caracteristique_sportif)); ?></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_service" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_service" name="espace_activite_service" value="1"
                       <?php echo e(old('espace_activite_service', $projet->espace_activite_service) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="espace_activite_service"><?php echo e(__('site.espace_service_label')); ?></label>
            </div>
            <div class="mt-3" id="caracteristique_activite_serv_group" style="display:<?php echo e($projet->espace_activite_service ? 'block' : 'none'); ?>;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_serv" rows="3"><?php echo e(old('caracteristique_activite_serv', $projet->caracteristique_activite_serv)); ?></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_culturelle" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_culturelle" name="espace_activite_culturelle" value="1"
                       <?php echo e(old('espace_activite_culturelle', $projet->espace_activite_culturelle) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="espace_activite_culturelle"><?php echo e(__('site.espace_culturel_label')); ?></label>
            </div>
            <div class="mt-3" id="caracteristique_activite_cult_group" style="display:<?php echo e($projet->espace_activite_culturelle ? 'block' : 'none'); ?>;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_cult" rows="3"><?php echo e(old('caracteristique_activite_cult', $projet->caracteristique_activite_cult)); ?></textarea>
            </div>
        </div>
        <div class="form-section mt-4">
            <h4><?php echo e(__('site.table_project_nature')); ?></h4>
            <div class="row align-items-center">
                <div class="col-sm-2">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label"><?php echo e(__('site.select_project_nature')); ?></label>
                </div>
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled><?php echo e(__('site.investment.form.placeholder.choose')); ?></option>
                        <?php $__currentLoopData = $naturesProjet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($nature->id_nature_p); ?>" 
                                <?php echo e(old('nature_projet_id', $projet->nature_projet_id) == $nature->id_nature_p ? 'selected' : ''); ?>>
                                <?php echo e(trans_field($nature, 'nature')); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4><?php echo e(__('site.number_positions_title')); ?></h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.holders_degree_label')); ?></label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_diplome_universitaire" 
                           value="<?php echo e(old('nbr_diplome_universitaire', $projet->nbr_diplome_universitaire)); ?>" 
                           placeholder="<?php echo e(__('site.holders_degree_label')); ?>">
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.others_label')); ?></label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_autre" 
                           value="<?php echo e(old('nbr_autre', $projet->nbr_autre)); ?>" placeholder="<?php echo e(__('site.others_label')); ?>">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4><?php echo e(__('site.director_title')); ?></h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.investment.form.label.full_name')); ?></label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" 
                           value="<?php echo e(old('nom_prenom_d', $projet->directeur->nom_prenom_d)); ?>" maxlength="50">
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_label')); ?></label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" 
                           value="<?php echo e(old('num_cin', $projet->directeur->num_cin)); ?>" maxlength="8">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_issue_date_label')); ?></label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" name="date_delivrance" 
                           value="<?php echo e(old('date_delivrance', $projet->directeur->date_delivrance)); ?>">
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.cin_issue_place_label')); ?></label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="lieu_delivrance" 
                           value="<?php echo e(old('lieu_delivrance', $projet->directeur->lieu_delivrance)); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><?php echo e(__('site.education_level')); ?></label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="<?php echo e(old('niveau_etude', $projet->directeur->niveau_etude)); ?>">
                </div>

                <label class="col-sm-2 col-form-label"><?php echo e(__('site.last_degree')); ?></label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome_obtenu" 
                           value="<?php echo e(old('dernier_diplome_obtenu', $projet->directeur->dernier_diplome_obtenu)); ?>">
                </div>
            </div>
        </div>

        <h4><?php echo e(__('site.investment_finance_title')); ?></h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th><?php echo e(__('site.investment_label')); ?></th>
                        <th><?php echo e(__('site.amount_label')); ?></th>
                        <th><?php echo e(__('site.fund_sources_label')); ?></th>
                        <th><?php echo e(__('site.notes_label')); ?></th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <?php $__currentLoopData = $projet->investissements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="<?php echo e(__('site.investment_label')); ?>">
                            <select class="form-control" name="investissements[<?php echo e($index); ?>][secteur_invest_id]">
                                <option value="" disabled><?php echo e(__('site.investment.form.placeholder.choose')); ?></option>
                                <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($secteur->id_secteur); ?>" 
                                        <?php echo e($inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : ''); ?>>
                                        <?php echo e(trans_field($secteur, 'secteur')); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="<?php echo e(__('site.amount_label')); ?>">
                            <input type="number" name="investissements[<?php echo e($index); ?>][montant_inv]" class="form-control" value="<?php echo e($inv->montant_inv); ?>">
                        </td>
                        <td data-label="<?php echo e(__('site.fund_sources_label')); ?>">
                            <input type="text" name="investissements[<?php echo e($index); ?>][source]" class="form-control" value="<?php echo e($inv->source); ?>" maxlength="100">
                        </td>
                        <td data-label="<?php echo e(__('site.notes_label')); ?>">
                            <input type="text" name="investissements[<?php echo e($index); ?>][remarques]" class="form-control" value="<?php echo e($inv->remarques); ?>" maxlength="200">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i><?php echo e(__('site.btn_delete') ?? 'حذف'); ?></button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
            <button type="button" class="btn btn-success" onclick="addInvestissementRow()">
                <?php echo e(__('site.btn_add_request') ?? 'إضافة صف'); ?>

            </button>
        </div>

        <span class="text-muted"><?php echo e(__('site.funds_examples')); ?></span>

        <div class="mt-3">
            <h4><?php echo e(__('site.declaration_title')); ?></h4>
            <span>
                <?php echo e(__('site.declaration_text')); ?>

            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4><?php echo e(__('site.remarks_title')); ?></h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="<?php echo e(__('site.write_remarks_placeholder')); ?>"><?php echo e(old('remarques', $projet->remarques)); ?></textarea>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-orange font-weight-medium" style="width:100px;margin-right:250px;"><?php echo e(__('site.profile_save_button')); ?></button>
            </div>
           
        </div>
    </form>
</div>
</div>
<script>
document.addEventListener("DOMContentLoaded", function() {
    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
        textareaGroup.style.display = checkbox.checked ? "block" : "none";
        checkbox.addEventListener("change", function() {
            textareaGroup.style.display = this.checked ? "block" : "none";
        });
    }
    toggleTextarea("espace_spectacle", "caracteristique_group");
    toggleTextarea("espace_sportif", "caracteristique_sportif_group");
    toggleTextarea("espace_activite_service", "caracteristique_activite_serv_group");
    toggleTextarea("espace_activite_culturelle", "caracteristique_activite_cult_group");
});
</script>

<script>
let investIndex = <?php echo e($projet->investissements->count()); ?>;
function addInvestissementRow() {
    let tableBody = document.getElementById('investissement-body');
    let newRow = `
        <tr>
            <td data-label="${'<?php echo e(__('site.investment_label')); ?>'}">
                <select class="form-control" name="investissements[\${investIndex}][secteur_invest_id]">
                    <option value="" disabled selected><?php echo e(__('site.investment.form.placeholder.choose')); ?></option>
                    <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($secteur->id_secteur); ?>"><?php echo e($secteur->secteur_ar); ?></option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </td>
            <td data-label="${'<?php echo e(__('site.amount_label')); ?>'}">
                <input type="number" name="investissements[\${investIndex}][montant_inv]" class="form-control" placeholder="<?php echo e(__('site.amount_label')); ?>">
            </td>
            <td data-label="${'<?php echo e(__('site.fund_sources_label')); ?>'}">
                <input type="text" name="investissements[\${investIndex}][source]" class="form-control" placeholder="<?php echo e(__('site.fund_sources_label')); ?>" maxlength="100">
            </td>
            <td data-label="${'<?php echo e(__('site.notes_label')); ?>'}">
                <input type="text" name="investissements[\${investIndex}][remarques]" class="form-control" placeholder="<?php echo e(__('site.notes_label')); ?>" maxlength="200">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i><?php echo e(__('site.btn_delete') ?? 'حذف'); ?></button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    investIndex++;
}

function removeRow(button) {
    let row = button.closest('tr');
    row.remove();
}
</script>

<?php else: ?>
<script>
    window.location.href = "<?php echo e(route('login')); ?>";
</script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_jeune_enfant/edit.blade.php ENDPATH**/ ?>