<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125" >
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span><?php echo e(__('site.investment.breadcrumb.home')); ?></span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span><?php echo e(__('site.investment.breadcrumb.index')); ?></span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('salle-sport.index2')); ?>">
                <span><?php echo e(__('site.investment.breadcrumb.salles_list')); ?></span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('site.investment.detail')); ?></li>
    </ol>
</nav>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <form class="card shadow-sm p-4" action="<?php echo e(route('salle-sport.show2', $immobilier->id_imm)); ?>" method="POST" enctype="multipart/form-data" lang="<?php echo e(app()->getLocale()); ?>">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">

        <div class="header-print-container">
    <div class="header-side header-left">
        <span class="delegation-print">
            <?php echo e(__('site.header.regional_delegation')); ?>:
            <?php
                $deleg = $delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first();
            ?>
            <?php echo e($deleg ? trans_field($deleg, 'nom') : __('site.not_specified')); ?>

        </span>
    </div>

    <div class="header-center">
        
        <h3 class="title-form"><?php echo e(__('site.investment.form_title_salle')); ?></h3>
        <h4 class="title-request"><?php echo e(__('site.investment.view_request')); ?></h4>
    </div>

    <div class="header-side header-right no-print">
        <button type="button" onclick="window.print()" class="btn btn-success">
            <i class="fa fa-print" style="margin-right:5px;"></i> <?php echo e(__('site.print')); ?>

        </button>
    </div>
</div>



        <div>
            <div class="d-flex align-items-center mb-3">
                <h5 class="mb-0 fw-bold me-2"><?php echo e(__('site.current_status_label')); ?></h5>
                <?php if($immobilier->id_statut == 1): ?>
                    <span><strong><?php echo e(__('site.status_accepted')); ?></strong></span>
                <?php elseif($immobilier->id_statut == 3): ?>
                    <span><strong><?php echo e(__('site.status_refused')); ?></strong></span>
                <?php else: ?>
                    <span><strong><?php echo e(__('site.status_pending')); ?></strong></span>
                <?php endif; ?>
            </div>

            <?php if($immobilier->id_statut == 3 && !empty($immobilier->commentaire_motif)): ?>
                <div class="d-flex align-items-center mb-3">
                    <label class="fw-bold text-danger me-2 mb-0"><?php echo e(__('site.start_activity.rejection_reason_label')); ?></label>
                    <p class="mb-0 border p-2 rounded shadow-sm text-muted"><?php echo e($immobilier->commentaire_motif); ?></p>
                </div>
            <?php endif; ?>
        </div>



        <div class="form-section">
            <h4 class="mb-3 fw-bold"><?php echo e(__('site.investment.form.identity.title')); ?></h4>   
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.full_name')); ?></label>
                <div class="col-sm-10 pt-2">
                    <span><?php echo e($immobilier->utilisateur->nom_prenom ?? __('site.not_specified')); ?></span>
                </div>
            </div>  
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.identity_type')); ?></label>  
                <div class="col-sm-4 pt-2">
                    <span>
                        <?php
                            $typeId = $typesIdentite->where('id_type', $immobilier->utilisateur->id_type_identite ?? '')->first();
                        ?>
                        <?php echo e($typeId ? trans_field($typeId, 'type') : __('site.not_specified')); ?>

                    </span>
                </div>
                <div class="col-sm-6 pt-2">
                    <?php if($immobilier->utilisateur->cin): ?>
                        <span><?php echo e(__('site.investment.form.label.cin')); ?>: <?php echo e($immobilier->utilisateur->cin); ?></span>
                    <?php elseif($immobilier->utilisateur->passport): ?>
                        <span><?php echo e(__('site.investment.form.label.passport')); ?>: <?php echo e($immobilier->utilisateur->passport); ?></span>
                    <?php elseif($immobilier->utilisateur->num_fiscal): ?>
                        <span><?php echo e(__('site.investment.form.label.fiscal_id')); ?>: <?php echo e($immobilier->utilisateur->num_fiscal); ?></span>
                    <?php else: ?>
                        <span><?php echo e(__('site.not_specified')); ?></span>
                    <?php endif; ?>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.phone')); ?></label>
                <div class="col-sm-10 pt-2">
                    <span><?php echo e($immobilier->utilisateur->tel ?? __('site.not_specified')); ?></span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.email')); ?></label>
                <div class="col-sm-10 pt-2">
                    <span><?php echo e($immobilier->utilisateur->email ?? __('site.not_specified')); ?></span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.address')); ?></label>
                <div class="col-sm-10 pt-2">
                    <span><?php echo e($immobilier->utilisateur->adresse ?? __('site.not_specified')); ?></span>
                </div>
            </div>

            <h4 class="mb-3 fw-bold"><?php echo e(__('site.investment.form.property.title')); ?></h4> 
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.property_address')); ?></label>
                <div class="col-sm-10 pt-2">
                    <span><?php echo e($immobilier->adresse_imm ?? __('site.not_specified')); ?></span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.gouvernorat')); ?></label>
                <div class="col-sm-4 pt-2">
                    <span>
                        <?php
                            $gouv = $gouvernorats->where('id_gouver', $immobilier->gouvernorat_id ?? '')->first();
                        ?>
                        <?php echo e($gouv ? trans_field($gouv, 'nom') : __('site.not_specified')); ?>

                    </span>
                </div>
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.delegation')); ?></label>
                <div class="col-sm-4 pt-2">
                    <span>
                        <?php
                            $deleg2 = $delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first();
                        ?>
                        <?php echo e($deleg2 ? trans_field($deleg2, 'nom') : __('site.not_specified')); ?>

                    </span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.property_type')); ?></label>
                <div class="col-sm-4 pt-2">
                    <span>
                        <?php
                            $typeImm = $typesImmobilier->where('id_type', $immobilier->type_imm_id ?? '')->first();
                        ?>
                        <?php echo e($typeImm ? trans_field($typeImm, 'type') : __('site.not_specified')); ?>

                    </span>
                </div>
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.surface_total')); ?></label>
                <div class="col-sm-4 pt-2">
                    <span><?php echo e($immobilier->superfici_m2 ? $immobilier->superfici_m2.' م²' : __('site.not_specified')); ?></span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.usage_type')); ?></label>
                <div class="col-sm-4 pt-2">
                    <span>
                        <?php
                            $usage = $usagesImmobilier->where('id_usage_imm', $immobilier->usage_id ?? '')->first();
                        ?>
                        <?php echo e($usage ? trans_field($usage, 'usage') : __('site.not_specified')); ?>

                    </span>
                </div>
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.document_property')); ?></label>
                <div class="col-sm-4 pt-2">
                    <?php if($immobilier->document_propriete): ?>
                        <a href="<?php echo e(asset('storage/'.$immobilier->document_propriete)); ?>" target="_blank" class="btn btn-link p-0"><?php echo e(__('site.view_file')); ?></a>
                    <?php else: ?>
                        <span><?php echo e(__('site.not_specified')); ?></span>
                    <?php endif; ?>
                </div>
            </div>

           <h4 class="mb-3 fw-bold"><?php echo e(__('site.investment.form.components.title')); ?></h4>

<table class="table table-bordered text-center align-middle">
    <thead class="table-light">
        <tr>
            <th><?php echo e(__('site.investment.form.components.component_label') ?? __('site.component')); ?></th>
            <th><?php echo e(__('site.yes_no') ?? __('site.yes_no_default')); ?></th>
            <th><?php echo e(__('site.investment.form.label.count')); ?></th>
            <th><?php echo e(__('site.investment.form.label.surface')); ?></th>
        </tr>
    </thead>
    <tbody>
        <?php
            $components = [
                'salle_exercice'   => __('site.investment.form.components.exercise_hall'),
                'piscine'          => __('site.investment.form.components.pool'),
                'vestiaire'        => __('site.investment.form.components.changing_rooms'),
                'unitaires_sanitaire' => __('site.investment.form.components.sanitary_units'),
                'stockage_conservation'  => __('site.investment.form.components.storage_space'),
                'espace_exterieur' => __('site.investment.form.components.outdoor_space'),
                'garage'           => __('site.investment.form.components.garage')
            ];
        ?>

        <?php $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                
                <td><?php echo e($label); ?></td>

                
                <td>
                    <?php if($immobilier->$comp == 1): ?>
                        <?php echo e(__('site.yes')); ?>

                    <?php elseif($immobilier->$comp == 0): ?>
                        <?php echo e(__('site.no')); ?>

                    <?php else: ?>
                        <?php echo e(__('site.not_specified')); ?>

                    <?php endif; ?>
                </td>

                
<td>
    <?php if($immobilier->$comp == 1): ?>
        <?php if(in_array($comp, ['salle_exercice','piscine','vestiaire'])): ?>
            <?php echo e($immobilier->{'nbr_'.$comp} ?? __('site.not_specified')); ?>

        <?php else: ?>
            <?php echo e(__('site.not_specified')); ?>

        <?php endif; ?>
    <?php else: ?>
        <?php echo e(__('site.not_specified')); ?>

    <?php endif; ?>
</td>


<td>
    <?php if($immobilier->$comp == 1): ?>
        <?php echo e($immobilier->{'superface_'.$comp} ? $immobilier->{'superface_'.$comp}.' م²' : __('site.not_specified')); ?>

    <?php else: ?>
        <?php echo e(__('site.not_specified')); ?>

    <?php endif; ?>
</td>

            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold"><?php echo e(__('site.investment.form.label.other_surfaces')); ?></label>
                <div class="col-sm-10 pt-2">
                   <span><?php echo e($immobilier->autres_surfaces ? $immobilier->autres_surfaces.' م²' : __('site.not_specified')); ?></span>

                </div>
            </div>
        </div>
        <div class="form-group no-print" style="display: flex; justify-content: center; margin-top: 20px;">
    <div class="d-flex" style="gap: 20px; align-items: center;">
       
       <button type="button" onclick="window.print()" 
    class="btn btn-success" 
    style="width:120px; height:40px; display:flex; align-items:center; justify-content:center; gap:6px;">
    <i class="fa fa-print"></i> <?php echo e(__('site.print')); ?>

</button>
    </div>
</div>

    </form>
</div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        <?php $__currentLoopData = array_keys($components); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            if (typeof toggleSection === 'function') {
                toggleSection('<?php echo e($comp); ?>','id_<?php echo e($comp); ?>');
            }
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    });
</script>


<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_salle_sport/salle_sport/show.blade.php ENDPATH**/ ?>