<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<style>
    /* Taille des boutons réduite */
    .form-group button,
    .form-group a {
        min-width: 140px;
        font-weight: bold;
        border: none;
        border-radius: 8px;
        font-size: 14px;
        padding: 6px 10px;
        box-shadow: 0 3px 6px rgba(0,0,0,0.1);
        transition: all 0.2s ease-in-out;
    }

    .form-group button:hover,
    .form-group a:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    /* Dégradé orange pour "حفظ كمسودة" */
    .btn-orange-gradient {
        background: linear-gradient(135deg, #ff9f43, #e96b05);
        color: #fff;
    }
    .btn-orange-gradient:hover {
        background: linear-gradient(135deg, #ffa94d, #ff7b1a);
    }

    /* Bouton Retour bleu */
    .btn-primary {
        background-color: #007bff;
    }
    .btn-primary:hover {
        background-color: #0069d9;
    }

    /* Responsive - garder même ligne si possible */
    @media (max-width: 768px) {
        .form-group .d-flex {
            flex-wrap: wrap;
            justify-content: center;
        }
        .form-group button,
        .form-group a {
            min-width: 120px;
            font-size: 13px;
            padding: 5px 8px;
        }
    }

    /* print */

@media print {
    /* Cacher header/footer et boutons */
    header, footer, .no-print {
        display: none !important;
    }

    /* Afficher tous les formulaires en séquence */
    .form1, .form2, .form3 {
        visibility: visible;
        position: static; /* normal flow */
        width: 100%;
    }

    /* Supprimer les page-breaks automatiques */
    .form1, .form2, .form3 {
        page-break-after: auto;
    }

    /* Tables */
    table {
        page-break-inside: auto;
    }
    tr {
        page-break-inside: avoid;
        page-break-after: auto;
    }
}

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit">
<div class="container">
<form action="" method="POST" enctype="multipart/form-data" lang="ar">
    <!-- Formulaire 1 -->
                <div class="container form1" lang="ar" dir="rtl" >
                        <input type="hidden" name="id_association" value="<?php echo e($association->id_association ?? ''); ?>">
                        <input type="hidden" name="id_demande" value="<?php echo e($demande_id ?? ''); ?>">
                        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
                        <input type="hidden" name="id_projet" value="<?php echo e($id_projet ?? ''); ?>">

                        <h2 class="text-center">الجمهورية التونسية</h2>
                        <h3 class="text-center">وزارة شؤون الشباب و الرياضة</h3>
                        <h4 class="text-center mt-4">اللجنة الفنية للنظر في مطالب التمويل العمومي</h4>

                        <div class="card mt-4 shadow-sm"> 
                            <div class="card-header text-center bg-white">
                                <div class="row mb-3 align-items-center">
                                    <label style="color:black;" class="col-sm-3 col-form-label">إسم الجمعية</label>
                                    <div class="col-sm-9">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->nom_association ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0"><?php echo e($formulaire->type_ar); ?></h5>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <?php $__currentLoopData = $type_financement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-4 col-sm-6 mb-2 text-center">
                                            <div class="form-check d-flex justify-content-start" dir="rtl">
                                                <input class="form-check-input me-2 text-center" type="checkbox" value="<?php echo e($type->id_type_fin); ?>"
                                                    <?php echo e(in_array($type->id_type_fin, $selectedTypes) ? 'checked' : ''); ?>

                                                    disabled>
                                                <label class="col-sm-12 col-form-label" style="color:black;"><?php echo e($type->type_ar); ?></label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>


                        <div class="card mt-4 shadow-sm">
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0">المعطيات الخاصة بالجمعية</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">عنوان الجمعية</label>
                                    <div class="col-sm-10">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->adresse ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">الترقيم البريدي</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->code_postal ?? '-'); ?>

                                        </div>
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">الهاتف</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->tel ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">الفاكس</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->fax ?? '-'); ?>

                                        </div>
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">تاريخ التأسيس</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->date_creation ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">رقم التأشيرة</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->num_visa ?? '-'); ?>

                                        </div>
                                    </div>
                                    <label style="color:black;" class="col-sm-2 col-form-label">تاريخ التأشيرة</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->date_visa ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">رقم المعرف الجبائي</label>
                                    <div class="col-sm-10">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->num_identification_fiscale ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">رقم الحساب الجاري</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->num_compte_courant ?? '-'); ?>

                                        </div>
                                    </div>
                                    <label style="color:black;" class="col-sm-2 col-form-label">البنك</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->banque ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">البريد الإلكتروني</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->adresse_mail ?? '-'); ?>

                                        </div>
                                    </div>
                                    <label style="color:black;" class="col-sm-2 col-form-label">عنوان موقع الواب</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->adresse_site_internet ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">إسم رئيس الجمعية</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->nom_president_association ?? '-'); ?>

                                        </div>
                                    </div>
                                    <label style="color:black;" class="col-sm-2 col-form-label">الهاتف الشخصي</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->tel_personnel ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">عدد أعضاء المكتب الوطني للجمعية</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->num_membre_bureau_national_a ?? '-'); ?>

                                        </div>
                                    </div>
                                    <label style="color:black;" class="col-sm-2 col-form-label">عدد المكاتب الجهوية ان وجدت</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->num_bureaux_regionaux ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">عدد المنخرطين الاجمالي</label>
                                    <div class="col-sm-4">
                                        <div class="form-control bg-white border-0">
                                            <?php echo e($docList->projet->demande->association->num_total_membre ?? '-'); ?>

                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                </div>
            

        <!-- Formulaire 2 -->
            <div class="container form2">
                    <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire2->id_type); ?>">
                    <input type="hidden" name="id_demande" value="<?php echo e($demande_id); ?>">
                    <h2 class="text-center">الجمهورية التونسية</h2>
                    <h2 class="text-center">وزارة الشباب و الرياضة</h2>
                    <h3 class="text-center" style="font-size:25px;"><?php echo e($formulaire2->type_ar); ?></h3>
                    <h4 class="text-center pt-3">جذاذة فنية</h4>
                    <br>

                    <div class="form-section">
                        <h4>  المعطيات البيداغوجية</h4>
                        <div class="form-group row mb-3" style="padding-top:20px;">
                            <label class="col-sm-2 col-form-label">اسم و لقب المشرف على التنفيذ</label>
                            <div class="col-sm-4">
                                <div class="form-control bg-white border-0">
                                    <?php echo e($docList->projet->superviseur->nom_prenom_sup ?? '-'); ?>

                                </div>
                            </div>
                            <label class="col-sm-2 col-form-label">المهنة</label>
                            <div class="col-sm-4">
                                <div class="form-control bg-white border-0">
                                    <?php echo e($docList->projet->superviseur->profession_sup ?? '-'); ?>

                                </div>
                            </div>
                        </div>

                        <div class="form-group row align-items-center">
                            <label class="col-sm-2 col-form-label">الصفة في الجمعية</label>  
                            <div class="col-sm-4">
                                <div class="form-control bg-white border-0">
                                    <?php echo e($docList->projet->superviseur->role_sup ?? '-'); ?>

                                </div>
                            </div>
                            <label class="col-sm-2 col-form-label">الهاتف</label>
                            <div class="col-sm-4">
                                <div class="form-control bg-white border-0">
                                    <?php echo e($docList->projet->superviseur->tel_sup ?? '-'); ?>

                                </div>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
                            <div class="col-sm-4">
                                <div class="form-control bg-white border-0">
                                    <?php echo e($docList->projet->superviseur->email_sup ?? '-'); ?>

                                </div>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                        <label class="col-sm-2 col-form-label">اسم المشروع / التظاهرة / النشاط</label>
                        <div class="col-sm-10">
                            <div class="form-control bg-white border-0">
                                <?php echo e($docList->projet->nom_projet ?? '-'); ?>

                            </div>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-sm-2 col-form-label">مبررات الانجاز</label>
                        <div class="col-sm-10">
                            <div class="form-control bg-white border-0" style="white-space: pre-wrap;">
                                <?php echo e($docList->projet->justification_realisation ?? '-'); ?>

                            </div>
                        </div>
                    </div>

                    <div class="form-group row mb-3">
                        <label class="col-sm-2 col-form-label">الأهداف</label>
                        <div class="col-sm-10">
                            <div class="form-control bg-white border-0" style="white-space: pre-wrap;">
                                <?php echo e($docList->projet->objectives ?? '-'); ?>

                            </div>
                        </div>
                    </div>

                    <div class="form-section mt-4">
                        <h4>وصف الفقرات او المراحل</h4>
                        <table class="custom-table">
                            <thead>
                                <tr>
                                    <th>رقم</th>
                                    <th>اهم الفقرات او المراحل</th>
                                    <th>تاريخ الانجاز</th>
                                    <th>مكان الإنجاز</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $docList->projet->activites ?? []; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($phase->description ?? 'غير محدد'); ?></td>
                                        <td><?php echo e($phase->completion_date ?? 'غير محدد'); ?></td>
                                        <td><?php echo e($phase->completion_location ?? 'غير محدد'); ?></td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="4" class="text-center">لا توجد مراحل مضافة</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                        <div class="form-section mt-4">
                            <div class="form-group row mb-3">
                                <label class="col-sm-2 col-form-label">الجمهور المستفيد</label>
                                <div class="col-sm-10">
                                    <div class="form-control bg-white border-0"><?php echo e($docList->projet->public ?? '-'); ?></div>
                                </div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-sm-2 col-form-label">العدد التقريبي للجمهور</label>
                                <div class="col-sm-10">
                                    <div class="form-control bg-white border-0"><?php echo e($docList->projet->nombre_spectateur ?? '-'); ?></div>
                                </div>
                            </div>

                            <div class="form-group row mb-3 align-items-center">
                                <label class="col-sm-2 col-form-label">الشريحة العمرية المستهدفة</label>
                                <div class="col-sm-5 d-flex align-items-center">
                                    <label class="col-form-label mb-0 me-3">من</label>
                                    <div class="form-control bg-white border-0"><?php echo e($docList->projet->tranch_age_min ?? '-'); ?></div>
                                </div>
                                <div class="col-sm-5 d-flex align-items-center">
                                    <label class="col-form-label mb-0 me-3">إلى</label>
                                    <div class="form-control bg-white border-0"><?php echo e($docList->projet->tranch_age_max ?? '-'); ?></div>
                                </div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-sm-6 col-form-label">الأطراف المشاركة في الإنجاز</label>
                                <div class="col-sm-12">
                                    <div class="form-control bg-white border-0" style="white-space: pre-wrap;"><?php echo e($docList->projet->parties_realisation ?? '-'); ?></div>
                                </div>
                            </div>
                        </div>

                        <div class="form-section mt-4">
                            <div class="form-group row mb-3">
                                <label class="col-sm-6 col-form-label">النتائج المرتقب تحقيقها</label>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-sm-6 col-form-label">1- النتائج الكمية</label>
                                <div class="col-sm-12">
                                    <div class="form-control bg-white border-0" style="white-space: pre-wrap;">
                                        <?php echo e($docList->projet->resultat_quantitatif ?? '-'); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-sm-6 col-form-label">2- النتائج النوعية</label>
                                <div class="col-sm-12">
                                    <div class="form-control bg-white border-0" style="white-space: pre-wrap;">
                                        <?php echo e($docList->projet->resultat_qualitatif ?? '-'); ?>

                                    </div>
                                </div>
                            </div>

                            <div class="form-group row mb-3">
                                <label class="col-sm-6 col-form-label">الآفاق المنتظرة</label>
                                <div class="col-sm-12">
                                    <div class="form-control bg-white border-0" style="white-space: pre-wrap;">
                                        <?php echo e($docList->projet->perspectives ?? '-'); ?>

                                    </div>
                                </div>
                            </div>
                        </div>

                    <div class="form-section">
                        <h4>الموازنة المالية</h4>
                        <label class="col-sm-6 col-form-label">الميزانية التقديرية</label>

                        <div class="form-section mt-4">
                            <table class="custom-table table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th rowspan="2">الكلفة الجملية التقديرية<br>(المبلغ بالدينار التونسي)</th>
                                        <th colspan="2">حجم التمويل الذاتي</th>
                                        <th colspan="2">حجم الدعم المطلوب من الوزارة</th>
                                    </tr>
                                    <tr>
                                        <th>النسبة المائوية</th>
                                        <th>المبلغ بالدينار</th>
                                        <th>المبلغ بالدينار</th>
                                        <th>النسبة المائوية</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $docList->projet->estimationBudget; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <tr>
                                            <td><?php echo e($budget->cout_total_estime ?? '-'); ?></td>
                                            <td><?php echo e($budget->financement_propre_pourcentage ?? '-'); ?></td>
                                            <td><?php echo e($budget->financement_propre_montant ?? '-'); ?></td>
                                            <td><?php echo e($budget->aide_ministere_montant ?? '-'); ?></td>
                                            <td><?php echo e($budget->aide_ministere_pourcentage ?? '-'); ?></td>
                                        </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="5" class="text-center">لا توجد بيانات مضافة</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>



                        <div class="form-section mt-4">
                            <table class="custom-table table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th colspan="4">الأطراف المساهمة في الدعم</th>
                                    </tr>
                                    <tr>
                                        <th>ع/ر</th>
                                        <th>الطرف المساهم</th>
                                        <th>المبلغ بالدينار</th>
                                        <th>النسبة المائوية</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $docList->projet->estimationBudget; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budgetIndex => $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php $__empty_2 = true; $__currentLoopData = $budget->contributeurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supporterIndex => $supporter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                            <tr>
                                                <td><?php echo e($supporterIndex + 1); ?></td>
                                                <td><?php echo e($supporter->nom ?? '-'); ?></td>
                                                <td><?php echo e($supporter->montant ?? '-'); ?></td>
                                                <td><?php echo e($supporter->pourcentage ?? '-'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                            <tr>
                                                <td colspan="4" class="text-center">لا توجد مساهمات مضافة</td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="4" class="text-center">لا توجد بيانات ميزانية</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <label class="col-sm-6 col-form-label"> ابواب صرف الميزانية </label>
                        <div class="form-section mt-4">
                            <table class="custom-table table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th>ع/ر</th>
                                        <th>الفقرات</th>
                                        <th>مستلزمات الفقرات</th>
                                        <th>التكلفة (د)</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php $__empty_1 = true; $__currentLoopData = $docList->projet->estimationBudget; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budgetIndex => $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                        <?php $__empty_2 = true; $__currentLoopData = $budget->postesDepense; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $depenseIndex => $depense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_2 = false; ?>
                                            <tr>
                                                <td><?php echo e($depenseIndex + 1); ?></td>
                                                <td><?php echo e($depense->libelle_depense ?? '-'); ?></td>
                                                <td><?php echo e($depense->description ?? '-'); ?></td>
                                                <td><?php echo e($depense->cout ?? '-'); ?></td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_2): ?>
                                            <tr>
                                                <td colspan="4" class="text-center">لا توجد مصاريف مضافة</td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                        <tr>
                                            <td colspan="4" class="text-center">لا توجد بيانات ميزانية</td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>
                            </table>
                        </div>

                        <span>
                            (1) :  مستلزمات كل فقرة على حدة مثلا / مستلزمات الندوة او المعرض او الورشة او العرض 
                        </span>
                    </div>
            </div>
     

<!-- Formulaire 3 -->
    <div class="container form3">

        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire3->id_type); ?>">
        <input type="hidden" name="id_projet" value="<?php echo e($id_projet); ?>">
        <h2>الجمهورية التونسية</h2>
        <h2>وزارة الشباب و الرياضة</h2>
        <h3 style="font-size:25px;"><?php echo e($formulaire3->type_ar); ?></h3>
        <br>
        <div class="form-section">
            <div class="form-section mt-4">
    <table class="custom-table table table-bordered text-center">
        <thead>
            <tr>
                <th>#</th>
                <th>الوثائق حسب الامر عدد 5183</th>
                <th>الوثائق</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $typedocum; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $existing = $documents->firstWhere('id_doc', $doc->id_type_doc);
                ?>
                <tr>
                    <td><?php echo e($index + 1); ?></td>
                    <td><?php echo e($doc->type_ar); ?></td>
                    <td>
                        <?php if(in_array($doc->id_type_doc, [15, 17])): ?>
                            ✅ هذا الملف متوفر بالفعل
                        <?php else: ?>
                            <?php if($existing && $existing->file): ?>
                                <a href="<?php echo e(asset('storage/'.$existing->file)); ?>" 
                                   target="_blank" 
                                   class="btn btn-sm btn-info" 
                                   title="عرض الملف">
                                    📂 عرض الملف
                                </a>
                            <?php else: ?>
                                <span class="text-muted">لا يوجد ملف</span>
                            <?php endif; ?>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

        </div>

    </div>
<div class="form-group row text-center" style="padding-top:50px;">
            <div class="col-sm-4 mx-auto no-print">
                <button type="button" class="btn btn-success font-weight-medium" style="width:120px;" onclick="window.print()">
                    <i class="bi bi-printer me-1"></i> طباعة
                </button>
            </div>
            <div class="col-sm-4 mx-auto no-print">
                <a href="<?php echo e(route('doc_fin.brouillons')); ?>" class="btn btn-primary" style="width:120px;">
                    <i class="bi bi-arrow-left me-1"></i> رجوع
                </a>
            </div>
        </div>




<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

   <div id="global-block-msg" class="alert alert-danger" style="display:none">
        يوجد مستندات مفقودة أو يلزم تعبئة خطوات سابقة — لن يتم حفظ الطلب حتى تكتمل الشروط.
    </div>
    
</div>  


</script>
</form>
</div>
<?php $__env->stopSection(); ?>

<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/financement/documents_financement/brouillons_show.blade.php ENDPATH**/ ?>