<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('jeunesse2.index')); ?>">
                <span>تنظيم الأنشطة الترفيهية للشباب و الطفولة</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">إضافة استمارة</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <form action="<?php echo e(route('jeunesse2.store')); ?>" method="POST" enctype="multipart/form-data" lang="ar">
    <?php echo csrf_field(); ?>
        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
      
      

        
        <h3><?php echo e($formulaire->type_ar); ?></h3>
        <div class="form-section">
            <h4>المستثمر</h4>
            
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" value="<?php echo e(old('nom_prenom', Auth::user()->nom_prenom ?? '')); ?>" readonly>
                </div>
            </div>


            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="lieu_naissance" value="<?php echo e(old('lieu_naissance', Auth::user()->lieu_naissance ?? '')); ?>" readonly>
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" name="date_naissance"  value="<?php echo e(old('date_naissance', Auth::user()->date_naissance ?? '')); ?>" readonly>
                </div>
            </div>
                        
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" value="<?php echo e(old('adresse', Auth::user()->adresse ?? '')); ?>" readonly>
                </div>
            </div>
            

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" value="<?php echo e(old('niveau_etude', Auth::user()->niveau_etude ?? '')); ?>" readonly>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" value="<?php echo e(old('dernier_diplome', Auth::user()->dernier_diplome ?? '')); ?>" readonly>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" value="<?php echo e(old('experience', Auth::user()->experience ?? '')); ?>" readonly>
                </div>
            </div>
        </div>

            
        <div class="form-section mt-4">
            <h4> خاصيات النشاط </h4>
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> تنظيم الأنشطة الترفيهية للشباب و الطفولة  </strong>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><strong>الإستثمار في هذا النشاط</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" id="id_statut_inv" name="id_statut_inv">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $statut_inv; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $statut): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($statut->id_status); ?>">
                                <?php echo e($statut->statut_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <label class="col-sm-2 col-form-label"><strong>طبيعة الأنشطة</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" id="id_nature_activite" name="id_nature_activite">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $nature_activite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($nature->id_nature_ac); ?>">
                                <?php echo e($nature->nature_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" placeholder="الاسم التجاري للمشروع " maxlength="100">
                </div>
                <label class="col-sm-2 col-form-label" for=""> عنوان المقر الاجتماعي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" placeholder="عنوان المقر الاجتماعي" maxlength="100">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-2 col-form-label"> الولاية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $gouvernorats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gouv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($gouv->id_gouver); ?>"><?php echo e($gouv->nom_ar); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <label class="col-sm-2 col-form-label"> البلدية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id" disabled>
                        <option value="" disabled selected>اختر...</option>
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الترقيم البريدي </label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="code_postal">
                </div>
            </div>
            
        </div>

        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>  مبلغ الإستثمار </th>
                        <th> التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[0][secteur_invest_id]" id="secteur_invest_id_0">
                                <option value="" disabled selected>اختر...</option>
                                <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($secteur->id_secteur); ?>"><?php echo e($secteur->secteur_ar); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[0][montant_inv]" class="form-control" min=1>
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[0][id_source_financement]" id="id_source_financement">
                                <option value="" disabled selected>اختر...</option>
                                <?php $__currentLoopData = $source_fin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($source->id_source); ?>"><?php echo e($source->source_ar); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[0][montant_fin]" class="form-control" min=1>
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                        </td>
                    </tr>
                </tbody>
            </table>
            <button type="button" class="btn btn-success" onclick="addInvestissementRow()">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا..."></textarea>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
             <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-success font-weight-medium">إرسال</button>
            </div>
            
        </div>
    </form>
</div>

</div>

    <?php else: ?>
        <script>
            window.location.href = "<?php echo e(route('login')); ?>";
        </script>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?><script>document.getElementById('gouvernorat_id').addEventListener('change', function() {    let gouvId = this.value;    let delegationSelect = document.getElementById('delegation_id');    delegationSelect.innerHTML = '<option value="" disabled selected>تحميل...</option>';    delegationSelect.disabled = true;    let url = "<?php echo e(route('delegations_jeunesse.get', ['gouvernoratId' => 'ID_PLACEHOLDER'])); ?>";    url = url.replace("ID_PLACEHOLDER", gouvId);    fetch(url)        .then(response => response.json())        .then(data => {            delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';            data.forEach(d => {                let option = document.createElement('option');                option.value = d.id_delegation;                option.text = d.nom_ar;                delegationSelect.add(option);            });            delegationSelect.disabled = false;        });});</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeunesse-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });

        // Initialiser les toggles des zones de texte
        initializeToggles();

        // Gestion de la dépendance gouvernorat-délégation
        const gouvernoratSelect = document.getElementById('gouvernorat_id');
        const delegationSelect = document.getElementById('delegation_id');

        if (gouvernoratSelect && delegationSelect) {
            // Désactiver le select des délégations au chargement
            delegationSelect.setAttribute('disabled', 'disabled');

            gouvernoratSelect.addEventListener('change', function() {
                const selectedGouvernorat = this.value;

                // Réinitialiser le select des délégations
                delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';

                if (selectedGouvernorat) {
                    // Activer le select des délégations
                    delegationSelect.removeAttribute('disabled');

                    // Récupérer les délégations
                    fetch(`/delegations/${selectedGouvernorat}`)
                        .then(response => {
                            if (!response.ok) {
                                throw new Error('Erreur réseau');
                            }
                            return response.json();
                        })
                        .then(delegations => {
                            if (Array.isArray(delegations)) {
                                delegations.forEach(d => {
                                    const option = new Option(d.nom_ar, d.id_delegation);
                                    delegationSelect.add(option);
                                });
                                delegationSelect.disabled = false;
                            } else {
                                console.error('Format de réponse inattendu:', delegations);
                            }
                        })
                        .catch(error => {
                            console.error('Erreur lors de la récupération des délégations:', error);
                            delegationSelect.disabled = true;
                        });
                } else {
                    // Si aucun gouvernorat n'est sélectionné, désactiver le select des délégations
                    delegationSelect.setAttribute('disabled', 'disabled');
                }
            });
        }
    });

    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
        
        const updateVisibility = () => {
            textareaGroup.style.display = checkbox.checked ? 'block' : 'none';
        };
        
        checkbox.addEventListener('change', updateVisibility);
        updateVisibility(); // État initial
    }

    function initializeToggles() {
        toggleTextarea('espace_spectacle', 'caracteristique_group');
        toggleTextarea('espace_sportif', 'caracteristique_sportif_group');
        toggleTextarea('espace_activite_service', 'caracteristique_activite_serv_group');
        toggleTextarea('espace_activite_culturelle', 'caracteristique_activite_cult_group');
    }

    let investIndex = 1; 
    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($secteur->id_secteur); ?>"><?php echo e($secteur->secteur_ar); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td data-label="المبلغ">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $source_fin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($source->id_source); ?>"><?php echo e($source->source_ar); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_jeunesse/create2.blade.php ENDPATH**/ ?>