<?php $__env->startSection('content'); ?>

<div class="it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
     <nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">مركز التربصات و تكوين الرياضيين</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="it-section-title-box text-center mb-30" style="padding-top:20px;">
                                <span class="it-section-subtitle">طلبات الاستثمارات الرياضية</span>
                                <h4 class="it-section-title it-split-in-right mb-0">عرض جميع الطلبات</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="card shadow-sm p-4">

                                <div class="d-flex justify-content-end mb-4">
                                    <a class="btn btn-success" href="<?php echo e(route('formation.create')); ?>">
                                        <i class="la la-plus me-1"></i> إضافة استثمار رياضي
                                    </a>
                                </div>

                                <?php if(session('success')): ?>
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        <?php echo e(session('success')); ?>

                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                <?php endif; ?>

                               <div class="my-table table-responsive">
                                     <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                                        <thead class="thead-light">
                                           <tr>
                                                <th width="5%">المعرف</th>
                                                <th width="25%">الاسم و اللقب</th>
                                                <th width="25%">طبيعة المشروع</th>
                                                <th width="15%">وضعية الطلب</th>
                                                <th width="30%">إجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $formations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $formation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr style="vertical-align: middle !important; text-align: center;">
                                                    <td><?php echo e($formation->id_inv_sport); ?></td>
                                                    <td><?php echo e($formation->investissements->first()?->utilisateur?->nom_prenom ?? '---'); ?></td>
                                                    <td><?php echo e($formation->natureProjet?->nature_ar ?? '---'); ?></td>
                                                    <td>
                                                        <?php
                                                            $statut = $formation->statut?->statut_ar ?? 'في الانتظار';
                                                            $badgeClass = match($formation->id_statut) {
                                                                1 => 'status-badge--success',
                                                                3 => 'status-badge--danger',
                                                                default => 'status-badge--pending'
                                                            };
                                                        ?>
                                                        <span class="status-badge <?php echo e($badgeClass); ?>"><?php echo e($statut); ?></span>
                                                    </td>
                                                    <td class="text-center align-middle">
                                                        <div class="actions-cell d-inline-flex gap-2 flex-wrap justify-content-center align-items-center" role="group" aria-label="actions">
                                                            
                                                            <a href="<?php echo e(route('formation.show', $formation->id_inv_sport)); ?>"
                                                            class="btn-icon btn-icon--primary"
                                                            title="عرض" aria-label="عرض">
                                                                <i class="la la-eye"></i>
                                                            </a>

                                                            
                                                            <?php if($formation->id_statut == 2): ?>
                                                                
                                                                <button type="button"
                                                                        class="btn-icon btn-icon--warning"
																		onclick="window.location='<?php echo e(route('formation.edit', $formation->id_inv_sport)); ?>'"
                                                                        title="تعديل" aria-label="تعديل">
                                                                    <i class="la la-edit"></i>
                                                                </button>

                                                                
                                                                <form action="<?php echo e(route('formation.destroy', $formation->id_inv_sport)); ?>" method="POST" class="d-inline">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <button type="button"
                                                                            onclick="confirmDelete(this.closest('form'))"
                                                                            class="btn-icon btn-icon--danger"
                                                                            title="حذف" aria-label="حذف">
                                                                        <i class="la la-trash"></i>
                                                                    </button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="5" class="text-center">لا توجد استثمارات رياضية</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="mt-3">
                                    <?php echo e($formations->links('pagination::bootstrap-5')); ?>

                                </div>

                            </div>
                        </div>
                    </div>

            </div>
        </div>
    </div>
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function confirmEdit(url) {
        Swal.fire({
            title: 'هل تريد تعديل هذا الاستثمار؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    }

    function confirmDelete(form) {
        Swal.fire({
            title: 'هل تريد حذف هذا الاستثمار؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }

    function confirmStatusChange(form, currentStatus) {
        Swal.fire({
            title: `هل تريد تغيير الحالة الحالية (${currentStatus})؟`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }
</script>

<script src="<?php echo e(asset('assets/js/index.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_formation_stage/index.blade.php ENDPATH**/ ?>