<?php $__env->startSection('content'); ?>

 <div class="it-about-3-area p-relative pt-30 pb-125">
   <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
                <div class="container">
<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        
        <li class="breadcrumb-item active" aria-current="page">قائمة الحجوزات</li>
    </ol>
</nav>
             

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="it-section-title-box text-center mb-65" style="padding-top:50px;">
                                <span class="it-section-subtitle">طلبات الحجز في المركبات الشبابية</span>
                                <h4 class="it-section-title it-split-in-right mb-0">عرض جميع حجوزاتي</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-10">
                            <div class="card shadow-sm p-4">

                                <div class="d-flex justify-content-end mb-4">
                                    <a class="btn btn-success" href="<?php echo e(route('gouvernorats.index')); ?>">
                                        <i class="la la-plus me-1"></i> إضافة حجز
                                    </a>
                                </div>

                                <?php if(session('success')): ?>
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        <?php echo e(session('success')); ?>

                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                <?php endif; ?>

                                <div class="my-table table-responsive">
                                     <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                                        <thead class="thead-light">
                                           

                                            <tr>
                                                <th width="5%">المعرف</th>
                                                <th width="15%"> إسم المركب الشبابي </th>
                                                <th width="15%">تاريخ الحجز </th>
                                                <th width="10%">تاريخ الوصول </th>
                                                <th width="10%">تاريخ المغادرة </th>
                                                <th width="10%">السعر الإجمالي </th>
                                                <th width="10%"> وضعية الطلب</th>
                                                <th width="20%">إجراءات</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $reservations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reserv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr>
                                                    <td><?php echo e($reserv->id_reserv ?? '---'); ?></td>
                                                    <td><?php echo e($reserv->auberge->nom ?? '---'); ?></td>
                                                    <td><?php echo e($reserv->date_reserv ?? '---'); ?></td>
                                                    <td><?php echo e($reserv->date_arrive ?? '---'); ?></td>
                                                    <td><?php echo e($reserv->date_depart ?? '---'); ?></td>
                                                    <td><?php echo e($reserv->total_price ?? '---'); ?></td>
                                                    <td>
                                                        <?php
                                                            $statut = $reserv->statut->statut_ar ?? 'في الانتظار';
                                                            $badgeClass = match($statut) {
                                                                'في الانتظار' => 'status-badge--pending',
                                                                'قبول' => 'status-badge--success',
                                                                'مرفوض' => 'status-badge--danger',
                                                                default => 'bg-secondary'
                                                            };
                                                        ?>
                                                        <span class="status-badge <?php echo e($badgeClass); ?>"><?php echo e($statut); ?></span>
                                                    </td>

                                                    <td class="text-center">
                                                        <div class="actions-cell d-inline-flex gap-2 flex-wrap justify-content-center" role="group" aria-label="actions">
                                                            <a href="<?php echo e(route('reservation.show', $reserv->id_reserv)); ?>"
                                                            class="btn-icon btn-icon--primary"
                                                            title="عرض" aria-label="عرض">
                                                                <i class="bx bx-show"></i>
                                                            </a>

                                                            <?php if($reserv->statut_id == 2): ?>
                                                                    <form action="<?php echo e(route('reservation.destroy', $reserv->id_reserv)); ?>" method="POST" class="d-inline">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('DELETE'); ?>
                                                                        <button type="button"
                                                                                onclick="confirmDeleteReserv(this.closest('form'))"
                                                                                class="btn-icon btn-icon--danger"
                                                                                title="حذف" aria-label="حذف">
                                                                            <i class="bx bx-trash"></i>
                                                                        </button>
                                                                    </form>
                                                            <?php endif; ?>

                                                        </div>
                                                    </td>

                                                    
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td class="text-center text-muted">لا يوجد حجز.</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>

                            <div class="mt-3">
                                <?php echo e($reservations->links('pagination::bootstrap-5')); ?>

                            </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
       
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="<?php echo e(asset('assets/js/index.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/reservation_auberge/index.blade.php ENDPATH**/ ?>