<?php $__env->startSection('content'); ?>
<?php
    $locale = app()->getLocale();
    $dir = $locale === 'ar' ? 'rtl' : 'ltr';
?>

<section class="it-about-3-area p-relative pt-30 pb-125" dir="<?php echo e($dir); ?>" lang="<?php echo e($locale); ?>">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="<?php echo e(__('site.map_alt')); ?>">

    <div class="container">
        <nav class="breadcrumb-nav" aria-label="breadcrumb">
            <ol class="breadcrumb mb-0">
                <li class="breadcrumb-item">
                    <a href="<?php echo e(url('/')); ?>">
                        <i class="bi bi-house-fill"></i>
                        <span><?php echo e(__('site.breadcrumb_home')); ?></span>
                    </a>
                </li>

                <li class="breadcrumb-item">
                    <a href="<?php echo e(route('concours.available')); ?>">
                        <span><?php echo e(__('site.concours_page_title')); ?></span>
                    </a>
                </li>

                <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('site.concours_results_title')); ?></li>
            </ol>
        </nav>

        <div class="row">
            <div class="col-12 text-center mb-4">
                <span class="it-section-subtitle"><?php echo e(__('site.concours_results_title')); ?></span>

                
                <h4 class="it-section-title it-split-in-right mb-0">
                    <?php echo e(function_exists('trans_field') ? trans_field($concours, 'titre') : ($concours->titre ?? $concours->titre_G ?? '')); ?>

                </h4>

                <p class="text-muted mt-2">
                    <?php echo e(__('site.registration_ends')); ?>:
                    <?php echo e(optional($concours->date_fin)->format('Y-m-d') ?? '—'); ?>

                </p>
            </div>
        </div>

        <div class="row mb-3">
            <div class="col-lg-8 mx-auto">
                <form method="GET" action="<?php echo e(route('concours.results', $concours)); ?>" class="d-flex gap-2 align-items-center">
                    <input
                        name="q"
                        value="<?php echo e(old('q', $q ?? '')); ?>"
                        class="conc-input form-control form-control-sm"
                        placeholder="<?php echo e(__('site.results_search_placeholder')); ?>"
                    />
                    <div class="d-flex gap-2">
                        <button class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                            <?php echo e(__('site.search_button')); ?>

                        </button>

                        <a href="<?php echo e(route('concours.results', $concours)); ?>" style="width: 105px;" class="btn bg-rgb-primary1 font-weight-medium">
                            <?php echo e(__('site.reset_button')); ?>

                        </a>
                    </div>
                </form>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div class="card shadow-sm p-4">
                    <div class="form-section">
                        
                        <?php if(! ($searchRan ?? false) ): ?>
                          <div class="py-5 text-center">
                            <p class="h6 text-muted mb-2"><?php echo e(__('site.results_prompt')); ?></p>
                            <small class="text-muted"><?php echo e(__('site.results_prompt_note')); ?></small>
                          </div>

                        <?php else: ?>
                          
                          <div class="table-responsive">
                            <table class="table table-hover mb-0 align-middle <?php echo e($dir === 'rtl' ? 'text-end' : ''); ?>">
                              <thead class="table-light">
                                <tr>
                                  <th style="width:30%;"><?php echo e(__('site.table_name')); ?></th>
                                  <th style="width:15%;"><?php echo e(__('site.table_cin')); ?></th>
                                  <th style="width:25%;"><?php echo e(__('site.table_email')); ?></th>
                                  <th style="width:15%;"><?php echo e(__('site.table_status')); ?></th>
                                  <th style="width:15%;"><?php echo e(__('site.table_created_at')); ?></th>
                                </tr>
                              </thead>

                              <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $candidates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cand): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                  <tr>
                                    <td>
                                      <div><strong><?php echo e($cand->nom); ?> <?php echo e($cand->prenom); ?></strong></div>
                                      <div class="text-muted small"><?php echo e($cand->gouvernorat ?? '—'); ?></div>
                                    </td>
                                    <td><?php echo e($cand->cin ?? '—'); ?></td>
                                    <td>
                                      <?php if($cand->email): ?>
                                        <a href="mailto:<?php echo e($cand->email); ?>" class="text-decoration-none"><?php echo e($cand->email); ?></a>
                                      <?php else: ?>
                                        —
                                      <?php endif; ?>
                                    </td>
                                    <td>
                                      <span class="badge
                                        <?php echo e($cand->etat === 'acceptation_definitif' ? 'bg-success' : ($cand->etat === 'acceptation_primaire' ? 'bg-info text-dark' : ($cand->etat === 'refuse' ? 'bg-danger' : 'bg-warning text-dark'))); ?>">
                                        
                                        <?php echo e($cand->etat_label ?? __('site.status_'.$cand->etat)); ?>

                                      </span>
                                    </td>
                                    <td><small class="text-muted"><?php echo e(optional($cand->created_at)->format('Y-m-d')); ?></small></td>
                                  </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                  <tr>
                                    <td colspan="5" class="text-center py-4 text-muted"><?php echo e(__('site.no_results')); ?></td>
                                  </tr>
                                <?php endif; ?>
                              </tbody>
                            </table>
                          </div>

                          <div class="mt-3 d-flex justify-content-center">
                            <?php echo e($candidates->appends(request()->except('page'))->links('pagination::bootstrap-5')); ?>

                          </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/concours_ext/results.blade.php ENDPATH**/ ?>