

<?php $__env->startSection('styles'); ?>

<style>

/* --- RTL Global --- */

body {
    direction: rtl;
    text-align: right;
    font-family: 'Cairo', sans-serif;
}

/* --- Section principale --- */
.card {
    border-radius: 15px;
    border: 1px solid #e0e0e0;
    background: #fff;
    box-shadow: 0 8px 25px rgba(0, 0, 0, 0.15);
    transition: all 0.3s ease;
}

/* Effet au survol pour dynamisme */
.card:hover {
    transform: translateY(-5px);
    box-shadow: 0 12px 30px rgba(0, 0, 0, 0.2);
}

/* --- Labels et Inputs --- */
.form-label {
    display: block;
    margin-bottom: 0.5rem;
    font-weight: 600;
    color: #333;
}

.form-control {
    margin-bottom: 1rem;
    border-radius: 10px;
    border: 1px solid #ccc;
    padding: 10px 15px;
    text-align: right;
    transition: border-color 0.3s ease;
}

.form-control:focus {
    border-color: #ff6600;
    box-shadow: 0 0 4px rgba(255, 102, 0, 0.4);
}

/* --- Boutons personnalisés (rouge vif) --- */
.it-btn-red, .it-btn-secondary {
    border: none;
    border-radius: 10px;
    padding: 10px 25px;
    font-weight: bold;
    transition: all 0.3s ease;
    box-shadow: 0 3px 8px rgba(0,0,0,0.15);
}

/* Bouton principal rouge */
.it-btn-red {
    background-color: #dc3545; /* rouge vif */
    color: #fff;
}

.it-btn-red:hover {
    background-color: #b52a37;
    transform: translateY(-2px);
}

/* Bouton secondaire gris */
.it-btn-secondary {
    background-color: #6c757d;
    color: #fff;
}

.it-btn-secondary:hover {
    background-color: #5a6268;
    transform: translateY(-2px);
}

/* --- Messages d’alerte --- */
.alert {
    border-radius: 10px;
    direction: rtl;
    text-align: right;
}

/* --- Titres et structure --- */
.it-section-title-box span {
    font-size: 1.2rem;
    color: #ff6600;
}

.it-section-title {
    font-weight: 700;
    color: #333;
}

/* --- Animation au basculement --- */
#profile-edit, #profile-info {
    transition: opacity 0.3s ease;
}

.it-section-subtitle {
    color: #dc3545 !important; /* rouge vif */
    font-weight: 600;
    font-size: 18px;
    letter-spacing: 0.5px;
}

.btn-back {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    background-color: #dc3545; /* rouge vif */
    color: #fff !important;
    font-weight: 600;
    padding: 10px 22px;
    border-radius: 30px;
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 3px 8px rgba(220, 53, 69, 0.25);
    direction: rtl; /* pour alignement naturel en arabe */
}

.btn-back:hover {
    background-color: #b52a37;
    transform: translateY(-2px);
    box-shadow: 0 6px 15px rgba(220, 53, 69, 0.35);
}

.btn-back i {
    font-size: 18px;
    margin-left: 6px; /* espace entre l'icône et le texte */
}

</style>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>

<div class="it-about-3-area p-relative pt-90 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
        <div class="container mt-4 mb-2 text-end">
            <a href="<?php echo e(route('dashboard')); ?>" class="btn-back">
                <span><?php echo e(__('site.back')); ?></span>
                <i class="bi bi-arrow-left-circle-fill"></i>
            </a>
        </div>

        <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

        <div class="row">
            <div class="col-xl-12">
                <div class="it-section-title-box text-center mb-65" style="padding-top:50px;">
                    <span class="it-section-subtitle"><?php echo e(__('site.profile_section_subtitle')); ?></span>
                    <h4 class="it-section-title mb-0"><?php echo e(__('site.profile_section_title')); ?></h4>
                </div>
            </div>
        </div>

        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card p-4 shadow-sm">

                    
                    <?php if(session('success')): ?>
                        <div class="alert alert-success mb-4"><?php echo e(session('success')); ?></div>
                    <?php endif; ?>

                    <?php if($errors->any()): ?>
                        <div class="alert alert-danger mb-4">
                            <ul class="mb-0 list-unstyled">
                                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <li><?php echo e($error); ?></li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    <?php endif; ?>

                    
                    <div id="profile-info" class="row" style="padding: 40px;">
                        <div class="col-md-6 mb-3"><strong><?php echo e(__('site.full_name_label')); ?> :</strong> <?php echo e($user->nom_prenom); ?></div>
                        <div class="col-md-6 mb-3"><strong><?php echo e(__('site.email_label')); ?> :</strong> <?php echo e($user->email); ?></div>
                        <div class="col-md-6 mb-3"><strong><?php echo e(__('site.cin_label')); ?> :</strong> <?php echo e($user->cin); ?></div>
                        <div class="col-md-6 mb-3"><strong><?php echo e(__('site.cin_issue_date_label')); ?> :</strong> <?php echo e($user->date_delivrance_cin ? \Carbon\Carbon::parse($user->date_delivrance_cin)->format('d-m-Y') : __('site.not_specified')); ?></div>
                        <div class="col-md-6 mb-3"><strong><?php echo e(__('site.cin_issue_place_label')); ?> :</strong> <?php echo e($user->lieu_delivrance_cin ?? __('site.not_specified')); ?></div>
                        <div class="col-md-6 mb-3"><strong><?php echo e(__('site.contact_phone')); ?> :</strong> <?php echo e($user->tel ?? __('site.not_specified')); ?></div>
                        <div class="col-12 mb-3"><strong><?php echo e(__('site.contact_address')); ?> :</strong> <?php echo e($user->adresse ?? __('site.not_specified')); ?></div>

                        <div class="col-12 mt-4 text-center">
                            <button type="button" class="it-btn-orange toggle-edit-btn">
                                <i class="fa fa-edit me-2"></i> <?php echo e(__('site.profile_edit_button')); ?>

                            </button>
                        </div>
                    </div>

                    
                    <form id="profile-edit" action="<?php echo e(route('profile.update')); ?>" method="POST" class="d-none">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PUT'); ?>
                        <div class="row">
                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('site.full_name_label')); ?></label>
                                <input type="text" name="nom_prenom" class="form-control" value="<?php echo e($user->nom_prenom); ?>" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('site.email_label')); ?></label>
                                <input type="email" name="email" class="form-control" value="<?php echo e($user->email); ?>" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('site.cin_label')); ?></label>
                                <input type="text" name="cin" class="form-control" value="<?php echo e($user->cin); ?>" required>
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('site.cin_issue_date_label')); ?></label>
                                <input type="date" name="date_delivrance_cin" class="form-control" value="<?php echo e($user->date_delivrance_cin); ?>">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('site.cin_issue_place_label')); ?></label>
                                <input type="text" name="lieu_delivrance_cin" class="form-control" value="<?php echo e($user->lieu_delivrance_cin); ?>">
                            </div>

                            <div class="col-md-6 mb-3">
                                <label class="form-label"><?php echo e(__('site.contact_phone')); ?></label>
                                <input type="tel" name="tel" class="form-control" value="<?php echo e($user->tel); ?>">
                            </div>

                            <div class="col-12 mb-3">
                                <label class="form-label"><?php echo e(__('site.contact_address')); ?></label>
                                <textarea name="adresse" class="form-control" rows="3"><?php echo e($user->adresse); ?></textarea>
                            </div>

                            <div class="col-12 mt-4 text-center">
                                <button type="submit" class="it-btn-orange"><i class="fa fa-save me-2"></i> <?php echo e(__('site.profile_save_button')); ?></button>
                                <button type="button" class="it-btn-secondary ms-2 toggle-edit-btn"><i class="fa fa-times me-2"></i> <?php echo e(__('site.profile_cancel_button')); ?></button>
                            </div>
                        </div>
                    </form>

                </div>
            </div>
        </div>

    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>

<script>
jQuery(document).ready(function($) {
    function toggleEditMode() {
        $('#profile-info, #profile-edit').toggleClass('d-none');
    }

    $(document).on('click', '.toggle-edit-btn', function(e) {
        e.preventDefault();
        toggleEditMode();
    });

    $('#profile-edit').on('submit', function(e) {
        e.preventDefault();
        const form = $(this);
        const formData = form.serialize();

        $.ajax({
            url: form.attr('action'),
            method: 'POST',
            data: formData,
            success: function(response) {
                const successMsg = `
                    <div class="alert alert-success mb-4 text-right">
                        ${response.message || '<?php echo e(__('site.profile_update_success')); ?>'}
                    </div>`;
                form.prepend(successMsg);
                setTimeout(() => window.location.reload(), 1000);
            },
            error: function(xhr) {
                let errorHtml = '<ul class="mb-0 list-unstyled">';
                if (xhr.status === 422) {
                    const errors = xhr.responseJSON.errors;
                    for (let field in errors) errorHtml += `<li>${errors[field][0]}</li>`;
                    errorHtml += '</ul>';
                    form.prepend(`<div class="alert alert-danger mb-4 text-right">${errorHtml}</div>`);
                } else {
                    form.prepend(`
                        <div class="alert alert-danger mb-4 text-right">
                            <ul class="mb-0 list-unstyled">
                                <li><?php echo e(__('site.profile_update_error')); ?></li>
                            </ul>
                        </div>
                    `);
                }
            }
        });
    });
});
</script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Dataera\Desktop\front\resources\views/auth/profil.blade.php ENDPATH**/ ?>