<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('formation.index')); ?>">
                <span>مركز التربصات و تكوين الرياضيين</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">تعديل استمارة</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4" action="<?php echo e(route('formation.update', $formation->id_inv_sport)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
    <?php echo csrf_field(); ?>
   <?php echo method_field('PUT'); ?>
        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
              <h3><?php echo e($formulaire->type_ar); ?></h3>

        <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="<?php echo e(old('nom_prenom', $formation->investissements->first()?->utilisateur->nom_prenom)); ?>" 
                            placeholder="الاسم و اللقب" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="<?php echo e(old('lieu_naissance', $formation->investissements->first()?->utilisateur->lieu_naissance)); ?>" 
                           placeholder="مكان الولادة">
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="<?php echo e(old('date_naissance', $formation->investissements->first()?->utilisateur->date_naissance)); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="<?php echo e(old('adresse', $formation->investissements->first()?->utilisateur->adresse)); ?>" 
                           placeholder=" العنوان الشخصي " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="<?php echo e(old('niveau_etude', $formation->investissements->first()?->utilisateur->niveau_etude)); ?>" 
                           placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" 
                           value="<?php echo e(old('dernier_diplome', $formation->investissements->first()?->utilisateur->dernier_diplome)); ?>" 
                           placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" 
                           value="<?php echo e(old('experience', $formation->investissements->first()?->utilisateur->experience)); ?>" 
                           placeholder="الاقدمية في تعاطي النشاط" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات المشروع </h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> المكونات  </strong>
                    </label>
                </div>
            </div>

            <div class="row align-items-center mb-3">
                <div class="col-sm-2">
                    <label for="type_espace_s_id" class="col-sm-10 col-form-label">
                        <strong> الرجاء الاختيار </strong>
                    </label>
                </div>

                <div class="col-sm-4">
                    <select required class="form-control" id="type_espace_s_id" name="type_espace_s_id">
                        <option value="" disabled <?php echo e($formation->type_espace_s_id ? '' : 'selected'); ?>>اختر...</option>
                        <?php $__currentLoopData = $types_espace_es; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id_type_es); ?>"
                                <?php echo e($formation->type_espace_s_id == $type->id_type_es ? 'selected' : ''); ?>>
                                <?php echo e($type->type_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u> مميزات الفضاء  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الغرف </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_chambre" name="nbr_chambre" min="1" 
                        value="<?php echo e(old('nbr_chambre', $formation->nbr_chambre)); ?>">
                </div>

                <label class="col-sm-2 col-form-label"> عدد القاعات </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_salles" name="nbr_salles" min="1" 
                        value="<?php echo e(old('nbr_salles', $formation->nbr_salles)); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الملاعب </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_stade" name="nbr_stade" min="1" 
                        value="<?php echo e(old('nbr_stade', $formation->nbr_stade)); ?>">
                </div>

                <label class="col-sm-2 col-form-label"> عدد حجرات الملابس </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_vestiaire" name="nbr_vestiaire" min="1" 
                        value="<?php echo e(old('nbr_vestiaire', $formation->nbr_vestiaire)); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد مسالك الرياضية </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_stages_sportifs" name="nbr_stages_sportifs" min="1" 
                        value="<?php echo e(old('nbr_stages_sportifs', $formation->nbr_stages_sportifs)); ?>">
                </div>

                <label class="col-sm-2 col-form-label"> قاعة تقوية العضلات </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_salle_renforcement_musculaire" name="nbr_salle_renforcement_musculaire" min="1" 
                        value="<?php echo e(old('nbr_salle_renforcement_musculaire', $formation->nbr_salle_renforcement_musculaire)); ?>">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>طاقة الاستعاب</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> بالمبيت </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_foyer" name="capacite_accueil_foyer" min="1"
                        value="<?php echo e(old('capacite_accueil_foyer', $formation->capacite_accueil_foyer)); ?>">
                </div>

                <label class="col-sm-2 col-form-label"> الملاعب و فضاءات التنشيط </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_stade" name="capacite_accueil_stade" min="1"
                        value="<?php echo e(old('capacite_accueil_stade', $formation->capacite_accueil_stade)); ?>">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <u> الخدمات التي تؤمنها المؤسسة  </u>
                    </label>
                </div>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_rest" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_rest" name="heberg_rest" value="1"
                    <?php echo e(old('heberg_rest', $formation->heberg_rest) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="heberg_rest">
                    الإقامة والتغذية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="stage_activ" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="stage_activ" name="stage_activ" value="1"
                    <?php echo e(old('stage_activ', $formation->stage_activ) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="stage_activ">
                    إيواء التربصات والأنشطة التكوينية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_exercice" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_exercice" name="espace_exercice" value="1"
                    <?php echo e(old('espace_exercice', $formation->espace_exercice) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="espace_exercice">
                    فضاء التمارين
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="activite_culturel" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="activite_culturel" name="activite_culturel" value="1"
                    <?php echo e(old('activite_culturel', $formation->activite_culturel) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="activite_culturel">
                    التنشيط الثقافي
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="manifestation_sportif" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="manifestation_sportif" name="manifestation_sportif" value="1"
                    <?php echo e(old('manifestation_sportif', $formation->manifestation_sportif) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="manifestation_sportif">
                    التظاهرات الرياضية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="autres" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="autres" name="autres" value="1"
                    <?php echo e(old('autres', $formation->autres) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="autres">
                    غير ذلك
                </label>

                <div id="autres_services_wrapper" class="<?php echo e(old('autres', $formation->autres) ? 'd-flex align-items-center' : 'd-none'); ?>">
                    <input
                        class="form-control form-control-sm"
                        type="text"
                        id="autres_services"
                        name="autres_services"
                        placeholder="أدخل الخدمة الأخرى"
                        dir="rtl"
                        value="<?php echo e(old('autres_services', $formation->autres_services)); ?>"
                        style="min-width: 300px;"
                    >
                </div>
            </div>

            <script>
            document.addEventListener('DOMContentLoaded', function () {
                const checkbox = document.getElementById('autres');
                const wrapper  = document.getElementById('autres_services_wrapper');

                if (!checkbox || !wrapper) return;

                function toggleAutres() {
                    if (checkbox.checked) {
                        wrapper.classList.remove('d-none');
                        wrapper.classList.add('d-flex', 'align-items-center');
                    } else {
                        wrapper.classList.add('d-none');
                        wrapper.classList.remove('d-flex', 'align-items-center');
                    }
                }
                checkbox.addEventListener('change', toggleAutres);
                toggleAutres();
            });
            </script>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" placeholder="الاسم التجاري للمشروع"
                        maxlength="50" value="<?php echo e(old('nom_projet', $formation->nom_projet)); ?>">
                </div>

                <label class="col-sm-2 col-form-label" for="nature_projet_id">طبيعة المشروع</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled <?php echo e(old('nature_projet_id', $formation->nature_projet_id) ? '' : 'selected'); ?>>اختر...</option>
                        <?php $__currentLoopData = $nature_projet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($nature->id_nature_p); ?>"
                                    <?php echo e(old('nature_projet_id', $formation->nature_projet_id) == $nature->id_nature_p ? 'selected' : ''); ?>>
                                <?php echo e($nature->nature_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عدد مواطن الشغل</label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_emplois" name="nbr_emplois" min="1"
                        value="<?php echo e(old('nbr_emplois', $formation->nbr_emplois)); ?>">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>مدير المؤسسة</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" maxlength="50"
                        placeholder="الاسم و اللقب"
                        value="<?php echo e(old('nom_prenom_d', $formation->directeur->nom_prenom_d ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" maxlength="8"
                        value="<?php echo e(old('num_cin', $formation->directeur->num_cin ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance" name="date_delivrance"
                        value="<?php echo e(old('date_delivrance', $formation->directeur->date_delivrance ?? '')); ?>">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance" name="lieu_delivrance" placeholder="مكان الإصدار"
                        value="<?php echo e(old('lieu_delivrance', $formation->directeur->lieu_delivrance ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="niveau_etude" placeholder="المستوى التعليمي"
                        value="<?php echo e(old('niveau_etude', $formation->directeur->niveau_etude ?? '')); ?>">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="dernier_diplome_obtenu" placeholder="آخر شهادة متحصل عليها"
                        value="<?php echo e(old('dernier_diplome_obtenu', $formation->directeur->dernier_diplome_obtenu ?? '')); ?>">
                </div>
            </div>
        </div>

        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <?php $__currentLoopData = $formation->investissements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[<?php echo e($index); ?>][secteur_invest_id]" id="secteur_invest_id_<?php echo e($index); ?>">
                                <option value="" disabled>اختر...</option>
                                <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($secteur->id_secteur); ?>" 
                                        <?php echo e($inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : ''); ?>>
                                        <?php echo e($secteur->secteur_ar); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[<?php echo e($index); ?>][montant_inv]" 
                                class="form-control" min=1 value="<?php echo e($inv->montant_inv); ?>">
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[<?php echo e($index); ?>][id_source_financement]" id="id_source_financement_<?php echo e($index); ?>">
                                <option value="" disabled>اختر...</option>
                                <?php $__currentLoopData = $source_fin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($source->id_source); ?>" 
                                        <?php echo e($inv->id_source_financement == $source->id_source ? 'selected' : ''); ?>>
                                        <?php echo e($source->source_ar); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[<?php echo e($index); ?>][montant_fin]" 
                                class="form-control" min=1 value="<?php echo e($inv->montant_fin); ?>">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

              <button type="button" class="btn btn-success" onclick="addInvestissementRow()">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا..."><?php echo e(old('remarques', $formation->remarques)); ?></textarea>
        </div>
       <div class="form-group row text-center" style="padding-top:50px;">
            <div class="d-flex justify-content-end mb-4">
                               <button type="submit" class="btn btn-orange font-weight-medium" >
                    تحيين
                </button>
            </div>
          
        </div>
    </form>
</div>
        </div>


<script>
    document.addEventListener("DOMContentLoaded", function() {
    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
            textareaGroup.style.display = checkbox.checked ? "block" : "none";
            checkbox.addEventListener("change", function() {
                textareaGroup.style.display = this.checked ? "block" : "none";
            });
        }
        toggleTextarea("espace_spectacle", "caracteristique_group");
        toggleTextarea("espace_sportif", "caracteristique_sportif_group");
        toggleTextarea("espace_activite_service", "caracteristique_activite_serv_group");
        toggleTextarea("espace_activite_culturelle", "caracteristique_activite_cult_group");

    });
</script>

<script>
    let investIndex = 1; 
    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($secteur->id_secteur); ?>"><?php echo e($secteur->secteur_ar); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td data-label="الإستثمارالمبلغ ">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $source_fin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($source->id_source); ?>"><?php echo e($source->source_ar); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                  <td class="action-buttons">
                            <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                        </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>

<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_formation_stage/edit.blade.php ENDPATH**/ ?>