<?php $__env->startSection('content'); ?>

<div class="it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
     <nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span>اختيار نوع الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('exoneration_choix')); ?>">
                <span>مشاريع الإعفاء الجبائي</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">قائمة المشاريع</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">


                    <div class="it-section-title-box text-center mb-30" style="padding-top:20px;">
                        <span class="it-section-subtitle">مشاريع الإعفاء الجبائي</span>
                        <?php if($typeFormulaire): ?>
                            <h4 class="it-section-title it-split-in-right mb-0">
                                عرض جميع المشاريع : 
                                <br>
                               <span style="color:black; font-size:25px;"> <?php echo e($typeFormulaire->type_ar ?? $typeFormulaire->libelle); ?> </span> 
                            </h4>
                        <?php else: ?>
                            <h4 class="it-section-title it-split-in-right mb-0">عرض جميع المشاريع</h4>
                        <?php endif; ?>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="card shadow-sm p-4">

                                <div class="d-flex justify-content-end mb-4">
                                    <!--a class="btn btn-success" href="<?php echo e(route('exoneration.create')); ?>">
                                        <i class="la la-plus me-1"></i> إضافة مشروع
                                    </!--a-->

                                    <a class="btn btn-success" 
                                        href="<?php echo e(route('exoneration.create', ['id_type_formulaire' => request('id_type_formulaire')])); ?>">
                                        <i class="la la-plus me-1"></i> إضافة مشروع
                                    </a>
                                </div>

                                <?php if(session('success')): ?>
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        <?php echo e(session('success')); ?>

                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                <?php endif; ?>

                                 <div class="my-table table-responsive">
                                     <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                                        <thead class="thead-light">
                                           <tr>
                                                <th width="5%">المعرف</th>
                                                <th width="15%">الاسم و اللقب</th>
                                                <th width="25%">اسم المشروع</th>
                                                <th width="20%">مكان المشروع</th>
                                                <th width="15%">وضعية المشروع</th>
                                                <th width="20%">إجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                                <tr style="vertical-align: middle !important; text-align: center;">
                                                    <td><?php echo e($doc->id_doc); ?></td>
                                                    <td><?php echo e($doc->utilisateur?->nom_prenom ?? '---'); ?></td>
                                                    <td><?php echo e($doc->nom_projet); ?></td>
                                                    <td><?php echo e($doc->adresse_projet); ?></td>
                                                    <td>
                                                        <?php
                                                            $statut = $doc->statut?->statut_ar ?? 'في الانتظار';
                                                            $badgeClass = match($doc->id_statut) {
                                                                1 => 'status-badge--success',
                                                                3 => 'status-badge--danger',
                                                                4 => 'badge bg-warning text-dark',
                                                                5 => 'badge bg-primary',
                                                                default => 'status-badge--pending'
                                                               };
                                                        ?>
                                                      <span class="status-badge <?php echo e($badgeClass); ?>"><?php echo e($statut); ?></span>
                                                    </td>
                                                    <td class="text-center align-middle">
                                                        <div class="actions-cell d-inline-flex gap-2 flex-wrap justify-content-center align-items-center" role="group" aria-label="actions">
                                                            
                                                            <a href="<?php echo e(route('exoneration.show', $doc->id_doc)); ?>"
                                                            class="btn-icon btn-icon--primary"
                                                            title="عرض" aria-label="عرض">
                                                                <i class="la la-eye"></i>
                                                            </a>

                                                            
                                                            <?php if($doc->id_statut == 2): ?>
                                                                
                                                                <button type="button"
                                                                        class="btn-icon btn-icon--warning"
																		onclick="window.location='<?php echo e(route('exoneration.edit', $doc->id_doc)); ?>'"
                                                                        title="تعديل" aria-label="تعديل">
                                                                    <i class="la la-edit"></i>
                                                                </button>

                                                                
                                                                <form action="<?php echo e(route('exoneration.destroy', $doc->id_doc)); ?>" method="POST" class="d-inline">
                                                                    <?php echo csrf_field(); ?>
                                                                    <?php echo method_field('DELETE'); ?>
                                                                    <input type="hidden" name="id_type_formulaire" value="<?php echo e($doc->id_type_formulaire); ?>">
                                                                    <button type="button"
                                                                            onclick="confirmDelete(this.closest('form'))"
                                                                            class="btn-icon btn-icon--danger"
                                                                            title="حذف" aria-label="حذف">
                                                                        <i class="la la-trash"></i>
                                                                    </button>
                                                                </form>
                                                            <?php endif; ?>
                                                        </div>
                                                    </td>

                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                                <tr>
                                                    <td colspan="6" class="text-center">لا توجد مشاريع</td>
                                                </tr>
                                            <?php endif; ?>
                                        </tbody>
                                    </table>
                                </div>

                                <div class="mt-3">
                                    <?php echo e($documents->links('pagination::bootstrap-5')); ?>

                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeunesse-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });
    });

    function confirmEdit(url) {
        Swal.fire({
            title: 'هل تريد تعديل هذا المشروع؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    }

    function confirmDelete(form) {
        Swal.fire({
            title: 'هل تريد حذف هذا المشروع؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }

    function confirmStatusChange2(form, currentStatus) {
        Swal.fire({
            title: `هل تريد تغيير الحالة الحالية (${currentStatus})؟`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_exoneration/index.blade.php ENDPATH**/ ?>