<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<style>
    /* Taille des boutons réduite */
    .form-group button,
    .form-group a {
        min-width: 140px;
        font-weight: bold;
        border: none;
        border-radius: 8px;
        font-size: 14px;
        padding: 6px 10px;
        box-shadow: 0 3px 6px rgba(0,0,0,0.1);
        transition: all 0.2s ease-in-out;
    }

    .form-group button:hover,
    .form-group a:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 8px rgba(0,0,0,0.15);
    }

    /* Dégradé orange pour "حفظ كمسودة" */
    .btn-orange-gradient {
        background: linear-gradient(135deg, #ff9f43, #e96b05);
        color: #fff;
    }
    .btn-orange-gradient:hover {
        background: linear-gradient(135deg, #ffa94d, #ff7b1a);
    }

    /* Bouton Retour bleu */
    .btn-primary {
        background-color: #007bff;
    }
    .btn-primary:hover {
        background-color: #0069d9;
    }

    /* Responsive - garder même ligne si possible */
    @media (max-width: 768px) {
        .form-group .d-flex {
            flex-wrap: wrap;
            justify-content: center;
        }
        .form-group button,
        .form-group a {
            min-width: 120px;
            font-size: 13px;
            padding: 5px 8px;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit">
<div class="container">
<form action="<?php echo e(route('doc_fin.update', $docList->id_doc_list)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>


    <!-- Formulaire 1 -->
                <div class="container" lang="ar" dir="rtl">
                        <input type="hidden" name="id_association" value="<?php echo e($association->id_association ?? ''); ?>">
                        <input type="hidden" name="id_demande" value="<?php echo e($demande_id ?? ''); ?>">
                        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
                        <input type="hidden" name="id_projet" value="<?php echo e($id_projet ?? ''); ?>">

                        <h2 class="text-center">الجمهورية التونسية</h2>
                        <h3 class="text-center">وزارة شؤون الشباب و الرياضة</h3>
                        <h4 class="text-center mt-4">اللجنة الفنية للنظر في مطالب التمويل العمومي</h4>

                        <div class="card mt-4 shadow-sm">
                            <div class="card-header text-center bg-white">
                                <div class="row mb-3 align-items-center">
                                    <label  style="color:black;"    class="col-sm-3 col-form-label">إسم الجمعية</label>
                                    <div class="col-sm-9">
                                        <input type="text" name="nom_association" class="form-control" value="<?php echo e(old('nom_association', $docList->projet->demande->association->nom_association ?? '')); ?>">    
                                    </div>
                                </div>
                            </div>
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0"><?php echo e($formulaire->type_ar); ?></h5>
                                
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <?php $__currentLoopData = $type_financement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="col-md-4 col-sm-6 mb-2 text-center">
                                            <div class="form-check d-flex justify-content-start" dir="rtl">
                                                    <input class="form-check-input me-2 text-center" type="checkbox" name="types_financement[]" value="<?php echo e($type->id_type_fin); ?>"
                                                        <?php if( (old('types_financement') && in_array($type->id_type_fin, old('types_financement'))) || (!old('types_financement') && in_array($type->id_type_fin, $selectedTypes)) ): ?> checked <?php endif; ?>>
                                                    <label class="col-sm-12 col-form-label" style="color:black;"><?php echo e($type->type_ar); ?></label>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                            </div>
                        </div>

                        <div class="card mt-4 shadow-sm">
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0">المعطيات الخاصة بالجمعية</h5>
                            </div>
                            <div class="card-body">
                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label"> عنوان الجمعية</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="adresse" class="form-control" value="<?php echo e(old('adresse', $docList->projet->demande->association->adresse ?? '')); ?>" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">الترقيم البريدي</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="code_postal" class="form-control" value="<?php echo e(old('code_postal', $docList->projet->demande->association->code_postal ?? '')); ?>" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">الهاتف</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="tel" class="form-control" value="<?php echo e(old('tel', $docList->projet->demande->association->tel ?? '')); ?>" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">الفاكس</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="fax" class="form-control" value="<?php echo e(old('fax', $docList->projet->demande->association->fax ?? '')); ?>" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">تاريخ التأسيس</label>
                                    <div class="col-sm-4">
                                        <input type="date" name="date_creation" class="form-control" value="<?php echo e(old('date_creation', $docList->projet->demande->association->date_creation ?? '')); ?>" >
                                    </div>
                                    
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">رقم التأشيرة</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_visa" class="form-control" value="<?php echo e(old('num_visa', $docList->projet->demande->association->num_visa ?? '')); ?>" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">تاريخ التأشيرة</label>
                                    <div class="col-sm-4">
                                        <input type="date" name="date_visa" class="form-control" value="<?php echo e(old('date_visa', $docList->projet->demande->association->date_visa ?? '')); ?>" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">رقم المعرف الجبائي</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="num_identification_fiscale" class="form-control" value="<?php echo e(old('num_identification_fiscale', $docList->projet->demande->association->num_identification_fiscale ?? '')); ?>" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">رقم الحساب الجاري</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_compte_courant" class="form-control" value="<?php echo e(old('num_compte_courant', $docList->projet->demande->association->num_compte_courant ?? '')); ?>" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">  البنك</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="banque" class="form-control" value="<?php echo e(old('banque', $docList->projet->demande->association->banque ?? '')); ?>" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">البريد الإلكتروني</label>
                                    <div class="col-sm-4">
                                        <input type="email" name="adresse_mail" class="form-control" value="<?php echo e(old('adresse_mail', $docList->projet->demande->association->adresse_mail ?? '')); ?>" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">  عنوان موقع الواب</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="adresse_site_internet" class="form-control" value="<?php echo e(old('adresse_site_internet', $docList->projet->demande->association->adresse_site_internet ?? '')); ?>" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label"> إسم رئيس الجمعية</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="nom_president_association" class="form-control" value="<?php echo e(old('nom_president_association', $docList->projet->demande->association->nom_president_association ?? '')); ?>" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">  الهاتف الشخصي </label>
                                    <div class="col-sm-4">
                                        <input type="text" name="tel_personnel" class="form-control" value="<?php echo e(old('tel_personnel', $docList->projet->demande->association->tel_personnel ?? '')); ?>" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">عدد أعضاء المكتب الوطني للجمعية</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_membre_bureau_national_a" class="form-control" value="<?php echo e(old('num_membre_bureau_national_a', $docList->projet->demande->association->num_membre_bureau_national_a ?? '')); ?>" >
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">عدد المكاتب الجهوية ان وجدت</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_bureaux_regionaux" class="form-control" value="<?php echo e(old('num_bureaux_regionaux', $docList->projet->demande->association->num_bureaux_regionaux ?? '')); ?>" >
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">عدد المنخرطين الاجمالي</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_total_membre" class="form-control" value="<?php echo e(old('num_total_membre', $docList->projet->demande->association->num_total_membre ?? '')); ?>" >
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            

        <!-- Formulaire 2 -->
            <div class="container">
                    <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire2->id_type); ?>">
                    <input type="hidden" name="id_demande" value="<?php echo e($demande_id); ?>">
                    <h2 class="text-center">الجمهورية التونسية</h2>
                    <h2 class="text-center">وزارة الشباب و الرياضة</h2>
                    <h3 class="text-center" style="font-size:25px;"><?php echo e($formulaire2->type_ar); ?></h3>
                    <h4 class="text-center pt-3">جذاذة فنية</h4>
                    <br>

                    <div class="form-section">
                       <!--div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">إسم الجمعية</label>
                            <div class="col-sm-10">
                                <input type="hidden" name="id_association" value="<?php echo e($selectedAssociationId); ?>">
                                <input type="text" name="nom_association_display" class="form-control bg-white" readonly>
                            </div>
                        </!--div-->

                        
                        <h4>  المعطيات البيداغوجية</h4>
                        <div class="form-group row mb-3"  style="padding-top:20px;">
                            <label class="col-sm-2 col-form-label"> اسم و لقب المشرف على التنفيذ </label>
                            <div class="col-sm-4">
                                <input  type="text" class="form-control" name="nom_prenom_sup" placeholder="الاسم و اللقب" value="<?php echo e(old('nom_prenom_sup', $docList->projet->superviseur->nom_prenom_sup ?? '')); ?>" maxlength="100">
                            </div>
                            <label class="col-sm-2 col-form-label">  المهنة </label>
                            <div class="col-sm-4">
                                <input  type="text" class="form-control" name="profession_sup" placeholder=" المهنة  " value="<?php echo e(old('profession_sup', $docList->projet->superviseur->profession_sup ?? '')); ?>" maxlength="100" >
                            </div>
                        </div>
                        <div class="form-group row align-items-center">
                            <label class="col-sm-2 col-form-label"> الصفة في الجمعية</label>  
                            <div class="col-sm-4">
                                <input  type="text" class="form-control" name="role_sup" value="<?php echo e(old('role_sup', $docList->projet->superviseur->role_sup ?? '')); ?>" placeholder=" الصفة  " maxlength="100" >
                            </div>
                            <label class="col-sm-2 col-form-label">  الهاتف </label>
                            <div class="col-sm-4">
                                <input  type="text" class="form-control" name="tel_sup" value="<?php echo e(old('tel_sup', $docList->projet->superviseur->tel_sup ?? '')); ?>" max=12 >
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">  البريد الالكتروني </label>
                            <div class="col-sm-4">
                                <input  type="email" class="form-control" name="email_sup" value="<?php echo e(old('email_sup', $docList->projet->superviseur->email_sup ?? '')); ?>">
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label"> اسم المشروع / التظاهرة / النشاط </label>
                            <div class="col-sm-10">
                                <input  type="text" class="form-control" name="nom_projet" maxlength="255" value="<?php echo e(old('nom_projet', $docList->projet->nom_projet ?? '')); ?>">
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label"> مبررات الانجاز </label>
                            <div class="col-sm-10">
                                <textarea  class="form-control" name="justification_realisation" maxlength="255" rows="4" placeholder="ادخل مبررات الانجاز"><?php echo e(old('justification_realisation', $docList->projet->justification_realisation ?? '')); ?></textarea>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">الأهداف</label>
                            <div class="col-sm-10">
                                <textarea class="form-control" 
                                        name="objectives" 
                                        rows="4" 
                                        placeholder="أدخل الأهداف"><?php echo e(old('objectives', $docList->projet->objectives ?? '')); ?></textarea>

                                
                                <?php $__errorArgs = ['objectives'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <div class="text-danger mt-1"><?php echo e($message); ?></div>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label">  وصف الفقرات او المراحل </label>
                        </div>

                        <div class="form-group row">
                            <table id="phase-table" class="custom-table">
                                <thead>
                                    <tr>
                                        <th> </th> 
                                        <th>اهم الفقرات او المراحل</th>
                                        <th>تاريخ الانجاز</th>
                                        <th>مكان الإنجاز</th>
                                        <th> </th>
                                    </tr>
                                </thead>
                                <tbody id="phase-body">
                                    <?php if(!empty($docList->projet->activites) && $docList->projet->activites->count() > 0): ?>
                                        <?php $__currentLoopData = $docList->projet->activites; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $phase): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td class="row-number"><?php echo e($index + 1); ?></td>
                                                <td data-label="اهم الفقرات او المراحل">
                                                    <input type="text" 
                                                        name="phases[<?php echo e($index); ?>][description]" 
                                                        class="form-control" 
                                                        maxlength="200"
                                                        value="<?php echo e(old('phases.' . $index . '.description', $phase->description)); ?>">
                                                </td>
                                                <td data-label="تاريخ الانجاز">
                                                    <input type="date" 
                                                        name="phases[<?php echo e($index); ?>][completion_date]" 
                                                        class="form-control"
                                                        value="<?php echo e(old('phases.' . $index . '.completion_date', $phase->completion_date)); ?>">
                                                </td>
                                                <td data-label="مكان الإنجاز">
                                                    <input type="text" 
                                                        name="phases[<?php echo e($index); ?>][completion_location]" 
                                                        class="form-control" 
                                                        maxlength="100"
                                                        value="<?php echo e(old('phases.' . $index . '.completion_location', $phase->completion_location)); ?>">
                                                </td>
                                                <td class="action-buttons">
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="removePhaseRow(this)">حذف</button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr>
                                            <td class="row-number">1</td> 
                                            <td data-label="اهم الفقرات او المراحل">
                                                <input type="text" name="phases[0][description]" class="form-control"  maxlength="200">
                                            </td>
                                            <td data-label="تاريخ الانجاز">
                                                <input type="date" name="phases[0][completion_date]" class="form-control">
                                            </td>
                                            <td data-label="مكان الإنجاز">
                                                <input type="text" name="phases[0][completion_location]" class="form-control" maxlength="100">
                                            </td>
                                            <td class="action-buttons">
                                                <button type="button" class="btn btn-danger btn-sm" onclick="removePhaseRow(this)">حذف</button>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>

                            </table>
                            <button type="button" class="btn btn-primary mt-2" onclick="addPhaseRow()" style="background-color: #28a745; border-color: #28a745;">
                                إضافة صف
                            </button>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">  الجمهور المستفيد  </label>
                            <div class="col-sm-10">
                                <input  type="text" class="form-control" value="<?php echo e(old('public', $docList->projet->public ?? '')); ?>" name="public" maxlength="255">
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">العدد التقريبي للجمهور</label>
                            <div class="col-sm-10">
                                <input  type="number" class="form-control" name="nombre_spectateur" value="<?php echo e(old('nombre_spectateur', $docList->projet->nombre_spectateur ?? '')); ?>">
                            </div>
                        </div>

                        <div class="form-group row mb-3 align-items-center">
                            <label class="col-sm-2 col-form-label">الشريحة العمرية المستهدفة</label>

                            <div class="col-sm-5 d-flex align-items-center">
                                <label class="col-form-label mb-0 me-3">من</label>
                                <input  type="number" class="form-control" name="tranch_age_min" value="<?php echo e(old('tranch_age_min', $docList->projet->tranch_age_min ?? '')); ?>">
                            </div>

                            <div class="col-sm-5 d-flex align-items-center">
                                <label class="col-form-label mb-0 me-3">الى</label> 
                                <input  type="number" class="form-control" name="tranch_age_max" value="<?php echo e(old('tranch_age_max', $docList->projet->tranch_age_max ?? '')); ?>">
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label">  الاطراف المشاركة في الانجاز </label>
                            <div class="col-sm-12">
                                <textarea  class="form-control" name="parties_realisation" rows="4"><?php echo e(old('parties_realisation', $docList->projet->parties_realisation ?? '')); ?></textarea>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label"> النتائج المرتقب تحقيقها </label>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label"> 1- النتائج الكمية  </label>
                            <div class="col-sm-12">
                                <textarea  class="form-control" name="resultat_quantitatif" rows="4"><?php echo e(old('resultat_quantitatif', $docList->projet->resultat_quantitatif ?? '')); ?></textarea>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label"> 2- النتائج النوعية  </label>
                            <div class="col-sm-12">
                                <textarea  class="form-control" name="resultat_qualitatif" rows="4"><?php echo e(old('resultat_qualitatif', $docList->projet->resultat_qualitatif ?? '')); ?></textarea>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
                            <label class="col-sm-6 col-form-label"> الافاق المنتضرة </label>
                            <div class="col-sm-12">
                                <textarea  class="form-control" name="perspectives" rows="4"><?php echo e(old('perspectives', $docList->projet->perspectives ?? '')); ?></textarea>
                            </div>
                        </div>
                    </div>

                    <div class="form-section">
                        <h4>الموازنة المالية</h4>
                        <label class="col-sm-6 col-form-label">الميزانية التقديرية</label>

                        <div class="form-group row">
                            <table class="custom-table table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th rowspan="2">الكلفة الجملية التقديرية<br>(المبلغ بالدينار التونسي)</th>
                                        <th colspan="2">حجم التمويل الذاتي</th>
                                        <th colspan="2">حجم الدعم المطلوب من الوزارة</th>
                                    </tr>
                                    <tr>
                                        <th>النسبة المائوية</th>
                                        <th>المبلغ بالدينار</th>
                                        <th>المبلغ بالدينار</th>
                                        <th>النسبة المائوية</th>
                                    </tr>
                                </thead>
                                <tbody id="budget-body">
                                    <?php if(!empty($docList->projet->estimationBudget) && $docList->projet->estimationBudget->count() > 0): ?>
                                        <?php $__currentLoopData = $docList->projet->estimationBudget; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[<?php echo e($index); ?>][total_cost]" 
                                                        class="form-control"
                                                        value="<?php echo e(old('budget.' . $index . '.total_cost', $budget->cout_total_estime)); ?>">
                                                </td>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[<?php echo e($index); ?>][self_percent]" 
                                                        class="form-control"
                                                        value="<?php echo e(old('budget.' . $index . '.self_percent', $budget->financement_propre_pourcentage)); ?>">
                                                </td>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[<?php echo e($index); ?>][self_amount]" 
                                                        class="form-control"
                                                        value="<?php echo e(old('budget.' . $index . '.self_amount', $budget->financement_propre_montant)); ?>">
                                                </td>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[<?php echo e($index); ?>][ministry_amount]" 
                                                        class="form-control"
                                                        value="<?php echo e(old('budget.' . $index . '.ministry_amount', $budget->aide_ministere_montant)); ?>">
                                                </td>
                                                <td>
                                                    <input type="number" 
                                                        name="budget[<?php echo e($index); ?>][ministry_percent]" 
                                                        class="form-control"
                                                        value="<?php echo e(old('budget.' . $index . '.ministry_percent', $budget->aide_ministere_pourcentage)); ?>">
                                                </td>
                                                <td class="action-buttons">
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeBudgetRow(this)">حذف</button>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    <?php else: ?>
                                        <tr>
                                            <td><input type="number" name="budget[0][total_cost]" class="form-control"></td>
                                            <td><input type="number" name="budget[0][self_percent]" class="form-control"></td>
                                            <td><input type="number" name="budget[0][self_amount]" class="form-control"></td>
                                            <td><input type="number" name="budget[0][ministry_amount]" class="form-control"></td>
                                            <td><input type="number" name="budget[0][ministry_percent]" class="form-control"></td>
                                            <td class="action-buttons">
                                                <button type="button" class="btn btn-danger btn-sm" onclick="removeBudgetRow(this)">حذف</button>
                                            </td>
                                        </tr>
                                    <?php endif; ?>
                                </tbody>

                            </table>
                        </div>

                        <div class="form-group row">
                            <table id="supporters-table" class="custom-table table table-bordered text-center">
                                <thead>
                                    <tr>
                                        <th colspan="5">الأطراف المساهمة في الدعم</th>
                                    </tr>
                                    <tr>
                                        <th>ع/ر</th>
                                        <th>الطرف المساهم</th>
                                        <th>المبلغ بالدينار</th>
                                        <th>النسبة المائوية</th>
                                        <th>إجراء</th>
                                    </tr>
                                </thead>
                                <tbody id="supporters-body">
                                    <?php $__currentLoopData = $docList->projet->estimationBudget; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budgetIndex => $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($budget->contributeurs) && $budget->contributeurs->count() > 0): ?>
                                            <?php $__currentLoopData = $budget->contributeurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supporterIndex => $supporter): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="row-number"><?php echo e($supporterIndex + 1); ?></td>
                                                    <td>
                                                        <input type="text" 
                                                            name="budget[<?php echo e($budgetIndex); ?>][supporters][<?php echo e($supporterIndex); ?>][name]" 
                                                            class="form-control"
                                                            value="<?php echo e(old('budget.' . $budgetIndex . '.supporters.' . $supporterIndex . '.name', $supporter->nom)); ?>">
                                                    </td>
                                                    <td>
                                                        <input type="number" 
                                                            name="budget[<?php echo e($budgetIndex); ?>][supporters][<?php echo e($supporterIndex); ?>][amount]" 
                                                            class="form-control"
                                                            value="<?php echo e(old('budget.' . $budgetIndex . '.supporters.' . $supporterIndex . '.amount', $supporter->montant)); ?>">
                                                    </td>
                                                    <td>
                                                        <input type="number" 
                                                            name="budget[<?php echo e($budgetIndex); ?>][supporters][<?php echo e($supporterIndex); ?>][percent]" 
                                                            class="form-control"
                                                            value="<?php echo e(old('budget.' . $budgetIndex . '.supporters.' . $supporterIndex . '.percent', $supporter->pourcentage)); ?>">
                                                    </td>
                                                    <td>
                                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeSupporterRow(this)">حذف</button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <tr>
                                                <td class="row-number">1</td>
                                                <td><input type="text" name="budget[<?php echo e($budgetIndex); ?>][supporters][0][name]" class="form-control"></td>
                                                <td><input type="number" name="budget[<?php echo e($budgetIndex); ?>][supporters][0][amount]" class="form-control"></td>
                                                <td><input type="number" name="budget[<?php echo e($budgetIndex); ?>][supporters][0][percent]" class="form-control"></td>
                                                <td>
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeSupporterRow(this)">حذف</button>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>
                            <button type="button" class="btn btn-success mt-2" onclick="addSupporterRow(0)">إضافة صف</button>
                        </div>

                        <label class="col-sm-6 col-form-label"> ابواب صرف الميزانية </label>
                        <div class="form-group row">
                            <table id="depenses-table" class="custom-table">
                                <thead>
                                    <tr>
                                        <th> </th> 
                                        <th> الفقرات </th>
                                        <th>مستلزمات الفقرات (1)</th>
                                        <th>التكلفة (د) </th>
                                        <th> </th>
                                    </tr>
                                </thead>
                                <tbody id="depenses-body">
                                    <?php $__currentLoopData = $docList->projet->estimationBudget; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $budgetIndex => $budget): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <?php if(!empty($budget->postesDepense) && $budget->postesDepense->count() > 0): ?>
                                            <?php $__currentLoopData = $budget->postesDepense; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $depenseIndex => $depense): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td class="row-number"><?php echo e($depenseIndex + 1); ?></td>
                                                    <td data-label="الفقرات">
                                                        <input type="text" 
                                                            name="depenses[<?php echo e($budgetIndex); ?>][<?php echo e($depenseIndex); ?>][libelle_depense]" 
                                                            class="form-control" 
                                                            maxlength="200"
                                                            value="<?php echo e(old('depenses.' . $budgetIndex . '.' . $depenseIndex . '.libelle_depense', $depense->libelle_depense)); ?>">
                                                    </td>
                                                    <td data-label="مستلزمات الفقرات">
                                                        <input type="text" 
                                                            name="depenses[<?php echo e($budgetIndex); ?>][<?php echo e($depenseIndex); ?>][description]" 
                                                            class="form-control"
                                                            value="<?php echo e(old('depenses.' . $budgetIndex . '.' . $depenseIndex . '.description', $depense->description)); ?>">
                                                    </td>
                                                    <td data-label="التكلفة (د)">
                                                        <input type="number" 
                                                            name="depenses[<?php echo e($budgetIndex); ?>][<?php echo e($depenseIndex); ?>][cout]" 
                                                            class="form-control"
                                                            value="<?php echo e(old('depenses.' . $budgetIndex . '.' . $depenseIndex . '.cout', $depense->cout)); ?>">
                                                    </td>
                                                    <td class="action-buttons">
                                                        <button type="button" class="btn btn-danger btn-sm" onclick="removeDepensesRow(this)">حذف</button>
                                                    </td>
                                                </tr>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        <?php else: ?>
                                            <tr>
                                                <td class="row-number">1</td>
                                                <td data-label="الفقرات">
                                                    <input type="text" name="depenses[<?php echo e($budgetIndex); ?>][0][libelle_depense]" class="form-control" maxlength="200">
                                                </td>
                                                <td data-label="مستلزمات الفقرات">
                                                    <input type="text" name="depenses[<?php echo e($budgetIndex); ?>][0][description]" class="form-control">
                                                </td>
                                                <td data-label="التكلفة (د)">
                                                    <input type="number" name="depenses[<?php echo e($budgetIndex); ?>][0][cout]" class="form-control">
                                                </td>
                                                <td class="action-buttons">
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="removeDepensesRow(this)">حذف</button>
                                                </td>
                                            </tr>
                                        <?php endif; ?>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>

                            </table>
                            <button type="button" class="btn btn-primary mt-2" onclick="addDepensesRow()" style="background-color: #28a745; border-color: #28a745;">
                                    إضافة صف
                            </button>
                        </div>
                        <span>
                            (1) :  مستلزمات كل فقرة على حدة مثلا / مستلزمات الندوة او المعرض او الورشة او العرض 
                        </span>
                    </div>
            </div>
     

<!-- Formulaire 3 -->
    <div class="container">

        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire3->id_type); ?>">
        <input type="hidden" name="id_projet" value="<?php echo e($id_projet); ?>">
        <h2>الجمهورية التونسية</h2>
        <h2>وزارة الشباب و الرياضة</h2>
        <h3 style="font-size:25px;"><?php echo e($formulaire3->type_ar); ?></h3>
        <br>
        <div class="form-section">
            <div class="form-group row">
                <table id="phase-table" class="custom-table table table-bordered text-center">
                    <thead>
                        <tr>
                            <th>#</th> 
                            <th> الوثائق حسب الامر عدد 5183 </th>
                            <th> الوثائق </th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php $__currentLoopData = $typedocum; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                            $existing = $documents->firstWhere('id_doc', $doc->id_type_doc);
                        ?>
                        <tr>
                            <td><?php echo e($index + 1); ?></td>

                            <td>
                                <?php echo e($doc->type_ar); ?>

                                <input type="hidden" name="doc_fin[<?php echo e($index); ?>][id_doc]" value="<?php echo e($doc->id_type_doc); ?>">
                            </td>

                            <td>
                                <?php if(in_array($doc->id_type_doc, [15, 17])): ?>
                                    ✅ هذا الملف متوفر بالفعل
                                <?php else: ?>
                                    <?php if($existing && $existing->file): ?>
                                        <a href="<?php echo e(asset('storage/'.$existing->file)); ?>" 
                                        target="_blank" 
                                        class="btn btn-sm btn-info" 
                                        title="عرض الملف">
                                            📂 عرض الملف
                                        </a>
                                    <?php else: ?>
                                        <span class="text-muted">لا يوجد ملف</span>
                                    <?php endif; ?>
                                <?php endif; ?>
                            </td>

                            <td>
                                <?php if(!in_array($doc->id_type_doc, [15, 17])): ?>
                                    <input type="file" name="doc_fin[<?php echo e($index); ?>][file]" class="form-control">
                                <?php endif; ?>
                            </td>

                           
                        </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>

                </table>
            </div>
        </div>

    </div>
    <div class="form-group text-center mt-5">
    <input type="hidden" id="brouillon" name="brouillon" value="0">

    <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
        <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill"
                onclick="document.getElementById('brouillon').value = 0;">
            <i class="bx bx-save"></i> حفظ
        </button>

        

        <a href="<?php echo e(route('doc_fin.index')); ?>"
           class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
            <i class="bx bx-arrow-back"></i> رجوع
        </a>
    </div>
</div>

<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

   <div id="global-block-msg" class="alert alert-danger" style="display:none">
        يوجد مستندات مفقودة أو يلزم تعبئة خطوات سابقة — لن يتم حفظ الطلب حتى تكتمل الشروط.
    </div>
    
</div>  


</form>
</div>
<script src="<?php echo e(asset('BackOfficeAR/js/salle_sport_form.js')); ?>"></script>
<script src="<?php echo e(asset('BackOfficeAR/js/script.js')); ?>"></script>
<script>
    let phaseIndex = 1;

    function addPhaseRow() {
        let tableBody = document.getElementById('phase-body');
        let newRow = document.createElement('tr');
        newRow.innerHTML = `
            <td class="row-number">${tableBody.rows.length + 1}</td>
            <td data-label="اهم الفقرات او المراحل">
                <input type="text" name="phases[${phaseIndex}][description]" class="form-control" maxlength="200">
            </td>
            <td data-label="تاريخ الانجاز">
                <input type="date" name="phases[${phaseIndex}][completion_date]" class="form-control">
            </td>
            <td data-label="مكان الإنجاز">
                <input type="text" name="phases[${phaseIndex}][completion_location]" class="form-control">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn btn-danger btn-sm" onclick="removePhaseRow(this)">حذف</button>
            </td>
        `;
        tableBody.appendChild(newRow);
        phaseIndex++;
        updateRowNumbers();
    }

    function removePhaseRow(button) {
        let row = button.closest('tr');
        row.remove();
        updateRowNumbers();
    }

    function updateRowNumbers() {
        let tableBody = document.getElementById('phase-body');
        Array.from(tableBody.rows).forEach((row, index) => {
            row.querySelector('.row-number').textContent = index + 1;
        });
    }
</script>

<script>
    let supporterCounts = {0: 1};

    function addSupporterRow(rowIndex) {
        let tbody = document.getElementById('supporters-body');
        let supporterIndex = supporterCounts[rowIndex]++;

        let newRow = document.createElement('tr');
        newRow.innerHTML = `
            <td class="row-number"></td>
            <td><input type="text" name="budget[${rowIndex}][supporters][${supporterIndex}][name]" class="form-control"></td>
            <td><input type="number" name="budget[${rowIndex}][supporters][${supporterIndex}][amount]" class="form-control"></td>
            <td><input type="number" name="budget[${rowIndex}][supporters][${supporterIndex}][percent]" class="form-control"></td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeSupporterRow(this)">حذف</button>
            </td>
        `;

        tbody.appendChild(newRow);
        updateSupporterRowNumbers();
    }

    function removeSupporterRow(button) {
        button.closest('tr').remove();
        updateSupporterRowNumbers();
    }

    function updateSupporterRowNumbers() {
        let rows = document.querySelectorAll('#supporters-body tr');
        rows.forEach((row, index) => {
            row.querySelector('.row-number').textContent = index + 1;
        });
    }
</script>


<script>
    let depenseIndex = 1; 
    function addDepensesRow() {
        let tableBody = document.getElementById('depenses-body');
        let newRow = document.createElement('tr');

        newRow.innerHTML = `
            <td class="row-number">${tableBody.rows.length + 1}</td> 
            <td data-label="الفقرات">
                <input type="text" name="depenses[${depenseIndex}][libelle_depense]" class="form-control" maxlength="200">
            </td>
            <td data-label="مستلزمات الفقرات">
                <input type="text" name="depenses[${depenseIndex}][description]" class="form-control">
            </td>
            <td data-label="التكلفة (د)">
                <input type="number" name="depenses[${depenseIndex}][cout]" class="form-control" maxlength="100">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeDepensesRow(this)">حذف</button>
            </td>
        `;

        tableBody.appendChild(newRow);
        depenseIndex++;
        updateDepensesRowNumbers();
    }

    function removeDepensesRow(button) {
        let row = button.closest('tr');
        row.remove();
        updateDepensesRowNumbers();
    }

    function updateDepensesRowNumbers() {
        let tableBody = document.getElementById('depenses-body');
        Array.from(tableBody.rows).forEach((row, index) => {
            row.querySelector('.row-number').textContent = index + 1;
        });
    }
</script>

<?php $__env->stopSection(); ?>

<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>


<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/financement/documents_financement/edit.blade.php ENDPATH**/ ?>