<?php $__env->startSection('content'); ?>
<?php
    $locale = app()->getLocale();
    $dir = $locale === 'ar' ? 'rtl' : 'ltr';
?>

<div class="container my-5" dir="<?php echo e($dir); ?>" lang="<?php echo e($locale); ?>">

    <div class="trophee-card">

        
        <div class="trophee-header">
            <div class="trophee-date">
                <i class="la la-calendar"></i>
                <?php echo e(\Carbon\Carbon::parse($trophee->date)->format('d/m/Y')); ?>

            </div>

            <h2 class="trophee-title">
                <?php echo e(function_exists('trans_field') ? (trans_field($trophee, 'title') ?? $trophee->title) : ($trophee->title ?? '')); ?>

            </h2>

            <div style="width:80px;"></div> 
        </div>

        
        <div class="trophee-body">

            
            <div class="trophee-media">
                <?php if(!empty($trophee->image)): ?>
                    <img src="<?php echo e(asset('uploads/' . $trophee->image)); ?>"
                         alt="<?php echo e(function_exists('trans_field') ? (trans_field($trophee,'title') ?? __('site.no_image_alt')) : ($trophee->title ?? __('site.no_image_alt'))); ?>">
                <?php elseif(!empty($trophee->youtube_url)): ?>
                    <?php
                        preg_match('/(youtu\.be\/|v=)([A-Za-z0-9_\-]+)/', $trophee->youtube_url, $matches);
                        $youtubeId = $matches[2] ?? null;
                    ?>
                    <?php if($youtubeId): ?>
                        <div class="ratio ratio-16x9">
                            <iframe
                                src="https://www.youtube.com/embed/<?php echo e($youtubeId); ?>"
                                title="<?php echo e(__('site.youtube_video')); ?>"
                                allowfullscreen>
                            </iframe>
                        </div>
                    <?php endif; ?>
                <?php endif; ?>
            </div>

            
            <div class="trophee-content">
                <?php if(function_exists('trans_field')): ?>
                    <?php echo trans_field($trophee, 'content') ?? $trophee->content; ?>

                <?php else: ?>
                    <?php echo $trophee->content; ?>

                <?php endif; ?>
            </div>

        </div>

        <div class="text-center mt-5">
            <a href="<?php echo e(route('trophees.index')); ?>" class="btn-back text-white d-inline-flex align-items-center gap-2 px-4 py-2 rounded-pill" aria-label="<?php echo e(__('site.news_back_to_list')); ?>">
                <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                     xmlns="http://www.w3.org/2000/svg" style="transform: rotate(180deg);">
                    <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651
                            H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                          fill="white" />
                </svg>

                <span><?php echo e(__('site.news_back_to_list')); ?></span>
            </a>
        </div>

    </div>

</div>

<style>
    .btn-back {
        background-color: #E74C3C;
        font-weight: 600;
        font-size: 1rem;
        transition: all 0.3s ease;
        text-decoration: none;
    }

    .btn-back:hover {
        background-color: #c0392b; /* plus foncé au survol */
        transform: translateY(-2px);
        box-shadow: 0 3px 8px rgba(0, 0, 0, 0.2);
    }

    .btn-back svg {
        transition: transform 0.3s ease;
    }

    .btn-back:hover svg {
        transform: translateX(-4px) rotate(180deg);
    }

    .trophee-card {
        background: #fff;
        border-radius: 20px;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.1);
        overflow: hidden;
        transition: all 0.3s ease-in-out;
        padding: 30px;
    }

    .trophee-card:hover {
        transform: translateY(-3px);
    }

    .trophee-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 25px;
    }

    .trophee-title {
        font-weight: 700;
        font-size: 1.8rem;
        color: #222;
        text-align: center;
        flex: 1;
    }

    .trophee-date {
        color: #888;
        font-size: 0.95rem;
    }

    .trophee-media {
        flex: 1;
        max-width: 48%;
    }

    .trophee-media img,
    .trophee-media iframe {
        width: 100%;
        border-radius: 15px;
        box-shadow: 0 3px 10px rgba(0,0,0,0.15);
    }

    .trophee-content {
        flex: 1;
        max-width: 48%;
        line-height: 1.9;
        font-size: 1.1rem;
        color: #333;
        text-align: justify;
    }

    .trophee-body {
        display: flex;
        flex-wrap: wrap;
        justify-content: space-between;
        gap: 30px;
    }

    @media(max-width: 768px) {
        .trophee-body {
            flex-direction: column;
        }
        .trophee-media, .trophee-content {
            max-width: 100%;
        }
    }
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/trophees_sport/show.blade.php ENDPATH**/ ?>