<?php $__env->startSection('styles'); ?>

<?php if($errors->any()): ?>
    <div class="alert alert-danger">
        <ul>
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
<?php endif; ?>
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
    body[dir="rtl"] .select2-container--default .select2-selection--single {
        direction: rtl;
        text-align: right;
    }
    .card-resume { border-radius: 10px; box-shadow: 0 6px 18px rgba(0,0,0,0.06); }
    .small-muted { font-size: .85rem; color:#6c757d; }
    .form-label { font-weight: 600; }
    .resto-card {
    border-radius: 10px;
    box-shadow: 0 6px 18px rgba(0,0,0,0.06);
    padding: 12px;
    background: #fff;
    margin-bottom: 10px;
    direction: rtl;
}
.resto-card .resto-header {
    display:flex;
    justify-content:space-between;
    align-items:center;
    gap:10px;
}
.resto-card .resto-name { font-weight:700; font-size:1rem; }
.resto-card .resto-price { font-weight:700; font-size:0.95rem; }
.resto-card .resto-desc { color:#555; font-size:0.95rem; margin-top:6px; white-space:pre-wrap; }
#restoDetails .empty-placeholder { color:#6c757d; font-size:.95rem; padding:8px; }

</style>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="it-about-3-area p-relative pt-30 pb-125">
   <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
                <div class="container">
<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('reservation.index')); ?>">
                <span>قائمة الحجوزات</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">تفاصيل الحجز</li>
    </ol>
</nav>
 <h3 class="mb-4 text-center">إتمام الحجز في <?php echo e($auberge->nom_ar); ?></h3>        
    <div class="row">
        <div class="col-lg-8">
            <form method="POST" action="<?php echo e(route('reservation.store')); ?>" id="reservationForm" novalidate>
                <?php echo csrf_field(); ?>
                <input style="text-transform: none; direction: rtl;"  type="hidden" name="id_auberge" value="<?php echo e($auberge->id); ?>">
                <input style="text-transform: none; direction: rtl;"  type="hidden" name="user_id" value="<?php echo e(auth()->id() ?? ''); ?>">

                <div class="card p-3 mb-3">

                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">الإسم و اللقب</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" name="nom_prenom" id="nom_prenom" name="nom_prenom" class="form-control bg-white"
                                value="<?php echo e($user->nom_prenom ?? ''); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">البريد الإلكتروني</label>
                            <input style="text-transform: none; direction: rtl;"  type="email" name="email" id="email" name="email" class="form-control bg-white"
                                value="<?php echo e($user->email ?? ''); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">رقم الهاتف</label>
                            <input style="text-transform: none; direction: rtl;" type="text" name="telephone" class="form-control bg-white"
                                value="<?php echo e($user->tel ?? ''); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label"> العنوان </label>
                            <input style="text-transform: none; direction: rtl;"  type="text" name="adresse" class="form-control bg-white"
                       value="<?php echo e($user->adresse ?? ''); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">تاريخ الوصول</label>
                            <input style="text-transform: none; direction: rtl;"  type="date" name="date_arrive" id="date_arrive" class="form-control" required>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">تاريخ المغادرة</label>
                            <input style="text-transform: none; direction: rtl;" type="date" name="date_depart" id="date_depart" 
                                class="form-control" required disabled> 
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;" class="form-label">عدد الرجال</label>
                            <input style="text-transform: none; direction: rtl;" type="number" name="nbr_h" id="nbr_h" class="form-control" min="0" value="0">
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;" class="form-label">عدد النساء</label>
                            <input style="text-transform: none; direction: rtl;" type="number" name="nbr_f" id="nbr_f" class="form-control" min="0" value="0">
                        </div>


                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد الليالي</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" id="nights" class="form-control" readonly>
                        </div>
                        <div class="col-md-6 mb-3">
                            <label style="color:black;" class="form-label">عدد النزلاء</label>
                            <input style="text-transform: none; direction: rtl;" type="number" name="nbr_personnes" id="nbr_personnes" class="form-control" readonly>
                            <div id="capacityHelp" class="form-text small-muted">سعة الغرفة: -</div>
                        </div>

                        <div class="col-12 mb-3">
    <label class="form-label" style="color:black;">إضافة خدمات الطعام (اختياري)</label>

    <?php $__currentLoopData = $restaurations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="form-check mb-2">
            <input class="form-check-input rest-option" 
                   type="checkbox" 
                   data-price="<?php echo e($res->tarif); ?>" 
                   data-description="<?php echo e(\Illuminate\Support\Str::of($res->description_ar)->replace('"','&quot;')); ?>" 
                   data-nom="<?php echo e(\Illuminate\Support\Str::of($res->nom_ar)->replace('"','&quot;')); ?>"
                   id="resto_<?php echo e($res->id_rest); ?>"
                   value="<?php echo e($res->id_rest); ?>" 
                   name="restaurations_selected[]"
            >
            <label class="form-check-label" style="color:black;" for="resto_<?php echo e($res->id_rest); ?>">
                <?php echo e($res->nom_ar); ?>

                <small class="small-muted d-block"> <?php echo e(number_format($res->tarif, 2)); ?> د</small>
            </label>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <!-- Conteneur où s'affichent les cartes descriptives -->
    <div id="restoDetails" class="mt-3"></div>
</div>

 
                        <div class="col-12 mb-3">
                            <label style="color:black;"  class="form-label">الملاحظات</label>
                            <textarea name="remarque" class="form-control" rows="3"></textarea>
                        </div>

                        <div class="col-12 form-check mb-3">
                            <input style="text-transform: none; direction: rtl;"  class="form-check-input" type="checkbox" name="accept_terms" id="accept_terms" required>
                            <label style="color:black;"  class="form-check-label" for="accept_terms">أوافق على شروط وسياسة الإلغاء</label>
                        </div>
                    </div>

                    <div class="text-center mt-2">
                        <button id="submitBtn" type="submit" class="btn btn-success px-5" disabled>تأكيد الحجز</button>
                    </div>
                </div>
            </form>
        </div>

        <div class="col-lg-4">
            <div class="card p-3 card-resume">
                <h5 class="mb-2">ملخّص الحجز</h5>
                <p class="small-muted mb-1">المؤسسة: <strong><?php echo e($auberge->nom_ar); ?></strong></p>
                <p class="small-muted mb-1">السعة: <span id="summary_capacity">-</span></p>
                <p class="small-muted mb-1">سعر الليلة: <strong id="summary_prix_lit"><?php echo e($auberge->prix_lit); ?></strong> د</p>
                <hr>
                <p class="mb-1">عدد الليالي: <strong id="summary_nights">0</strong></p>
                <p class="mb-3">السعر الإجمالي: <strong id="summary_total">0 TND</strong></p>
                <input style="text-transform: none; direction: rtl;"  type="hidden" id="total_price" name="total_price">
            </div>
        </div>
    </div>
</div>
</div>
<?php $__env->startSection('scripts'); ?>
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<!--script>
const prixLit = parseFloat("<?php echo e($auberge->prix_lit); ?>") || 0;
$(function(){

    const $dateArr = $('#date_arrive');
    const $dateDep = $('#date_depart');
    const $nights = $('#nights');
    const $nbrTotal = $('#nbr_personnes');
    const $nbrH = $('#nbr_h');
    const $nbrF = $('#nbr_f');
    const todayStr = today.toISOString().split('T')[0]; 
    $dateArr.attr('min', todayStr);
    $dateDep.prop('disabled', true);

    $dateArr.on('change', function(){
        const arriveDateStr = $(this).val();
        if(arriveDateStr){
            const arriveDate = new Date(arriveDateStr);
            $dateDep.prop('disabled', false);

            const depMin = new Date(arriveDate);
            depMin.setDate(depMin.getDate() + 1);
            const depMinStr = depMin.toISOString().split('T')[0];
            $dateDep.attr('min', depMinStr);

            if($dateDep.val() && $dateDep.val() < depMinStr){
                $dateDep.val(depMinStr);
            }
        } else {
            $dateDep.prop('disabled', true);
            $dateDep.val('');
        }
        updateSummary();
    });

    // =========================
    // Fonctions de calcul
    // =========================
    function calcNights(){
        const a = new Date($dateArr.val());
        const b = new Date($dateDep.val());
        if($dateArr.val() && $dateDep.val() && b > a){
            const diff = Math.ceil((b - a)/(1000*60*60*24));
            $nights.val(diff);
            $('#summary_nights').text(diff);
            return diff;
        }
        $nights.val('');
        $('#summary_nights').text(0);
        return 0;
    }

    function updateSummary(){
        const nights = calcNights();

        const nbrPersons = parseInt($('#nbr_personnes').val()) || 0;
        const total = prixLit * nbrPersons * nights;

        $('#summary_type').text('—');
        $('#summary_capacity').text(nbrPersons);
        $('#summary_nights').text(nights);
        $('#summary_total').text(total.toFixed(2) + ' د');

        $('#total_price').val(total);
    }

    function calcRestaurations() {
        let total = 0;
        $('.rest-option:checked').each(function() {
            total += parseFloat($(this).data('price'));
        });
        return total;
    }


    function updateCapacitySummary(){
        const totalPersons = parseInt($nbrTotal.val()) || 0;
        $('#summary_capacity').text(totalPersons);
    }

    function updateTotalPersons() {
        let h = parseInt($nbrH.val()) || 0;
        let f = parseInt($nbrF.val()) || 0;
        let total = h + f;

        const maxTotal = parseInt($nbrTotal.attr('max')) || 1000;

        if(total > maxTotal){
            alert('مجموع الرجال والنساء لا يمكن أن يتجاوز عدد النزلاء: ' + maxTotal);
            if(f > 0) $nbrF.val(f - 1);
            else if(h > 0) $nbrH.val(h - 1);
            updateTotalPersons();
            return;
        }

        $nbrTotal.val(total);
        updateCapacitySummary();
        updateSummary();
    }

    // =========================
    // Événements
    // =========================
    $dateDep.on('change', updateSummary);

    $nbrH.on('input', updateTotalPersons);
    $nbrF.on('input', updateTotalPersons);
    $nbrTotal.on('input', function(){
        const total = parseInt($nbrTotal.val()) || 0;
        const h = parseInt($nbrH.val()) || 0;
        const f = parseInt($nbrF.val()) || 0;
        const sumHF = h + f;

        if(sumHF > total){
            const ratioH = h / sumHF;
            const ratioF = f / sumHF;
            $nbrH.val(Math.floor(total * ratioH));
            $nbrF.val(Math.ceil(total * ratioF));
        }
        updateCapacitySummary();
    });

    $('#reservationForm').on('submit', function(e){
    const h = parseInt($('#nbr_h').val()) || 0;
    const f = parseInt($('#nbr_f').val()) || 0;
    const nbrPersons = h + f;
    
    $('#nbr_personnes').val(nbrPersons);
     
    const nights = calcNights();
    const total = prixLit * nbrPersons * nights;

    $('#summary_total').text(total.toFixed(2) + ' د');
    $('#total_price').val(total);

    if(nights <= 0){
        e.preventDefault();
        alert('تحقق من تواريخ الوصول والمغادرة.');
        return false;
    }

    if(nbrPersons <= 0){
        e.preventDefault();
        alert('يجب إدخال عدد الرجال والنساء.');
        return false;
    }
});

});
</!script-->

<script>
const prixLit = parseFloat("<?php echo e($auberge->prix_lit); ?>") || 0;

$(function(){

    const today = new Date(); // ✅ Définit today
    const $dateArr = $('#date_arrive');
    const $dateDep = $('#date_depart');
    const $nights = $('#nights');
    const $nbrTotal = $('#nbr_personnes');
    const $nbrH = $('#nbr_h');
    const $nbrF = $('#nbr_f');

    const todayStr = today.toISOString().split('T')[0]; 
    $dateArr.attr('min', todayStr);
    $dateDep.prop('disabled', true);

    // --------------------
    // Gestion des dates
    // --------------------
    $dateArr.on('change', function(){
        const arriveDateStr = $(this).val();
        if(arriveDateStr){
            const arriveDate = new Date(arriveDateStr);
            $dateDep.prop('disabled', false);

            const depMin = new Date(arriveDate);
            depMin.setDate(depMin.getDate() + 1);
            const depMinStr = depMin.toISOString().split('T')[0];
            $dateDep.attr('min', depMinStr);

            if($dateDep.val() && $dateDep.val() < depMinStr){
                $dateDep.val(depMinStr);
            }
        } else {
            $dateDep.prop('disabled', true);
            $dateDep.val('');
        }
        updateSummary();
    });

    $dateDep.on('change', updateSummary);

    // --------------------
    // Calcul du nombre de nuits
    // --------------------
    function calcNights(){
        const a = new Date($dateArr.val());
        const b = new Date($dateDep.val());
        if($dateArr.val() && $dateDep.val() && b > a){
            const diff = Math.ceil((b - a)/(1000*60*60*24));
            $nights.val(diff);
            $('#summary_nights').text(diff);
            return diff;
        }
        $nights.val('');
        $('#summary_nights').text(0);
        return 0;
    }

    // --------------------
    // Calcul total des restaurations cochées
    // --------------------
    function calcRestaurations() {
        let total = 0;
        $('.rest-option:checked').each(function() {
            total += parseFloat($(this).data('price')) || 0;
        });
        return total;
    }

    // --------------------
    // Mise à jour du résumé
    // --------------------
    function updateSummary(){
        const nights = calcNights();
        const nbrPersons = parseInt($nbrTotal.val()) || 0;

        const baseTotal = prixLit * nbrPersons * nights;
        const restoTotal = calcRestaurations();
        const finalTotal = baseTotal + restoTotal;

        $('#summary_type').text('—');
        $('#summary_capacity').text(nbrPersons);
        $('#summary_nights').text(nights);
        $('#summary_total').text(finalTotal.toFixed(2) + ' د');

        $('#total_price').val(finalTotal);
    }

    // --------------------
    // Gestion des personnes
    // --------------------
    function updateCapacitySummary(){
        const totalPersons = parseInt($nbrTotal.val()) || 0;
        $('#summary_capacity').text(totalPersons);
    }

    function updateTotalPersons() {
        let h = parseInt($nbrH.val()) || 0;
        let f = parseInt($nbrF.val()) || 0;
        let total = h + f;

        const maxTotal = parseInt($nbrTotal.attr('max')) || 1000;

        if(total > maxTotal){
            alert('مجموع الرجال والنساء لا يمكن أن يتجاوز عدد النزلاء: ' + maxTotal);
            if(f > 0) $nbrF.val(f - 1);
            else if(h > 0) $nbrH.val(h - 1);
            updateTotalPersons();
            return;
        }

        $nbrTotal.val(total);
        updateCapacitySummary();
        updateSummary();
    }

    $nbrH.on('input', updateTotalPersons);
    $nbrF.on('input', updateTotalPersons);
    $nbrTotal.on('input', function(){
        const total = parseInt($nbrTotal.val()) || 0;
        const h = parseInt($nbrH.val()) || 0;
        const f = parseInt($nbrF.val()) || 0;
        const sumHF = h + f;

        if(sumHF > total){
            const ratioH = h / sumHF;
            const ratioF = f / sumHF;
            $nbrH.val(Math.floor(total * ratioH));
            $nbrF.val(Math.ceil(total * ratioF));
        }
        updateCapacitySummary();
        updateSummary();
    });

    // --------------------
    // Restaurations cochées
    // --------------------
    $('.rest-option').on('change', updateSummary);

    // --------------------
    // Soumission du formulaire
    // --------------------
    $('#reservationForm').on('submit', function(e){
        const h = parseInt($('#nbr_h').val()) || 0;
        const f = parseInt($('#nbr_f').val()) || 0;
        const nbrPersons = h + f;
        $('#nbr_personnes').val(nbrPersons);

        updateSummary();

        const nights = calcNights();
        if(nights <= 0){
            e.preventDefault();
            alert('تحقق من تواريخ الوصول والمغادرة.');
            return false;
        }

        if(nbrPersons <= 0){
            e.preventDefault();
            alert('يجب إدخال عدد الرجال والنساء.');
            return false;
        }
    });

});
</script>



<script>
$(document).ready(function() {
    const $checkbox = $('#accept_terms');
    const $submit = $('#submitBtn');

    $submit.prop('disabled', !$checkbox.is(':checked'));

    $checkbox.on('change', function() {
        $submit.prop('disabled', !$(this).is(':checked'));
    });
});


// --- Gestion affichage descriptif des restaurations sélectionnées ---
(function($){
    function escapeHtml(str) {
        if(!str) return '';
        return String(str)
            .replace(/&/g, "&amp;")
            .replace(/</g, "&lt;")
            .replace(/>/g, "&gt;")
            .replace(/"/g, "&quot;")
            .replace(/'/g, "&#039;");
    }

    function buildCard(id, nom, description, prix){
        const html = `
            <div class="resto-card" data-resto-id="${escapeHtml(id)}">
                <div class="resto-header">
                    <div class="resto-name">${escapeHtml(nom)}</div>
                    <div class="resto-price">${Number(prix).toFixed(2)} د</div>
                </div>
                <div class="resto-desc">${escapeHtml(description)}</div>
            </div>
        `;
        return html;
    }

    function renderSelectedRestos(){
        const $container = $('#restoDetails');
        $container.stop(true, true);
        $container.empty();

        const $checked = $('.rest-option:checked');
        if($checked.length === 0){
            $container.append('<div class="empty-placeholder">لم يتم اختيار أي خدمة طعام حتى الآن.</div>');
            return;
        }

        $checked.each(function(){
            const $this = $(this);
            const id = $this.val();
            const nom = $this.data('nom') || 'خدمة';
            const desc = $this.data('description') || '-';
            const prix = $this.data('price') || 0;

            $container.append(buildCard(id, nom, desc, prix));
        });

        // animation légère
        $container.hide().slideDown(180);
    }

    // bind events
    $(document).on('change', '.rest-option', function(){
        renderSelectedRestos();
        // --- si tu veux aussi mettre à jour le résumé total (déjà présent dans ton code) ---
        if(typeof updateSummary === 'function'){
            updateSummary();
        }
    });

    // init on load (au cas où certaines cases sont pré-cochées)
    $(document).ready(function(){
        renderSelectedRestos();
    });
})(jQuery);

</script>


<?php $__env->stopSection(); ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/reservation_auberge/reservation_form.blade.php ENDPATH**/ ?>