<?php $__env->startSection('content'); ?>
<?php
    $locale = app()->getLocale();
    $dir = $locale === 'ar' ? 'rtl' : 'ltr';
?>

<div class="container my-5" dir="<?php echo e($dir); ?>" lang="<?php echo e($locale); ?>">

    <h2 class="text-center mb-4"><?php echo e(__('site.trophies_title')); ?></h2>

    <div class="row">
        <?php $__currentLoopData = $trophee_sportif; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="col-md-4 mb-4">
                <div class="card h-100 shadow-sm">

                    <div class="card-img-top text-center" style="height:200px; overflow:hidden;">
                        <?php if(!empty($item->image)): ?>
                            <img src="<?php echo e(asset('uploads/' . $item->image)); ?>"
                                 alt="<?php echo e(trans_field($item,'title') ?? $item->title ?? __('site.no_image_alt')); ?>"
                                 class="img-fluid rounded"
                                 style="max-height:200px;">
                        <?php elseif(!empty($item->youtube_url)): ?>
                            <?php
                                preg_match('/(youtu\.be\/|v=)([A-Za-z0-9_\-]+)/', $item->youtube_url, $matches);
                                $youtubeId = $matches[2] ?? null;
                            ?>
                            <?php if($youtubeId): ?>
                                <iframe
                                    src="https://www.youtube.com/embed/<?php echo e($youtubeId); ?>"
                                    title="<?php echo e(__('site.youtube_video')); ?>"
                                    allowfullscreen
                                    class="w-100 rounded"
                                    style="height:200px;">
                                </iframe>
                            <?php endif; ?>
                        <?php else: ?>
                            <img src="<?php echo e(asset('assets/img/no-image.jpg')); ?>"
                                 alt="<?php echo e(__('site.no_image_alt')); ?>"
                                 class="img-fluid rounded">
                        <?php endif; ?>
                    </div>

                    <div class="card-body text-center">
                        <h5><?php echo e(trans_field($item,'title') ?? $item->title); ?></h5>

                        <div class="col-md-7 mx-auto" style="line-height: 1.9; font-size: 1.1rem; color:#333;">
                            <?php echo \Illuminate\Support\Str::limit(strip_tags(
                                trans_field($item,'resume') ??
                                ($item->resume_ar ?? $item->resume ?? '')
                            ), 200); ?>

                        </div>
                    </div>

                    <div class="it-about-2-btn text-center pb-3">
                        <a href="<?php echo e(route('trophees.show', $item->slug)); ?>" class="it-btn-orange">
                            <span>
                                <span class="text-1"><?php echo e(__('site.trophies_read_more')); ?></span>
                                <span class="text-2"><?php echo e(__('site.trophies_read_more')); ?></span>
                            </span>
                            <i>
                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                </svg>
                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                </svg>
                            </i>
                        </a>
                    </div>

                </div>
            </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>

    <div class="d-flex justify-content-center mt-4">
        <?php echo e($trophee_sportif->links()); ?> 
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/trophees_sport/index.blade.php ENDPATH**/ ?>