<?php $__env->startSection('styles'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('dashboard')); ?>">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('investissement_choix')); ?>">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="<?php echo e(route('salle-sport.index2')); ?>">
                <span>قائمة القاعات الرياضية</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">تعديل القاعة الرياضية</li>
    </ol>
</nav>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <form class="card shadow-sm p-4" action="<?php echo e(route('salle-sport.update2', $immobilier->id_imm)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">

        <h3><?php echo e($formulaire->type_ar); ?></h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>

       

        <div class="form-section">
            <h4>هوية الباعث</h4>  
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">الاسم و اللقب أو الاسم التجاري</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom" 
                        placeholder="الاسم و اللقب أو الاسم التجاري" maxlength="50" style="text-transform: none; direction: rtl;"
                        value="<?php echo e(old('nom_prenom', $immobilier->utilisateur->nom_prenom ?? '')); ?>">
                </div>
            </div>  

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput2()">
                        <option value="" disabled>اختر...</option>
                        <?php $__currentLoopData = $typesIdentite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id_type); ?>" 
                                <?php echo e(old('id_type_identite', $immobilier->utilisateur->id_type_identite ?? '') == $type->id_type ? 'selected' : ''); ?>>
                                <?php echo e($type->type_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-sm-6" id="identite-fields">
                    <input type="text" class="form-control identite-field" id="cin_input" name="cin" 
                        placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8" style="text-transform: none; direction: rtl;"
                        style="display:none;"
                        value="<?php echo e(old('cin', $immobilier->utilisateur->cin ?? '')); ?>">
                    <input type="text" class="form-control identite-field" id="passport_input" name="passport"  style="text-transform: none; direction: rtl;"
                        placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12"
                        style="display:none;"
                        value="<?php echo e(old('passport', $immobilier->utilisateur->passport ?? '')); ?>">
                    <input type="text" class="form-control identite-field" id="num_fiscal_input" name="num_fiscal" 
                        placeholder="أدخل رقم المعرف الجبائي"  style="text-transform: none; direction: rtl;" pattern="^\d{12}$" maxlength="12"
                        style="display:none;"
                        value="<?php echo e(old('num_fiscal', $immobilier->utilisateur->num_fiscal ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">رقم الهاتف الشخصي</label>
                <div class="col-sm-10">
                    <input required type="text" style="text-transform: none; direction: rtl;" class="form-control" name="tel" placeholder="رقم الهاتف الشخصي" maxlength="12"
                        value="<?php echo e(old('tel', $immobilier->utilisateur->tel ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
                <div class="col-sm-10">
                    <input required type="email" class="form-control"  style="text-transform: none; direction: rtl;" name="email" placeholder=" "
                        value="<?php echo e(old('email', $immobilier->utilisateur->email ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                <div class="col-sm-10">
                    <input required type="text" style="text-transform: none; direction: rtl;" class="form-control" name="adresse" placeholder=" " maxlength="100"
                        value="<?php echo e(old('adresse', $immobilier->utilisateur->adresse ?? '')); ?>">
                </div>
            </div>

            <h4>هوية العقار</h4> 
            <div class="form-group row">
                <label for="adresse_imm" class="col-sm-2 col-form-label">عنوان العقار</label>
                <div class="col-sm-10">
                    <input maxlength="255" style="text-transform: none; direction: rtl;" required type="text" class="form-control" id="adresse_imm" name="adresse_imm" placeholder=" "
                        value="<?php echo e(old('adresse_imm', $immobilier->adresse_imm ?? '')); ?>"
                        oninvalid="this.setCustomValidity('يجب ألا يتجاوز عنوان العقار 255 حرفاً')" 
                        oninput="this.setCustomValidity('')">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">الولاية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled <?php echo e(old('gouvernorat_id', $immobilier->gouvernorat_id ?? '') ? '' : 'selected'); ?>>اختر...</option>
                        <?php $__currentLoopData = $gouvernorats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gouv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($gouv->id_gouver); ?>"
                                <?php echo e(old('gouvernorat_id', $immobilier->gouvernorat_id ?? '') == $gouv->id_gouver ? 'selected' : ''); ?>>
                                <?php echo e($gouv->nom_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <label class="col-sm-2 col-form-label">البلدية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id" <?php echo e($immobilier->delegation_id ? '' : 'disabled'); ?>>
                        <option value="" disabled <?php echo e(old('delegation_id', $immobilier->delegation_id ?? '') ? '' : 'selected'); ?>>اختر...</option>
                        <?php if($immobilier->delegation_id): ?>
                            <?php $__currentLoopData = $delegations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $del): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($del->id_delegation); ?>"
                                    <?php echo e(old('delegation_id', $immobilier->delegation_id ?? '') == $del->id_delegation ? 'selected' : ''); ?>>
                                    <?php echo e($del->nom_ar); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
            </div>

            <div class="form-group row">
                <label for="type_imm_id" class="col-sm-2 col-form-label">صيغة العقار</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="type_imm_id" name="type_imm_id">
                        <option value="" disabled <?php echo e(old('type_imm_id', $immobilier->type_imm_id ?? '') ? '' : 'selected'); ?>>اختر...</option>
                        <?php $__currentLoopData = $typesImmobilier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id_type); ?>"
                                <?php echo e(old('type_imm_id', $immobilier->type_imm_id ?? '') == $type->id_type ? 'selected' : ''); ?>>
                                <?php echo e($type->type_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <label for="superfici_m2" class="col-sm-2 col-form-label">المساحة الجملية للعقار بالم2</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" id="superfici_m2" name="superfici_m2" placeholder=" "
                        value="<?php echo e(old('superfici_m2', $immobilier->superfici_m2 ?? '')); ?>"
                        oninvalid="this.setCustomValidity('المساحة يجب ان لا تتجاوز 100م2')" 
                        oninput="this.setCustomValidity('')" min="100">
                    <span>المساحة يجب ان تكون 100م2 على الاقل.</span>
                </div>                
            </div>

            <div class="form-group row">
                <label for="usage_id" class="col-sm-2 col-form-label">صيغة استغلال العقار</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="usage_id" name="usage_id">
                        <option value="" disabled <?php echo e(old('usage_id', $immobilier->usage_id ?? '') ? '' : 'selected'); ?>>اختر...</option>
                        <?php $__currentLoopData = $usagesImmobilier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($usage->id_usage_imm); ?>"
                                <?php echo e(old('usage_id', $immobilier->usage_id ?? '') == $usage->id_usage_imm ? 'selected' : ''); ?>>
                                <?php echo e($usage->usage_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <label for="document_propriete" class="col-sm-2 col-form-label">نسخة العقد/الملكية</label>
                <div class="col-sm-4">
                    <input type="file" class="form-control" id="document_propriete" name="document_propriete">
                    <?php if($immobilier->document_propriete): ?>
                        <small>الملف الحالي: <a href="<?php echo e(asset('storage/'.$immobilier->document_propriete)); ?>" target="_blank">عرض</a></small>
                    <?php endif; ?>
                </div>
            </div>
            <h4>مكونات العقار</h4>

            <?php
                $components = [
                    'salle_exercice','piscine','vestiaire','unitaires_sanitaire',
                    'stockage_conservation','espace_exterieur','garage'
                ];
            ?>
            <?php $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group row">
                    <label for="<?php echo e($comp); ?>" class="col-sm-2 col-form-label">
                        <?php switch($comp):
                            case ('salle_exercice'): ?> قاعة التمارين <?php break; ?>
                            <?php case ('piscine'): ?> حوض مائي <?php break; ?>
                            <?php case ('vestiaire'): ?> حجرات ملابس <?php break; ?>
                            <?php case ('unitaires_sanitaire'): ?> وحدات صحية <?php break; ?>
                            <?php case ('stockage_conser'): ?> فضاء للخزن و حفض الاثاث و المعدات <?php break; ?>
                            <?php case ('espace_exterieur'): ?> فضاء خارجي <?php break; ?>
                            <?php case ('garage'): ?> ماوى سيارات <?php break; ?>
                        <?php endswitch; ?>
                    </label>
                    <div class="col-sm-4">
                        <select required class="form-control" id="<?php echo e($comp); ?>" name="<?php echo e($comp); ?>" onchange="toggleSection('<?php echo e($comp); ?>','id_<?php echo e($comp); ?>')">
                            <option value="" disabled <?php echo e(old($comp, $immobilier->$comp ?? '') === null ? 'selected' : ''); ?>>اختر...</option>
                            <option value="1" <?php echo e(old($comp, $immobilier->$comp ?? '') == 1 ? 'selected' : ''); ?>>نعم</option>
                            <option value="0" <?php echo e(old($comp, $immobilier->$comp ?? '') == 0 ? 'selected' : ''); ?>>لا</option>
                        </select>
                    </div>

                    <div class="col-sm-6" id="id_<?php echo e($comp); ?>" style="display: <?php echo e(old($comp, $immobilier->$comp ?? '') == 1 ? 'block' : 'none'); ?>;">
                        <?php if(in_array($comp, ['salle_exercice','piscine','vestiaire'])): ?>
                            <div class="mb-2">
                                <input type="number" class="form-control" id="nbr_<?php echo e($comp); ?>" name="nbr_<?php echo e($comp); ?>" placeholder="عدد"
                                    value="<?php echo e(old('nbr_'.$comp, $immobilier->{'nbr_'.$comp} ?? '')); ?>">
                            </div>
                            <div>
                                <input type="number" class="form-control" id="superface_<?php echo e($comp); ?>" name="superface_<?php echo e($comp); ?>" placeholder="مساحة"
                                    value="<?php echo e(old('superface_'.$comp, $immobilier->{'superface_'.$comp} ?? '')); ?>">
                            </div>
                        <?php else: ?>
                            <input type="number" class="form-control" id="superface_<?php echo e($comp); ?>" name="superface_<?php echo e($comp); ?>" placeholder="مساحة"
                                value="<?php echo e(old('superface_'.$comp, $immobilier->{'superface_'.$comp} ?? '')); ?>">
                        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="form-group row">
                <label for="autres_surfaces" class="col-sm-2 col-form-label">مساحات اخرى</label>
                <div class="col-sm-10">
                    <input required type="number" class="form-control" id="autres_surfaces" name="autres_surfaces" 
                        value="<?php echo e(old('autres_surfaces', $immobilier->autres_surfaces ?? '')); ?>">
                </div>
            </div>
            
        </div>
        <div class="form-group row justify-content-center">
            <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-orange font-weight-medium" >
                    تحيين
                </button>
               
            </div>
        </div>


    </form>
</div>
</div>


<?php $__env->startSection('scripts'); ?>
<script>
    // Fonction pour gérer l'affichage des champs d'identité
    function showTypeIdentiteInput2() {
        const idType = document.getElementById('id_type_identite').value;
        const cinInput = document.getElementById('cin_input');
        const passportInput = document.getElementById('passport_input');
        const numFiscalInput = document.getElementById('num_fiscal_input');

        // Cacher tous les champs
        [cinInput, passportInput, numFiscalInput].forEach(input => {
            input.style.display = 'none';
            input.required = false;
        });

        // Afficher le champ approprié
        switch(idType) {
            case '1':
                cinInput.style.display = 'block';
                cinInput.required = true;
                break;
            case '2':
                passportInput.style.display = 'block';
                passportInput.required = true;
                break;
            case '3':
                numFiscalInput.style.display = 'block';
                numFiscalInput.required = true;
                break;
        }
    }

    // Fonction pour basculer l'affichage des sections
    function toggleSection(selectId, sectionId) {
        const select = document.getElementById(selectId);
        const section = document.getElementById(sectionId);
        if (!select || !section) return;

        const updateVisibility = () => {
            section.style.display = select.value === '1' ? 'block' : 'none';
        };

        select.addEventListener('change', updateVisibility);
        updateVisibility(); // État initial
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.salle-sport-edit select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });

        // Initialiser showTypeIdentiteInput2
        showTypeIdentiteInput2();

        // Initialiser les sections
        const sections = [
            'salle_exercice',
            'piscine',
            'vestiaire',
            'unitaires_sanitaire',
            'stockage_conservation',
            'espace_exterieur',
            'garage'
        ];

        sections.forEach(id => {
            toggleSection(id, 'id_' + id);
        });

        // Gérer la dépendance gouvernorat-delegation
        const gouvernoratSelect = document.getElementById('gouvernorat_id');
        const delegationSelect = document.getElementById('delegation_id');

        if (gouvernoratSelect && delegationSelect) {
            gouvernoratSelect.addEventListener('change', function() {
                const gouvernoratId = this.value;
                delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';

                if (gouvernoratId) {
                    fetch(`/delegations/${gouvernoratId}`)
                        .then(response => response.json())
                        .then(delegations => {
                            delegations.forEach(d => {
                                const option = new Option(d.nom_ar, d.id_delegation);
                                delegationSelect.add(option);
                            });
                            delegationSelect.disabled = false;
                        })
                        .catch(error => {
                            console.error('Erreur:', error);
                        });
                } else {
                    delegationSelect.disabled = true;
                }
            });
        }
    });
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {

    const gouvSelect = document.getElementById('gouvernorat_id');
    const delSelect  = document.getElementById('delegation_id');

    gouvSelect.addEventListener('change', function () {

        let gouvId = this.value;

        delSelect.innerHTML = '';
        delSelect.disabled = true;

        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';

        let url = "<?php echo e(route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER'])); ?>";
        url = url.replace("ID_PLACEHOLDER", gouvId);

        fetch(url)
            .then(response => response.json())
            .then(data => {

                
                delSelect.innerHTML = '<option disabled selected>اختر...</option>';

                
                data.forEach(d => {
                    let option = document.createElement('option');
                    option.value = d.id_delegation;
                    option.text  = d.nom_ar;
                    delSelect.appendChild(option);
                });

                delSelect.disabled = false;
            });
    });

});
</script>
<?php $__env->stopSection(); ?>

<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/front/resources/views/investissement/gestion_salle_sport/salle_sport/edit.blade.php ENDPATH**/ ?>