

<?php $__env->startSection('content'); ?>



 <div class="it-about-3-area p-relative pt-30 pb-125">
   <img class="it-about-shape-1" src="<?php echo e(asset('assets/img/shape/about-1-1.png')); ?>" alt="">
                <div class="container">
    <nav class="breadcrumb-nav" aria-label="breadcrumb">
      <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
          <a href="<?php echo e(route('dashboard')); ?>">
            <i class="bi bi-house-fill"></i>
            <span><?php echo e(__('site.breadcrumb_home')); ?></span>
          </a>
        </li>

        <li class="breadcrumb-item">
          <a href="<?php echo e(route('investissement_choix')); ?>">
            <span><?php echo e(__('site.breadcrumb_investment')); ?></span>
          </a>
        </li>

        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('site.breadcrumb_salles_list')); ?></li>
      </ol>
    </nav>
             

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="it-section-title-box text-center mb-30" style="padding-top:20px;">
                                <span class="it-section-subtitle"> <?php echo e(__('site.section_subtitle_requests')); ?></span>
                                <h4 class="it-section-title it-split-in-right mb-0">  <?php echo e(__('site.section_title_all_requests')); ?></h4>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="card shadow-sm p-4">

                                <div class="d-flex justify-content-end mb-4">
                                       <a class="btn btn-success" href="<?php echo e(route('salle-sport.create3')); ?>">
                                        <i class="la la-plus me-1"></i>  <?php echo e(__('site.btn_add_request')); ?>

                                    </a>
                                </div>

                                <?php if(session('success')): ?>
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        <?php echo e(session('success')); ?>

                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                <?php endif; ?>

 <div class="my-table table-responsive">
            <table class="table align-items-center table-flush mb-0 table-hover" style="<?php echo e(app()->getLocale() === 'ar' ? 'direction: rtl; text-align: right;' : ''); ?>">
              <thead class="thead-light">
                <tr>
                  <th width="5%"><?php echo e(__('site.table_id')); ?></th>
                  <th width="10%"><?php echo e(__('site.table_deposit_date')); ?></th>
                  <th width="15%"><?php echo e(__('site.table_applicant')); ?></th>
                  <th width="10%"><?php echo e(__('site.table_status')); ?></th>
                  <th width="30%"><?php echo e(__('site.table_actions')); ?></th>
                  <th width="15%"><?php echo e(__('site.table_start_activity')); ?></th>
                  <th width="15%"><?php echo e(__('site.table_tax_exemption')); ?></th>
                </tr>
              </thead>

              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $salles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $salle): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td><?php echo e($salle->id_imm); ?></td>
                    <td><?php echo e(optional($salle->created_at)->format('Y-m-d H:i')); ?></td>
                    <td><?php echo e($salle->utilisateur->nom_prenom ?? __('site.not_specified')); ?></td>

                    <td>
                      <?php
                        // translate status using file keys (safe approach)
                        $statusLabel = match($salle->id_statut) {
                          1 => __('site.status_pending'),
                          2 => __('site.status_accepted'),
                          3 => __('site.status_refused'),
                          default => __('site.status_unknown'),
                        };
                        $badgeClass = match($salle->id_statut) {
                          1 => 'status-badge--pending',
                          2 => 'status-badge--success',
                          3 => 'status-badge--danger',
                          default => 'bg-secondary',
                        };
                      ?>

                      <span class="status-badge <?php echo e($badgeClass); ?>"><?php echo e($statusLabel); ?></span>
                    </td>

                    <td class="text-center">
                      <div class="actions-cell d-inline-flex gap-2 flex-wrap justify-content-center" role="group" aria-label="actions">
                        <a href="<?php echo e(route('salle-sport.show2', $salle->id_imm)); ?>"
                           class="btn-icon btn-icon--primary"
                           title="<?php echo e(__('site.btn_view')); ?>" aria-label="<?php echo e(__('site.btn_view')); ?>">
                          <i class="la la-eye"></i>
                        </a>

                        <?php if($salle->id_statut == 2): ?>
                          <button type="button"
                                  class="btn-icon btn-icon--warning"
                                  onclick="window.location='<?php echo e(route('salle-sport.edit2', $salle->id_imm)); ?>'"
                                  title="<?php echo e(__('site.btn_edit')); ?>" aria-label="<?php echo e(__('site.btn_edit')); ?>">
                            <i class="la la-edit"></i>
                          </button>

                          <form action="<?php echo e(route('salle-sport.destroy2', $salle->id_imm)); ?>" method="POST" class="d-inline">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="button"
                                    onclick="confirmDelete(this.closest('form'))"
                                    class="btn-icon btn-icon--danger"
                                    title="<?php echo e(__('site.btn_delete')); ?>" aria-label="<?php echo e(__('site.btn_delete')); ?>">
                              <i class="la la-trash"></i>
                            </button>
                          </form>
                        <?php endif; ?>
                      </div>
                    </td>

                    <td class="text-center">
                      <?php if($salle->id_statut == 1): ?>
                        <?php $etat = optional($salle->debutActivite)->etat_formulaire; ?>
                        <div class="actions-activite d-inline-flex gap-2 justify-content-center" >
                          <?php if(is_null($salle->debutActivite) || $etat === 'non_remplir'): ?>
                            <button type="button" class="btn-icon btn-icon--success"
                                    onclick="openDebutActiviteForm(<?php echo e($salle->id_imm); ?>)"
                                    title="<?php echo e(__('site.start_activity_notify')); ?>" aria-label="<?php echo e(__('site.start_activity_notify')); ?>">
                              <?php echo e(__('site.start_activity_notify')); ?>

                            </button>

                          <?php elseif($etat === 'remplir'): ?>
                            <button type="button" class="btn-icon btn-icon--warning"
                                    onclick="openEditActiviteForm(<?php echo e(optional($salle->debutActivite)->id_debut); ?>)"
                                    title="<?php echo e(__('site.start_activity_edit')); ?>" aria-label="<?php echo e(__('site.start_activity_edit')); ?>">
                              <?php echo e(__('site.start_activity_edit')); ?>

                            </button>

                          <?php elseif($etat === 'reponse'): ?>
                            <button type="button" class="btn-icon btn-icon--info"
                                    onclick="openConsulterActiviteForm(<?php echo e(optional($salle->debutActivite)->id_debut); ?>)"
                                    title="<?php echo e(__('site.start_activity_view')); ?>" aria-label="<?php echo e(__('site.start_activity_view')); ?>">
                              <?php echo e(__('site.start_activity_view')); ?>

                            </button>
                          <?php endif; ?>
                        </div>
                      <?php endif; ?>
                    </td>

                    <td class="text-center">
                      <?php
                        $doc = $salle->documentsFormulaires->first();
                        $etat1 = $doc->etat_formulaire ?? null;
                      ?>

                      <?php if(optional($salle->debutActivite)->etat_formulaire === 'reponse' && optional($salle->debutActivite)->id_statut == 1): ?>
                        <div class="actions-activite d-inline-flex gap-2 justify-content-center">
                          <?php if(is_null($doc) || $etat1 === 'non_remplir'): ?>
                            <button type="button" class="btn-icon btn-icon--success" style="padding:10px 50px;"
                                    onclick="openExonerationForm(<?php echo e($salle->id_imm); ?>)"
                                    title="<?php echo e(__('site.exoneration_add')); ?>" aria-label="<?php echo e(__('site.exoneration_add')); ?>">
                              <?php echo e(__('site.exoneration_add')); ?>

                            </button>

                          <?php elseif($doc && $etat1 === 'remplir'): ?>
                            <button type="button" class="btn-icon btn-icon--warning" style="padding:10px 50px;"
                                    onclick="editExonerationForm(<?php echo e($doc->id_doc); ?>)"
                                    title="<?php echo e(__('site.exoneration_edit')); ?>" aria-label="<?php echo e(__('site.exoneration_edit')); ?>">
                              <?php echo e(__('site.exoneration_edit')); ?>

                            </button>

                          <?php elseif($doc && $etat1 === 'reponse'): ?>
                            <button type="button" class="btn-icon btn-icon--info" style="padding:10px 50px;"
                                    onclick="viewExonerationForm(<?php echo e($doc->id_doc); ?>)"
                                    title="<?php echo e(__('site.exoneration_view')); ?>" aria-label="<?php echo e(__('site.exoneration_view')); ?>">
                              <?php echo e(__('site.exoneration_view')); ?>

                            </button>
                          <?php endif; ?>
                        </div>
                      <?php endif; ?>
                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr>
                    <td colspan="7" class="text-center text-muted"><?php echo e(__('site.no_salles_requests')); ?></td>
                  </tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>

                            <div class="mt-3">
                                <?php echo e($salles->links('pagination::bootstrap-5')); ?>

                            </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
       
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">


<script>
    function openDebutActiviteForm(idImm) {
        window.location.href = "<?php echo e(route('debut_activite.create2')); ?>" + "?immobilier_id=" + idImm;
    }

    function openEditActiviteForm(idDebutActivite) {
        window.location.href = "<?php echo e(route('debut_activite.edit2', ':id')); ?>".replace(':id', idDebutActivite);
    }

    function openConsulterActiviteForm(idDebutActivite) {
        window.location.href = "<?php echo e(route('debut_activite.show2', ':id')); ?>".replace(':id', idDebutActivite);
    }

    function openExonerationForm(idImm) {
        window.location.href = `/salle-sport2/${idImm}/exoneration/create`;
    }

    function editExonerationForm(docId) {
        window.location.href = `/salle-sport2/exoneration/${docId}/edit`;
    }


    function viewExonerationForm(docId) {
        window.location.href = `/salle-sport2/exoneration/${docId}/show`;
    }
</script>
<script src="<?php echo e(asset('assets/js/index.js')); ?>"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Dataera\Desktop\front\resources\views/investissement/gestion_salle_sport/salle_sport/index.blade.php ENDPATH**/ ?>