<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\App;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\Auth\ForgotPasswordController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\ProfileController;
use App\Http\Controllers\UtilisateurController;
use App\Http\Controllers\RoleController;
use App\Http\Controllers\PermissionController;
use App\Http\Controllers\PasswordController;
use App\Http\Controllers\Investissement\SalleSportController;
use App\Http\Controllers\Investissement\DebutActiviteController;
use App\Http\Controllers\Investissement\JeuneEnfantController;
use App\Http\Controllers\Investissement\JeunesseController;
use App\Http\Controllers\Investissement\FormationStageController;
use App\Http\Controllers\Investissement\ExonarationController;
use App\Http\Controllers\Financement\DemandeFinancementPublicController;
use App\Http\Controllers\Financement\FormulaireController;
use App\Http\Controllers\Financement\DocumentFinancementController;
use App\Http\Controllers\Financement\Document2FinancementController;
use App\Http\Controllers\ManifestationSport\ManifestationSportController;
use App\Http\Controllers\ManifestationSport\ManifestationSport2Controller;
use App\Http\Controllers\MenuController;
use App\Http\Controllers\GuideController;

use App\Http\Controllers\Financement\FinancementController;


use App\Http\Controllers\FinancementStepperController;

use App\Http\Controllers\Api\PageBuilderController;
use App\Http\Controllers\EditorController;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\SearchController;
use App\Http\Controllers\ReservationController;
use App\Http\Controllers\ConcoursExtController;
use App\Http\Controllers\LanguageController;

use App\Http\Controllers\FieldDefinitionController;
/****** FrontOffice ********** */
Route::get('/', function () {
    return view('.home');
})->name('home');

Route::get('/', [HomeController::class, 'index'])->name('home');

// Routes avec middleware web et localization
Route::middleware(['web'])->group(function () {
    // Route de changement de langue
    Route::get('/lang/{lang}', [LanguageController::class, 'switchLang']);

    // Route de debug
    Route::get('/debug', function() {
        return [
            'app_locale' => app()->getLocale(),
            'session_locale' => session('applocale'),
            'config_locale' => config('app.locale'),
            'all_session' => session()->all()
        ];
    });

    // Routes principales
    Route::get('/', [HomeController::class, 'index'])->name('home');
});

Route::get('/trophees', [HomeController::class, 'trophees'])
    ->name('trophees.index');

Route::get('/trophees/{slug}', [HomeController::class, 'showTrophee'])
    ->name('trophees.show');

Route::get('/news', [HomeController::class, 'news'])
    ->name('news.index');

Route::get('/news/{slug}', [HomeController::class, 'showNews'])
    ->name('news.show');

Route::get('/search', [HomeController::class, 'search'])->name('search');
Route::get('/guide/{id}', [HomeController::class, 'redirectGuide'])->name('guide.redirect');


Route::get('/gouvernorats', function () {
    return view('search_gouver');
})->name('gouver');

Route::get('/gouvernorats', [HomeController::class, 'gouvernorats'])->name('gouvernorats.index');

Route::get('/builder/{id}', [HomeController::class, 'showBuilderPage'])->name('front.builder');
Route::get('/detail_gouver', function () {
    return view('detail_gouver');
})->name('detail_gouver');
Route::get('/detail_gouver/{id}', [HomeController::class, 'detailGouver'])->name('detail_gouver');
Route::get('/gouvernorat/{id}', [HomeController::class, 'detailGouver'])
     ->name('gouvernorat.detail');

// Route::get('/auberge', function () { return view('auberge'); })->name('auberge');

Route::get('/centres', function () {
    return view('general');
})->name('centres');

Route::get('/formulaire/{formulaire}', [HomeController::class, 'redirectToForm'])
    ->name('formulaire.access');

 Route::get('admin/field-definitions', [FieldDefinitionController::class, 'index'])
    ->name('field_definitions.index');

// Show create form
Route::get('admin/field-definitions/create', [FieldDefinitionController::class, 'create'])
    ->name('field_definitions.create');

// Store new field
Route::post('admin/field-definitions', [FieldDefinitionController::class, 'store'])
    ->name('field_definitions.store');

// Update existing field
Route::put('admin/field-definitions/{field_definition}', [FieldDefinitionController::class, 'update'])
    ->name('field_definitions.update');

// Delete
Route::delete('admin/field-definitions/{field_definition}', [FieldDefinitionController::class, 'destroy'])
    ->name('field_definitions.destroy');

// Toggle visibility quick action
Route::post('admin/field-definitions/{field_definition}/toggle', [FieldDefinitionController::class, 'toggleVisibility'])
    ->name('field_definitions.toggle');
Route::get('/concours-ext/create', [ConcoursExtController::class, 'create'])->name('concours_ext.create');
Route::post('/concours/{concours}/apply', [ConcoursExtController::class, 'store'])
    ->name('concours.apply');
Route::get('/concours/{concours}', [ConcoursExtController::class, 'show'])
    ->name('concours.show');
	
	

Route::get('/concours', [ConcoursExtController::class, 'index'])
    ->name('concours.available');

Route::get('/concours/{concours}/results', [ConcoursExtController::class, 'results'])
    ->name('concours.results');   





Route::get('/menu', [MenuController::class, 'header'])->name('menu.header');
Route::get('/guide/pageAR/{id_P}', [GuideController::class, 'showPage'])->name('guide.pageAR');
Route::get('/auberge/{id}', [HomeController::class, 'showAuberge'])->name('auberge.show');


Route::middleware(['auth'])->group(function () {
    Route::get('/reservation', [ReservationController::class, 'index'])
        ->name('reservation.index');

    Route::get('/reservation/{auberge_id}', [ReservationController::class, 'create'])
        ->name('reservation.create');
    Route::post('/reservation/store', [ReservationController::class, 'store'])
        ->name('reservation.store');
    Route::get('/reservation/{id}/show', [ReservationController::class, 'show'])
    ->name('reservation.show');
    Route::delete('/reservation/{id}', [ReservationController::class, 'destroy'])
    ->name('reservation.destroy');

    Route::post('/auberge/{id}/avis', [HomeController::class, 'storeAvis'])->name('auberge.avis.store');
    ///Route::put('/avis/{id}', [HomeController::class, 'updateAvis'])->name('auberge.avis.update');
// Ajouter un avis
//Route::post('/auberge/{id}/avis', [HomeController::class, 'storeAvis'])->name('auberge.avis.store');

// Modifier un avis existant
Route::put('/avis/{id}', [HomeController::class, 'updateAvis'])->name('auberge.avis.update');



});




/*Route::get('/builder', function () {
    return view('builder');
})->middleware('auth');

Route::post('/pages/save', [PageBuilderController::class, 'store'])->middleware('auth:sanctum'); 
Route::get('/page/{id}', function($id){
    $page = Page::findOrFail($id);
    return view('front.page', compact('page'));
});
*/


Route::get('/pages/{id}/sections', [App\Http\Controllers\SectionController::class, 'listByPage']);
Route::get('/sections/{id}', [App\Http\Controllers\SectionController::class, 'show']);
Route::post('/sections/{id}', [App\Http\Controllers\SectionController::class, 'save']); // update HTML
Route::post('/sections', [App\Http\Controllers\SectionController::class, 'store']); // create

Route::get('/editor/page/{id}', [EditorController::class, 'editor'])->name('editor.page')->middleware('auth');
Route::post('/upload-asset', [App\Http\Controllers\AssetController::class, 'upload'])->middleware('auth');



/*  Athentification  */
 
Route::get('/check-cin-view', function () {
    return view('auth.check_cin');
})->name('checkCin');

Route::get('/register', [AuthController::class, 'registerForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);

Route::get('/register/confirm/{utilisateur}', [AuthController::class, 'confirmForm'])
    ->name('register.confirm.form');

Route::post('/register/confirm/{utilisateur}', [AuthController::class, 'confirm'])
    ->name('register.confirm');

Route::post('/register/confirm/{utilisateur}/resend', [AuthController::class, 'resendConfirmation'])
    ->name('register.confirm.resend');
Route::get('/login', [AuthController::class, 'loginForm'])
    ->middleware('guest:web')
    ->name('login');
Route::post('/login', [AuthController::class, 'login']);
Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
Route::get('/forgot-password', [ForgotPasswordController::class, 'showForgotForm'])->name('password.request');
Route::post('/forgot-password', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');

Route::get('/reset-password/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset');
Route::post('/reset-password', [ResetPasswordController::class, 'reset'])->name('password.update');


Route::get('/dashboard', function() {
    return view('auth.myaccount');
})->middleware('auth')->name('dashboard');

// Routes publiques
Route::middleware(['web'])->group(function () {
    Route::get('/', [HomeController::class, 'index'])->name('home');
    Route::get('/lang/{lang}', [LanguageController::class, 'switchLang']);
    
    // Routes d'authentification
    Route::middleware(['guest'])->group(function () {
        Route::get('/login', [AuthController::class, 'loginForm'])->name('login');
        Route::post('/login', [AuthController::class, 'login']);
        Route::get('/forgot-password', [ForgotPasswordController::class, 'showForgotForm'])->name('password.request');
        Route::post('/forgot-password', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
        Route::get('/reset-password/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset');
        Route::post('/reset-password', [ResetPasswordController::class, 'reset'])->name('password.update');
    });
});

// Routes protégées - utilisateur connecté
Route::middleware(['web', 'auth'])->group(function () {
    Route::get('/dashboard', function() {
        return view('auth.myaccount');
    })->name('dashboard');
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');

    Route::get('/exoneration_choix', function () {
        return view('auth.exoneration_choix');
    })->name('exoneration_choix');

    Route::get('/investissment_choix', function () {
    return view('auth.investissement_choix');})->name('investissement_choix');

    Route::get('/manifestation_choix', function () {
    return view('auth.manifestation_choix');})->name('manifestation_choix');

    Route::get('/account-details', [AuthController::class, 'accountDetails'])->name('account.details');

    // Routes du profil
    Route::get('/profile', [ProfileController::class, 'show'])->name('profile.show');
    Route::put('/profile/update', [ProfileController::class, 'update'])->name('profile.update');
//investissement Creation Salle Sport
    Route::get('/investissement/salle-sport2', [SalleSportController::class, 'index2'])->name('salle-sport.index2');
    Route::get('/investissement/salle-sport2/create2', [SalleSportController::class, 'create3'])->name('salle-sport.create3');
    Route::post('/investissement/salle-sport2/store', [SalleSportController::class, 'store2'])->name('salle-sport.store2');
    Route::get('/investissement/salle-sport2/{id_imm}', [SalleSportController::class, 'show2'])->name('salle-sport.show2');
    Route::get('/investissement/salle-sport2/{id_imm}/edit', [SalleSportController::class, 'edit2'])->name('salle-sport.edit2');
    Route::put('/investissement/salle-sport2/{id_imm}', [SalleSportController::class, 'update2'])->name('salle-sport.update2');
    Route::delete('/investissement/salle-sport2/{id_imm}', [SalleSportController::class, 'destroy2'])->name('salle-sport.destroy2');
    Route::patch('/salle-sport2/{salle}/acceptation', [SalleSportController::class, 'toggleStatut2'])
        ->name('salle-sport2.acceptation');

    Route::get('/salle-sport2/{id_imm}/exoneration/create', [SalleSportController::class, 'createExoneration'])
        ->name('salle-sport.exoneration.create');
    Route::post('/salle-sport2/{id_imm}/exoneration/store', [SalleSportController::class, 'storeExoneration'])
        ->name('salle-sport.exoneration.store');
    Route::get('/salle-sport2/exoneration/{id}/edit', [SalleSportController::class, 'editExoneration'])
    ->name('salle-sport.exoneration.edit');
    Route::put('/salle-sport2/exoneration/{id}/update', [SalleSportController::class, 'updateExoneration'])
    ->name('salle-sport.exoneration.update');
    Route::get('/salle-sport2/exoneration/{id}/show', [SalleSportController::class, 'showExoneration'])
    ->name('salle-sport.exoneration.show');

    
    


//investissement Debut activite (salla de sport)
    Route::get('debut-activite', [DebutActiviteController::class, 'index2']) ->name('debut_activite.index2');
    Route::get('debut-activite/create', [DebutActiviteController::class, 'create2'])
        ->name('debut_activite.create2');
    Route::post('debut-activite/store', [DebutActiviteController::class, 'store2'])
        ->name('debut_activite.store2');
    Route::post('debut-activite/verifier-identite', [DebutActiviteController::class, 'verifierIdentite2'])
        ->name('debut_activite.verifier_identite2');
    Route::get('debut-activite/{id}/edit', [DebutActiviteController::class, 'edit2'])
        ->name('debut_activite.edit2');
    Route::put('debut-activite/{id}', [DebutActiviteController::class, 'update2'])
        ->name('debut_activite.update2');
    Route::get('debut-activite/{id}', [DebutActiviteController::class, 'show2'])->name('debut_activite.show2');
    Route::patch('debut-activite/{id}/toggle-statut', [DebutActiviteController::class, 'toggleStatut2'])
         ->name('debut_activite.toggle_statut2');
    Route::delete('debut-activite/{id}', [DebutActiviteController::class, 'destroy2'])
        ->name('debut_activite.destroy2');


    // Jeune _ Enfant
            Route::get('jeune_enfant', [JeuneEnfantController::class, 'index'])
                ->name('jeune_enfant.index');
            Route::get('jeune_enfant/create', [JeuneEnfantController::class, 'create'])
                ->name('jeune_enfant.create');
            Route::post('jeune_enfant/store', [JeuneEnfantController::class, 'store'])
                ->name('jeune_enfant.store');
            Route::get('jeune_enfant/{id}/show', [JeuneEnfantController::class, 'show'])
                ->name('jeune_enfant.show');
            Route::patch('jeune_enfant/{id}/toggle-statut', [JeuneEnfantController::class, 'toggleStatut'])
                ->name('jeune_enfant.toggle_statut');
            Route::get('jeune_enfant/{id}/edit', [JeuneEnfantController::class, 'edit'])
                ->name('jeune_enfant.edit');
            Route::put('jeune_enfant/{id}', [JeuneEnfantController::class, 'update'])
                ->name('jeune_enfant.update');
            Route::delete('jeune_enfant/{id}', [JeuneEnfantController::class, 'destroy'])
                ->name('jeune_enfant.destroy');

            // Jeunesse
            Route::get('jeunesse', [JeunesseController::class, 'index'])
                ->name('jeunesse.index');
            Route::get('jeunesse/create', [JeunesseController::class, 'create'])
                ->name('jeunesse.create');
            Route::post('jeunesse/store', [JeunesseController::class, 'store'])
                ->name('jeunesse.store');
            Route::get('jeunesse/{id}/show', [JeunesseController::class, 'show'])
                ->name('jeunesse.show');
            Route::patch('jeunesse/{id}/toggle-statut', [JeunesseController::class, 'toggleStatut'])
                ->name('jeunesse.toggle_statut');
            Route::get('jeunesse/{id}/edit', [JeunesseController::class, 'edit'])
                ->name('jeunesse.edit');
            Route::put('jeunesse/{id}', [JeunesseController::class, 'update'])
                ->name('jeunesse.update');
            Route::delete('jeunesse/{id}', [JeunesseController::class, 'destroy'])
                ->name('jeunesse.destroy');



            Route::get('jeunesse2', [JeunesseController::class, 'index2'])
                ->name('jeunesse2.index');
            Route::get('jeunesse2/create', [JeunesseController::class, 'create2'])
                ->name('jeunesse2.create');
            Route::post('jeunesse2/store', [JeunesseController::class, 'store2'])
                ->name('jeunesse2.store');
            Route::get('jeunesse2/{id}/show', [JeunesseController::class, 'show2'])
                ->name('jeunesse2.show');
            Route::patch('jeunesse2/{id}/toggle-statut', [JeunesseController::class, 'toggleStatut2'])
                ->name('jeunesse2.toggle_statut');
            Route::get('jeunesse2/{id}/edit', [JeunesseController::class, 'edit2'])
                ->name('jeunesse2.edit');
            Route::put('jeunesse2/{id}', [JeunesseController::class, 'update2'])
                ->name('jeunesse2.update');
            Route::delete('jeunesse2/{id}', [JeunesseController::class, 'destroy2'])
                ->name('jeunesse2.destroy');
			Route::get('jeunesse2/delegations/{gouvernoratId}', [JeunesseController::class, 'getDelegations_jeunesse'])->name('delegations_jeunesse.get');

        // Formation _ Stage
            Route::get('formation', [FormationStageController::class, 'index'])
                ->name('formation.index');
            Route::get('formation/create', [FormationStageController::class, 'create'])
                ->name('formation.create');
            Route::post('formation/store', [FormationStageController::class, 'store'])
                ->name('formation.store');
            Route::get('formation/{id}/show', [FormationStageController::class, 'show'])
                ->name('formation.show');
            Route::patch('formation/{id}/toggle-statut', [FormationStageController::class, 'toggleStatut'])
                ->name('formation.toggle_statut');
            Route::get('formation/{id}/edit', [FormationStageController::class, 'edit'])
                ->name('formation.edit');
            Route::put('formation/{id}', [FormationStageController::class, 'update'])
                ->name('formation.update');
            Route::delete('formation/{id}', [FormationStageController::class, 'destroy'])
                ->name('formation.destroy');

        //Exonaration
            /*Route::get('exoneration/{id_type_formulaire?}', [ExonarationController::class, 'index'])
                ->name('exoneration.index');
            Route::get('exoneration/create/{id_type_formulaire?}', [ExonarationController::class, 'create'])
                ->name('exoneration.create');*/

            Route::get('exoneration/create/{id_type_formulaire?}', [ExonarationController::class, 'create'])
                ->name('exoneration.create');
            Route::get('exoneration/{id_type_formulaire?}', [ExonarationController::class, 'index'])
                ->name('exoneration.index');    
            Route::post('exoneration/store', [ExonarationController::class, 'store'])
                ->name('exoneration.store');
            Route::get('exoneration/{id}/show', [ExonarationController::class, 'show'])
                ->name('exoneration.show');
            Route::patch('exoneration/{id}/toggle-statut', [ExonarationController::class, 'toggleStatut'])
                ->name('exoneration.toggle_statut');
            Route::get('exoneration/{id}/edit', [ExonarationController::class, 'edit'])
                ->name('exoneration.edit');
            Route::put('exoneration/{id}', [ExonarationController::class, 'update'])
                ->name('exoneration.update');
            Route::delete('exoneration/{id}', [ExonarationController::class, 'destroy'])
                ->name('exoneration.destroy');





            // Financement

            /* Demance financement public */
            Route::get('demande', [DemandeFinancementPublicController::class, 'index'])
                ->name('demande.index');
            Route::get('demande/create', [DemandeFinancementPublicController::class, 'create'])
                ->name('demande.create');
            Route::post('demande/store', [DemandeFinancementPublicController::class, 'store'])
                ->name('demande.store');
            Route::get('demande/{id_demande_fin}/show', [DemandeFinancementPublicController::class, 'show'])
                ->name('demande.show');
            Route::get('demande/{id_demande_fin}/edit', [DemandeFinancementPublicController::class, 'edit'])
                ->name('demande.edit');
            Route::put('demande/{id_demande_fin}', [DemandeFinancementPublicController::class, 'update'])
                ->name('demande.update');
            Route::delete('demande/{id_demande_fin}', [DemandeFinancementPublicController::class, 'destroy'])
                ->name('demande.destroy');

                
                
            /* Demance financement public */
            Route::get('form', [FormulaireController::class, 'index'])
                ->name('form.index');
            Route::get('form/create', [FormulaireController::class, 'create'])
                ->name('form.create');

            
            Route::post('form/store', [FormulaireController::class, 'store'])
                ->name('form.store');
            Route::get('form/{id_projet}/show', [FormulaireController::class, 'show'])
                ->name('form.show');
            Route::get('form/{id_projet}/edit', [FormulaireController::class, 'edit'])
                ->name('form.edit');
            Route::put('form/{id_projet}', [FormulaireController::class, 'update'])
                ->name('form.update');
            Route::delete('form/{id_projet}', [FormulaireController::class, 'destroy'])
                ->name('form.destroy');

            /* Document financement public */
            Route::get('doc_fin', [DocumentFinancementController::class, 'index'])
                ->name('doc_fin.index');
            Route::get('doc_fin/create', [DocumentFinancementController::class, 'create'])->name('stepper.create');
            Route::post('/doc_fin/store-all', [DocumentFinancementController::class, 'storeAll'])->name('financement.storeAll');
  
            Route::get('doc_fin/{id}', [DocumentFinancementController::class, 'show'])->name('doc_fin.show');
            Route::get('doc_fin/{id}/edit', [DocumentFinancementController::class, 'edit'])->name('doc_fin.edit');
            Route::put('doc_fin/{id}', [DocumentFinancementController::class, 'update'])->name('doc_fin.update');
            Route::delete('doc_fin/{id}', [DocumentFinancementController::class, 'destroy'])->name('doc_fin.destroy');

            Route::get('/documents-financement/brouillons', [DocumentFinancementController::class, 'brouillons'])
                ->name('doc_fin.brouillons');

            Route::get('/documents-financement/brouillons/{id}/show', [DocumentFinancementController::class, 'brouillons_show'])
                ->name('doc_fin.brouillons.show');

            Route::get('/documents-financement/brouillons/{id}/edit', [DocumentFinancementController::class, 'brouillons_edit'])
                ->name('doc_fin.brouillons.edit');

            Route::put('/documents-financement/brouillons/{id}/update', [DocumentFinancementController::class, 'brouillons_update'])
                ->name('doc_fin.brouillons.update');

            Route::delete('/documents-financement/brouillons/{id}/destroy', [DocumentFinancementController::class, 'brouillons_destroy'])
                ->name('doc_fin.brouillons.destroy');


            //Manifetation sportif
            Route::get('/manifestation', [ManifestationSportController::class, 'index'])
                ->name('manifestation.index');
            Route::get('/manifestation/create', [ManifestationSportController::class, 'create'])
                ->name('manifestation.create');
            Route::post('/manifestation/store', [ManifestationSportController::class, 'store'])
                ->name('manifestation.store');
            Route::get('/manifestation/{id}/edit', [ManifestationSportController::class, 'edit'])
                ->name('manifestation.edit');
            Route::put('/manifestation/{id}', [ManifestationSportController::class, 'update'])
                ->name('manifestation.update');
            Route::get('/manifestation/{id}/show', [ManifestationSportController::class, 'show'])
                ->name('manifestation.show');
            Route::delete('manifestation/{id}', [ManifestationSportController::class, 'destroy'])
                ->name('manifestation.destroy'); 
            Route::patch('/manifestation/{id}/toggle-statut', [ManifestationSportController::class, 'toggleStatut'])
                ->name('manifestation.toggle_statut');
                Route::get('manifestation/delegations/{gouvernoratId}', [ManifestationSportController::class, 'getDelegations_manifestation'])->name('delegations_manifestation.get');
           
		   //Manifetation sportif Intern
            Route::get('/manifestation2', [ManifestationSport2Controller::class, 'index'])
                ->name('manifestation2.index');
            Route::get('/manifestation2/create', [ManifestationSport2Controller::class, 'create'])
                ->name('manifestation2.create');
            Route::post('/manifestation2/store', [ManifestationSport2Controller::class, 'store'])
                ->name('manifestation2.store');
            Route::get('/manifestation2/{id}/edit', [ManifestationSport2Controller::class, 'edit'])
                ->name('manifestation2.edit');
            Route::put('/manifestation2/{id}', [ManifestationSport2Controller::class, 'update'])
                ->name('manifestation2.update');
            Route::get('/manifestation2/{id}/show', [ManifestationSport2Controller::class, 'show'])
                ->name('manifestation2.show');
            Route::delete('manifestation2/{id}', [ManifestationSport2Controller::class, 'destroy'])
                ->name('manifestation2.destroy');
            Route::patch('/manifestation2/{id}/toggle-statut', [ManifestationSport2Controller::class, 'toggleStatut'])
                ->name('manifestation2.toggle_statut');
            Route::get('manifestation2/delegations/{gouvernoratId}', [ManifestationSport2Controller::class, 'getDelegations2_manifestation'])->name('delegations2_manifestation.get');

            
        
});
Route::get('/forgot-password', [ForgotPasswordController::class, 'showForgotForm'])->name('password.request');
Route::post('/forgot-password', [ForgotPasswordController::class, 'sendResetLinkEmail'])->name('password.email');
Route::get('/reset-password/{token}', [ResetPasswordController::class, 'showResetForm'])->name('password.reset');
Route::post('/reset-password', [ResetPasswordController::class, 'reset'])->name('password.update');

Route::get('/delegations/{gouvernoratId}', [SalleSportController::class, 'getDelegations_salle'])->name('delegations.get');


/* API cin exemple */
$cin_list = [
    '12345678' => ['date_delivrance_cin' => '2025-01-01', 'nom_prenom' => 'علي بن أحمد', 'lieu_delivrance_cin' => 'تونس'],
    '87654321' => ['date_delivrance_cin' => '2024-05-10', 'nom_prenom' => 'سارة الرمضاني', 'lieu_delivrance_cin' => 'بنزرت'],
    '11223344' => ['date_delivrance_cin' => '2023-12-15', 'nom_prenom' => 'محمد خالد', 'lieu_delivrance_cin' => 'بن عروس'],
    '10785468' => ['date_delivrance_cin' => '2025-01-01', 'nom_prenom' => 'آدم صياري', 'lieu_delivrance_cin' => 'منوبة'],
    '80179632' => ['date_delivrance_cin' => '2024-05-10', 'nom_prenom' => 'سلمى مسعودي', 'lieu_delivrance_cin' => 'أريانة'],
    '10025412' => ['date_delivrance_cin' => '2023-12-15', 'nom_prenom' => 'مراد عوني', 'lieu_delivrance_cin' => 'المهدية'],
    '44987401' => ['date_delivrance_cin' => '2025-03-20', 'nom_prenom' => 'نور بن علي', 'lieu_delivrance_cin' => 'باجة'],
    '07845120' => ['date_delivrance_cin' => '2022-08-30', 'nom_prenom' => 'راوية بن سالم', 'lieu_delivrance_cin' => 'سوسة'],
];

Route::post('/api/check-cin', function (Request $request) use ($cin_list) {
    $request->validate([
        'cin' => 'required|size:8',
        'date_delivrance_cin' => 'required|date',
    ]);

    if (isset($cin_list[$request->cin]) && $cin_list[$request->cin]['date_delivrance_cin'] === $request->date_delivrance_cin) {
        return response()->json([
            'status' => 'success',
            'message' => 'CIN vérifié avec succès',
            'data' => [
                'cin' => $request->cin,
                'date_delivrance_cin' => $cin_list[$request->cin]['date_delivrance_cin'],
                'nom_prenom' => $cin_list[$request->cin]['nom_prenom'],
                'lieu_delivrance_cin' => $cin_list[$request->cin]['lieu_delivrance_cin'],
            ],
        ]);
    }

    return response()->json([
        'status' => 'error',
        'message' => 'رقم بطاقة التعريف غير صالح أو تاريخ الإصدار غير صحيح',
    ], 422);
});

    
    
    
    

   