@extends('layouts.app')

@section('title', 'نتائج البحث')

@section('content')
<main dir="rtl">
<div class="it-hero-2-area">
               <div class="slider">
                  <!-- First Slide -->
                  <div class="slide active">
                     <div class="it-hero-2-overlay fix gray-bg z-index-1" data-background="assets/img/hero/images2.jpg">
                        <div class="container">
                           <div class="row align-items-center">
                              <div class="col-xl-6 col-lg-6">
                                 <div class="it-hero-2-content">
                                    <h4 class="it-hero-3-subtitle it-split-in-right">
                                       <span>الجمهورية التونسية</span>
                                    </h4>
                                    <h1 class="it-hero-2-title it-split-in-right">
                                       وزارة الشباب والرياضة
                                    </h1>
                                    <div class="it-hero-2-text wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".5s">
                                       <p class="mb-30"><br/></p>
                                    </div>
                                    <div class="it-hero-btn d-sm-flex align-items-center">
                                       <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay=".8">
                                          <a href="contact.html" class="it-btn-orange mr-30 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".7s">
                                             <span>
                                                <span class="text-1">إتصل بنا</span>
                                                <span class="text-2">إتصل بنا</span>
                                             </span>
                                             <i>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                             </i>
                                          </a>
                                       </div>
                                       <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay="1">
                                          <a href="service.html" class="it-btn-border wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".9s">
                                             <span>
                                                <span class="text-1">آخر الأخبار</span>
                                                <span class="text-2">آخر الأخبار</span>
                                             </span>
                                             <i>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                             </i>
                                          </a>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-xl-6 col-lg-6">
                                 <div class="it-contact-form-box z-index-1 p-relative wow img-anim-top" data-wow-duration="1.5s" data-wow-delay="0.1">
                                    <h4 class="it-contact-form-title mb-10" style="color:#FFFFFF;">ابحث في الموقع</h4>
                                    <form action="#">
                                       <div class="it-contact-input-wrap">
                                          <div class="row gx-30">
                                             <div class="col-sm-12 mb-20">
                                                <div class="it-contact-input-box">
                                                   <input class="ph" type="text" placeholder="أدخل كلمة البحث..." style="color:#FFFFFF;">
                                                </div>
                                             </div>
                                          </div>
                                          <div class="it-contact-btn">
                                             <button type="submit" class="it-btn-orange">
                                                <span>
                                                   <span class="text-1">بحث</span>
                                                   <span class="text-2">بحث</span>
                                                </span>
                                                <i>
                                                   <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                      <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                   </svg>
                                                   <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                      <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                   </svg>
                                                </i>
                                             </button>
                                          </div>
                                       </div>
                                    </form>
                                    <img class="it-contact-shape-1" src="assets/img/shape/contact-1-1.png" alt="">
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
</div>
</div>

{{-- === Résultats === --}}
<div class="container mt-5" dir="rtl">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h3 class="mb-0">نتائج البحث عن: <span class="text-danger">{{ $query }}</span></h3>
        <small class="text-muted">إجمالي النتائج:
            {{ $news->count() + $trophees->count() + $guides->count() }}
        </small>
    </div>

    @if($news->isEmpty() && $trophees->isEmpty() && $guides->isEmpty())
        <div class="alert alert-info text-center">لم يتم العثور على نتائج.</div>
    @else
        <div class="row gy-4">
            {{-- News --}}
            @if($news->count())
                <div class="col-12">
                    <h4 class="section-title text-danger mb-3">📰 الأخبار</h4>
                </div>
                @foreach($news as $item)
                    <div class="col-md-6 col-lg-4">
                        <article class="card result-card h-100">
                            <div class="card-body d-flex flex-column">
                                {{-- Si tu as une image miniature, afficher ici --}}
                                @if(!empty($item->thumbnail))
                                    <img src="{{ asset($item->thumbnail) }}" alt="" class="mb-3 rounded" style="width:100%; height:160px; object-fit:cover;">
                                @endif

                                <h5 class="card-title mb-1">
                                    <a href="{{ route('news.show', $item->slug) }}" class="stretched-link text-decoration-none">
                                        {!! highlight($item->title, $query) !!}
                                    </a>
                                </h5>

                                <small class="text-muted mb-2">{{ $item->created_at->format('Y-m-d') }}</small>

                                <p class="card-text mb-3 text-truncate-3">
                                    {!! highlight(strip_tags($item->excerpt ?? \Illuminate\Support\Str::limit($item->content, 150)), $query) !!}
                                </p>

                                <div class="mt-auto d-flex justify-content-between align-items-center">
                                    <span class="badge bg-danger">الأخبار</span>
                                    <a href="{{ route('news.show', $item->slug) }}" class="btn btn-sm btn-outline-primary">قراءة المزيد</a>
                                </div>
                            </div>
                        </article>
                    </div>
                @endforeach
            @endif

            {{-- Trophées --}}
            @if($trophees->count())
                <div class="col-12">
                    <h4 class="section-title text-success mb-3">🏆 التتويجات الرياضية</h4>
                </div>
                @foreach($trophees as $item)
                    <div class="col-md-6 col-lg-4">
                        <article class="card result-card h-100">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title mb-1">
                                    <a href="{{ route('trophees.show', $item->slug) }}" class="stretched-link text-decoration-none">
                                        {!! highlight($item->title, $query) !!}
                                    </a>
                                </h5>

                                <small class="text-muted mb-2">{{ $item->created_at->format('Y-m-d') }}</small>

                                <p class="card-text mb-3 text-truncate-3">
                                    {!! highlight(strip_tags($item->excerpt ?? \Illuminate\Support\Str::limit($item->description ?? '', 140)), $query) !!}
                                </p>

                                <div class="mt-auto d-flex justify-content-between align-items-center">
                                    <span class="badge bg-success">التتويجات</span>
                                    <a href="{{ route('trophees.show', $item->slug) }}" class="btn btn-sm btn-outline-primary">تفاصيل</a>
                                </div>
                            </div>
                        </article>
                    </div>
                @endforeach
            @endif

            {{-- Guides --}}
            @if($guides->count())
                <div class="col-12">
                    <h4 class="section-title text-primary mb-3">📚 الأدلة</h4>
                </div>
                @foreach($guides as $item)
                    <div class="col-md-6 col-lg-4">
                        <article class="card result-card h-100">
                            <div class="card-body d-flex flex-column">
                                <h5 class="card-title mb-2">
                                    <a href="#" class="stretched-link text-decoration-none">
                                        {!! highlight($item->titre_G, $query) !!}
                                    </a>
                                </h5>

                                <p class="card-text mb-3 text-truncate-3">
                                    {!! highlight(strip_tags($item->excerpt ?? \Illuminate\Support\Str::limit($item->description ?? '', 140)), $query) !!}
                                </p>

                                <div class="mt-auto d-flex justify-content-between align-items-center">
                                    <span class="badge bg-primary">دليل</span>
                                    <a href="#" class="btn btn-sm btn-outline-primary">عرض</a>
                                </div>
                            </div>
                        </article>
                    </div>
                @endforeach
            @endif
        </div>
    @endif
</div>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.css" />
<script src="https://cdn.jsdelivr.net/npm/swiper@9/swiper-bundle.min.js"></script>
</main>

{{-- === JS Swiper === --}}
<script>
  document.addEventListener('DOMContentLoaded', function () {
    const swiper = new Swiper('.it-hero-swiper', {
      loop: true,
      autoplay: {
        delay: 5000,
        disableOnInteraction: false,
      },
      speed: 900,
      pagination: {
        el: '.swiper-pagination',
        clickable: true,
      },
      navigation: {
        nextEl: '.swiper-button-next',
        prevEl: '.swiper-button-prev'
      },
      effect: 'fade',
      fadeEffect: { crossFade: true },
    });
  });
</script>
<style>
  /* --- HERO / SLIDER --- */
  .it-hero-swiper { height: 510px; position: relative; }
  .it-hero-swiper .swiper-slide { display:flex; align-items:center; }
  .swiper-slide-overlay { width:100%; height:100%; display:flex; align-items:center; }
  .swiper-button-prev, .swiper-button-next { color:#fff; }
  .swiper-pagination-bullet { background:#fff; opacity:.8; }
  .hero-search-box input::placeholder { color: #ddd; }
  @media (max-width: 768px) {
      .it-hero-swiper { height: 340px; }
      .display-5 { font-size: 1.8rem; }
  }

  /* --- RESULTATS --- */
  .result-card { border: 1px solid rgba(0,0,0,0.05); transition: all .2s ease; }
  .result-card:hover { transform: translateY(-6px); box-shadow: 0 12px 24px rgba(0,0,0,0.1); }
  .text-truncate-3 { display: -webkit-box; -webkit-line-clamp: 3; -webkit-box-orient: vertical; overflow: hidden; }
  mark { background: #ffd54f; padding: 0 .2rem; border-radius: .15rem; color: #222; }
</style>
@push('styles')

@endpush

@endsection
