@extends('layouts.app')

@section('content')

<style>
.card-resume { border-radius: 10px; box-shadow: 0 6px 18px rgba(0,0,0,0.06); }
.small-muted { font-size: .85rem; color:#6c757d; }
.form-label { font-weight: 600; }

/* cards restauration */
.resto-card {
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.04);
    padding: 10px;
    margin-bottom: 10px;
    direction: rtl;
    background: #fff;
}
.resto-card .resto-header { display:flex; justify-content:space-between; align-items:center; gap:10px; }
.resto-card .resto-name { font-weight:700; }
.resto-card .resto-price { font-weight:700; }
.resto-card .resto-desc { color:#555; margin-top:6px; white-space:pre-wrap; }
.empty-placeholder { color:#6c757d; font-size:.95rem; padding:8px; }


</style>
<div class="it-about-3-area p-relative pt-30 pb-125">
   <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
                <div class="container">
<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('reservation.index') }}">
                <span>قائمة الحجوزات</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">تفاصيل الحجز</li>
    </ol>
</nav>
             

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <div class="card p-4 shadow-sm">

        <h3 class="mb-4 text-center">تفاصيل الحجز</h3>

        <div class="row">

            <div class="col-lg-8">
                <div class="card p-3 mb-3">
                    <div class="row">

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"   class="form-label">الإسم و اللقب</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="{{ $reservation->user->nom_prenom ?? '-' }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">البريد الإلكتروني</label>
                            <input style="text-transform: none; direction: rtl;"  type="email" class="form-control bg-white"
                                value="{{ $reservation->user->email ?? '-' }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">رقم الهاتف</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="{{ $reservation->user->tel ?? '-' }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">العنوان</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="{{ $reservation->user->adresse ?? '-' }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">تاريخ الوصول</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="{{ $reservation->date_arrive }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">تاريخ المغادرة</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="{{ $reservation->date_depart }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد الرجال</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="{{ $reservation->nbr_h }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد النساء</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="{{ $reservation->nbr_f }}" readonly>
                        </div>

                        @php
                            $nights = \Carbon\Carbon::parse($reservation->date_arrive)
                                ->diffInDays(\Carbon\Carbon::parse($reservation->date_depart));
                            $basePrice = ($reservation->auberge->prix_lit ?? 0)
                                * ($reservation->nbr_personnes ?? 0)
                                * $nights;
                            $restoTotal = $reservation->restaurations->sum(fn($r) => $r->pivot->tarif ?? 0);
                            $calculatedTotal = $basePrice + $restoTotal;
                            $selectedIds = $reservation->restaurations->pluck('id_rest')->toArray();
                        @endphp

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد الليالي</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="{{ $nights }}" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد النزلاء</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="{{ $reservation->nbr_personnes }}" readonly>
                        </div>

                        <div class="col-12 mb-3">
                            <label style="color:black;"  class="form-label">إضافة خدمات الطعام (اختياري)</label>

                            @foreach($restaurations as $res)
                                <div class="form-check mb-2">
                                    <input style="text-transform: none; direction: rtl;"  class="form-check-input" type="checkbox"
                                        id="resto_{{ $res->id_rest }}"
                                        @if(in_array($res->id_rest, $selectedIds)) checked @endif
                                        disabled>
                                    <label style="color:black;"  class="form-check-label" for="resto_{{ $res->id_rest }}">
                                        {{ $res->nom_ar }}
                                        <small class="small-muted d-block">{{ number_format($res->tarif, 2) }} د</small>
                                    </label>
                                </div>
                            @endforeach

                            <div id="restoDetails" class="mt-3">
                                @if($reservation->restaurations->isEmpty())
                                    <div class="empty-placeholder">لا توجد خدمات إضافية</div>
                                @else
                                    @foreach($reservation->restaurations as $resto)
                                        <div class="resto-card">
                                            <div class="resto-header">
                                                <div class="resto-name">{{ $resto->nom_ar }}</div>
                                                <div class="resto-price">{{ number_format($resto->pivot->tarif, 2) }} د</div>
                                            </div>
                                            <div class="resto-desc">{!! nl2br(e($resto->description_ar ?? '—')) !!}</div>
                                        </div>
                                    @endforeach
                                @endif
                            </div>
                        </div>

                        <div class="col-12 mb-3">
                            <label style="color:black;"  class="form-label">الملاحظات</label>
                            <div class="mt-2 p-2 border border-gray rounded bg-white">
                            <p rows="3" readonly class="form-label bg-white">{{ $reservation->remarque ?? '—' }}</p>
                        </div>
                        </div>

                         
                    </div>
                </div>
            </div>

            <div class="col-lg-4">

    <div class="card p-3 card-resume mb-3">
        <h5 class="mb-2" style="color:#d82b2a;">ملخص الحجز</h5>

        <p class="small-muted mb-1">
            المؤسسة: <strong>{{ $reservation->auberge->nom_ar ?? '-' }}</strong>
        </p>

        <p class="small-muted mb-1">
            سعر الليلة: <strong>{{ number_format($reservation->auberge->prix_lit ?? 0, 2) }}</strong> د
        </p>

        <p class="small-muted mb-1">عدد الليالي: <strong>{{ $nights }}</strong></p>

        
        <div class="mt-2 p-2 border border-gray rounded bg-white">
            <strong class="text-black"> الملاحظات:</strong>
            <p class="mb-0">{{ $reservation->remarque ?? '—' }}</p>
        </div>
        


        <hr>

        <p class="small-muted mb-1">
            السعر الأساسي: <strong>{{ number_format($basePrice, 2) }} د</strong>
        </p>

        <p class="small-muted mb-1">
            خدمات الطعام: <strong>{{ number_format($restoTotal, 2) }} د</strong>
        </p>

        <p class="mb-3">
            المجموع الكلي: <strong>{{ number_format($calculatedTotal, 2) }} د</strong>
        </p>

        <p>
            حالة الحجز:

            <span class="status-badge 
                {{ $reservation->statut_id == 1 ? 'status-badge--success' : 
                    ($reservation->statut_id == 3 ? 'status-badge--danger' : 'status-badge--pending') }}">
                {{ $reservation->statut?->statut_ar ?? 'في الانتظار' }}
            </span>
        </p>

        @if($reservation->statut_id == 3 && !empty($reservation->commentaire_motif))
            <div class="mt-2 p-2 border border-danger rounded bg-light">
                <strong class="text-danger">سبب الرفض:</strong>
                <p class="mb-0">{{ $reservation->commentaire_motif }}</p>
            </div>
        @endif


        <a href="{{ route('reservation.index') }}"
            class="btn btn-secondary mt-3 w-100" style="background-color:#1a237e;">
            رجوع إلى قائمة الحجوزات
        </a>
    </div>



    @if($reservation->statut_id == 2)

        @php
            $currentStatus = old('statut_id', $reservation->statut_id ?? '');
            $currentMotif  = old('commentaire_motif', $reservation->commentaire_motif ?? '');
        @endphp

        <div class="card shadow-lg border-0 rounded-4 p-3 mb-3">

            <h5 class="mb-3 fw-bold">الوضعية الحالية</h5>

            <p class="text-muted mb-3">
                يمكنك تعديل وضعية الحجز من هنا:
            </p>

            <form action="{{ route('reservation.updateStatus', $reservation->id_reserv) }}" method="POST">
                @csrf
                @method('PUT')

                <label style="color:black;"  class="form-label fw-bold">تغيير الوضعية</label>
                <select class="form-control" id="statut_id" name="statut_id" onchange="toggleMotifInputReservation()">
                    <option value="">اختر...</option>
                    <option value="1" {{ $currentStatus == 1 ? 'selected' : '' }}>قبول</option>
                    <option value="3" {{ $currentStatus == 3 ? 'selected' : '' }}>رفض</option>
                </select>

                <div class="mt-3 {{ $currentStatus == 3 ? '' : 'd-none' }}" id="motifDiv">
                    <label style="color:black;"  class="form-label text-danger fw-bold">سبب الرفض</label>
                    <textarea name="commentaire_motif" class="form-control border-danger" rows="3">{{ $currentMotif }}</textarea>
                </div>

                <button class="btn btn-primary w-100 mt-3">تحديث الوضعية</button>
            </form>

        </div>

    @endif

</div>



        </div>
    </div>
</div>
 </div>
<script>
function toggleMotifInputReservation() {
    let status = document.getElementById("statut_id").value;
    let motif = document.getElementById("motifDiv");

    if (status == 3) {
        motif.classList.remove("d-none");
    } else {
        motif.classList.add("d-none");
    }
}
</script>
 
@endsection
