@extends('layouts.app')

@section('content')

 <div class="it-about-3-area p-relative pt-30 pb-125">
   <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
                <div class="container">
<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        
        <li class="breadcrumb-item active" aria-current="page">قائمة الحجوزات</li>
    </ol>
</nav>
             

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="it-section-title-box text-center mb-65" style="padding-top:50px;">
                                <span class="it-section-subtitle">طلبات الحجز في المركبات الشبابية</span>
                                <h4 class="it-section-title it-split-in-right mb-0">عرض جميع حجوزاتي</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-10">
                            <div class="card shadow-sm p-4">

                                <div class="d-flex justify-content-end mb-4">
                                    <a class="btn btn-success" href="{{ route('gouvernorats.index') }}">
                                        <i class="la la-plus me-1"></i> إضافة حجز
                                    </a>
                                </div>

                                @if(session('success'))
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        {{ session('success') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @endif

                                <div class="my-table table-responsive">
                                     <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                                        <thead class="thead-light">
                                           

                                            <tr>
                                                <th width="5%">المعرف</th>
                                                <th width="15%"> إسم المركب الشبابي </th>
                                                <th width="15%">تاريخ الحجز </th>
                                                <th width="10%">تاريخ الوصول </th>
                                                <th width="10%">تاريخ المغادرة </th>
                                                <th width="10%">السعر الإجمالي </th>
                                                <th width="10%"> وضعية الطلب</th>
                                                <th width="20%">إجراءات</th>
                                            </tr>
                                        </thead>

                                        <tbody>
                                            @forelse($reservations as $reserv)
                                                <tr>
                                                    <td>{{ $reserv->id_reserv ?? '---'  }}</td>
                                                    <td>{{ $reserv->auberge->nom ?? '---'  }}</td>
                                                    <td>{{ $reserv->date_reserv ?? '---' }}</td>
                                                    <td>{{ $reserv->date_arrive ?? '---' }}</td>
                                                    <td>{{ $reserv->date_depart ?? '---' }}</td>
                                                    <td>{{ $reserv->total_price ?? '---' }}</td>
                                                    <td>
                                                        @php
                                                            $statut = $reserv->statut->statut_ar ?? 'في الانتظار';
                                                            $badgeClass = match($statut) {
                                                                'في الانتظار' => 'status-badge--pending',
                                                                'قبول' => 'status-badge--success',
                                                                'مرفوض' => 'status-badge--danger',
                                                                default => 'bg-secondary'
                                                            };
                                                        @endphp
                                                        <span class="status-badge {{ $badgeClass }}">{{ $statut }}</span>
                                                    </td>

                                                    <td class="text-center">
                                                        <div class="actions-cell d-inline-flex gap-2 flex-wrap justify-content-center" role="group" aria-label="actions">
                                                            <a href="{{ route('reservation.show', $reserv->id_reserv) }}"
                                                            class="btn-icon btn-icon--primary"
                                                            title="عرض" aria-label="عرض">
                                                                <i class="bx bx-show"></i>
                                                            </a>

                                                            @if($reserv->statut_id == 2)
                                                                    <form action="{{ route('reservation.destroy', $reserv->id_reserv) }}" method="POST" class="d-inline">
                                                                        @csrf
                                                                        @method('DELETE')
                                                                        <button type="button"
                                                                                onclick="confirmDeleteReserv(this.closest('form'))"
                                                                                class="btn-icon btn-icon--danger"
                                                                                title="حذف" aria-label="حذف">
                                                                            <i class="bx bx-trash"></i>
                                                                        </button>
                                                                    </form>
                                                            @endif

                                                        </div>
                                                    </td>

                                                    
                                                </tr>
                                            @empty
                                                <tr>
                                                    <td class="text-center text-muted">لا يوجد حجز.</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>

                            <div class="mt-3">
                                {{ $reservations->links('pagination::bootstrap-5') }}
                            </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
       
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">


<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{ asset('assets/js/index.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>
@endsection
