@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
<style>
        .bg-custom-gray {
        background-color: #f8f9fb !important;
    }

    /* Stepper container */
    .modern-stepper {
        display: flex;
        align-items: flex-start;
        justify-content: space-between;
        position: relative;
        gap: 40px;
        margin-top: 30px;
    }

    /* Step block */
    .modern-stepper .step {
        background: #fff;
        border: 2px solid #e0e4eb;
        border-radius: 16px;
        padding: 20px;
        flex: 1;
        text-align: center;
        position: relative;
        transition: all 0.3s ease;
        box-shadow: 0 3px 8px rgba(0, 0, 0, 0.05);
    }

    /* Step hover effect */
    .modern-stepper .step:hover {
        transform: translateY(-3px);
        box-shadow: 0 6px 15px rgba(0, 0, 0, 0.08);
    }

    /* Icon */
    .modern-stepper .icon {
        font-size: 2rem;
        margin-bottom: 10px;
        color: #6c757d;
    }

    /* Active / Success state */
    .modern-stepper .step.active {
        border-color: #28a745;
        background: #e9f9ef;
    }

    .modern-stepper .step.active .icon {
        color: #28a745;
        animation: pulse 1.5s infinite;
    }

    /* Rejected */
    .modern-stepper .step.rejected {
        border-color: #dc3545;
        background: #fdeaea;
    }

    .modern-stepper .step.rejected .icon {
        color: #dc3545;
    }

    /* Connector line */
    .connector-line {
        flex: 0.05;
        height: 3px;
        background: linear-gradient(to right, #ccc, #ccc);
        position: relative;
        top: 45px;
    }

    /* Animation */
    @keyframes pulse {
        0% { transform: scale(1); opacity: 1; }
        50% { transform: scale(1.1); opacity: 0.7; }
        100% { transform: scale(1); opacity: 1; }
    }

    /* Responsive */
    @media (max-width: 992px) {
        .modern-stepper {
            flex-direction: column;
            gap: 25px;
        }
        .connector-line {
            display: none;
        }
    }

</style>
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit">
<div class="container">
    <form action="" method="POST" enctype="multipart/form-data" lang="ar">
        <input type="hidden" name="type_formulaire_id" value="13">

        <!-- step1 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire2->id_type }}">
            <h2>الجمهورية التونسية</h2>
            <h2>وزارة الشباب و الرياضة</h2>



            <div class="card shadow-lg border-0 mb-4 rounded-4">
                <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
                    <h5 class="mb-0 fw-bold">مراحل معالجة الطلب</h5>
                    <span class="badge bg-primary fs-6">تتبع الحالة</span>
                </div>

                <div class="card-body">
                    <p class="text-muted mb-4 text-center fs-6">
                        تتبع مراحل سير الطلب عبر الإدارات المختلفة:
                    </p>

                    <div class="modern-stepper">
                        <!-- Step 1 -->
                        <div class="step {{ $demande->id_type == 1 ? 'active' : ($demande->id_type == 3 ? 'rejected' : '') }}">
                            <div class="icon">
                                <i class="la la-building"></i>
                            </div>
                            <div class="content">
                                <h6 class="fw-bold mb-1">الإدارة الفرعية</h6>
                                @if($demande->id_type == 1)
                                    <span class="badge bg-success">مقبول</span>
                                @elseif($demande->id_type == 3)
                                    <span class="badge bg-danger">مرفوض</span>
                                @else
                                    <span class="badge bg-warning text-dark">في الانتظار</span>
                                @endif

                                @if($demande->commentaire_motif)
                                    <div class="text-danger small mt-2 fw-semibold">
                                        <i class="la la-comment-dots"></i> {{ $demande->commentaire_motif }}
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Connector -->
                        <div class="connector-line"></div>

                        <!-- Step 2 -->
                        <div class="step {{ $demande->statut_id == 1 ? 'active' : ($demande->statut_id == 3 ? 'rejected' : '') }}">
                            <div class="icon">
                                <i class="la la-university"></i>
                            </div>
                            <div class="content">
                                <h6 class="fw-bold mb-1">الجامعة</h6>
                                @if($demande->statut_id == 1)
                                    <span class="badge bg-success">مقبول</span>
                                @elseif($demande->statut_id == 3)
                                    <span class="badge bg-danger">مرفوض</span>
                                @else
                                    <span class="badge bg-secondary">—</span>
                                @endif

                                @if($demande->commentaire_motif2)
                                    <div class="text-danger small mt-2 fw-semibold">
                                        <i class="la la-comment-dots"></i> {{ $demande->commentaire_motif2 }}
                                    </div>
                                @endif
                            </div>
                        </div>

                        <!-- Connector -->
                        <div class="connector-line"></div>

                        <!-- Step 3 -->
                        <div class="step {{ $demande->statut2_id == 1 ? 'active' : ($demande->statut2_id == 3 ? 'rejected' : '') }}">
                            <div class="icon">
                                <i class="la la-users"></i>
                            </div>
                            <div class="content">
                                <h6 class="fw-bold mb-1">اللجنة الوطنية</h6>
                                @if($demande->statut2_id == 1)
                                    <span class="badge bg-success">مقبول</span>
                                @elseif($demande->statut2_id == 3)
                                    <span class="badge bg-danger">مرفوض</span>
                                @else
                                    <span class="badge bg-secondary">—</span>
                                @endif

                                @if($demande->commentaire_motif3)
                                    <div class="text-danger small mt-2 fw-semibold">
                                        <i class="la la-comment-dots"></i> {{ $demande->commentaire_motif3 }}
                                    </div>
                                @endif
                            </div>
                        </div>
                    </div>
                </div>
            </div>


            <h3 style="font-size:25px;">{{ $formulaire2->type_ar }}</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label">اسم الهيكل غير الرياضي</label>
                    <div class="col-sm-10">
                        <span class="form-control-plaintext">{{ $org->nom ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">عدد التاشيرة</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->num_visa ?? '' }}</span>
                    </div>
                    <label class="col-sm-2 col-form-label">تاريخ التسجيل س.و.م</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->date_enregistrement ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">المعرف الجبائي</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->identifiant_fiscal ?? '' }}</span>
                    </div>

                    <label class="col-sm-2 col-form-label">رقم الحساب البنكي</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->num_compte_bancaire ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">العنوان</label>
                    <div class="col-sm-10">
                        <span class="form-control-plaintext">{{ $org->adresse ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">رقم الهاتف</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->tel ?? '' }}</span>
                    </div>

                    <label class="col-sm-2 col-form-label">رقم الفاكس</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->fax ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->email ?? '' }}</span>
                    </div>
                </div>
            </div>   
        </div>

<div class="container">
            <h3 style="font-size:25px;">ملف التامين الخاص</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        نسخة من ملف التأمين الخاص بالتظاهرة الرياضية
                    </label>
                    <div class="col-sm-12">

                        @if($demande->assuranceFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ asset('storage/' . $demande->assuranceFile->file) }}" 
                                target="_blank" class="text-primary">
                                <i class="la la-file-pdf"></i> عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد ملف تأمين مرفق.</p>
                        @endif

                    </div>
                </div>
            </div>
        </div>


        <!-- step2 -->
         @php
            $evenement = $demande->evenementSportifs->first(); // On prend le premier événement lié
        @endphp

        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">

            <h2>الجمهورية التونسية</h2>
            <h2>وزارة الشباب و الرياضة</h2>
            <h3 style="font-size:25px;">{{ $formulaire3->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label">اسم التظاهرة</label>
                    <div class="col-sm-10">
                        <span class="form-control-plaintext">{{ $evenement->nom_even ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label">الهدف من تنظيم التظاهرة و آثارها الرياضية و الأبعاد الاقتصادية والاجتماعية</label>
                    <div class="col-sm-12">
                        <textarea name="objectifs" readonly class="form-control bg-white" rows="2">{{ old('objectifs', $evenement->objectifs ?? '') }}</textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label">محتوى التظاهرة و الاختصاصات الرياضية المستهدفة</label>
                    <div class="col-sm-12">
                        <textarea name="contenus" readonly class="form-control bg-white" rows="2">{{ old('contenus', $evenement->contenus ?? '') }}</textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">تاريخ تنظيم التظاهرة</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->date ?? '' }}</span>
                    </div>

                    <label class="col-sm-2 col-form-label">توقيت تنظيم التظاهرة</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">
                            {{ isset($evenement->heure) ? \Carbon\Carbon::parse($evenement->heure)->format('H:i') : '' }}
                        </span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الولاية</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">
                            {{ optional($gouvernorats->firstWhere('id_gouver', $evenement->gouvernorat_id))->nom_ar ?? '' }}
                        </span>
                    </div>

                    <label class="col-sm-2 col-form-label">البلدية</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">
                            {{ optional($delegations->firstWhere('id_delegation', $evenement->delegation_id))->nom_ar ?? '' }}
                        </span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label"> المنشئات الرياضية التي ستستغل </label>
                    <div class="col-sm-12">
                        <textarea name="instalation_sportives" readonly class="form-control bg-white" rows="2">{{ old('instalation_sportives', $evenement->instalation_sportives ?? '') }}</textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الجامعة الرياضية مرجع الاختصاص</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->reference ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">المداخيل التقديرية الجملية</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->estimation_evenement ?? '' }}</span>
                    </div>

                    <label class="col-sm-2 col-form-label">المصاريف التقديرية الجملية</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->cout_total_evenement ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الفارق التقديري</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->difference_estimee ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">بيان الجوائز</label>
                    <div class="col-sm-10">
                        <span class="form-control-plaintext">{{ $evenement->recompense ?? '' }}</span>
                    </div>
                </div>

                <input type="hidden" name="user_id" value="{{ Auth::user()->id }}">
            </div>
        </div>

        <!-- step3 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire4->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire4->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة عناصر فريق التنظيم</label>
                    <table id="membres-table" class="custom-table">
                        <thead>
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>الصفة</th>
                                <th>الجنسية</th>
                            </tr>
                        </thead>
                        <tbody id="membres-body">
                            @php
                                $membres = $evenement && $evenement->membres
                                    ? $evenement->membres->where('type_membre_id', 1)
                                    : collect();
                            @endphp

                            @if($membres->count())
                                @foreach($membres as $membre)
                                    <tr>
                                        <td data-label="الاسم واللقب">
                                            <span class="form-control-plaintext">{{ $membre->nom_prenom }}</span>
                                        </td>
                                        <td data-label="الصفة">
                                            <span class="form-control-plaintext">{{ $membre->role }}</span>
                                        </td>
                                        <td data-label="الجنسية">
                                            <span class="form-control-plaintext">{{ $membre->nationalite }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td data-label="الاسم واللقب">
                                        <span class="form-control-plaintext">-</span>
                                    </td>
                                    <td data-label="الصفة">
                                        <span class="form-control-plaintext">رئيس لجنة التنظيم</span>
                                    </td>
                                    <td data-label="الجنسية">
                                        <span class="form-control-plaintext">-</span>
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>


                <div class="form-group row mt-4">
                    <label class="col-sm-6 col-form-label">الشخصيات الرسمية المدعوة</label>
                    <table id="invites-table" class="custom-table">
                        <thead>
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>الصفة</th>
                                <th>الجنسية</th>
                            </tr>
                        </thead>
                        <tbody id="invites-body">
                            @php
                                $invites = $evenement && $evenement->membres
                                    ? $evenement->membres->where('type_membre_id', 2)
                                    : collect();
                            @endphp

                            @if($invites->count())
                                @foreach($invites as $invite)
                                    <tr>
                                        <td>
                                            <span class="form-control-plaintext">{{ $invite->nom_prenom }}</span>
                                        </td>
                                        <td>
                                            <span class="form-control-plaintext">{{ $invite->role }}</span>
                                        </td>
                                        <td>
                                            <span class="form-control-plaintext">{{ $invite->nationalite }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td><span class="form-control-plaintext">-</span></td>
                                    <td><span class="form-control-plaintext">-</span></td>
                                    <td><span class="form-control-plaintext">-</span></td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>

            </div>
        </div>

        <!-- step4 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire5->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire5->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-12 col-form-label">الجمعيات المشاركة</label>
                    <div class="table-responsive">
                        <table id="assoc-table" class="custom-table table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th rowspan="2" style="width:4%">ع/ر</th>
                                    <th rowspan="2" style="width:20%">الجمعيات المشاركة</th>
                                    <th colspan="2" style="width:20%">عدد الرياضيين</th>
                                    <th rowspan="2" style="width:10%">المرافقون</th>
                                    <th rowspan="2" style="width:10%">المجموع</th>
                                </tr>
                                <tr>
                                    <th style="width:10%">ذكور</th>
                                    <th style="width:10%">إناث</th>
                                </tr>
                            </thead>

                            @php
                                $assocParticipantes = collect();
                                if ($demande->evenementSportifs && $demande->evenementSportifs->first()) {
                                    $assocParticipantes = $demande->evenementSportifs->first()->assocParticipantes ?? collect();
                                }
                            @endphp

                            <tbody id="assoc_participantes-body">
                                @if($assocParticipantes->count())
                                    @foreach($assocParticipantes as $index => $assoc)
                                        <tr>
                                            <td class="row-number">{{ $index + 1 }}</td>
                                            <td><span class="form-control-plaintext">{{ $assoc->nom }}</span></td>
                                            <td><span class="form-control-plaintext text-center">{{ $assoc->num_athlete_h }}</span></td>
                                            <td><span class="form-control-plaintext text-center">{{ $assoc->num_athlete_f }}</span></td>
                                            <td><span class="form-control-plaintext text-center">{{ $assoc->accompagnants }}</span></td>
                                            <td><span class="form-control-plaintext text-center fw-bold">{{ $assoc->total }}</span></td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td class="row-number">1</td>
                                        <td><span class="form-control-plaintext">-</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center fw-bold">0</span></td>
                                    </tr>
                                @endif
                            </tbody>

                            <tfoot>
                                <tr class="fw-bold">
                                    <td colspan="2" class="text-center">المجموع العام</td>
                                    <td><span class="form-control-plaintext text-center">{{ $assocParticipantes->sum('num_athlete_h') }}</span></td>
                                    <td><span class="form-control-plaintext text-center">{{ $assocParticipantes->sum('num_athlete_f') }}</span></td>
                                    <td><span class="form-control-plaintext text-center">{{ $assocParticipantes->sum('accompagnants') }}</span></td>
                                    <td><span class="form-control-plaintext text-center fw-bold">{{ $assocParticipantes->sum('total') }}</span></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

        </div>
  


        <!-- step5 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire6->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire6->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row"> 
                    <label class="col-sm-12 col-form-label">الرياضيين المشاركين بصفة فردية</label>
                    <div class="table-responsive">
                        <table id="athletes-table" class="custom-table table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th rowspan="2" style="width:4%">ع/ر</th>
                                    <th rowspan="2" style="width:25%">اسم و لقب الرياضي المشارك</th>
                                    <th colspan="2" style="width:20%">عدد الرياضيين</th>
                                    <th rowspan="2" style="width:10%">المرافقون</th>
                                    <th rowspan="2" style="width:10%">المجموع</th>
                                </tr>
                                <tr>
                                    <th style="width:10%">ذكور</th>
                                    <th style="width:10%">إناث</th>
                                </tr>
                            </thead>

                            <tbody id="athletes-body">
                                @foreach($demande->evenementSportifs->first()->athletesIndividuels ?? [] as $athlete)
                                    <tr>
                                        <td class="row-number">{{ $loop->iteration }}</td>
                                        <td><span class="form-control-plaintext">{{ $athlete->nom_prenom_sportif }}</span></td>
                                        <td><span class="form-control-plaintext text-center">{{ $athlete->num_athlete_h }}</span></td>
                                        <td><span class="form-control-plaintext text-center">{{ $athlete->num_athlete_f }}</span></td>
                                        <td><span class="form-control-plaintext text-center">{{ $athlete->accompagnants }}</span></td>
                                        <td><span class="form-control-plaintext text-center fw-bold">{{ $athlete->total }}</span></td>
                                    </tr>
                                @endforeach
                                @if(empty($demande->evenementSportifs->first()->athletesIndividuels))
                                    <tr>
                                        <td class="row-number">1</td>
                                        <td><span class="form-control-plaintext">-</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center fw-bold">0</span></td>
                                    </tr>
                                @endif
                            </tbody>

                            <tfoot>
                                <tr class="fw-bold">
                                    <td colspan="2" class="text-center">المجموع العام</td>
                                    <td><span class="form-control-plaintext text-center">{{ $demande->evenementSportifs->first()->athletesIndividuels->sum('num_athlete_h') ?? 0 }}</span></td>
                                    <td><span class="form-control-plaintext text-center">{{ $demande->evenementSportifs->first()->athletesIndividuels->sum('num_athlete_f') ?? 0 }}</span></td>
                                    <td><span class="form-control-plaintext text-center">{{ $demande->evenementSportifs->first()->athletesIndividuels->sum('accompagnants') ?? 0 }}</span></td>
                                    <td><span class="form-control-plaintext text-center fw-bold">{{ $demande->evenementSportifs->first()->athletesIndividuels->sum('total') ?? 0 }}</span></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- step6 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire7->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire7->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-12 col-form-label">الرياضيين المشاركين</label>
                    <div class="table-responsive">
                        <table id="sportifs-table" class="custom-table table table-bordered text-center align-middle">
                            <thead>
                                <tr>
                                    <th>اسم و لقب الرياضي المشارك</th>
                                    <th>الصنف العمري</th>
                                    <th>تاريخ الولادة</th>
                                    <th>رقم بطاقة التعريف</th>
                                </tr>
                            </thead>
                            <tbody id="sportifs-body">
                                @foreach($demande->evenementSportifs->first()->sportifs ?? [] as $sportif)
                                    <tr>
                                        <td data-label="الاسم واللقب">
                                            <span class="form-control-plaintext">{{ $sportif->nom_prenom }}</span>
                                        </td>
                                        <td data-label="الصنف العمري">
                                            <span class="form-control-plaintext">{{ $sportif->tranch_age }}</span>
                                        </td>
                                        <td data-label="تاريخ الولادة">
                                            <span class="form-control-plaintext">{{ $sportif->date_naissance }}</span>
                                        </td>
                                        <td data-label="رقم بطاقة التعريف">
                                            <span class="form-control-plaintext">{{ $sportif->num_cin }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                                @if(empty($demande->evenementSportifs->first()->sportifs))
                                    <tr>
                                        <td colspan="4" class="text-center">لا توجد بيانات</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>


        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire8->id_type }}">
            <input type="hidden" name="demande_id" value="{{ $demande->id_demande ?? '' }}">  

            <h3 style="font-size:25px;">{{ $formulaire8->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة الرياضيين و المرافقين</label>
                    <table id="touristes-table" class="custom-table table table-bordered text-center align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>البلد الأصلي</th>
                                <th>رقم جواز السفر</th>
                                <th>تاريخ الوصول</th>
                                <th>مكان الإقامة</th>
                                <th>تاريخ المغادرة</th>
                            </tr>
                        </thead>
                        <tbody id="touristes-body">
                            @forelse($evenement->etrangeres->where('type_etranger_id', 1) as $touriste)
                                <tr>
                                    <td><input type="text" class="form-control" value="{{ $touriste->nom_prenom }}" readonly></td>
                                    <td><input type="text" class="form-control" value="{{ $touriste->pays_origine }}" readonly></td>
                                    <td><input type="text" class="form-control" value="{{ $touriste->num_passport }}" readonly></td>
                                    <td><input type="date" class="form-control" value="{{ $touriste->date_arrive }}" readonly></td>
                                    <td><input type="text" class="form-control" value="{{ $touriste->lieu_residence }}" readonly></td>
                                    <td><input type="date" class="form-control" value="{{ $touriste->date_depart }}" readonly></td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center text-muted">لا توجد بيانات</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>

            </div>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة الحكام و الرسميين</label>
                    <table id="touriste2s-table" class="custom-table table table-bordered text-center align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>البلد الأصلي</th>
                                <th>رقم جواز السفر</th>
                                <th>تاريخ الوصول</th>
                                <th>مكان الإقامة</th>
                                <th>تاريخ المغادرة</th>
                            </tr>
                        </thead>
                        <tbody id="touriste2s-body">
                            @forelse($evenement->etrangeres->where('type_etranger_id', 2) as $touriste2)
                                <tr>
                                    <td><input type="text" class="form-control" value="{{ $touriste2->nom_prenom }}" readonly></td>
                                    <td><input type="text" class="form-control" value="{{ $touriste2->pays_origine }}" readonly></td>
                                    <td><input type="text" class="form-control" value="{{ $touriste2->num_passport }}" readonly></td>
                                    <td><input type="date" class="form-control" value="{{ $touriste2->date_arrive }}" readonly></td>
                                    <td><input type="text" class="form-control" value="{{ $touriste2->lieu_residence }}" readonly></td>
                                    <td><input type="date" class="form-control" value="{{ $touriste2->date_depart }}" readonly></td>
                                </tr>
                            @empty
                                <tr>
                                    <td colspan="6" class="text-center text-muted">لا توجد بيانات</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>


        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire9->id_type }}">
            <input type="hidden" name="demande_id" value="">  
            <h3 style="font-size:25px;">{{ $formulaire9->type_ar }}</h3>
            <br>
            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة الشخصيات الرسمية الأجنبية</label>
                    <table id="touriste3s-table" class="custom-table table table-bordered text-center align-middle">
                        <thead class="table-light">
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>البلد الأصلي</th>
                                <th>رقم جواز السفر</th>
                                <th>تاريخ الوصول</th>
                                <th>مكان الإقامة</th>
                                <th>تاريخ المغادرة</th>
                            </tr>
                        </thead>
                        <tbody id="touriste3s-body">
                            @if(isset($evenement) && $evenement->etrangeres && $evenement->etrangeres->where('type_etranger_id', 3)->isNotEmpty())
                                @foreach($evenement->etrangeres->where('type_etranger_id', 3) as $touriste3)
                                    <tr>
                                        <td><input type="text" class="form-control" value="{{ $touriste3->nom_prenom }}" readonly></td>
                                        <td><input type="text" class="form-control" value="{{ $touriste3->pays_origine }}" readonly></td>
                                        <td><input type="text" class="form-control" value="{{ $touriste3->num_passport }}" readonly></td>
                                        <td><input type="date" class="form-control" value="{{ $touriste3->date_arrive }}" readonly></td>
                                        <td><input type="text" class="form-control" value="{{ $touriste3->lieu_residence }}" readonly></td>
                                        <td><input type="date" class="form-control" value="{{ $touriste3->date_depart }}" readonly></td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td colspan="6" class="text-center text-muted">لا توجد بيانات</td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>

            </div>
        </div>


        <div class="container">
            <h3 style="font-size:25px;">موافقة مبدئية</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-10 col-form-label">
                        موافقة مبدئية كتابية لاستغلال مكان إقامة التظاهرة الرياضية من المصالح المختصة
                    </label>
                    <div class="col-sm-12">
                        @if($demande->accordFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ asset('storage/' . $demande->accordFile->file) }}" target="_blank">
                                    <i class="la la-file"></i> عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد ملف موافقة مبدئية مرفق.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <h3 style="font-size:25px;">الملف الفني</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        الملف الفني للتظاهرة
                    </label>
                    <div class="col-sm-12">
                        @if($demande->techniqueFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ asset('storage/' . $demande->techniqueFile->file) }}" target="_blank">
                                    <i class="la la-file"></i> عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد ملف فني مرفق.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>


        <div class="container">
            <h3 style="font-size:25px;">مطلب في إقامة تظاهرة رياضية وطنية بالبلاد التونسية</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        المطلب 
                    </label>
                    <div class="col-sm-12">
                        @if($demande->demandeFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ asset('storage/' . $demande->demandeFile->file) }}" target="_blank">
                                    <i class="la la-file"></i> عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد ملف فني مرفق.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="form-group no-print" style="display: flex; justify-content: center; margin-top: 20px;">
            <div class="d-flex" style="gap: 20px; align-items: center;">
                <a href="{{ route('manifestation2.index') }}" class="btn btn-primary" style="width:120px; height:40px; display:flex; align-items:center; justify-content:center;">
                    <i class="bi bi-arrow-left" style="margin-right:5px;"></i> رجوع
                </a>
                <button type="button" onclick="window.print()" class="btn btn-success" style="width:120px; height:40px; display:flex; align-items:center; justify-content:center;">
                    <i class="fa fa-print" style="margin-right:5px;"></i> طباعة
                </button>
            </div>
        </div>

    </form>
</div>

<script src="{{ asset('BackOfficeAR/js/salle_sport_form.js') }}"></script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection