
@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit">
<div class="header-print-container">
    <form action="" method="POST" enctype="multipart/form-data" lang="ar">
        <input type="hidden" name="type_formulaire_id" value="12">

        <!-- step1 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire2->id_type }}">
            <h2>الجمهورية التونسية</h2>
            <h2>وزارة الشباب و الرياضة</h2>

            <div class="card shadow-lg border-0 mb-4 rounded-4">
    <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
        <h5 class="mb-0 fw-bold">مراحل معالجة الطلب</h5>
        <span class="badge bg-primary fs-6">تتبع الحالة</span>
    </div>

    <div class="card-body">
        <p class="text-muted mb-4 text-center fs-6">
            تتبع مراحل سير الطلب عبر الإدارات المختلفة:
        </p>

        <div class="modern-stepper">
            <!-- Step 1 -->
            <div class="step {{ $demande->id_type == 1 ? 'active' : ($demande->id_type == 3 ? 'rejected' : '') }}">
                <div class="icon">
                    <i class="la la-building"></i>
                </div>
                <div class="content">
                    <h6 class="fw-bold mb-1">الإدارة الفرعية</h6>
                    @if($demande->id_type == 1)
                        <span class="badge bg-success">مقبول</span>
                    @elseif($demande->id_type == 3)
                        <span class="badge bg-danger">مرفوض</span>
                    @else
                        <span class="badge bg-warning text-dark">في الانتظار</span>
                    @endif

                    @if($demande->commentaire_motif)
                        <div class="text-danger small mt-2 fw-semibold">
                            <i class="la la-comment-dots"></i> {{ $demande->commentaire_motif }}
                        </div>
                    @endif
                </div>
            </div>

            <!-- Connector -->
            <div class="connector-line"></div>

            <!-- Step 2 -->
            <div class="step {{ $demande->statut_id == 1 ? 'active' : ($demande->statut_id == 3 ? 'rejected' : '') }}">
                <div class="icon">
                    <i class="la la-university"></i>
                </div>
                <div class="content">
                    <h6 class="fw-bold mb-1">الجامعة</h6>
                    @if($demande->statut_id == 1)
                        <span class="badge bg-success">مقبول</span>
                    @elseif($demande->statut_id == 3)
                        <span class="badge bg-danger">مرفوض</span>
                    @else
                        <span class="badge bg-secondary">—</span>
                    @endif

                    @if($demande->commentaire_motif2)
                        <div class="text-danger small mt-2 fw-semibold">
                            <i class="la la-comment-dots"></i> {{ $demande->commentaire_motif2 }}
                        </div>
                    @endif
                </div>
            </div>

            <!-- Connector -->
            <div class="connector-line"></div>

            <!-- Step 3 -->
            <div class="step {{ $demande->statut2_id == 1 ? 'active' : ($demande->statut2_id == 3 ? 'rejected' : '') }}">
                <div class="icon">
                    <i class="la la-users"></i>
                </div>
                <div class="content">
                    <h6 class="fw-bold mb-1">اللجنة الوطنية</h6>
                    @if($demande->statut2_id == 1)
                        <span class="badge bg-success">مقبول</span>
                    @elseif($demande->statut2_id == 3)
                        <span class="badge bg-danger">مرفوض</span>
                    @else
                        <span class="badge bg-secondary">—</span>
                    @endif

                    @if($demande->commentaire_motif3)
                        <div class="text-danger small mt-2 fw-semibold">
                            <i class="la la-comment-dots"></i> {{ $demande->commentaire_motif3 }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
<style>
    .bg-custom-gray {
    background-color: #f8f9fb !important;
}

/* Stepper container */
.modern-stepper {
    display: flex;
    align-items: flex-start;
    justify-content: space-between;
    position: relative;
    gap: 40px;
    margin-top: 30px;
}

/* Step block */
.modern-stepper .step {
    background: #fff;
    border: 2px solid #e0e4eb;
    border-radius: 16px;
    padding: 20px;
    flex: 1;
    text-align: center;
    position: relative;
    transition: all 0.3s ease;
    box-shadow: 0 3px 8px rgba(0, 0, 0, 0.05);
}

/* Step hover effect */
.modern-stepper .step:hover {
    transform: translateY(-3px);
    box-shadow: 0 6px 15px rgba(0, 0, 0, 0.08);
}

/* Icon */
.modern-stepper .icon {
    font-size: 2rem;
    margin-bottom: 10px;
    color: #6c757d;
}

/* Active / Success state */
.modern-stepper .step.active {
    border-color: #28a745;
    background: #e9f9ef;
}

.modern-stepper .step.active .icon {
    color: #28a745;
    animation: pulse 1.5s infinite;
}

/* Rejected */
.modern-stepper .step.rejected {
    border-color: #dc3545;
    background: #fdeaea;
}

.modern-stepper .step.rejected .icon {
    color: #dc3545;
}

/* Connector line */
.connector-line {
    flex: 0.05;
    height: 3px;
    background: linear-gradient(to right, #ccc, #ccc);
    position: relative;
    top: 45px;
}

/* Animation */
@keyframes pulse {
    0% { transform: scale(1); opacity: 1; }
    50% { transform: scale(1.1); opacity: 0.7; }
    100% { transform: scale(1); opacity: 1; }
}

/* Responsive */
@media (max-width: 992px) {
    .modern-stepper {
        flex-direction: column;
        gap: 25px;
    }
    .connector-line {
        display: none;
    }
}

</style>


            <h3 style="font-size:25px;">{{ $formulaire2->type_ar }}</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label">اسم الهيكل غير الرياضي</label>
                    <div class="col-sm-10">
                        <span class="form-control-plaintext">{{ $org->nom ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">عدد التاشيرة</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->num_visa ?? '' }}</span>
                    </div>
                    <label class="col-sm-2 col-form-label">تاريخ التسجيل س.و.م</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->date_enregistrement ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">المعرف الجبائي</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->identifiant_fiscal ?? '' }}</span>
                    </div>

                    <label class="col-sm-2 col-form-label">رقم الحساب البنكي</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->num_compte_bancaire ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">العنوان</label>
                    <div class="col-sm-10">
                        <span class="form-control-plaintext">{{ $org->adresse ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">رقم الهاتف</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->tel ?? '' }}</span>
                    </div>

                    <label class="col-sm-2 col-form-label">رقم الفاكس</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->fax ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $org->email ?? '' }}</span>
                    </div>
                </div>
            </div>   
        </div>

        <div class="container">
            <h3 style="font-size:25px;">ملف التامين الخاص</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        نسخة من ملف التأمين الخاص بالتظاهرة الرياضية
                    </label>
                    <div class="col-sm-12">

                        @if($demande->assuranceFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ asset('storage/' . $demande->assuranceFile->file) }}" 
                                target="_blank" class="text-primary">
                                <i class="la la-file-pdf"></i> عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد ملف تأمين مرفق.</p>
                        @endif

                    </div>
                </div>
            </div>
        </div>


        <!-- step2 -->
         @php
            $evenement = $demande->evenementSportifs->first(); // On prend le premier événement lié
        @endphp

        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire3->id_type }}">

            <h2>الجمهورية التونسية</h2>
            <h2>وزارة الشباب و الرياضة</h2>
            <h3 style="font-size:25px;">{{ $formulaire3->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label">اسم التظاهرة</label>
                    <div class="col-sm-10">
                        <span class="form-control-plaintext">{{ $evenement->nom_even ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label">الهدف من تنظيم التظاهرة و آثارها الرياضية و الأبعاد الاقتصادية والاجتماعية</label>
                    <div class="col-sm-12">
                        <textarea name="objectifs" readonly class="form-control bg-white" rows="2">{{ old('objectifs', $evenement->objectifs ?? '') }}</textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label">محتوى التظاهرة و الاختصاصات الرياضية المستهدفة</label>
                    <div class="col-sm-12">
                        <textarea name="contenus" readonly class="form-control bg-white" rows="2">{{ old('contenus', $evenement->contenus ?? '') }}</textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">تاريخ تنظيم التظاهرة</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->date ?? '' }}</span>
                    </div>

                    <label class="col-sm-2 col-form-label">توقيت تنظيم التظاهرة</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">
                            {{ isset($evenement->heure) ? \Carbon\Carbon::parse($evenement->heure)->format('H:i') : '' }}
                        </span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الولاية</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">
                            {{ optional($gouvernorats->firstWhere('id_gouver', $evenement->gouvernorat_id))->nom_ar ?? '' }}
                        </span>
                    </div>

                    <label class="col-sm-2 col-form-label">البلدية</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">
                            {{ optional($delegations->firstWhere('id_delegation', $evenement->delegation_id))->nom_ar ?? '' }}
                        </span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-12 col-form-label"> المنشئات الرياضية التي ستستغل </label>
                    <div class="col-sm-12">
                        <textarea name="instalation_sportives" readonly class="form-control bg-white" rows="2">{{ old('instalation_sportives', $evenement->instalation_sportives ?? '') }}</textarea>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الجامعة الرياضية مرجع الاختصاص</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->reference ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">المداخيل التقديرية الجملية</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->estimation_evenement ?? '' }}</span>
                    </div>

                    <label class="col-sm-2 col-form-label">المصاريف التقديرية الجملية</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->cout_total_evenement ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الفارق التقديري</label>
                    <div class="col-sm-4">
                        <span class="form-control-plaintext">{{ $evenement->difference_estimee ?? '' }}</span>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">بيان الجوائز</label>
                    <div class="col-sm-10">
                        <span class="form-control-plaintext">{{ $evenement->recompense ?? '' }}</span>
                    </div>
                </div>

                <input type="hidden" name="user_id" value="{{ Auth::user()->id }}">
            </div>
        </div>

        <!-- step3 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire4->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire4->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-6 col-form-label">قائمة عناصر فريق التنظيم</label>
                    <table id="membres-table" class="custom-table">
                        <thead>
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>الصفة</th>
                                <th>الجنسية</th>
                            </tr>
                        </thead>
                        <tbody id="membres-body">
                            @php
                                $membres = $evenement && $evenement->membres
                                    ? $evenement->membres->where('type_membre_id', 1)
                                    : collect();
                            @endphp

                            @if($membres->count())
                                @foreach($membres as $membre)
                                    <tr>
                                        <td data-label="الاسم واللقب">
                                            <span class="form-control-plaintext">{{ $membre->nom_prenom }}</span>
                                        </td>
                                        <td data-label="الصفة">
                                            <span class="form-control-plaintext">{{ $membre->role }}</span>
                                        </td>
                                        <td data-label="الجنسية">
                                            <span class="form-control-plaintext">{{ $membre->nationalite }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td data-label="الاسم واللقب">
                                        <span class="form-control-plaintext">-</span>
                                    </td>
                                    <td data-label="الصفة">
                                        <span class="form-control-plaintext">رئيس لجنة التنظيم</span>
                                    </td>
                                    <td data-label="الجنسية">
                                        <span class="form-control-plaintext">-</span>
                                    </td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>


                <div class="form-group row mt-4">
                    <label class="col-sm-6 col-form-label">الشخصيات الرسمية المدعوة</label>
                    <table id="invites-table" class="custom-table">
                        <thead>
                            <tr>
                                <th>الاسم واللقب</th>
                                <th>الصفة</th>
                                <th>الجنسية</th>
                            </tr>
                        </thead>
                        <tbody id="invites-body">
                            @php
                                $invites = $evenement && $evenement->membres
                                    ? $evenement->membres->where('type_membre_id', 2)
                                    : collect();
                            @endphp

                            @if($invites->count())
                                @foreach($invites as $invite)
                                    <tr>
                                        <td>
                                            <span class="form-control-plaintext">{{ $invite->nom_prenom }}</span>
                                        </td>
                                        <td>
                                            <span class="form-control-plaintext">{{ $invite->role }}</span>
                                        </td>
                                        <td>
                                            <span class="form-control-plaintext">{{ $invite->nationalite }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td><span class="form-control-plaintext">-</span></td>
                                    <td><span class="form-control-plaintext">-</span></td>
                                    <td><span class="form-control-plaintext">-</span></td>
                                </tr>
                            @endif
                        </tbody>
                    </table>
                </div>

            </div>
        </div>

        <!-- step4 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire5->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire5->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-12 col-form-label">الجمعيات المشاركة</label>
                    <div class="table-responsive">
                        <table id="assoc-table" class="custom-table table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th rowspan="2" style="width:4%">ع/ر</th>
                                    <th rowspan="2" style="width:20%">الجمعيات المشاركة</th>
                                    <th colspan="2" style="width:20%">عدد الرياضيين</th>
                                    <th rowspan="2" style="width:10%">المرافقون</th>
                                    <th rowspan="2" style="width:10%">المجموع</th>
                                </tr>
                                <tr>
                                    <th style="width:10%">ذكور</th>
                                    <th style="width:10%">إناث</th>
                                </tr>
                            </thead>

                            @php
                                $assocParticipantes = collect();
                                if ($demande->evenementSportifs && $demande->evenementSportifs->first()) {
                                    $assocParticipantes = $demande->evenementSportifs->first()->assocParticipantes ?? collect();
                                }
                            @endphp

                            <tbody id="assoc_participantes-body">
                                @if($assocParticipantes->count())
                                    @foreach($assocParticipantes as $index => $assoc)
                                        <tr>
                                            <td class="row-number">{{ $index + 1 }}</td>
                                            <td><span class="form-control-plaintext">{{ $assoc->nom }}</span></td>
                                            <td><span class="form-control-plaintext text-center">{{ $assoc->num_athlete_h }}</span></td>
                                            <td><span class="form-control-plaintext text-center">{{ $assoc->num_athlete_f }}</span></td>
                                            <td><span class="form-control-plaintext text-center">{{ $assoc->accompagnants }}</span></td>
                                            <td><span class="form-control-plaintext text-center fw-bold">{{ $assoc->total }}</span></td>
                                        </tr>
                                    @endforeach
                                @else
                                    <tr>
                                        <td class="row-number">1</td>
                                        <td><span class="form-control-plaintext">-</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center fw-bold">0</span></td>
                                    </tr>
                                @endif
                            </tbody>

                            <tfoot>
                                <tr class="fw-bold">
                                    <td colspan="2" class="text-center">المجموع العام</td>
                                    <td><span class="form-control-plaintext text-center">{{ $assocParticipantes->sum('num_athlete_h') }}</span></td>
                                    <td><span class="form-control-plaintext text-center">{{ $assocParticipantes->sum('num_athlete_f') }}</span></td>
                                    <td><span class="form-control-plaintext text-center">{{ $assocParticipantes->sum('accompagnants') }}</span></td>
                                    <td><span class="form-control-plaintext text-center fw-bold">{{ $assocParticipantes->sum('total') }}</span></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>

        </div>
  


        <!-- step5 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire6->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire6->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row"> 
                    <label class="col-sm-12 col-form-label">الرياضيين المشاركين بصفة فردية</label>
                    <div class="table-responsive">
                        <table id="athletes-table" class="custom-table table table-bordered text-center align-middle">
                            <thead class="table-light">
                                <tr>
                                    <th rowspan="2" style="width:4%">ع/ر</th>
                                    <th rowspan="2" style="width:25%">اسم و لقب الرياضي المشارك</th>
                                    <th colspan="2" style="width:20%">عدد الرياضيين</th>
                                    <th rowspan="2" style="width:10%">المرافقون</th>
                                    <th rowspan="2" style="width:10%">المجموع</th>
                                </tr>
                                <tr>
                                    <th style="width:10%">ذكور</th>
                                    <th style="width:10%">إناث</th>
                                </tr>
                            </thead>

                            <tbody id="athletes-body">
                                @foreach($demande->evenementSportifs->first()->athletesIndividuels ?? [] as $athlete)
                                    <tr>
                                        <td class="row-number">{{ $loop->iteration }}</td>
                                        <td><span class="form-control-plaintext">{{ $athlete->nom_prenom_sportif }}</span></td>
                                        <td><span class="form-control-plaintext text-center">{{ $athlete->num_athlete_h }}</span></td>
                                        <td><span class="form-control-plaintext text-center">{{ $athlete->num_athlete_f }}</span></td>
                                        <td><span class="form-control-plaintext text-center">{{ $athlete->accompagnants }}</span></td>
                                        <td><span class="form-control-plaintext text-center fw-bold">{{ $athlete->total }}</span></td>
                                    </tr>
                                @endforeach
                                @if(empty($demande->evenementSportifs->first()->athletesIndividuels))
                                    <tr>
                                        <td class="row-number">1</td>
                                        <td><span class="form-control-plaintext">-</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center">0</span></td>
                                        <td><span class="form-control-plaintext text-center fw-bold">0</span></td>
                                    </tr>
                                @endif
                            </tbody>

                            <tfoot>
                                <tr class="fw-bold">
                                    <td colspan="2" class="text-center">المجموع العام</td>
                                    <td><span class="form-control-plaintext text-center">{{ $demande->evenementSportifs->first()->athletesIndividuels->sum('num_athlete_h') ?? 0 }}</span></td>
                                    <td><span class="form-control-plaintext text-center">{{ $demande->evenementSportifs->first()->athletesIndividuels->sum('num_athlete_f') ?? 0 }}</span></td>
                                    <td><span class="form-control-plaintext text-center">{{ $demande->evenementSportifs->first()->athletesIndividuels->sum('accompagnants') ?? 0 }}</span></td>
                                    <td><span class="form-control-plaintext text-center fw-bold">{{ $demande->evenementSportifs->first()->athletesIndividuels->sum('total') ?? 0 }}</span></td>
                                </tr>
                            </tfoot>
                        </table>
                    </div>
                </div>
            </div>
        </div>

        <!-- step6 -->
        <div class="container">
            <input type="hidden" name="id_formulaire" value="{{ $formulaire7->id_type }}">
            <h3 style="font-size:25px;">{{ $formulaire7->type_ar }}</h3>
            <br>

            <div class="form-section">
                <div class="form-group row">
                    <label class="col-sm-12 col-form-label">الرياضيين المشاركين</label>
                    <div class="table-responsive">
                        <table id="sportifs-table" class="custom-table table table-bordered text-center align-middle">
                            <thead>
                                <tr>
                                    <th>اسم و لقب الرياضي المشارك</th>
                                    <th>الصنف العمري</th>
                                    <th>تاريخ الولادة</th>
                                    <th>رقم بطاقة التعريف</th>
                                </tr>
                            </thead>
                            <tbody id="sportifs-body">
                                @foreach($demande->evenementSportifs->first()->sportifs ?? [] as $sportif)
                                    <tr>
                                        <td data-label="الاسم واللقب">
                                            <span class="form-control-plaintext">{{ $sportif->nom_prenom }}</span>
                                        </td>
                                        <td data-label="الصنف العمري">
                                            <span class="form-control-plaintext">{{ $sportif->tranch_age }}</span>
                                        </td>
                                        <td data-label="تاريخ الولادة">
                                            <span class="form-control-plaintext">{{ $sportif->date_naissance }}</span>
                                        </td>
                                        <td data-label="رقم بطاقة التعريف">
                                            <span class="form-control-plaintext">{{ $sportif->num_cin }}</span>
                                        </td>
                                    </tr>
                                @endforeach
                                @if(empty($demande->evenementSportifs->first()->sportifs))
                                    <tr>
                                        <td colspan="4" class="text-center">لا توجد بيانات</td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>

        </div>


        <div class="container">
            <h3 style="font-size:25px;">موافقة مبدئية</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-10 col-form-label">
                        موافقة مبدئية كتابية لاستغلال مكان إقامة التظاهرة الرياضية من المصالح المختصة
                    </label>
                    <div class="col-sm-12">
                        @if($demande->accordFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ asset('storage/' . $demande->accordFile->file) }}" target="_blank">
                                    <i class="la la-file"></i> عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد ملف موافقة مبدئية مرفق.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        <div class="container">
            <h3 style="font-size:25px;">الملف الفني</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        الملف الفني للتظاهرة
                    </label>
                    <div class="col-sm-12">
                        @if($demande->techniqueFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ asset('storage/' . $demande->techniqueFile->file) }}" target="_blank">
                                    <i class="la la-file"></i> عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد ملف فني مرفق.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>


        <div class="container">
            <h3 style="font-size:25px;">مطلب في إقامة تظاهرة رياضية وطنية بالبلاد التونسية</h3>
            <br>
            <div class="form-section">
                <div class="form-group row mb-3" style="padding-top:20px;">
                    <label class="col-sm-6 col-form-label">
                        المطلب 
                    </label>
                    <div class="col-sm-12">
                        @if($demande->demandeFile)
                            <p>
                                الملف الحالي :
                                <a href="{{ asset('storage/' . $demande->demandeFile->file) }}" target="_blank">
                                    <i class="la la-file"></i> عرض الملف
                                </a>
                            </p>
                        @else
                            <p class="text-muted">لا يوجد ملف فني مرفق.</p>
                        @endif
                    </div>
                </div>
            </div>
        </div>

        

        <div class="form-group no-print" style="display: flex; justify-content: center; margin-top: 20px;">
    <div class="d-flex" style="gap: 20px; align-items: center;">
        <a href="{{ route('manifestation.index') }}" class="btn btn-primary" style="width:120px; height:40px; display:flex; align-items:center; justify-content:center;">
            <i class="bi bi-arrow-left" style="margin-right:5px;"></i> رجوع
        </a>
       <button type="button" onclick="window.print()" 
    class="btn btn-success" 
    style="width:120px; height:40px; display:flex; align-items:center; justify-content:center; gap:6px;">
    <i class="fa fa-print"></i> طباعة
</button>
    </div>
</div>

    </form>
</div>

<script src="{{ asset('BackOfficeAR/js/salle_sport_form.js') }}"></script>
<script>
    let orgIndex = {{ $membres->count() ?: 1 }};
    function addOrganisateurRow() {
        let tableBody = document.getElementById('membres-body');
        let newRow = `
            <tr>
                <td data-label="الاسم واللقب">
                    <input type="text" name="membres[${orgIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                </td>
                <td data-label="الصفة">
                    <input type="text" name="membres[${orgIndex}][role]" class="form-control" placeholder="الصفة">
                </td>
                <td data-label="الجنسية">
                    <input type="text" name="membres[${orgIndex}][nationalite]" class="form-control" placeholder="الجنسية">
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>`;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        orgIndex++;
    }

    let inviteIndex = {{ $invites->count() ?: 1 }};
    function addInviteRow() {
        let tableBody = document.getElementById('invites-body');
        let newRow = `
            <tr>
                <td data-label="الاسم واللقب">
                    <input type="text" name="invites[${inviteIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
                </td>
                <td data-label="الصفة">
                    <input type="text" name="invites[${inviteIndex}][role]" class="form-control" placeholder="الصفة">
                </td>
                <td data-label="الجنسية">
                    <input type="text" name="invites[${inviteIndex}][nationalite]" class="form-control" placeholder="الجنسية">
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>`;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        inviteIndex++;
    }

    function removeRow(button) {
        button.closest('tr').remove();
    }
</script>


<script>
    let assocIndex = {{ $assocParticipantes->count() ?? 1 }};

    function addAssocRow() {
        const tbody = document.getElementById('assoc_participantes-body');
        const newRow = document.createElement('tr');

        newRow.innerHTML = `
            <td class="row-number"></td>
            <td><input type="text" name="assoc_participantes[${assocIndex}][nom]" class="form-control" placeholder="اسم الجمعية"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][num_athlete_h]" class="form-control text-center" placeholder="ذكور" min="0"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][num_athlete_f]" class="form-control text-center" placeholder="إناث" min="0"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][accompagnants]" class="form-control text-center" placeholder="عدد" min="0"></td>
            <td><input type="number" name="assoc_participantes[${assocIndex}][total]" class="form-control text-center" readonly placeholder="0"></td>
            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeAssocRow(this)">حذف</button></td>
        `;
        tbody.appendChild(newRow);
        assocIndex++;
        updateAssocRowNumbers();
        updateTotals();
    }

    function removeAssocRow(button) {
        button.closest('tr').remove();
        updateAssocRowNumbers();
        updateTotals();
    }

    function updateAssocRowNumbers() {
        const rows = document.querySelectorAll('#assoc_participantes-body tr');
        rows.forEach((row, index) => {
            row.querySelector('.row-number').textContent = index + 1;
        });
    }

    document.addEventListener('input', function(e) {
        if (!e.target.closest('#assoc_participantes-body')) return;

        const row = e.target.closest('tr');

        const males = Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
        const females = Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
        const escorts = Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;

        const rowTotal = males + females + escorts;
        const totalInput = row.querySelector('input[name$="[total]"]');
        if (totalInput) totalInput.value = rowTotal;

        updateTotals();
    });

    function updateTotals() {
        let totalMales = 0;
        let totalFemales = 0;
        let totalAccompagnants = 0;
        let totalGeneral = 0;

        document.querySelectorAll('#assoc_participantes-body tr').forEach(row => {
            totalMales += Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
            totalFemales += Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
            totalAccompagnants += Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;
            totalGeneral += Number(row.querySelector('input[name$="[total]"]').value) || 0;
        });

        document.getElementById('total-males').value = totalMales;
        document.getElementById('total-females').value = totalFemales;
        document.getElementById('total-accompagnants').value = totalAccompagnants;
        document.getElementById('total-general').value = totalGeneral;
    }

    updateTotals();
</script>


<script>
let athleteIndex = 1;

function addAthleteRow() {
    const tbody = document.getElementById('athletes-body');
    const newRow = document.createElement('tr');

    newRow.innerHTML = `
        <td class="row-number"></td>
        <td><input type="text" name="athletes[${athleteIndex}][nom_prenom_sportif]" class="form-control" placeholder="الاسم و اللقب"></td>
        <td><input type="number" name="athletes[${athleteIndex}][num_athlete_h]" class="form-control text-center" placeholder="ذكور" min="0"></td>
        <td><input type="number" name="athletes[${athleteIndex}][num_athlete_f]" class="form-control text-center" placeholder="إناث" min="0"></td>
        <td><input type="number" name="athletes[${athleteIndex}][accompagnants]" class="form-control text-center" placeholder="عدد" min="0"></td>
        <td><input type="number" name="athletes[${athleteIndex}][total]" class="form-control text-center" readonly placeholder="0"></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeAthleteRow(this)">حذف</button></td>
    `;
    tbody.appendChild(newRow);
    athleteIndex++;
    updateAthleteRowNumbers();
    update2Totals();
}

function removeAthleteRow(button) {
    button.closest('tr').remove();
    updateAthleteRowNumbers();
    update2Totals();
}

function updateAthleteRowNumbers() {
    const rows = document.querySelectorAll('#athletes-body tr');
    rows.forEach((row, index) => {
        row.querySelector('.row-number').textContent = index + 1;
    });
}

document.addEventListener('input', function(e) {
    if (!e.target.closest('#athletes-body')) return;

    const row = e.target.closest('tr');

    const males = Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
    const females = Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
    const escorts = Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;

    const rowTotal = males + females + escorts;
    const totalInput = row.querySelector('input[name$="[total]"]');
    if (totalInput) totalInput.value = rowTotal;

    update2Totals();
});

function update2Totals() {
    let total2Males = 0;
    let total2Females = 0;
    let total2Accompagnants = 0;
    let total2General = 0;

    document.querySelectorAll('#athletes-body tr').forEach(row => {
        total2Males += Number(row.querySelector('input[name$="[num_athlete_h]"]').value) || 0;
        total2Females += Number(row.querySelector('input[name$="[num_athlete_f]"]').value) || 0;
        total2Accompagnants += Number(row.querySelector('input[name$="[accompagnants]"]').value) || 0;
        total2General += Number(row.querySelector('input[name$="[total]"]').value) || 0;
    });

    document.getElementById('total2-males').value = total2Males;
    document.getElementById('total2-females').value = total2Females;
    document.getElementById('total2-accompagnants').value = total2Accompagnants;
    document.getElementById('total2-general').value = total2General;
}

update2Totals();
</script>


<script>
    let sportifIndex = {{ $sportifIndex ?? 1 }}; 

    function addSportifRow() {
        const tbody = document.getElementById('sportifs-body');
        const newRow = document.createElement('tr');

        newRow.innerHTML = `
            <td data-label="الاسم واللقب">
                <input type="text" name="sportifs[${sportifIndex}][nom_prenom]" class="form-control" placeholder="الاسم واللقب">
            </td>
            <td data-label="الصنف العمري">
                <input type="text" name="sportifs[${sportifIndex}][tranch_age]" class="form-control" placeholder="الصنف العمري">
            </td>
            <td data-label="تاريخ الولادة">
                <input type="date" name="sportifs[${sportifIndex}][date_naissance]" class="form-control">
            </td>
            <td data-label="رقم بطاقة التعريف">
                <input type="text" name="sportifs[${sportifIndex}][num_cin]" class="form-control" placeholder="رقم البطاقة">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn btn-danger btn-sm" onclick="removeSportifRow(this)">حذف</button>
            </td>
        `;

        tbody.appendChild(newRow);
        sportifIndex++;
    }

    function removeSportifRow(button) {
        button.closest('tr').remove();
    }

</script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection