@extends('layouts.app')

@section('content')<div class="it-about-3-area p-relative pt-30 pb-125">   <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">                <div class="container"><nav class="breadcrumb-nav" aria-label="breadcrumb">    <ol class="breadcrumb mb-0">        <li class="breadcrumb-item">            <a href="{{ route('dashboard') }}">                <i class="bi bi-house-fill"></i>                <span>الرئيسية</span>            </a>        </li>        <li class="breadcrumb-item">            <a href="{{ route('manifestation_choix') }}">                <span>التظاهرات الرياضية</span>            </a>        </li>        <li class="breadcrumb-item active" aria-current="page">التظاهرات الرياضية الوطنية</li>    </ol></nav>             <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

        <!-- Titre -->
        <div class="row">
            <div class="col-xl-12">
                <div class="it-section-title-box text-center mb-30" style="padding-top:20px;">
                    <span class="it-section-subtitle">طلبات التظاهرات الرياضية الوطنية</span>
                    <h4 class="it-section-title it-split-in-right mb-0">عرض جميع الطلبات</h4>
                </div>
            </div>
        </div>

        <!-- Card -->
        <div class="row justify-content-center">
            <div class="col-lg-12">
                <div class="card shadow-sm p-4">

                    <div class="d-flex justify-content-end mb-4">
                        <a class="btn btn-success" href="{{ route('manifestation.create') }}">
                            <i class="la la-plus me-1"></i> إضافة طلب
                        </a>
                    </div>

                    @if(session('success'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('success') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <div class="my-table table-responsive">                                     <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">                                        <thead class="thead-light">                                                                                       <tr>
                                     <th width="5%">المعرف</th>
                                    <th width="5%">رقم الملف</th>
                                    <th width="5%">اسم الهيكل</th>
                                    <th width="5%">اسم التظاهرة</th>
                                    <th width="5%">التاريخ</th>
                                    <th width="5%">الساعة</th>
                                    <th width="5%" >الولاية</th>
                                    <th width="5%">البلدية</th>
                                    <th width="5%">الحالة</th>
                                    <th width="15%">إجراءات</th>
                                    <th> القرار </th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($rows as $i => $row)
                                    <tr>
                                        <td>{{ $i + 1 }}</td>
                                        <td>{{ $row->num_dossier }}</td>
                                        <td>{{ $row->nom_organisme ?? '-' }}</td>
                                        <td>{{ $row->nom_evenement ?? '-' }}</td>
                                        <td>{{ $row->date_even ?? '-' }}</td>
                                        <td>{{ $row->heure_even ?? '-' }}</td>
                                        <td>{{ $row->gouvernorat ?? ($row->raw->evenementSportifs->first()?->gouvernorat->nom_ar ?? '-') }}</td>
                                        <td>{{ $row->delegation ?? ($row->raw->evenementSportifs->first()?->delegation->nom_ar ?? '-') }}</td>
                                        <td>
                                            @php
                                                $statut = $row->statut?->statut_ar ?? 'في الانتظار';
                                                $badgeClass = match($statut) {
                                                    'في الانتظار' => 'status-badge--pending',
                                                    'قبول' => 'status-badge--success',
                                                    'رفض' => 'status-badge--danger',
                                                    default => 'bg-secondary'
                                                };
                                            @endphp
                                              <span class="status-badge {{ $badgeClass }}">{{ $statut }}</span>
                                        </td>
                                        <td class="text-center">
                                            <div class="actions-cell d-inline-flex gap-2 justify-content-center align-items-center" role="group" aria-label="actions">
                                                <a href="{{ route('manifestation.show', $row->id_demande) }}"
                                                class="btn-icon btn-icon--primary"
                                                title="عرض">
                                                    <i class="la la-eye"></i>
                                                </a>

                                                @if($row->raw->id_type == 2)
                                                    <a href="{{ route('manifestation.edit', $row->id_demande) }}"
                                                    class="btn-icon btn-icon--warning"
                                                    title="تعديل">
                                                        <i class="la la-edit"></i>
                                                    </a>

                                                    <form action="{{ route('manifestation.destroy', $row->id_demande) }}" method="POST" class="d-inline">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="button" onclick="confirmDelete(this.closest('form'))"
                                                                class="btn-icon btn-icon--danger" title="حذف">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            @if($row->raw->id_type == 1 && $row->raw->statut_id == 1 && $row->raw->statut2_id == 1)
                                                @if(!empty($row->raw->file))
                                                    <button type="button" class="btn-icon btn-icon--warning" style="padding:10px 50px 10px 50px;"
                                                        onclick="window.open('{{ asset('storage/' . $row->raw->file) }}', '_blank')"
                                                        title="طباعة القرار" aria-label="طباعة القرار">
                                                        طباعة القرار
                                                    </button>
                                                @else
                                                    <span class="text-danger">لا يوجد ملف</span>
                                                @endif
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>

                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="10" class="text-center text-muted">لا توجد طلبات تظاهرات رياضية.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                <div class="mt-3">
    {{ $demandes->onEachSide(1)->links('pagination::bootstrap-5') }}
</div>
                </div>
            </div>
        </div>

    </div>
</div>

<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script src="{{ asset('assets/js/index.js') }}"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<script>
function confirmStatusChange(form, statut) {
    Swal.fire({
        title: 'تغيير الحالة',
        text: 'هل أنت متأكد من تغيير الحالة؟',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) form.submit();
    });
}

function confirmDelete(form) {
    Swal.fire({
        title: 'حذف الطلب',
        text: 'هل أنت متأكد من الحذف؟',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) form.submit();
    });
}
</script>

<style>
.btn-back {
    display: inline-flex;
    align-items: center;
    gap: 8px;
    background-color: #dc3545;
    color: #fff !important;
    font-weight: 600;
    padding: 10px 22px;
    border-radius: 30px;
    text-decoration: none;
    transition: all 0.3s ease;
    box-shadow: 0 3px 8px rgba(220, 53, 69, 0.25);
}
.btn-back:hover { background-color: #b52a37; transform: translateY(-2px); box-shadow: 0 6px 15px rgba(220,53,69,0.35); }
.btn-back i { font-size: 18px; margin-left: 6px; }

.btn-icon {
    width: 35px;
    height: 35px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 16px;
    transition: all 0.2s ease;
    border: none;
    cursor: pointer;
}
.btn-icon--primary { background-color: #e3f2fd; color: #0d6efd; }
.btn-icon--warning { background-color: #fff8e1; color: #d4a017; }
.btn-icon--danger { background-color: #fde8ea; color: #e74c3c; }
.btn-icon--secondary { background-color: #e2e3e5; color: #6c757d; }
.btn-icon:hover { transform: translateY(-1px); box-shadow: 0 2px 5px rgba(0,0,0,0.15); }

.badge { padding: 5px 8px; font-size: 12px; font-weight: 600; border-radius: 6px; }
.bg-warning { background-color: #fff8e1; color: white; }
.bg-success { background-color: #e8f9ee; color: white; }
.bg-danger { background-color: #fde8ea; color: white; }
.bg-secondary { background-color: #e2e3e5; color: white; }
</style>


@endsection
