@extends('layouts.app')

@section('styles')
<style>
    /* Styles pour les formulaires */
    form {
        direction: rtl;
    }

    .form-group label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: bold;
        font-size: 1rem;
        color: #333;
    }

    .form-control {
        direction: rtl;
        text-align: right;
        border: 1px solid #ced4da;
        padding: 0.75rem;
        font-size: 1rem;
        transition: border-color 0.15s ease-in-out;
    }

    .form-control:focus {
        border-color: #28a745;
        box-shadow: 0 0 0 0.2rem rgba(40, 167, 69, 0.25);
    }

    .card {
        border: none;
        box-shadow: 0 0 15px rgba(0,0,0,0.1);
        border-radius: 8px;
        margin-bottom: 2rem;
    }

    .card-title {
        color: #28a745;
        font-size: 1.5rem;
        font-weight: bold;
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid #eee;
        text-align: right;
    }

    .card-body {
        padding: 2rem;
    }

    /* Style pour les boutons */
    .btn {
        padding: 0.75rem 2rem;
        font-size: 1rem;
        border-radius: 5px;
        font-weight: 500;
    }

    .btn-success {
        background-color: #28a745;
        border-color: #28a745;
    }

    .btn-success:hover {
        background-color: #218838;
        border-color: #1e7e34;
    }

    .btn-primary {
        background-color: #007bff;
        border-color: #007bff;
    }

    .btn-primary:hover {
        background-color: #0069d9;
        border-color: #0062cc;
    }
    /* Styles pour le stepper */
    .stepper-wrapper {
        margin-top: 50px;
        margin-bottom: 50px;
        direction: rtl;
    }
    
    .stepper-item {
        position: relative;
        display: flex;
        flex-direction: column;
        align-items: center;
        flex: 1;
    }
    
    .stepper-item::before {
        position: absolute;
        content: "";
        border-bottom: 2px solid #ccc;
        width: 100%;
        top: 20px;
        right: -50%;
        z-index: 2;
    }
    
    .stepper-item::after {
        position: absolute;
        content: "";
        border-bottom: 2px solid #ccc;
        width: 100%;
        top: 20px;
        left: 50%;
        z-index: 2;
    }
    
    .stepper-item .step-counter {
        position: relative;
        z-index: 5;
        display: flex;
        justify-content: center;
        align-items: center;
        width: 40px;
        height: 40px;
        border-radius: 50%;
        background: #ccc;
        margin-bottom: 6px;
        color: white;
    }
    
    .stepper-item.active {
        font-weight: bold;
    }
    
    .stepper-item.active .step-counter {
        background-color: #28a745;
    }
    
    .stepper-item.completed .step-counter {
        background-color: #28a745;
    }
    
    .stepper-item.completed::after,
    .stepper-item.active::after,
    .stepper-item.completed::before,
    .stepper-item.active::before {
        background-color: #28a745;
    }
    
    .stepper-item:first-child::before {
        content: none;
    }
    
    .stepper-item:last-child::after {
        content: none;
    }

    /* Styles pour le contenu */
    .step-content {
        display: none;
        padding: 20px;
        border: 1px solid #ddd;
        border-radius: 4px;
        margin-top: 20px;
    }
    
    .step-content.active {
        display: block;
    }

    /* Styles pour les boutons */
    .step-navigation {
        margin-top: 20px;
        display: flex;
        justify-content: space-between;
    }
</style>
@endsection

@section('content')
<div class="container">
    <!-- Stepper -->
    <div class="stepper-wrapper d-flex justify-content-center">
        <div class="stepper-item active">
            <div class="step-counter">1</div>
            <div class="step-name">ملء الاستمارة</div>
        </div>
        <div class="stepper-item">
            <div class="step-counter">2</div>
            <div class="step-name">تحميل الوثائق</div>
        </div>
    </div>

    <!-- Formulaire 1 -->
    <div class="step-content active" id="step1">
        <div class="card">
            <div class="card-body">
                <h3 class="card-title">المعلومات الشخصية</h3>
                <form id="form1">
                    <div class="form-group row mb-3">
                        <label for="nom" class="col-sm-3 col-form-label">الاسم و اللقب</label>
                        <div class="col-sm-9">
                            <input type="text" class="form-control" id="nom" name="nom" required>
                        </div>
                    </div>
                    <div class="form-group row mb-3">
                        <label for="email" class="col-sm-3 col-form-label">البريد الإلكتروني</label>
                        <div class="col-sm-9">
                            <input type="email" class="form-control" id="email" name="email" required>
                        </div>
                    </div>
                    <div class="form-group row mb-3">
                        <label for="tel" class="col-sm-3 col-form-label">رقم الهاتف</label>
                        <div class="col-sm-9">
                            <input type="tel" class="form-control" id="tel" name="tel" required>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Formulaire 2 -->
    <div class="step-content" id="step2">
        <div class="card">
            <div class="card-body">
                <h3 class="card-title">تحميل الوثائق</h3>
                <form id="form2">
                    <div class="form-group row mb-4">
                        <label for="cin_doc" class="col-sm-3 col-form-label">بطاقة التعريف الوطنية</label>
                        <div class="col-sm-9">
                            <input type="file" class="form-control" id="cin_doc" name="cin_doc" accept=".pdf,.jpg,.jpeg,.png" required>
                            <small class="text-muted">يجب أن يكون الملف بصيغة PDF أو صورة</small>
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <label for="diplome" class="col-sm-3 col-form-label">الشهادة العلمية</label>
                        <div class="col-sm-9">
                            <input type="file" class="form-control" id="diplome" name="diplome" accept=".pdf" required>
                            <small class="text-muted">يجب أن يكون الملف بصيغة PDF</small>
                        </div>
                    </div>

                    <div class="form-group row mb-4">
                        <label for="justificatif" class="col-sm-3 col-form-label">وثيقة إثبات المقر</label>
                        <div class="col-sm-9">
                            <input type="file" class="form-control" id="justificatif" name="justificatif" accept=".pdf" required>
                            <small class="text-muted">يجب أن يكون الملف بصيغة PDF</small>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Navigation -->
    <div class="step-navigation">
        <button id="prevBtn" class="btn btn-primary" style="display: none;" onclick="prevStep()">السابق</button>
        <button id="nextBtn" class="btn btn-success" onclick="nextStep()">التالي</button>
    </div>
</div>
@endsection

@section('scripts')
<script>
let currentStep = 1;
const totalSteps = 2;

function updateStepper() {
    // Mise à jour des indicateurs de l'étape
    document.querySelectorAll('.stepper-item').forEach((item, index) => {
        if (index + 1 === currentStep) {
            item.classList.add('active');
        } else if (index + 1 < currentStep) {
            item.classList.add('completed');
            item.classList.remove('active');
        } else {
            item.classList.remove('active', 'completed');
        }
    });

    // Afficher/masquer les formulaires
    document.querySelectorAll('.step-content').forEach((content, index) => {
        if (index + 1 === currentStep) {
            content.classList.add('active');
        } else {
            content.classList.remove('active');
        }
    });

    // Mise à jour des boutons
    document.getElementById('prevBtn').style.display = currentStep === 1 ? 'none' : 'block';
    document.getElementById('nextBtn').textContent = currentStep === totalSteps ? 'إرسال' : 'التالي';
}

function validateCurrentForm() {
    const form = document.getElementById(`form${currentStep}`);
    return form.checkValidity();
}

function nextStep() {
    // Valider le formulaire actuel
    if (!validateCurrentForm()) {
        document.getElementById(`form${currentStep}`).reportValidity();
        return;
    }

    if (currentStep < totalSteps) {
        // Passer à l'étape suivante
        currentStep++;
        updateStepper();
    } else {
        // Soumettre les deux formulaires
        const formData1 = new FormData(document.getElementById('form1'));
        const formData2 = new FormData(document.getElementById('form2'));
        
        // Combiner les données
        const allData = {};
        for (let [key, value] of formData1.entries()) {
            allData[key] = value;
        }
        for (let [key, value] of formData2.entries()) {
            allData[key] = value;
        }
        
        // Afficher les données (à remplacer par votre logique d'envoi)
        console.log('Données à envoyer:', allData);
        alert('Formulaires soumis avec succès !');
    }
}

function prevStep() {
    if (currentStep > 1) {
        currentStep--;
        updateStepper();
    }
}

// Initialisation
document.addEventListener('DOMContentLoaded', () => {
    updateStepper();
});
</script>
@endsection
