@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125" >
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>{{ __('site.investment.breadcrumb.home') }}</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('investissement_choix') }}">
                <span>{{ __('site.investment.breadcrumb.index') }}</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('salle-sport.index2') }}">
                <span>{{ __('site.investment.breadcrumb.salles_list') }}</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('site.investment.detail') }}</li>
    </ol>
</nav>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <form class="card shadow-sm p-4" action="{{ route('salle-sport.show2', $immobilier->id_imm) }}" method="POST" enctype="multipart/form-data" lang="{{ app()->getLocale() }}">
        @csrf
        @method('PUT')

        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">

        <div class="header-print-container">
    <div class="header-side header-left">
        <span class="delegation-print">
            {{ __('site.header.regional_delegation') }}:
            @php
                $deleg = $delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first();
            @endphp
            {{ $deleg ? trans_field($deleg, 'nom') : __('site.not_specified') }}
        </span>
    </div>

    <div class="header-center">
        
        <h3 class="title-form">{{ __('site.investment.form_title_salle') }}</h3>
        <h4 class="title-request">{{ __('site.investment.view_request') }}</h4>
    </div>

    <div class="header-side header-right no-print">
        <button type="button" onclick="window.print()" class="btn btn-success">
            <i class="fa fa-print" style="margin-right:5px;"></i> {{ __('site.print') }}
        </button>
    </div>
</div>



        <div>
            <div class="d-flex align-items-center mb-3">
                <h5 class="mb-0 fw-bold me-2">{{ __('site.current_status_label') }}</h5>
                @if($immobilier->id_statut == 1)
                    <span><strong>{{ __('site.status_accepted') }}</strong></span>
                @elseif($immobilier->id_statut == 3)
                    <span><strong>{{ __('site.status_refused') }}</strong></span>
                @else
                    <span><strong>{{ __('site.status_pending') }}</strong></span>
                @endif
            </div>

            @if($immobilier->id_statut == 3 && !empty($immobilier->commentaire_motif))
                <div class="d-flex align-items-center mb-3">
                    <label class="fw-bold text-danger me-2 mb-0">{{ __('site.start_activity.rejection_reason_label') }}</label>
                    <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $immobilier->commentaire_motif }}</p>
                </div>
            @endif
        </div>



        <div class="form-section">
            <h4 class="mb-3 fw-bold">{{ __('site.investment.form.identity.title') }}</h4>   
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.full_name') }}</label>
                <div class="col-sm-10 pt-2">
                    <span>{{ $immobilier->utilisateur->nom_prenom ?? __('site.not_specified') }}</span>
                </div>
            </div>  
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.identity_type') }}</label>  
                <div class="col-sm-4 pt-2">
                    <span>
                        @php
                            $typeId = $typesIdentite->where('id_type', $immobilier->utilisateur->id_type_identite ?? '')->first();
                        @endphp
                        {{ $typeId ? trans_field($typeId, 'type') : __('site.not_specified') }}
                    </span>
                </div>
                <div class="col-sm-6 pt-2">
                    @if($immobilier->utilisateur->cin)
                        <span>{{ __('site.investment.form.label.cin') }}: {{ $immobilier->utilisateur->cin }}</span>
                    @elseif($immobilier->utilisateur->passport)
                        <span>{{ __('site.investment.form.label.passport') }}: {{ $immobilier->utilisateur->passport }}</span>
                    @elseif($immobilier->utilisateur->num_fiscal)
                        <span>{{ __('site.investment.form.label.fiscal_id') }}: {{ $immobilier->utilisateur->num_fiscal }}</span>
                    @else
                        <span>{{ __('site.not_specified') }}</span>
                    @endif
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.phone') }}</label>
                <div class="col-sm-10 pt-2">
                    <span>{{ $immobilier->utilisateur->tel ?? __('site.not_specified') }}</span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.email') }}</label>
                <div class="col-sm-10 pt-2">
                    <span>{{ $immobilier->utilisateur->email ?? __('site.not_specified') }}</span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.address') }}</label>
                <div class="col-sm-10 pt-2">
                    <span>{{ $immobilier->utilisateur->adresse ?? __('site.not_specified') }}</span>
                </div>
            </div>

            <h4 class="mb-3 fw-bold">{{ __('site.investment.form.property.title') }}</h4> 
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.property_address') }}</label>
                <div class="col-sm-10 pt-2">
                    <span>{{ $immobilier->adresse_imm ?? __('site.not_specified') }}</span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.gouvernorat') }}</label>
                <div class="col-sm-4 pt-2">
                    <span>
                        @php
                            $gouv = $gouvernorats->where('id_gouver', $immobilier->gouvernorat_id ?? '')->first();
                        @endphp
                        {{ $gouv ? trans_field($gouv, 'nom') : __('site.not_specified') }}
                    </span>
                </div>
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.delegation') }}</label>
                <div class="col-sm-4 pt-2">
                    <span>
                        @php
                            $deleg2 = $delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first();
                        @endphp
                        {{ $deleg2 ? trans_field($deleg2, 'nom') : __('site.not_specified') }}
                    </span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.property_type') }}</label>
                <div class="col-sm-4 pt-2">
                    <span>
                        @php
                            $typeImm = $typesImmobilier->where('id_type', $immobilier->type_imm_id ?? '')->first();
                        @endphp
                        {{ $typeImm ? trans_field($typeImm, 'type') : __('site.not_specified') }}
                    </span>
                </div>
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.surface_total') }}</label>
                <div class="col-sm-4 pt-2">
                    <span>{{ $immobilier->superfici_m2 ? $immobilier->superfici_m2.' م²' : __('site.not_specified') }}</span>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.usage_type') }}</label>
                <div class="col-sm-4 pt-2">
                    <span>
                        @php
                            $usage = $usagesImmobilier->where('id_usage_imm', $immobilier->usage_id ?? '')->first();
                        @endphp
                        {{ $usage ? trans_field($usage, 'usage') : __('site.not_specified') }}
                    </span>
                </div>
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.document_property') }}</label>
                <div class="col-sm-4 pt-2">
                    @if($immobilier->document_propriete)
                        <a href="{{ asset('storage/'.$immobilier->document_propriete) }}" target="_blank" class="btn btn-link p-0">{{ __('site.view_file') }}</a>
                    @else
                        <span>{{ __('site.not_specified') }}</span>
                    @endif
                </div>
            </div>

           <h4 class="mb-3 fw-bold">{{ __('site.investment.form.components.title') }}</h4>

<table class="table table-bordered text-center align-middle">
    <thead class="table-light">
        <tr>
            <th>{{ __('site.investment.form.components.component_label') ?? __('site.component') }}</th>
            <th>{{ __('site.yes_no') ?? __('site.yes_no_default') }}</th>
            <th>{{ __('site.investment.form.label.count') }}</th>
            <th>{{ __('site.investment.form.label.surface') }}</th>
        </tr>
    </thead>
    <tbody>
        @php
            $components = [
                'salle_exercice'   => __('site.investment.form.components.exercise_hall'),
                'piscine'          => __('site.investment.form.components.pool'),
                'vestiaire'        => __('site.investment.form.components.changing_rooms'),
                'unitaires_sanitaire' => __('site.investment.form.components.sanitary_units'),
                'stockage_conservation'  => __('site.investment.form.components.storage_space'),
                'espace_exterieur' => __('site.investment.form.components.outdoor_space'),
                'garage'           => __('site.investment.form.components.garage')
            ];
        @endphp

        @foreach($components as $comp => $label)
            <tr>
                {{-- component --}}
                <td>{{ $label }}</td>

                {{-- yes / no --}}
                <td>
                    @if($immobilier->$comp == 1)
                        {{ __('site.yes') }}
                    @elseif($immobilier->$comp == 0)
                        {{ __('site.no') }}
                    @else
                        {{ __('site.not_specified') }}
                    @endif
                </td>

                {{-- count --}}
<td>
    @if($immobilier->$comp == 1)
        @if(in_array($comp, ['salle_exercice','piscine','vestiaire']))
            {{ $immobilier->{'nbr_'.$comp} ?? __('site.not_specified') }}
        @else
            {{ __('site.not_specified') }}
        @endif
    @else
        {{ __('site.not_specified') }}
    @endif
</td>

{{-- surface --}}
<td>
    @if($immobilier->$comp == 1)
        {{ $immobilier->{'superface_'.$comp} ? $immobilier->{'superface_'.$comp}.' م²' : __('site.not_specified') }}
    @else
        {{ __('site.not_specified') }}
    @endif
</td>

            </tr>
        @endforeach
    </tbody>
</table>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label fw-bold">{{ __('site.investment.form.label.other_surfaces') }}</label>
                <div class="col-sm-10 pt-2">
                   <span>{{ $immobilier->autres_surfaces ? $immobilier->autres_surfaces.' م²' : __('site.not_specified') }}</span>

                </div>
            </div>
        </div>
        <div class="form-group no-print" style="display: flex; justify-content: center; margin-top: 20px;">
    <div class="d-flex" style="gap: 20px; align-items: center;">
       
       <button type="button" onclick="window.print()" 
    class="btn btn-success" 
    style="width:120px; height:40px; display:flex; align-items:center; justify-content:center; gap:6px;">
    <i class="fa fa-print"></i> {{ __('site.print') }}
</button>
    </div>
</div>

    </form>
</div>
</div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        @foreach(array_keys($components) as $comp)
            if (typeof toggleSection === 'function') {
                toggleSection('{{ $comp }}','id_{{ $comp }}');
            }
        @endforeach
    });
</script>


@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection
