@extends('layouts.app')

@section('content')



 <div class="it-about-3-area p-relative pt-30 pb-125">
   <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
                <div class="container">
    <nav class="breadcrumb-nav" aria-label="breadcrumb">
      <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
          <a href="{{ route('dashboard') }}">
            <i class="bi bi-house-fill"></i>
            <span>{{ __('site.breadcrumb_home') }}</span>
          </a>
        </li>

        <li class="breadcrumb-item">
          <a href="{{ route('investissement_choix') }}">
            <span>{{ __('site.breadcrumb_investment') }}</span>
          </a>
        </li>

        <li class="breadcrumb-item active" aria-current="page">{{ __('site.breadcrumb_salles_list') }}</li>
      </ol>
    </nav>
             

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

                    <div class="row">
                        <div class="col-xl-12">
                            <div class="it-section-title-box text-center mb-30" style="padding-top:20px;">
                                <span class="it-section-subtitle"> {{ __('site.section_subtitle_requests') }}</span>
                                <h4 class="it-section-title it-split-in-right mb-0">  {{ __('site.section_title_all_requests') }}</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="card shadow-sm p-4">

                                <div class="d-flex justify-content-end mb-4">
                                       <a class="btn btn-success" href="{{ route('salle-sport.create3') }}">
                                        <i class="la la-plus me-1"></i>  {{ __('site.btn_add_request') }}
                                    </a>
                                </div>

                                @if(session('success'))
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        {{ session('success') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @endif

 <div class="my-table table-responsive">
            <table class="table align-items-center table-flush mb-0 table-hover" style="{{ app()->getLocale() === 'ar' ? 'direction: rtl; text-align: right;' : '' }}">
              <thead class="thead-light">
                <tr>
                  <th width="5%">{{ __('site.table_id') }}</th>
                  <th width="10%">{{ __('site.table_deposit_date') }}</th>
                  <th width="15%">{{ __('site.table_applicant') }}</th>
                  <th width="10%">{{ __('site.table_status') }}</th>
                  <th width="30%">{{ __('site.table_actions') }}</th>
                  <th width="15%">{{ __('site.table_start_activity') }}</th>
                  <th width="15%">{{ __('site.table_tax_exemption') }}</th>
                </tr>
              </thead>

              <tbody>
                @forelse($salles as $salle)
                  <tr>
                    <td>{{ $salle->id_imm }}</td>
                    <td>{{ optional($salle->created_at)->format('Y-m-d H:i') }}</td>
                    <td>{{ $salle->utilisateur->nom_prenom ?? __('site.not_specified') }}</td>

                    <td>
                      @php
                        // translate status using file keys (safe approach)
                        $statusLabel = match($salle->id_statut) {
                          1 => __('site.status_accepted'),
                          2 => __('site.status_pending'),
                          3 => __('site.status_refused'),
                          default => __('site.status_unknown'),
                        };
                        $badgeClass = match($salle->id_statut) {
                          
                          1 => 'status-badge--success',
                          2 => 'status-badge--pending',
                          3 => 'status-badge--danger',
                          default => 'bg-secondary',
                        };
                      @endphp

                      <span class="status-badge {{ $badgeClass }}">{{ $statusLabel }}</span>
                    </td>

                    <td class="text-center">
                      <div class="actions-cell d-inline-flex gap-2 flex-wrap justify-content-center" role="group" aria-label="actions">
                        <a href="{{ route('salle-sport.show2', $salle->id_imm) }}"
                           class="btn-icon btn-icon--primary"
                           title="{{ __('site.btn_view') }}" aria-label="{{ __('site.btn_view') }}">
                          <i class="la la-eye"></i>
                        </a>

                        @if($salle->id_statut == 2)
                          <button type="button"
                                  class="btn-icon btn-icon--warning"
                                  onclick="window.location='{{ route('salle-sport.edit2', $salle->id_imm) }}'"
                                  title="{{ __('site.btn_edit') }}" aria-label="{{ __('site.btn_edit') }}">
                            <i class="la la-edit"></i>
                          </button>

                          <form action="{{ route('salle-sport.destroy2', $salle->id_imm) }}" method="POST" class="d-inline">
                            @csrf
                            @method('DELETE')
                            <button type="button"
                                    onclick="confirmDelete(this.closest('form'))"
                                    class="btn-icon btn-icon--danger"
                                    title="{{ __('site.btn_delete') }}" aria-label="{{ __('site.btn_delete') }}">
                              <i class="la la-trash"></i>
                            </button>
                          </form>
                        @endif
                      </div>
                    </td>

                    <td class="text-center">
                      @if($salle->id_statut == 1)
                        @php $etat = optional($salle->debutActivite)->etat_formulaire; @endphp
                        <div class="actions-activite d-inline-flex gap-2 justify-content-center" >
                          @if(is_null($salle->debutActivite) || $etat === 'non_remplir')
                            <button type="button" class="btn-icon btn-icon--success"
                                    onclick="openDebutActiviteForm({{ $salle->id_imm }})"
                                    title="{{ __('site.start_activity_notify') }}" aria-label="{{ __('site.start_activity_notify') }}">
                              {{ __('site.start_activity_notify') }}
                            </button>

                          @elseif($etat === 'remplir')
                            <button type="button" class="btn-icon btn-icon--warning"
                                    onclick="openEditActiviteForm({{ optional($salle->debutActivite)->id_debut }})"
                                    title="{{ __('site.start_activity_edit') }}" aria-label="{{ __('site.start_activity_edit') }}">
                              {{ __('site.start_activity_edit') }}
                            </button>

                          @elseif($etat === 'reponse')
                            <button type="button" class="btn-icon btn-icon--info"
                                    onclick="openConsulterActiviteForm({{ optional($salle->debutActivite)->id_debut }})"
                                    title="{{ __('site.start_activity_view') }}" aria-label="{{ __('site.start_activity_view') }}">
                              {{ __('site.start_activity_view') }}
                            </button>
                          @endif
                        </div>
                      @endif
                    </td>

                    <td class="text-center">
                      @php
                        $doc = $salle->documentsFormulaires->first();
                        $etat1 = $doc->etat_formulaire ?? null;
                      @endphp

                      @if(optional($salle->debutActivite)->etat_formulaire === 'reponse' && optional($salle->debutActivite)->id_statut == 1)
                        <div class="actions-activite d-inline-flex gap-2 justify-content-center">
                          @if(is_null($doc) || $etat1 === 'non_remplir')
                            <button type="button" class="btn-icon btn-icon--success" style="padding:10px 50px;"
                                    onclick="openExonerationForm({{ $salle->id_imm }})"
                                    title="{{ __('site.exoneration_add') }}" aria-label="{{ __('site.exoneration_add') }}">
                              {{ __('site.exoneration_add') }}
                            </button>

                          @elseif($doc && $etat1 === 'remplir')
                            <button type="button" class="btn-icon btn-icon--warning" style="padding:10px 50px;"
                                    onclick="editExonerationForm({{ $doc->id_doc }})"
                                    title="{{ __('site.exoneration_edit') }}" aria-label="{{ __('site.exoneration_edit') }}">
                              {{ __('site.exoneration_edit') }}
                            </button>

                          @elseif($doc && $etat1 === 'reponse')
                            <button type="button" class="btn-icon btn-icon--info" style="padding:10px 50px;"
                                    onclick="viewExonerationForm({{ $doc->id_doc }})"
                                    title="{{ __('site.exoneration_view') }}" aria-label="{{ __('site.exoneration_view') }}">
                              {{ __('site.exoneration_view') }}
                            </button>
                          @endif
                        </div>
                      @endif
                    </td>
                  </tr>
                @empty
                  <tr>
                    <td colspan="7" class="text-center text-muted">{{ __('site.no_salles_requests') }}</td>
                  </tr>
                @endforelse
              </tbody>
            </table>
          </div>

                            <div class="mt-3">
                                {{ $salles->links('pagination::bootstrap-5') }}
                            </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
       
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

{{-- <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script> --}}
<script>
    function openDebutActiviteForm(idImm) {
        window.location.href = "{{ route('debut_activite.create2') }}" + "?immobilier_id=" + idImm;
    }

    function openEditActiviteForm(idDebutActivite) {
        window.location.href = "{{ route('debut_activite.edit2', ':id') }}".replace(':id', idDebutActivite);
    }

    function openConsulterActiviteForm(idDebutActivite) {
        window.location.href = "{{ route('debut_activite.show2', ':id') }}".replace(':id', idDebutActivite);
    }

    function openExonerationForm(idImm) {
        window.location.href = `/salle-sport2/${idImm}/exoneration/create`;
    }

    function editExonerationForm(docId) {
        window.location.href = `/salle-sport2/exoneration/${docId}/edit`;
    }


    function viewExonerationForm(docId) {
        window.location.href = `/salle-sport2/exoneration/${docId}/show`;
    }
</script>
<script src="{{ asset('assets/js/index.js') }}"></script>
{{-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script> --}}
@endsection
