@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('investissement_choix') }}">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('salle-sport.index2') }}">
                <span>قائمة القاعات الرياضية</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">تعديل القاعة الرياضية</li>
    </ol>
</nav>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <form class="card shadow-sm p-4" action="{{ route('salle-sport.update2', $immobilier->id_imm) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')

        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">

        <h3>{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>

       

        <div class="form-section">
            <h4>هوية الباعث</h4>  
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">الاسم و اللقب أو الاسم التجاري</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom" 
                        placeholder="الاسم و اللقب أو الاسم التجاري" maxlength="50" style="text-transform: none; direction: rtl;"
                        value="{{ old('nom_prenom', $immobilier->utilisateur->nom_prenom ?? '') }}">
                </div>
            </div>  

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput2()">
                        <option value="" disabled>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}" 
                                {{ old('id_type_identite', $immobilier->utilisateur->id_type_identite ?? '') == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-sm-6" id="identite-fields">
                    <input type="text" class="form-control identite-field" id="cin_input" name="cin" 
                        placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8" style="text-transform: none; direction: rtl;"
                        style="display:none;"
                        value="{{ old('cin', $immobilier->utilisateur->cin ?? '') }}">
                    <input type="text" class="form-control identite-field" id="passport_input" name="passport"  style="text-transform: none; direction: rtl;"
                        placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12"
                        style="display:none;"
                        value="{{ old('passport', $immobilier->utilisateur->passport ?? '') }}">
                    <input type="text" class="form-control identite-field" id="num_fiscal_input" name="num_fiscal" 
                        placeholder="أدخل رقم المعرف الجبائي"  style="text-transform: none; direction: rtl;" pattern="^\d{12}$" maxlength="12"
                        style="display:none;"
                        value="{{ old('num_fiscal', $immobilier->utilisateur->num_fiscal ?? '') }}">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">رقم الهاتف الشخصي</label>
                <div class="col-sm-10">
                    <input required type="text" style="text-transform: none; direction: rtl;" class="form-control" name="tel" placeholder="رقم الهاتف الشخصي" maxlength="12"
                        value="{{ old('tel', $immobilier->utilisateur->tel ?? '') }}">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
                <div class="col-sm-10">
                    <input required type="email" class="form-control"  style="text-transform: none; direction: rtl;" name="email" placeholder=" "
                        value="{{ old('email', $immobilier->utilisateur->email ?? '') }}">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                <div class="col-sm-10">
                    <input required type="text" style="text-transform: none; direction: rtl;" class="form-control" name="adresse" placeholder=" " maxlength="100"
                        value="{{ old('adresse', $immobilier->utilisateur->adresse ?? '') }}">
                </div>
            </div>

            <h4>هوية العقار</h4> 
            <div class="form-group row">
                <label for="adresse_imm" class="col-sm-2 col-form-label">عنوان العقار</label>
                <div class="col-sm-10">
                    <input maxlength="255" style="text-transform: none; direction: rtl;" required type="text" class="form-control" id="adresse_imm" name="adresse_imm" placeholder=" "
                        value="{{ old('adresse_imm', $immobilier->adresse_imm ?? '') }}"
                        oninvalid="this.setCustomValidity('يجب ألا يتجاوز عنوان العقار 255 حرفاً')" 
                        oninput="this.setCustomValidity('')">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">الولاية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled {{ old('gouvernorat_id', $immobilier->gouvernorat_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}"
                                {{ old('gouvernorat_id', $immobilier->gouvernorat_id ?? '') == $gouv->id_gouver ? 'selected' : '' }}>
                                {{ $gouv->nom_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <label class="col-sm-2 col-form-label">البلدية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id" {{ $immobilier->delegation_id ? '' : 'disabled' }}>
                        <option value="" disabled {{ old('delegation_id', $immobilier->delegation_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @if($immobilier->delegation_id)
                            @foreach($delegations as $del)
                                <option value="{{ $del->id_delegation }}"
                                    {{ old('delegation_id', $immobilier->delegation_id ?? '') == $del->id_delegation ? 'selected' : '' }}>
                                    {{ $del->nom_ar }}
                                </option>
                            @endforeach
                        @endif
                    </select>
                </div>
            </div>

            <div class="form-group row">
                <label for="type_imm_id" class="col-sm-2 col-form-label">صيغة العقار</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="type_imm_id" name="type_imm_id">
                        <option value="" disabled {{ old('type_imm_id', $immobilier->type_imm_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @foreach($typesImmobilier as $type)
                            <option value="{{ $type->id_type }}"
                                {{ old('type_imm_id', $immobilier->type_imm_id ?? '') == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <label for="superfici_m2" class="col-sm-2 col-form-label">المساحة الجملية للعقار بالم2</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" id="superfici_m2" name="superfici_m2" placeholder=" "
                        value="{{ old('superfici_m2', $immobilier->superfici_m2 ?? '') }}"
                        oninvalid="this.setCustomValidity('المساحة يجب ان لا تتجاوز 100م2')" 
                        oninput="this.setCustomValidity('')" min="100">
                    <span>المساحة يجب ان تكون 100م2 على الاقل.</span>
                </div>                
            </div>

            <div class="form-group row">
                <label for="usage_id" class="col-sm-2 col-form-label">صيغة استغلال العقار</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="usage_id" name="usage_id">
                        <option value="" disabled {{ old('usage_id', $immobilier->usage_id ?? '') ? '' : 'selected' }}>اختر...</option>
                        @foreach($usagesImmobilier as $usage)
                            <option value="{{ $usage->id_usage_imm }}"
                                {{ old('usage_id', $immobilier->usage_id ?? '') == $usage->id_usage_imm ? 'selected' : '' }}>
                                {{ $usage->usage_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <label for="document_propriete" class="col-sm-2 col-form-label">نسخة العقد/الملكية</label>
                <div class="col-sm-4">
                    <input type="file" class="form-control" id="document_propriete" name="document_propriete">
                    @if($immobilier->document_propriete)
                        <small>الملف الحالي: <a href="{{ asset('storage/'.$immobilier->document_propriete) }}" target="_blank">عرض</a></small>
                    @endif
                </div>
            </div>
            <h4>مكونات العقار</h4>

            @php
                $components = [
                    'salle_exercice','piscine','vestiaire','unitaires_sanitaire',
                    'stockage_conservation','espace_exterieur','garage'
                ];
            @endphp
            @foreach($components as $comp)
                <div class="form-group row">
                    <label for="{{ $comp }}" class="col-sm-2 col-form-label">
                        @switch($comp)
                            @case('salle_exercice') قاعة التمارين @break
                            @case('piscine') حوض مائي @break
                            @case('vestiaire') حجرات ملابس @break
                            @case('unitaires_sanitaire') وحدات صحية @break
                            @case('stockage_conser') فضاء للخزن و حفض الاثاث و المعدات @break
                            @case('espace_exterieur') فضاء خارجي @break
                            @case('garage') ماوى سيارات @break
                        @endswitch
                    </label>
                    <div class="col-sm-4">
                        <select required class="form-control" id="{{ $comp }}" name="{{ $comp }}" onchange="toggleSection('{{ $comp }}','id_{{ $comp }}')">
                            <option value="" disabled {{ old($comp, $immobilier->$comp ?? '') === null ? 'selected' : '' }}>اختر...</option>
                            <option value="1" {{ old($comp, $immobilier->$comp ?? '') == 1 ? 'selected' : '' }}>نعم</option>
                            <option value="0" {{ old($comp, $immobilier->$comp ?? '') == 0 ? 'selected' : '' }}>لا</option>
                        </select>
                    </div>

                    <div class="col-sm-6" id="id_{{ $comp }}" style="display: {{ old($comp, $immobilier->$comp ?? '') == 1 ? 'block' : 'none' }};">
                        @if(in_array($comp, ['salle_exercice','piscine','vestiaire']))
                            <div class="mb-2">
                                <input type="number" class="form-control" id="nbr_{{ $comp }}" name="nbr_{{ $comp }}" placeholder="عدد"
                                    value="{{ old('nbr_'.$comp, $immobilier->{'nbr_'.$comp} ?? '') }}">
                            </div>
                            <div>
                                <input type="number" class="form-control" id="superface_{{ $comp }}" name="superface_{{ $comp }}" placeholder="مساحة"
                                    value="{{ old('superface_'.$comp, $immobilier->{'superface_'.$comp} ?? '') }}">
                            </div>
                        @else
                            <input type="number" class="form-control" id="superface_{{ $comp }}" name="superface_{{ $comp }}" placeholder="مساحة"
                                value="{{ old('superface_'.$comp, $immobilier->{'superface_'.$comp} ?? '') }}">
                        @endif
                    </div>
                </div>
            @endforeach
            <div class="form-group row">
                <label for="autres_surfaces" class="col-sm-2 col-form-label">مساحات اخرى</label>
                <div class="col-sm-10">
                    <input required type="number" class="form-control" id="autres_surfaces" name="autres_surfaces" 
                        value="{{ old('autres_surfaces', $immobilier->autres_surfaces ?? '') }}">
                </div>
            </div>
            
        </div>
        <div class="form-group row justify-content-center">
            <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-orange font-weight-medium" >
                    تحيين
                </button>
               
            </div>
        </div>


    </form>
</div>
</div>


@section('scripts')
<script>
    // Fonction pour gérer l'affichage des champs d'identité
    function showTypeIdentiteInput2() {
        const idType = document.getElementById('id_type_identite').value;
        const cinInput = document.getElementById('cin_input');
        const passportInput = document.getElementById('passport_input');
        const numFiscalInput = document.getElementById('num_fiscal_input');

        // Cacher tous les champs
        [cinInput, passportInput, numFiscalInput].forEach(input => {
            input.style.display = 'none';
            input.required = false;
        });

        // Afficher le champ approprié
        switch(idType) {
            case '1':
                cinInput.style.display = 'block';
                cinInput.required = true;
                break;
            case '2':
                passportInput.style.display = 'block';
                passportInput.required = true;
                break;
            case '3':
                numFiscalInput.style.display = 'block';
                numFiscalInput.required = true;
                break;
        }
    }

    // Fonction pour basculer l'affichage des sections
    function toggleSection(selectId, sectionId) {
        const select = document.getElementById(selectId);
        const section = document.getElementById(sectionId);
        if (!select || !section) return;

        const updateVisibility = () => {
            section.style.display = select.value === '1' ? 'block' : 'none';
        };

        select.addEventListener('change', updateVisibility);
        updateVisibility(); // État initial
    }

    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.salle-sport-edit select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });

        // Initialiser showTypeIdentiteInput2
        showTypeIdentiteInput2();

        // Initialiser les sections
        const sections = [
            'salle_exercice',
            'piscine',
            'vestiaire',
            'unitaires_sanitaire',
            'stockage_conservation',
            'espace_exterieur',
            'garage'
        ];

        sections.forEach(id => {
            toggleSection(id, 'id_' + id);
        });

        // Gérer la dépendance gouvernorat-delegation
        const gouvernoratSelect = document.getElementById('gouvernorat_id');
        const delegationSelect = document.getElementById('delegation_id');

        if (gouvernoratSelect && delegationSelect) {
            gouvernoratSelect.addEventListener('change', function() {
                const gouvernoratId = this.value;
                delegationSelect.innerHTML = '<option value="" disabled selected>اختر...</option>';

                if (gouvernoratId) {
                    fetch(`/delegations/${gouvernoratId}`)
                        .then(response => response.json())
                        .then(delegations => {
                            delegations.forEach(d => {
                                const option = new Option(d.nom_ar, d.id_delegation);
                                delegationSelect.add(option);
                            });
                            delegationSelect.disabled = false;
                        })
                        .catch(error => {
                            console.error('Erreur:', error);
                        });
                } else {
                    delegationSelect.disabled = true;
                }
            });
        }
    });
</script>

<script>
document.addEventListener("DOMContentLoaded", function () {

    const gouvSelect = document.getElementById('gouvernorat_id');
    const delSelect  = document.getElementById('delegation_id');

    gouvSelect.addEventListener('change', function () {

        let gouvId = this.value;

        delSelect.innerHTML = '';
        delSelect.disabled = true;

        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';

        let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";
        url = url.replace("ID_PLACEHOLDER", gouvId);

        fetch(url)
            .then(response => response.json())
            .then(data => {

                
                delSelect.innerHTML = '<option disabled selected>اختر...</option>';

                
                data.forEach(d => {
                    let option = document.createElement('option');
                    option.value = d.id_delegation;
                    option.text  = d.nom_ar;
                    delSelect.appendChild(option);
                });

                delSelect.disabled = false;
            });
    });

});
</script>
@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection
