@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')


@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
   <li class="breadcrumb-item">
    <a href="{{ route('dashboard') }}">
        <i class="bi bi-house-fill"></i>
        <span>{{ __('site.investment.breadcrumb.home') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
    <a href="{{ route('investissement_choix') }}">
        <span>{{ __('site.investment.breadcrumb.index') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
    <a href="{{ route('salle-sport.index2') }}">
        <span>{{ __('site.investment.breadcrumb.salles_list') }}</span>
    </a>
</li>
<li class="breadcrumb-item active" aria-current="page">{{ __('site.investment.breadcrumb.add_salle') }}</li>

    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4" action="{{ route('salle-sport.store2') }}" method="POST" enctype="multipart/form-data" lang="ar"> 

    @csrf
    <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
    
    <h3>{{ trans_field($formulaire, 'type') }}  </h3>
    <div class="form-section">
    
               <h4>{{ __('site.investment.form.identity.title') }}</h4>

            <div class="form-group row">
                 <label class="col-sm-2 col-form-label">{{ __('site.investment.form.label.full_name') }}</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" style="text-transform: none; direction: rtl;" value="{{ $user->nom_prenom }}" readonly>
                </div>
            </div>
            <div class="form-group row">
                 <label class="col-sm-2 col-form-label">{{ __('site.investment.form.label.email') }}</label>
                <div class="col-sm-10">
                    <input type="email" class="form-control" style="text-transform: none; direction: rtl;" value="{{ $user->email }}" readonly>
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label" for="id_type_identite"> {{ __('site.investment.form.label.identity_type') }}</label>
                <div class="col-sm-4">
                    <input type="text" id="id_type_identite" style="text-transform: none; direction: rtl;" class="form-control" 
                        value="{{ $user->typeIdentite->{ 'type_' . app()->getLocale() } ?? ($user->typeIdentite->type_ar ?? '') }}" readonly>
                    @error('id_type_identite') 
                        <span class="text-danger">{{ $message }}</span> 
                    @enderror
                </div>
                @if(old('id_type_identite', $user->id_type_identite ?? '') == 1)
                    <label class="col-sm-2 col-form-label" for="cin_input">{{ __('site.investment.form.label.cin') }}  </label>
                    <div class="col-sm-4">
                        <input type="text" id="cin_input" name="cin" class="form-control" 
                            value="{{ old('cin', $user->cin ?? '') }}" placeholder="{{ __('site.investment.form.placeholder.cin') }}" style="text-transform: none; direction: rtl;" readonly>
                        @error('cin') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                @elseif(old('id_type_identite', $user->id_type_identite ?? '') == 2)
                    <label class="col-sm-2 col-form-label" for="passport_input">{{ __('site.investment.form.label.passport') }}  </label>
                    <div class="col-sm-4">
                        <input type="text" id="passport_input" name="passport" class="form-control" 
                            value="{{ old('passport', $user->passport ?? '') }}" placeholder="{{ __('site.investment.form.placeholder.passport') }}" style="text-transform: none; direction: rtl;" readonly>
                        @error('passport') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                @elseif(old('id_type_identite', $user->id_type_identite ?? '') == 3)
                    <label class="col-sm-2 col-form-label" for="num_fiscal_input">  {{ __('site.investment.form.label.fiscal_id') }}</label>
                    <div class="col-sm-4">
                        <input type="text" id="num_fiscal_input" name="num_fiscal" class="form-control" 
                            value="{{ old('num_fiscal', $user->num_fiscal ?? '') }}" placeholder="{{ __('site.investment.form.placeholder.fiscal') }}" style="text-transform: none; direction: rtl;" readonly>
                        @error('num_fiscal') <span class="text-danger">{{ $message }}</span> @enderror
                    </div>
                @endif
            </div>
            <div class="form-group row" id="cin_details_wrapper" 
                style="{{ old('id_type_identite', $user->id_type_identite ?? '') == 1 ? '' : 'display:none;' }}">
                <label for="date_delivrance_cin" class="col-sm-2 col-form-label"> {{ __('site.investment.form.label.cin_issue_date') }}</label>
                <div class="col-sm-4">
                    <input type="date" id="date_delivrance_cin" name="date_delivrance_cin" 
                        value="{{ old('date_delivrance_cin', isset($user->date_delivrance_cin) && $user->date_delivrance_cin ? \Carbon\Carbon::parse($user->date_delivrance_cin)->format('Y-m-d') : '') }}" 
                        class="form-control" style="text-transform: none; direction: rtl;" readonly>
                    @error('date_delivrance_cin') 
                        <span class="text-danger">{{ $message }}</span> 
                    @enderror
                </div>


                <label for="lieu_delivrance_cin" class="col-sm-2 col-form-label">  {{ __('site.investment.form.label.cin_issue_place') }}</label>
                <div class="col-sm-4">
                    <input type="text" id="lieu_delivrance_cin" name="lieu_delivrance_cin" 
                        value="{{ old('lieu_delivrance_cin', $user->lieu_delivrance_cin ?? '') }}" 
                        placeholder="{{ __('site.investment.form.placeholder.cin_issue_place') }}" class="form-control" style="text-transform: none; direction: rtl;" readonly >
                    @error('lieu_delivrance_cin') 
                        <span class="text-danger">{{ $message }}</span> 
                    @enderror
                </div>
            </div>
            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label" for="tel">  {{ __('site.investment.form.label.phone') }}</label>
                <div class="col-sm-4">
                    <input type="text" id="tel" class="form-control" value="{{ $user->tel }}" readonly>
                </div>
                <label class="col-sm-2 col-form-label" style="text-transform: none; direction: rtl;" for="adresse"> {{ __('site.investment.form.label.address') }}</label>
                <div class="col-sm-4">
                    <input type="text" id="adresse" class="form-control" style="text-transform: none; direction: rtl;" value="{{ $user->adresse }}" readonly>
                </div>
            </div>

            <h4>  {{ __('site.investment.form.property.title') }} </h4> 
            <div class="form-group row">
                <label for="nom_victime" class="col-sm-2 col-form-label">  {{ __('site.investment.form.label.property_address') }} </label>
                <div class="col-sm-10">
                    <input required type="text" style="text-transform: none; direction: rtl;" class="form-control" id="adresse_imm" name="adresse_imm" placeholder=" " 
                        oninvalid="this.setCustomValidity('{{ __('site.investment.form.validation.property_address_max') }}')" 
                        oninput="this.setCustomValidity('')">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-2 col-form-label"> {{ __('site.investment.form.label.gouvernorat') }} </label>
                <div class="col-sm-4 postbox__select">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled selected>{{ __('site.investment.form.placeholder.choose') }}</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}">{{ trans_field($gouv, 'nom') }}</option>
                        @endforeach
                    </select>
                </div>
                <label class="col-sm-2 col-form-label">  {{ __('site.investment.form.label.delegation') }}  </label>
                <div class="col-sm-4 postbox__select">
                    <select required class="form-control" id="delegation_id" name="delegation_id" disabled>
                        <option value="" disabled selected>{{ __('site.investment.form.placeholder.choose') }}</option>
                    </select>
                </div>
            </div>
            
            <div class="form-group row">
                <label for="type_imm_id" class="col-sm-2 col-form-label">{{ __('site.investment.form.label.property_type') }} </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="type_imm_id" name="type_imm_id">
                        <option value="" disabled selected>{{ __('site.investment.form.placeholder.choose') }}</option>
                        @foreach($typesImmobilier as $type)
                            <option value="{{ $type->id_type }}">{{ trans_field($type, 'type') }}</option>
                        @endforeach
                    </select>
                </div>
                <label for="superfici_m2" class="col-sm-2 col-form-label">  {{ __('site.investment.form.label.surface_total') }}  </label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" id="superfici_m2" name="superfici_m2" placeholder=" "
                          oninvalid="this.setCustomValidity('{{ __('site.investment.form.validation.surface_min') }}')" 
                        oninput="this.setCustomValidity('')"  min="100">
                    <span>{{ __('site.investment.form.validation.surface_hint') }}</span>
                </div>                
            </div>
            <div class="form-group row">
                <label for="usage_id" class="col-sm-2 col-form-label">  {{ __('site.investment.form.label.usage_type') }}</label>
                <div class="col-sm-4">
                     <select required class="form-control" id="usage_id" name="usage_id">
                        <option value="" disabled selected>{{ __('site.investment.form.placeholder.choose') }}</option>
                        @foreach($usagesImmobilier as $usage)
                            <option value="{{ $usage->id_usage_imm }}">{{ trans_field($usage, 'usage') }}</option>
                        @endforeach
                    </select>
                </div>
                <label for="document_propriete" class="col-sm-2 col-form-label"> {{ __('site.investment.form.label.document_property') }}</label>
                <div class="col-sm-4">
                    <input required type="file" class="form-control" id="document_propriete" name="document_propriete">
                </div>
            </div>
            <h4>{{ __('site.investment.form.components.title') }}</h4>
            <div class="form-group row">
                <label for="salle_exercice" class="col-sm-2 col-form-label">{{ __('site.investment.form.components.exercise_hall') }}</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="salle_exercice" name="salle_exercice" onchange="toggleSection('salle_exercice', 'id_salle_exercice')">
                        <option value="" disabled {{ old('salle_exercice', '') === '' ? 'selected' : '' }}>{{ __('site.investment.form.placeholder.choose') }}</option>
                        <option value="1" {{ old('salle_exercice') === '1' ? 'selected' : '' }}>{{ __('site.yes') }}</option>
                        <option value="0" {{ old('salle_exercice') === '0' ? 'selected' : '' }}>{{ __('site.no') }}</option>
                    </select>
                </div>
                <div class="col-sm-6" id="id_salle_exercice" style="display: none;">
                    <div class="mb-2">
                        <input type="number"
                            class="form-control"
                            id="nbr_salle_exercice"
                            name="nbr_salle_exercice"
                            placeholder="{{ __('site.investment.form.placeholder.count') }}"
                            value="{{ old('nbr_salle_exercice') }}">
                    </div>
                    <div>
                        <input type="number"
                            class="form-control"
                            id="superface_salle"
                            name="superface_salle_exercice"
                            placeholder="{{ __('site.investment.form.placeholder.surface') }}"
                            value="{{ old('superface_salle_exercice') }}">
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label for="piscine" class="col-sm-2 col-form-label">{{ __('site.investment.form.components.pool') }}</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="piscine" name="piscine" onchange="toggleSection('piscine', 'id_piscine')">
                        <option value="" disabled {{ old('piscine', '') === '' ? 'selected' : '' }}>{{ __('site.investment.form.placeholder.choose') }}</option>
                        <option value="1" {{ old('piscine') === '1' ? 'selected' : '' }}>{{ __('site.yes') }}</option>
                        <option value="0" {{ old('piscine') === '0' ? 'selected' : '' }}>{{ __('site.no') }}</option>
                    </select>
                </div>
                <div class="col-sm-6" id="id_piscine" style="display: none;">
                    <div class="mb-2">
                        <input type="number"
                            class="form-control"
                            id="nbr_piscine"
                            name="nbr_piscine"
                            placeholder="{{ __('site.investment.form.placeholder.count') }}"
                            value="{{ old('nbr_piscine') }}">
                    </div>
                    <div>
                        <input type="number"
                            class="form-control"
                            id="superface_piscine"
                            name="superface_piscine"
                            placeholder="{{ __('site.investment.form.placeholder.surface') }}"
                            value="{{ old('superface_piscine') }}">
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label for="vestiaire" class="col-sm-2 col-form-label">{{ __('site.investment.form.components.changing_rooms') }}</label>

                <div class="col-sm-4">
                    <select required class="form-control" id="vestiaire" name="vestiaire" onchange="toggleSection('vestiaire', 'id_vestiaire')">
                        <option value="" disabled {{ old('vestiaire', '') === '' ? 'selected' : '' }}>{{ __('site.investment.form.placeholder.choose') }}</option>
                        <option value="1" {{ old('vestiaire') === '1' ? 'selected' : '' }}>{{ __('site.yes') }}</option>
                        <option value="0" {{ old('vestiaire') === '0' ? 'selected' : '' }}>{{ __('site.no') }}</option>
                    </select>
                </div>
                <div class="col-sm-6" id="id_vestiaire" style="display: none;">
                    <div class="mb-2">
                        <input type="number"
                            class="form-control"
                            id="nbr_vestiaire"
                            name="nbr_vestiaire"
                            placeholder="{{ __('site.investment.form.placeholder.count') }}"
                            value="{{ old('nbr_vestiaire') }}">
                    </div>
                    <div>
                        <input type="number"
                            class="form-control"
                            id="superface_vestiaire"
                            name="superface_vestiaire"
                            placeholder="{{ __('site.investment.form.placeholder.surface') }}"
                            value="{{ old('superface_vestiaire') }}">
                    </div>
                </div>
            </div>
            <div class="form-group row">
                <label for="unitaires_sanitaire" class="col-sm-2 col-form-label">{{ __('site.investment.form.components.sanitary_units') }}</label>

                <div class="col-sm-4">
                    <select required class="form-control" id="unitaires_sanitaire" name="unitaires_sanitaire" onchange="toggleSection('unitaires_sanitaire', 'id_unitaires_sanitaire')">
                        <option value="" disabled {{ old('unitaires_sanitaire', '') === '' ? 'selected' : '' }}>{{ __('site.investment.form.placeholder.choose') }}</option>
                        <option value="1" {{ old('unitaires_sanitaire') === '1' ? 'selected' : '' }}>{{ __('site.yes') }}</option>
                        <option value="0" {{ old('unitaires_sanitaire') === '0' ? 'selected' : '' }}>{{ __('site.no') }}</option>
                    </select>
                </div>
                <div class="col-sm-6" id="id_unitaires_sanitaire" style="display: none;">
                    <input type="number"
                        class="form-control"
                        id="superface_unitaires_sanitaire"
                        name="superface_unitaires_sanitaire"
                        placeholder="{{ __('site.investment.form.placeholder.surface') }}"
                        value="{{ old('superface_unitaires_sanitaire') }}">
                </div>
            </div>
            <div class="form-group row">
                <label for="stockage_conservation" class="col-sm-2 col-form-label">{{ __('site.investment.form.components.storage_space') }}</label>

                <div class="col-sm-4">
                    <select required class="form-control" id="stockage_conservation" name="stockage_conservation" onchange="toggleSection('stockage_conservation', 'id_stockage_conservation')">
                        <option value="" disabled {{ old('stockage_conservation', '') === '' ? 'selected' : '' }}>{{ __('site.investment.form.placeholder.choose') }}</option>
                        <option value="1" {{ old('stockage_conservation') === '1' ? 'selected' : '' }}>{{ __('site.yes') }}</option>
                        <option value="0" {{ old('stockage_conservation') === '0' ? 'selected' : '' }}>{{ __('site.no') }}</option>
                    </select>
                </div>
                <div class="col-sm-6" id="id_stockage_conservation" style="display: none;">
                    <input type="number"
                        class="form-control"
                        id="superface_stockage_conser"
                        name="superface_stockage_conservation"
                        placeholder="{{ __('site.investment.form.placeholder.surface') }}"
                        value="{{ old('superface_stockage_conservation') }}">
                </div>
            </div>
            <div class="form-group row">
                <label for="espace_exterieur" class="col-sm-2 col-form-label">{{ __('site.investment.form.components.outdoor_space') }}</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="espace_exterieur" name="espace_exterieur" onchange="toggleSection('espace_exterieur', 'id_espace_exterieur')">
                        <option value="" disabled {{ old('espace_exterieur', '') === '' ? 'selected' : '' }}>{{ __('site.investment.form.placeholder.choose') }}</option>
                        <option value="1" {{ old('espace_exterieur') === '1' ? 'selected' : '' }}>{{ __('site.yes') }}</option>
                        <option value="0" {{ old('espace_exterieur') === '0' ? 'selected' : '' }}>{{ __('site.no') }}</option>
                    </select>
                </div>
                <div class="col-sm-6" id="id_espace_exterieur" style="display: none;">
                    <input type="number"
                        class="form-control"
                        id="superface_espace_exterieur"
                        name="superface_espace_exterieur"
                        placeholder="{{ __('site.investment.form.placeholder.surface') }}"
                        value="{{ old('superface_espace_exterieur') }}">
                </div>
            </div>
            <div class="form-group row">
                <label for="garage" class="col-sm-2 col-form-label">{{ __('site.investment.form.components.garage') }}</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="garage" name="garage" onchange="toggleSection('garage', 'id_garage')">
                        <option value="" disabled {{ old('garage', '') === '' ? 'selected' : '' }}>{{ __('site.investment.form.placeholder.choose') }}</option>
                        <option value="1" {{ old('garage') === '1' ? 'selected' : '' }}>{{ __('site.yes') }}</option>
                        <option value="0" {{ old('garage') === '0' ? 'selected' : '' }}>{{ __('site.no') }}</option>
                    </select>
                </div>
                <div class="col-sm-6" id="id_garage" style="display: none;">
                    <input type="number"
                        class="form-control"
                        id="superface_garage"
                        name="superface_garage"
                        placeholder="{{ __('site.investment.form.placeholder.surface') }}"
                        value="{{ old('superface_garage') }}">
                </div>
            </div>
            <div class="form-group row">
                <label for="autres_surfaces" class="col-sm-2 col-form-label"> {{ __('site.investment.form.label.other_surfaces') }} </label>
                <div class="col-sm-10">
                    <input required type="number" class="form-control" id="autres_surfaces" name="autres_surfaces" placeholder="{{ __('site.investment.form.placeholder.count') }}">
                </div>
            </div>
        </div>
            <div class="form-group row text-center">
                <div class="d-flex justify-content-end mb-4">
                    <button type="submit" class="btn btn-success font-weight-medium">{{ __('site.investment.form.button.submit') }}</button>
                </div>
            </div>
			    
    </form>
</div>
</div>

@endsection

@section('scripts')
{{-- Scripts spécifiques au formulaire --}}
<script src="{{ asset('BackOfficeAR/js/salle_sport_form.js') }}"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.salle-sport-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });

        // Initialiser notre gestionnaire de formulaire
        SalleSportForm.init();
    });
</script>


<script>
document.addEventListener('DOMContentLoaded', function () {
    const gouvernoratSelect = document.getElementById('gouvernorat_id');
    const delegationSelect = document.getElementById('delegation_id');
    const locale = @json(app()->getLocale());
    const oldDelegation = @json(old('delegation_id', ''));

    function setLoading() {
        delegationSelect.innerHTML = `<option value="" disabled selected>{{ __('site.investment.form.placeholder.loading') }}</option>`;
        delegationSelect.disabled = true;
    }

    function setEmptyChoose() {
        delegationSelect.innerHTML = `<option value="" disabled selected>{{ __('site.investment.form.placeholder.choose') }}</option>`;
        delegationSelect.disabled = false;
    }

    async function loadDelegationsFor(gouvId) {
        if (!gouvId) {
            setEmptyChoose();
            return;
        }

        setLoading();

        let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";
        url = url.replace("ID_PLACEHOLDER", gouvId);

        try {
            const resp = await fetch(url);
            if (!resp.ok) throw new Error('Network response was not ok');
            const data = await resp.json();

            // Reset and add choose placeholder
            delegationSelect.innerHTML = `<option value="" disabled selected>{{ __('site.investment.form.placeholder.choose') }}</option>`;

            data.forEach(d => {
                const option = document.createElement('option');
                option.value = d.id_delegation;

                // trans_field-like logic in JS:
                // try to use the locale-specific column first (e.g. nom_ar / nom_fr / nom_en),
                // then fall back to other known fields.
                let text = '';

                // direct locale key like nom_ar, nom_fr, nom_en
                if (d[`nom_${locale}`]) {
                    text = d[`nom_${locale}`];
                } else {
                    // try common fallbacks
                    text = d.nom_fr || d.nom_en || d.nom_ar || d.name || d.nom || '';
                }

                option.text = text;
                // restore old selection if present
                if (oldDelegation && String(oldDelegation) === String(d.id_delegation)) {
                    option.selected = true;
                }

                delegationSelect.add(option);
            });

            delegationSelect.disabled = false;
        } catch (err) {
            console.error('Failed to load delegations:', err);
            // Graceful fallback: keep choose placeholder enabled
            setEmptyChoose();
        }
    }

    // attach change listener
    if (gouvernoratSelect) {
        gouvernoratSelect.addEventListener('change', function () {
            loadDelegationsFor(this.value);
        });

        // initialize on page load if a gouvernorat is already selected
        if (gouvernoratSelect.value) {
            loadDelegationsFor(gouvernoratSelect.value);
        }
    }
});
</script>


@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
