@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')


@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
   <li class="breadcrumb-item">
    <a href="{{ route('dashboard') }}">
        <i class="bi bi-house-fill"></i>
        <span>{{ __('site.investment.breadcrumb.home') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
    <a href="{{ route('investissement_choix') }}">
        <span>{{ __('site.investment.breadcrumb.index') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
    <a href="{{ route('salle-sport.index2') }}">
        <span>{{ __('site.investment.breadcrumb.salles_list') }}</span>
    </a>
</li>
    <li class="breadcrumb-item active" aria-current="page">عرض إستمارة</li>

    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4"  action="" method="POST" enctype="multipart/form-data" lang="ar">

           
            <h4 style="text-align:center;padding-top:20px;">إستمارة تسجيل الإنتفاع بإعفاء جبائي</h4>
            <br>

            <div class="mb-3">
                <h5 class="fw-bold mb-1">الوضعية الحالية:</h5>
                @if($document->id_statut == 1)
                    <span><strong>موافقة</strong></span>
                @elseif($document->id_statut == 3)
                    <span><strong>عدم موافقة</strong></span>
                @elseif($document->id_statut == 4)
                    <span><strong>موافقة شريطة</strong></span>
                @elseif($document->id_statut == 5)
                    <span><strong>ارجاء لابداء الراي</strong></span>
                @else
                    <span><strong>في الانتظار</strong></span>
                @endif
            </div>

            @if($document->id_statut == 3 && !empty($document->commentaire_motif))
                <div class="mb-3">
                    <label class="fw-bold text-danger mb-0">سبب الرفض:</label>
                    <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $document->commentaire_motif }}</p>
                </div>
            @endif

            @if($document->id_statut == 4 && !empty($document->commentaire_acceptation))
                <div class="mb-3">
                    <label class="fw-bold text-warning mb-0">تعليق:</label>
                    <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $document->commentaire_acceptation }}</p>
                </div>
            @endif

            @if($document->id_statut == 5 && !empty($document->commentaire_avis))
                <div class="mb-3">
                    <label class="fw-bold text-primary mb-0">تعليق:</label>
                    <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $document->commentaire_avis }}</p>
                </div>
            @endif

            <div class="form-section">
                <h4>هوية صاحب المشروع</h4>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                    <div class="col-sm-10">
                        <div class="form-control bg-white border-0">{{ $document->utilisateur->nom_prenom ?? '-' }}</div>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">رقم الهاتف</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">{{ $document->utilisateur->tel ?? '-' }}</div>
                    </div>

                    <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">{{ $document->utilisateur->email ?? '-' }}</div>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                    <div class="col-sm-10">
                        <div class="form-control bg-white border-0">{{ $document->utilisateur->adresse ?? '-' }}</div>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">عنوان المشروع</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">{{ $document->nom_projet ?? '-' }}</div>
                    </div>

                    <label class="col-sm-2 col-form-label">مكان المشروع</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">{{ $document->adresse_projet ?? '-' }}</div>
                    </div>
                </div>
            </div>

            <div class="form-section mt-4">
                <h4>الوثائق المرفقة</h4>
                @php
                    $files = [
                        'copie_cahier_des_charges','copie_originale','facture','contrat','fichier_arrivage','fichier_colisage',
                        'copie_registre_fiscal','copie_registre_national_institutions','copie_certificat_propriete','engagement','exemple_projet'
                    ];
                    $labels = [
                        '1- نسخة من كراس الشروط','2- الاصل من شهادة ايداع التصريح','3- فاتورة','4- عقد بين المشتري و المورد','5- وثيقة الاعلام بالوصول',
                        '6- وثيقة الشحن','7- نسخة من بطاقة التعريف الجبائي','8- نسخة من مضمون السجل الوطني للمؤسسات','9- نسخة من شهادة الملكية',
                        '10- تعهد','11- مثال هندسي للمشروع'
                    ];
                @endphp

                @foreach($files as $index => $file)
                    <div class="form-group row mb-3">
                        <label class="col-sm-6 col-form-label">{{ $labels[$index] }}</label>
                        <div class="col-sm-6">
                            @if(!empty($document->$file))
                                <a href="{{ asset('storage/'.$document->$file) }}" target="_blank" class="btn btn-link">مشاهدة الملف</a>
                            @else
                                <span>-</span>
                            @endif
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="form-group row justify-content-center d-print-none" style="padding-top:50px;">
                <div class="col-auto">
                    <button type="button" onclick="window.print()" class="btn btn-success d-flex align-items-center">
                        <i class="fa fa-print me-2"></i> طباعة
                    </button>
                </div>
             
            </div>
        </form>
    </div>

    @else
        <script>
            window.location.href = "{{ route('login') }}";
        </script>
    @endif
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeunesse-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });
    });
</script>
@endsection