@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')


@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
   <li class="breadcrumb-item">
    <a href="{{ route('dashboard') }}">
        <i class="bi bi-house-fill"></i>
        <span>{{ __('site.investment.breadcrumb.home') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
    <a href="{{ route('investissement_choix') }}">
        <span>{{ __('site.investment.breadcrumb.index') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
    <a href="{{ route('salle-sport.index2') }}">
        <span>{{ __('site.investment.breadcrumb.salles_list') }}</span>
    </a>
</li>
<li class="breadcrumb-item active" aria-current="page">{{ __('site.investment.breadcrumb.add_exo') }}</li>

    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4"  action="{{ route('salle-sport.exoneration.store', $immobilier->id_imm) }}" method="POST" enctype="multipart/form-data" lang="{{ app()->getLocale() }}">
        @csrf
            <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
            <input type="hidden" name="id_type_formulaire" value="1">
            <input type="hidden" name="immobilier_id" value="{{ $immobilier }}">
          
            <h4 style="text-align:center;padding-top:20px;">{{ __('site.exoneration.form_title') }}</h4>
            <br>
            <div class="form-section">
                <h4>{{ __('site.exoneration.identity.title') }}</h4>

                <div class="form-group row mb-3"  style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label">{{ __('site.investment.form.label.full_name') }}</label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="nom_prenom" value="{{ old('nom_prenom', Auth::user()->nom_prenom ?? '') }}" readonly>
                    </div>

                    <label class="col-sm-2 col-form-label">{{ __('site.investment.form.label.phone') }}</label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="tel" value="{{ old('tel', Auth::user()->tel ?? '') }}" readonly>
                    </div>
                </div>

                <div class="form-group row align-items-center">
                    <label class="col-sm-2 col-form-label">{{ __('site.investment.form.label.identity_type') }}</label>
                    <div class="col-sm-4">
                        <input type="text" class="form-control"
                            value="{{ Auth::user()->typeIdentite->{ 'type_' . app()->getLocale() } ?? (Auth::user()->typeIdentite->type_ar ?? '') }}"
                            readonly>
                    </div>

                    @php $user = Auth::user(); @endphp

                    @if($user->id_type_identite == 1)
                        <div class="col-sm-6">
                            <input type="text" class="form-control" value="{{ $user->cin ?? '' }}" readonly placeholder="{{ __('site.investment.form.placeholder.cin') }}">
                        </div>
                    @elseif($user->id_type_identite == 2)
                        <div class="col-sm-6">
                               <input type="text" class="form-control" value="{{ $user->passport ?? '' }}" readonly placeholder="{{ __('site.investment.form.placeholder.passport') }}">
                        </div>
                    @elseif($user->id_type_identite == 3)
                        <div class="col-sm-6">
                            <input type="text" class="form-control" value="{{ $user->num_fiscal ?? '' }}" readonly placeholder="{{ __('site.investment.form.placeholder.fiscal') }}">
                        </div>
                    @endif
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">{{ __('site.investment.form.label.address') }}</label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="adresse" value="{{ old('adresse', Auth::user()->adresse ?? '') }}" readonly >
                    </div>

                    <label class="col-sm-2 col-form-label">{{ __('site.investment.form.label.email') }}</label>
                    <div class="col-sm-4">
                        <input required type="email" class="form-control" name="email" value="{{ old('email', Auth::user()->email ?? '') }}" readonly>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">{{ __('site.exoneration.project_name_label') }}</label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="nom_projet" value="{{ old('nom_projet') }}">
                    </div>

                    <label class="col-sm-2 col-form-label">{{ __('site.exoneration.project_place_label') }}</label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="adresse_projet" value="{{ old('adresse_projet') }}">
                    </div>
                </div>

            </div>

            <div class="form-section mt-4">
                <h4>{{ __('site.exoneration.documents.title') }}</h4>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.1.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_cahier_des_charges" name="copie_cahier_des_charges">
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.1.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.2.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_originale" name="copie_originale">
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.2.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.3.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="facture" name="facture" >
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.3.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.4.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="contrat" name="contrat">
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.4.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.5.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="fichier_arrivage" name="fichier_arrivage">
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.5.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.6.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="fichier_colisage" name="fichier_colisage">
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.6.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.7.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_registre_fiscal" name="copie_registre_fiscal" >
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.7.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.8.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_registre_national_institutions" name="copie_registre_national_institutions">
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.8.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.9.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_certificat_propriete" name="copie_certificat_propriete">
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.9.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.10.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="engagement" name="engagement">
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.10.desc') }}</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">{{ __('site.exoneration.documents.11.label') }}</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="exemple_projet" name="exemple_projet">
                    </div>
                </div>
                <span>{{ __('site.exoneration.documents.11.desc') }}</span>

            </div>

               <div class="form-group row text-center" style="padding-top:50px;">
          <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-success font-weight-medium" >إرسال</button>
            </div>
          
        </div>
        </form>
    </div>

    @else
        <script>
            window.location.href = "{{ route('login') }}";
        </script>
    @endif
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeunesse-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });

        // Prévisualisation des fichiers
        const fileInputs = document.querySelectorAll('input[type="file"]');
        fileInputs.forEach(input => {
            input.addEventListener('change', function(e) {
                const fileName = e.target.files[0]?.name;
                if (fileName) {
                    const label = input.closest('.form-group').querySelector('.col-form-label');
                    if (label) {
                        label.setAttribute('title', `${'{{ __('site.file_selected_prefix') }}'}: ${fileName}`);
                    }
                }
            });
        });
    });
</script>
@endsection
