@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@auth


<div class="salle-sport-edit" >
<div class="container">
    <form action="" method="POST" id="myForm"  enctype="multipart/form-data">
        @csrf

    <div class="header-print-container mb-4">
        <div class="header-center text-center">
            <div class="d-flex justify-content-between align-items-center mb-3">
                <div class="text-start">
                    <strong>{{ __('site.start_activity.form_number_label') }}</strong>
                    {{
                        '00' . $debutActivite->id_debut . '_' .
                        (
                            $debutActivite->immobilier->utilisateur->cin ??
                            $debutActivite->immobilier->utilisateur->passport ??
                            $debutActivite->immobilier->utilisateur->num_fiscal ??
                            '---'
                        ) . '_' . \Carbon\Carbon::now()->format('Y')
                    }}
                </div>

                <div class="text-center flex-grow-1 header-center">
                    <h2 class="mb-0">{{ __('site.republic') }}</h2>
                    <h2 class="mb-0">{{ __('site.ministry_name') }}</h2>
                    <h3 class="mb-0">{{ __('site.start_activity.form_title') }}</h3>
                </div>

                <div style="width: 150px;"></div>
            </div>
        </div>

        <div class="header-side header-right no-print">
            <button type="button" onclick="window.print()" class="btn btn-success">
                <i class="fas fa-print" ></i> {{ __('site.print') }}
            </button>
        </div>
    </div>

    {{-- Statut --}}
    <div class="card shadow-lg border-0 mb-4 rounded-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-bold">{{ __('site.start_activity.current_status') }}</h5>
            @if($debutActivite->id_statut == 1)
                <span class="badge bg-success fs-6">{{ __('site.start_activity.status.accepted') }}</span>
            @elseif($debutActivite->id_statut == 3)
                <span class="badge bg-danger fs-6">{{ __('site.start_activity.status.rejected') }}</span>
            @else
                <span class="badge bg-warning text-dark fs-6">{{ __('site.start_activity.status.pending') }}</span>
            @endif
        </div>

        @if($debutActivite->id_statut == 3 && $debutActivite->commentaire_motif)
            <div class="card-body">
                <p class="text-danger fw-bold">{{ __('site.start_activity.rejection_reason_label') }}</p>
                <p>{{ $debutActivite->commentaire_motif }}</p>
            </div>
        @endif
    </div>

    {{-- Informations sur le propriétaire --}}
    <h4 class="mb-3 fw-bold">{{ __('site.start_activity.owner_identity_title') }}</h4>
    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">{{ __('site.investment.form.label.full_name') }}</label>
            <input type="text" class="form-control" value="{{ $debutActivite->immobilier->utilisateur->nom_prenom ?? __('site.not_specified') }}" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold">{{ __('site.start_activity.owner_identity_number') }}</label>
            <input type="text" class="form-control" value="{{ $debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? __('site.not_specified') }}" readonly>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">{{ __('site.investment.form.label.phone') }}</label>
            <input type="text" class="form-control" value="{{ $debutActivite->immobilier->utilisateur->tel ?? __('site.not_specified') }}" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold">{{ __('site.investment.form.label.email') }}</label>
            <input type="text" class="form-control" value="{{ $debutActivite->immobilier->utilisateur->email ?? __('site.not_specified') }}" readonly>
        </div>
    </div>

    <h4>{{ __('site.start_activity.start_date_label') }}</h4>
    <div class="form-group row">
        <div class="col-sm-11">
            <input required type="date" class="form-control" id="date_debut_activite" name="date_debut_activite" value="{{ $debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('Y-m-d') : '' }}" readonly>
        </div>
    </div>
    <span>{{ __('site.start_activity.start_date_hint') }}</span>

    {{-- Documents --}}
    <h4 class="mb-3 fw-bold">{{ __('site.start_activity.attached_documents') }}</h4>

    @php
        $docs = [
            'preuve_propriete_location',
            'plan_architectural',
            'declaration_investissement',
            'identification',
            'extrait_registre_national_entreprise',
            'certificat_prevention',
            'contrat_assurance',
            'approbation_autorite_minicipale'
        ];
    @endphp

    @foreach($docs as $field)
        @php
            $label = __('site.start_activity.documents.' . $field . '.label');
            $desc  = __('site.start_activity.documents.' . $field . '.desc');
        @endphp

        <div class="mb-2">
            <strong>{{ $label ?: ucfirst(str_replace('_', ' ', $field)) }}: </strong>
            @if(!empty($debutActivite->$field))
                <a href="{{ asset('storage/'.$debutActivite->$field) }}" target="_blank">{{ __('site.view_file') }}</a>
            @else
                <span>{{ __('site.not_specified') }}</span>
            @endif

            @if($desc && $desc !== ('site.start_activity.documents.' . $field . '.desc'))
                <div class="small text-muted">{{ $desc }}</div>
            @endif
        </div>
    @endforeach

    <div class="mt-4 no-print d-flex justify-content-center" style="gap: 10px;">
        <a href="{{ route('salle-sport.index2') }}" class="btn btn-primary d-flex align-items-center">
            <i class="bi bi-arrow-left me-1"></i> {{ __('site.back') }}
        </a>
        <button type="button" onclick="window.print()" class="btn btn-success d-flex align-items-center">
            <i class="fa fa-print me-1"></i> {{ __('site.print') }}
        </button>
    </div>

    </form>
</div>
</div>

@else
    <script>window.location.href = "{{ route('login') }}";</script>
@endauth

@endsection
