
@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit">
<div class="container">
    <form action="{{ route('debut_activite.update2', $debutActivite->id_debut) }}" method="POST" id="myForm" lang="ar" enctype="multipart/form-data">
        @csrf
        @method('PUT') 
        <input type="hidden" name="immobilier_id" value="{{ $debutActivite->immobilier_id ?? '' }}">
        <input type="hidden" name="utilisateur_id" id="utilisateur_id" value="{{ $debutActivite->immobilier->utilisateur->id ?? '' }}">

       <div class="d-flex justify-content-between align-items-center mb-3">
    <div class="text-start">
        <strong>رقم الاستمارة: </strong> 
        {{
            '00' . $debutActivite->id_debut . '_' . 
            (
                $debutActivite->immobilier->utilisateur->cin ??
                $debutActivite->immobilier->utilisateur->passport ??
                $debutActivite->immobilier->utilisateur->num_fiscal ??
                '---'
            ) . '_' . \Carbon\Carbon::now()->format('Y')
        }}
    </div>

    <div class="text-center flex-grow-1">
        <h2 class="mb-0">الجمهورية التونسية</h2>
        <h2 class="mb-0">وزارة الشباب و الرياضة</h2>
        <h3 class="mb-0">استمارة الاعلام ببداية النشاط</h3>
    </div>

    <div style="width: 150px;"></div>
</div>



        

        <div class="form-section">
            <h4 class="mb-4">هوية الباعث</h4> 
            <div class="form-group row align-items-center mb-3">
                <label class="col-sm-2 fw-bold" style="color: #333; padding-top: 7px;">نوع الهوية</label>
                <div class="col-sm-4">
                    <span class="form-control" style="background-color: #f8f9fa;">
                        {{ 
                            $debutActivite->immobilier->utilisateur->cin ? 'بطاقة تعريف وطنية (CIN)' : 
                            ($debutActivite->immobilier->utilisateur->passport ? 'جواز سفر (Passport)' : 
                            ($debutActivite->immobilier->utilisateur->num_fiscal ? 'رقم تعريفي جبائي (Num Fiscal)' : '---')) 
                        }}
                    </span>
                </div>

                <div class="col-sm-4">
                    <input type="text" class="form-control" id="identifiant" value="{{ $debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? '' }}" readonly>
                </div>
                
            </div>

            <div id="sectionIdentite" class="d-block">
                <h5 class="mb-4">بيانات الباعث</h5>
                <div class="form-group row mb-3">
                    <label class="col-sm-2 fw-bold" style="color: #333; padding-top: 7px;">الاسم و اللقب أو الاسم التجاري</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="nom_prenom" name="nom_prenom" value="{{ $debutActivite->immobilier->utilisateur->nom_prenom ?? '' }}" readonly>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 fw-bold" style="color: #333; padding-top: 7px;">رقم الهوية</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="identifiantAffiche" value="{{ $debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? '' }}" readonly>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 fw-bold" style="color: #333; padding-top: 7px;">المندوبية الجهوية للشباب و الرياضة</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="mandoubia" value="{{ $debutActivite->immobilier->gouvernorat->nom_ar ?? '' }}" readonly>
                    </div>
                </div>
            </div>

            <h4>تاريخ بداية النشاط</h4>
            <div class="form-group row">
                <div class="col-sm-11">
                    <input required type="date" class="form-control" id="date_debut_activite" name="date_debut_activite" value="{{ $debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('Y-m-d') : '' }}">
                </div>
            </div>
            <span>تاريخ بداية النشاط يجب ان يكون بعد 15 يوما من تاريخ استلام وصل التسجيل.</span>

            <h4 class="mb-4">إضافة الوثائق المطلوبة</h4>
            @php
                $docs = [
                    'preuve_propriete_location' => 'نسخة من شهادة الملكية او عقد بيع او عقد كراء ...',
                    'plan_architectural' => 'مثال هندسي معد من قبل مهندس معماري ...',
                    'declaration_investissement' => 'شهادة تصريح بالاستثمار ...',
                    'identification' => 'بطاقة تعريف جبائية',
                    'extrait_registre_national_entreprise' => 'مضمون السجل الوطني للمؤسسات',
                    'certificat_prevention' => 'شهادة وقاية مسلمة من المصالح الجهوية ...',
                    'contrat_assurance' => 'عقد التامين',
                    'approbation_autorite_minicipale' => 'عقود الشغل مع الاعوان ...'
                ];
            @endphp

            @foreach($docs as $field => $label)
                <div class="form-group row mb-3">
                    <label for="{{ $field }}" class="col-sm-8 fw-bold" style="color: #333; padding-top: 7px;">{{ $label }}</label>
                    <div class="col-sm-3">
                        <input type="file" class="form-control" id="{{ $field }}" name="{{ $field }}">
                        @if(!empty($debutActivite->$field))
                            <a href="{{ asset('storage/'.$debutActivite->$field) }}" target="_blank" class="mt-2 d-inline-block">الملف الحالي</a>
                        @endif
                    </div>
                </div>
            @endforeach

            


            <div class="form-group row text-center">
    <div class="col-sm-4 mx-auto d-flex justify-content-between" style="gap: 10px;">
        <button type="submit" style="width:150px; text-align:center; background-color:#C51B01; color:white;">
           تحديث البيانات
        </button>

        <a href="{{ route('salle-sport.index2') }}" 
           class="btn btn-secondary" 
           style="width:150px; text-align:center;">
            العودة
        </a>
    </div>         
</div>

        </div>   
    </form>
</div>
 </div>
<script src="{{ asset('BackOfficeAR/js/script.js') }}"></script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection