
@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit">
<div class="container">
<form action="{{ route('debut_activite.store2') }}" method="POST" enctype="multipart/form-data" lang="ar">
@csrf
<div class="d-flex justify-content-between align-items-center mb-3">
    <div class="text-start">
        <strong>رقم الاستمارة: </strong>
        {{
            str_pad($immobilier_id ?? ($debutActivite->immobilier_id ?? 0), 3, '0', STR_PAD_LEFT) . '_' .
            ($immobilier->utilisateur->cin ?? $immobilier->utilisateur->passport ?? $immobilier->utilisateur->num_fiscal ?? '---') . '_' .
            \Carbon\Carbon::now()->format('Y')
        }}
    </div>
    <div class="text-center flex-grow-1">
        <h2 class="mb-0">الجمهورية التونسية</h2>
        <h2 class="mb-0">وزارة الشباب و الرياضة</h2>
        <h3 class="mb-0">استمارة الاعلام ببداية النشاط</h3>
    </div>

    <div style="width: 150px;"></div>
</div>

<input type="hidden" name="immobilier_id" value="{{ $immobilier_id ?? ($debutActivite->immobilier_id ?? '') }}">
<input type="hidden" name="utilisateur_id" id="utilisateur_id" value="{{ $immobilier->utilisateur->id ?? ($debutActivite->immobilier->utilisateur->id ?? '') }}">



  
    <div id="sectionIdentite" class="d-block">
        <h5>هوية الباعث</h5>

<div class="form-group row">
    <label class="col-sm-2 col-form-label">الاسم و اللقب أو الاسم التجاري</label>
    <div class="col-sm-10">
        <input type="text" class="form-control" 
               style="text-transform: none; direction: rtl;" 
               value="{{ auth()->user()->nom_prenom ?? '' }}" readonly>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
    <div class="col-sm-10">
        <input type="email" class="form-control" 
               style="text-transform: none; direction: rtl;" 
               value="{{ auth()->user()->email ?? '' }}" readonly>
    </div>
</div>

<div class="form-group row align-items-center">
    {{-- نوع الهوية --}}
    <label class="col-sm-2 col-form-label">نوع الهوية</label>
    <div class="col-sm-4">
        <input type="text" class="form-control"
               style="text-transform: none; direction: rtl;"
               value="{{ auth()->user()->typeIdentite->type_ar ?? '' }}" readonly>
    </div>

    @if(auth()->user()->id_type_identite == 1)
        <label class="col-sm-2 col-form-label">رقم بطاقة التعريف</label>
        <div class="col-sm-4">
            <input type="text" class="form-control"
                   style="text-transform: none; direction: rtl;"
                   value="{{ auth()->user()->cin ?? '' }}" readonly>
        </div>
    @elseif(auth()->user()->id_type_identite == 2)
        <label class="col-sm-2 col-form-label">رقم جواز السفر</label>
        <div class="col-sm-4">
            <input type="text" class="form-control"
                   style="text-transform: none; direction: rtl;"
                   value="{{ auth()->user()->passport ?? '' }}" readonly>
        </div>
    @elseif(auth()->user()->id_type_identite == 3)
        <label class="col-sm-2 col-form-label">رقم المعرف الجبائي</label>
        <div class="col-sm-4">
            <input type="text" class="form-control"
                   style="text-transform: none; direction: rtl;"
                   value="{{ auth()->user()->num_fiscal ?? '' }}" readonly>
        </div>
    @endif
</div>



<div class="form-group row">
    <label class="col-sm-2 col-form-label">رقم الهاتف الشخصي</label>
    <div class="col-sm-4">
        <input type="text" class="form-control" 
               value="{{ auth()->user()->tel ?? '' }}" readonly>
    </div>
    <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
    <div class="col-sm-4">
        <input type="text" class="form-control" 
               style="text-transform: none; direction: rtl;" 
               value="{{ auth()->user()->adresse ?? '' }}" readonly>
    </div>
</div>

<div class="form-group row">
    <label class="col-sm-2 col-form-label">المندوبية الجهوية للشباب و الرياضة</label>
    <div class="col-sm-10">
        <input type="text" class="form-control" 
               style="text-transform: none; direction: rtl;" 
               value="{{ auth()->user()->immobiliers->first()->gouvernorat->nom_ar ?? 'غير محدد' }}" readonly>
    </div>
</div>

     
    </div>

            <h4> تاريخ بداية النشاط </h4> 
            <div class="form-group row">
                <div class="col-sm-11">
                    <input required type="date" class="form-control" id="date_debut_activite" name="date_debut_activite" placeholder="">
                </div>
            </div>
            <span>تاريخ بداية النشاط يجب ان يكون بعد 15 يوما من تاريخ استلام وصل التسجيل .</span>

            <h4> اضافة الوثائق المطلوبة </h4> 
            <div class="form-group row">
                <label for="preuve_propriete_location" class="col-sm-8 col-form-label"> 1- نسخة من شهادة الملكية او عقد بيع او عقد كراء او عقد هبة او اي وثيقة رسمية اخرى للعقار</label>
                <div class="col-sm-3">
                    <input required type="file" class="form-control" id="preuve_propriete_location" name="preuve_propriete_location" placeholder="">
                </div>
            </div>
            <div class="form-group row">
                <label for="plan_architectural" class="col-sm-8 col-form-label"> 2- مثال هندسي معد من قبل مهندس معماري مرسم بهيئة المهندسين المعماريين بالبلاد التونسية</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="plan_architectural" name="plan_architectural">
                </div>
            </div>
            <div class="form-group row">
                <label for="declaration_investissement" class="col-sm-8 col-form-label"> 3- شهادة تصريح بالاستثمار مسلمة من وكالةالنهوض بالصناعة و التجديد</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="declaration_investissement" name="declaration_investissement">
                </div>
            </div>

            <div class="form-group row">
                <label for="identification" class="col-sm-8 col-form-label"> 4- بطاقة تعريف جبائية</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="identification" name="identification">
                </div>
            </div>
            <div class="form-group row">
                <label for="extrait_registre_national_entreprise" class="col-sm-8 col-form-label"> 5- مضمون السجل الوطني للمؤسسات</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="extrait_registre_national_entreprise" name="extrait_registre_national_entreprise">
                </div>
            </div>
            <div class="form-group row">
                <label for="certificat_prevention" class="col-sm-8 col-form-label"> 6- شهادة وقاية مسلمة من المصالح الجهوية للحماية المدنية </label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="certificat_prevention" name="certificat_prevention">
                </div>
            </div>
            <div class="form-group row">
                <label for="contrat_assurance" class="col-sm-8 col-form-label"> 7- عقد التامين</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="contrat_assurance" name="contrat_assurance">
                </div>
            </div>
            <div class="form-group row">
                <label for="approbation_autorite_minicipale" class="col-sm-8 col-form-label"> 8- عقود الشغل مع الاعوان القارين او تراخيص بمقابل بالنسبة للاعوان العموميين</label>
                <div class="col-sm-3">   
                    <input required type="file" class="form-control" id="approbation_autorite_minicipale" name="approbation_autorite_minicipale">
                </div>
            </div>

            <div class="form-group row text-center">
    <div class="col-sm-4 mx-auto d-flex justify-content-between" style="gap: 10px;">
        <button type="submit" style="width:150px; text-align:center; background-color:#C51B01; color:white;">
            تسجيل البيانات
        </button>

        <a href="{{ route('salle-sport.index2') }}" 
           class="btn btn-secondary" 
           style="width:150px; text-align:center;">
            العودة
        </a>
    </div>         
</div>


        </div>   
    </form>
</div>
    </div>
   
<script src="{{ asset('BackOfficeAR/js/script.js') }}"></script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
 @endsection