
@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
<style>
.stylish-btn {
    padding: 10px 25px;
    font-size: 1rem;
    border-radius: 12px;
    transition: all 0.3s ease;
    font-weight: bold;
    box-shadow: 0 3px 8px rgba(0, 0, 0, 0.15);
}

.stylish-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 12px rgba(0, 0, 0, 0.25);
}

@media print {
    .action-buttons,
    .navbar,
    .footer,
    header,
    footer {
        display: none !important;
    }

    @page {
        margin: 0;
    }

    body {
        margin: 1cm;
        font-size: 14px;
        line-height: 1.6;
    }

    * {
        color: #000 !important;
        background: transparent !important;
        box-shadow: none !important;
    }
}

</style>
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('investissement_choix') }}">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
       <a href="{{ route('jeunesse2.index') }}">
                <span>تنظيم الأنشطة الترفيهية للشباب و الطفولة</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">عرض إستمارة</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
        <form action="{{ route('jeunesse2.update', $activite->id_jeune_enfant) }}" method="POST" enctype="multipart/form-data" lang="ar">
            @csrf
            @method('PUT')

            <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
        
            <h3>{{ $formulaire->type_ar }}</h3>
            <br>
            <div>
                <div class="d-flex align-items-center mb-3">
                    <h5 class="mb-0 fw-bold me-2">   الوضعية الحالية: </h5>
                    @if($activite->id_statut == 1)
                        <span><strong> قبول </strong></span>
                    @elseif($activite->id_statut == 3)
                        <span><strong> رفض </strong></span>
                    @else
                        <span><strong> في الانتظار </strong></span>
                    @endif
                </div>

                @if($activite->id_statut == 3 && !empty($activite->commentaire_motif))
                    <div class="d-flex align-items-center mb-3">
                        <label class="fw-bold text-danger me-2 mb-0">سبب الرفض:</label>
                        <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $activite->commentaire_motif }}</p>
                    </div>
                @endif
            </div>

            <div class="form-section">
                <h4>المستثمر</h4>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                    <div class="col-sm-10">
                        <div class="form-control bg-white border-0">{{ $activite->investissements->first()?->utilisateur->nom_prenom ?? '-' }}</div>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">مكان الولادة</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->investissements->first()?->utilisateur->lieu_naissance ?? '-' }}
                        </div>
                    </div>

                    <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->investissements->first()?->utilisateur->date_naissance ?? '-' }}
                        </div>
                    </div>
                </div>

                <div class="form-group row align-items-center">
                    <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->investissements->first()?->utilisateur->typeIdentite->type_ar ?? '-' }}
                        </div>
                    </div>

                    @php
                        $typeIdentite = $activite->investissements->first()?->utilisateur->id_type_identite;
                    @endphp

                    @if($typeIdentite == 1)
                        <div class="col-sm-6">
                            <div class="form-control bg-white border-0">
                                {{ $activite->investissements->first()?->utilisateur->cin ?? '-' }}
                            </div>
                        </div>
                    @elseif($typeIdentite == 2)
                        <div class="col-sm-6">
                            <div class="form-control bg-white border-0">
                                {{ $activite->investissements->first()?->utilisateur->passport ?? '-' }}
                            </div>
                        </div>
                    @elseif($typeIdentite == 3)
                        <div class="col-sm-6">
                            <div class="form-control bg-white border-0">
                                {{ $activite->investissements->first()?->utilisateur->num_fiscal ?? '-' }}
                            </div>
                        </div>
                    @endif
                </div>

                @php
                    $user = $activite->investissements->first()?->utilisateur;
                @endphp

                @if($user && $user->id_type_identite == 1)
                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $user->date_delivrance_cin ?? '-' }}
                        </div>
                    </div>

                    <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $user->lieu_delivrance_cin ?? '-' }}
                        </div>
                    </div>
                </div>
                @endif

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                    <div class="col-sm-10">
                        <div class="form-control bg-white border-0">
                            {{ $user->adresse ?? '-' }}
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $user->niveau_etude ?? '-' }}
                        </div>
                    </div>

                    <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $user->dernier_diplome ?? '-' }}
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label">الاقدمية في تعاطي النشاط</label>
                    <div class="col-sm-10">
                        <div class="form-control bg-white border-0">
                            {{ $activite->investissements->first()?->utilisateur->experience ?? '-' }}
                        </div>
                    </div>
                </div>
            </div>

            <div class="form-section mt-4">
                <h4> خاصيات النشاط </h4>
                <div class="row align-items-center">
                    <div class="col-sm-6">
                        <label for="" class="col-sm-10 col-form-label">
                            <strong> تنظيم الأنشطة الترفيهية للشباب و الطفولة  </strong>
                        </label>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"><strong>الإستثمار في هذا النشاط</strong></label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->statutInv->statut_ar ?? '-' }}
                        </div>
                    </div>

                    <label class="col-sm-2 col-form-label"><strong>طبيعة الأنشطة</strong></label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->natureActivite->nature_ar ?? '-' }}
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-3 align-items-center">
                    <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->nom_projet ?? '-' }}
                        </div>
                    </div>

                    <label class="col-sm-2 col-form-label">عنوان المقر الاجتماعي</label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->adresse_siege ?? '-' }}
                        </div>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label"> الولاية </label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->gouvernorat->nom_ar ?? '-' }}
                        </div>
                    </div>

                    <label class="col-sm-2 col-form-label"> البلدية </label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->delegation->nom_ar ?? '-' }}
                        </div>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> الترقيم البريدي </label>
                    <div class="col-sm-4">
                        <div class="form-control bg-white border-0">
                            {{ $activite->code_postal ?? '-' }}
                        </div>
                    </div>
                </div>
            </div>

            <h4>جدول الاستثمار و التمويل</h4>
            <div class="form-section mt-4">
                <table class="custom-table">
                    <thead>
                        <tr>
                            <th>الإستثمار</th>
                            <th>مبلغ الإستثمار</th>
                            <th>مصادر التمويل</th>
                            <th>مبلغ التمويل</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($activite->investissements as $inv)
                        <tr>
                            <td>
                                {{ $secteurs->firstWhere('id_secteur', $inv->secteur_invest_id)?->secteur_ar ?? 'غير محدد' }}
                            </td>
                            <td>{{ $inv->montant_inv ?? 'غير محدد' }}</td>
                            <td>
                                {{ $source_fin->firstWhere('id_source', $inv->id_source_financement)?->source_ar ?? 'غير محدد' }}
                            </td>
                            <td>{{ $inv->montant_fin ?? 'غير محدد' }}</td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>

            <div class="mt-3">
                <h4>تصريح على الشرف</h4>
                <span>
                    إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
                </span>
            </div>

            <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
                <h4> ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</h4>
                <textarea class="form-control mt-2 bg-white" name="remarques" readonly rows="6" placeholder="اكتب ملاحظاتك هنا...">{{ old('remarques', $activite->remarques) }}</textarea>
            </div>



            <div class="form-group row justify-content-center action-buttons d-print-none" style="padding-top:50px;">
                <div class="col-auto">
                    <button type="button" onclick="window.print()" class="btn btn-outline-success stylish-btn">
                        <i class="fa fa-print me-2"></i> طباعة 
                    </button>
                </div>
                
            </div>



        </form>
    </div>
</div>
    @else
        <script>
            window.location.href = "{{ route('login') }}";
        </script>
    @endif
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeunesse-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });
    });
</script>
@endsection