@extends('layouts.app')
@section('content')

<div class="it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
     <nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('investissement_choix') }}">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">تنظيم الأنشطة الترفيهية للشباب و الطفولة</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
 
<div class="row">
                        <div class="col-xl-12">
                            <div class="it-section-title-box text-center mb-30" style="padding-top:20px;">
                                <span class="it-section-subtitle">استمارات الأنشطة الخاصة بالشباب و الأطفال</span>
                                <h4 class="it-section-title it-split-in-right mb-0">عرض جميع الاستمارات</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="card shadow-sm p-4">

                                <div class="d-flex justify-content-end mb-4">
                                    <a class="btn btn-success" href="{{ route('jeunesse2.create') }}">
                                        <i class="la la-plus me-1"></i> إضافة استمارة
                                    </a>
                                </div>

                                @if(session('success'))
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        {{ session('success') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                    </div>
                                @endif

                                 <div class="my-table table-responsive">
                                     <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                                        <thead class="thead-light">
                                           <tr>
                                                <th width="5%">المعرف</th>
                                                <th width="25%">الاسم و اللقب</th>
                                                <th width="25%">طبيعة النشاط</th>
                                                <th width="15%">وضعية الطلب</th>
                                                <th width="30%">إجراءات</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            @forelse($activites as $activite)
                                                <tr style="vertical-align: middle !important; text-align: center;">
                                                    <td>{{ $activite->id_jeune_enfant }}</td>
                                                    <td>{{ $activite->investissements->first()?->utilisateur?->nom_prenom ?? '---' }}</td>
                                                    <td>{{ $activite->natureActivite?->nature_ar ?? '---' }}</td>
                                                    <td>
                                                        @php
                                                            $statut = $activite->statut?->statut_ar ?? 'في الانتظار';
                                                            $badgeClass = match($activite->id_statut) {
                                                                1 => 'status-badge--success',
                                                                3 => 'status-badge--danger',
                                                                default => 'status-badge--pending'
                                                            };
                                                        @endphp
                                                        <span class="status-badge {{ $badgeClass }}">{{ $statut }}</span>
                                                    </td>
                                                   <td class="text-center align-middle">
                                                        <div class="actions-cell d-inline-flex gap-2 flex-wrap justify-content-center align-items-center" role="group" aria-label="actions">
                                                            <a href="{{ route('jeunesse2.show', $activite->id_jeune_enfant) }}"
                                                                class="btn-icon btn-icon--primary"
                                                                title="عرض" aria-label="عرض">
                                                                <i class="la la-eye"></i>
                                                            </a>

                                                            {{-- Boutons Modifier + Supprimer si statut == 2 --}}
                                                            @if($activite->id_statut == 2)
                                                                {{-- Modifier --}}
                                                                <button type="button"
                                                                        class="btn-icon btn-icon--warning"
																		onclick="window.location='{{ route('jeunesse2.edit', $activite->id_jeune_enfant) }}'"
                                                                        
                                                                        title="تعديل" aria-label="تعديل">
                                                                    <i class="la la-edit"></i>
                                                                </button>

                                                                {{-- Supprimer --}}
                                                                <form action="{{ route('jeunesse2.destroy', $activite->id_jeune_enfant) }}" method="POST" class="d-inline">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <button type="button"
                                                                            onclick="confirmDelete(this.closest('form'))"
                                                                            class="btn-icon btn-icon--danger"
                                                                            title="حذف" aria-label="حذف">
                                                                        <i class="la la-trash"></i>
                                                                    </button>
                                                                </form>
                                                            @endif
                                                        </div>
                                                    </td>

                                                </tr>
                                            @empty
                                                <tr>
                                                    <td colspan="5" class="text-center">لا توجد استمارات</td>
                                                </tr>
                                            @endforelse
                                        </tbody>
                                    </table>
                                </div>

                                <div class="mt-3">
                                    {{ $activites->links('pagination::bootstrap-5') }}
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
    </div>
</div>
@endsection

@section('scripts')
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeunesse-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });
    });

    function confirmEdit(url) {
        Swal.fire({
            title: 'هل تريد تعديل هذه الاستمارة؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    }

    function confirmDelete(form) {
        Swal.fire({
            title: 'هل تريد حذف هذه الاستمارة؟',
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }

    function confirmStatusChange(form, currentStatus) {
        Swal.fire({
            title: `هل تريد تغيير الحالة الحالية (${currentStatus})؟`,
            icon: 'question',
            showCancelButton: true,
            confirmButtonText: 'نعم',
            cancelButtonText: 'إلغاء'
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }
</script>
@endsection
