
@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('investissement_choix') }}">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('jeunesse2.index') }}">
                <span>تنظيم الأنشطة الترفيهية للشباب و الطفولة</span>
            </a>
        </li>
   <li class="breadcrumb-item active" aria-current="page">تعديل استمارة</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
    <form action="{{ route('jeunesse2.update', $activite->id_jeune_enfant) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')

       <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
     
        <h3>{{ $formulaire->type_ar }}</h3>

        <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="{{ old('nom_prenom', $activite->investissements->first()?->utilisateur->nom_prenom) }}" 
                            placeholder="الاسم و اللقب" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="{{ old('lieu_naissance', $activite->investissements->first()?->utilisateur->lieu_naissance) }}" 
                           placeholder="مكان الولادة">
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="{{ old('date_naissance', $activite->investissements->first()?->utilisateur->date_naissance) }}">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput3()">
                        <option value="" disabled>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}" 
                                {{ old('id_type_identite', $activite->investissements->first()?->utilisateur->id_type_identite) == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:{{ $activite->investissements->first()?->utilisateur->id_type_identite == 1 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="cin_input" name="cin" 
                           value="{{ old('cin', $activite->investissements->first()?->utilisateur->cin) }}" 
                           placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:{{ $activite->investissements->first()?->utilisateur->id_type_identite == 2 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="passport_input" name="passport" 
                           value="{{ old('passport', $activite->investissements->first()?->utilisateur->passport) }}" 
                           placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:{{ $activite->investissements->first()?->utilisateur->id_type_identite == 3 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" 
                           value="{{ old('num_fiscal', $activite->investissements->first()?->utilisateur->num_fiscal) }}" 
                           placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3" id="cin_extra_fields" style="display:{{ $activite->investissements->first()?->utilisateur->id_type_identite == 1 ? 'flex' : 'none' }};">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance_cin" name="date_delivrance_cin" 
                           value="{{ old('date_delivrance_cin', $activite->investissements->first()?->utilisateur->date_delivrance_cin) }}">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance_cin" name="lieu_delivrance_cin" 
                           value="{{ old('lieu_delivrance_cin', $activite->investissements->first()?->utilisateur->lieu_delivrance_cin) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="{{ old('adresse', $activite->investissements->first()?->utilisateur->adresse) }}" 
                           placeholder=" العنوان الشخصي " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="{{ old('niveau_etude', $activite->investissements->first()?->utilisateur->niveau_etude) }}" 
                           placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" 
                           value="{{ old('dernier_diplome', $activite->investissements->first()?->utilisateur->dernier_diplome) }}" 
                           placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" 
                           value="{{ old('experience', $activite->investissements->first()?->utilisateur->experience) }}" 
                           placeholder="الاقدمية في تعاطي النشاط" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات النشاط </h4>
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> تنظيم الأنشطة الترفيهية للشباب و الطفولة  </strong>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><strong>الإستثمار في هذا النشاط</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" name="id_statut_inv">
                        @foreach($statut_inv as $statut)
                            <option value="{{ $statut->id_status }}"
                                {{ old('id_statut_inv', $activite->id_statut_inv) == $statut->id_status ? 'selected' : '' }}>
                                {{ $statut->statut_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <label class="col-sm-2 col-form-label"><strong>طبيعة الأنشطة</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" name="id_nature_activite">
                        @foreach($nature as $nature)
                            <option value="{{ $nature->id_nature_ac }}"
                                {{ old('id_nature_activite', $activite->id_statut_inv) == $nature->id_nature_ac ? 'selected' : '' }}>
                                {{ $nature->nature_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" 
                        name="nom_projet" 
                        placeholder="الاسم التجاري للمشروع" 
                        maxlength="100"
                        value="{{ old('nom_projet', $activite->nom_projet ?? '') }}">
                </div>

                <label class="col-sm-2 col-form-label">عنوان المقر الاجتماعي</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" 
                        name="adresse_siege" 
                        placeholder="عنوان المقر الاجتماعي" 
                        maxlength="100"
                        value="{{ old('adresse_siege', $activite->adresse_siege ?? '') }}">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label"> الولاية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled {{ old('gouvernorat_id', $activite->id_gouvernorat ?? '') == '' ? 'selected' : '' }}>اختر...</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}" 
                                {{ old('gouvernorat_id', $activite->id_gouvernorat ?? '') == $gouv->id_gouver ? 'selected' : '' }}>
                                {{ $gouv->nom_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <label class="col-sm-2 col-form-label"> البلدية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id">
                        <option value="" disabled {{ old('delegation_id', $activite->id_delegation ?? '') == '' ? 'selected' : '' }}>اختر...</option>
                        @foreach($delegations as $deleg)
                            <option value="{{ $deleg->id_delegation }}" 
                                {{ old('delegation_id', $activite->id_delegation ?? '') == $deleg->id_delegation ? 'selected' : '' }}>
                                {{ $deleg->nom_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الترقيم البريدي </label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" 
                        name="code_postal"  value="{{ old('code_postal', $activite->code_postal ?? '') }}"  placeholder="أدخل الترقيم البريدي" >
                </div>
            </div>
        </div>

        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    @foreach($activite->investissements as $index => $inv)
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[{{ $index }}][secteur_invest_id]" id="secteur_invest_id_{{ $index }}">
                                <option value="" disabled>اختر...</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}" 
                                        {{ $inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : '' }}>
                                        {{ $secteur->secteur_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[{{ $index }}][montant_inv]" 
                                class="form-control" min=1 value="{{ $inv->montant_inv }}">
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[{{ $index }}][id_source_financement]" id="id_source_financement_{{ $index }}">
                                <option value="" disabled>اختر...</option>
                                @foreach($source_fin as $source)
                                    <option value="{{ $source->id_source }}" 
                                        {{ $inv->id_source_financement == $source->id_source ? 'selected' : '' }}>
                                        {{ $source->source_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[{{ $index }}][montant_fin]" 
                                class="form-control" min=1 value="{{ $inv->montant_fin }}">
                        </td>
                        <td class="action-buttons">
                           <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <button type="button" class="btn btn-success" onclick="addInvestissementRow()">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا...">{{ old('remarques', $activite->remarques) }}</textarea>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
       <div class="d-flex justify-content-end mb-4">
                              <button type="submit" class="btn btn-orange font-weight-medium" >
                    تحيين
                </button>
            </div>
          
        </div>
    </form>
</div>
</div>
<script>
    let investIndex = {{ count($activite->investissements) }}; 

    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($secteurs as $secteur)
                        <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="مبلغ الإستثمار">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($source_fin as $source)
                            <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                         @endforeach
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                <td class="action-buttons">
                   <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>
<script>document.addEventListener("DOMContentLoaded", function () {    const gouvSelect = document.getElementById('gouvernorat_id');    const delSelect  = document.getElementById('delegation_id');    gouvSelect.addEventListener('change', function () {        let gouvId = this.value;        delSelect.innerHTML = '';        delSelect.disabled = true;        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';        let url = "{{ route('delegations_jeunesse.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";        url = url.replace("ID_PLACEHOLDER", gouvId);        fetch(url)            .then(response => response.json())            .then(data => {                                delSelect.innerHTML = '<option disabled selected>اختر...</option>';                                data.forEach(d => {                    let option = document.createElement('option');                    option.value = d.id_delegation;                    option.text  = d.nom_ar;                    delSelect.appendChild(option);                });                delSelect.disabled = false;            });    });});</script>
@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection