@extends('layouts.app')

@section('content')


            <div class="it-about-3-area p-relative pt-30 pb-125">
                <img class="it-about-shape-1" src="assets/img/shape/about-1-1.png" alt="">
    <div class="container">
         <nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>{{ __('site.breadcrumb_home') }}</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('investissement_choix') }}">
                <span>{{ __('site.breadcrumb_investment') }}</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('site.project_spaces_title') }}</li>
    </ol>
</nav>


<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
      <div class="row">
                        <div class="col-xl-12">
                            <div class="it-section-title-box text-center mb-30" style="padding-top:20px;">
                                <span class="it-section-subtitle">{{ __('site.projects_subtitle') }}</span>
                                <h4 class="it-section-title it-split-in-right mb-0">{{ __('site.section_title_all_requests') }}</h4>
                            </div>
                        </div>
                    </div>

                    <div class="row justify-content-center">
                        <div class="col-lg-12">
                            <div class="card shadow-sm p-4">

                                {{-- Bouton ajouter --}}
                                <div class="d-flex justify-content-end mb-4">
                                    <a class="btn btn-success" href="{{ route('jeune_enfant.create') }}">
                                        <i class="la la-plus me-1"></i> {{ __('site.btn_add_request') }}
                                    </a>
                                </div>

                                {{-- Message de succès --}}
                                @if(session('success'))
                                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                                        {{ session('success') }}
                                        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="{{ __('site.confirm_cancel') }}"></button>
                                    </div>
                                @endif

                                {{-- Tableau --}}
                                 <div class="my-table table-responsive">
                                     <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
    <thead class="thead-light">
        <tr>
            <th width="5%">{{ __('site.table_id') }}</th>
            <th width="25%">{{ __('site.table_applicant') }}</th>
            <th width="25%">{{ __('site.table_project_nature') }}</th>
            <th width="15%">{{ __('site.table_status') }}</th>
            <th width="30%">{{ __('site.table_actions') }}</th>
        </tr>
    </thead>
    <tbody>
        @forelse($projets as $projet)
            <tr style="vertical-align: middle !important; text-align: center;">
                <td>{{ $projet->id_projet }}</td>

                <td>{{ $projet->investissements->first()?->utilisateur?->nom_prenom ?? __('site.not_specified') }}</td>

                {{-- nature du projet: use trans_field so it picks nature_ar / nature_fr / nature_en / nature_G --}}
                <td>
                    {{trans_field($projet->natureProjet, 'nature')
                        ?? __('site.not_specified')
                    }}
                </td>

                {{-- statut: use trans_field on the related statut record --}}
                <td>
                    @php
                        $statut = trans_field($projet->statut, 'statut') ?? __('site.status_en_attente');

                        $badgeClass = match($projet->id_statut) {
                            1 => 'status-badge--success',
                            3 => 'status-badge--danger',
                            default => 'status-badge--pending'
                        };
                    @endphp

                    <span class="status-badge {{ $badgeClass }}">{{ $statut }}</span>
                </td>

                <td class="text-center align-middle">
                    <div class="actions-cell d-inline-flex gap-2 flex-wrap justify-content-center align-items-center" role="group" aria-label="{{ __('site.table_actions') }}">
                        {{-- Voir --}}
                        <a href="{{ route('jeune_enfant.show', $projet->id_projet) }}"
                           class="btn-icon btn-icon--primary"
                           title="{{ __('site.btn_view') }}" aria-label="{{ __('site.btn_view') }}">
                            <i class="la la-eye"></i>
                        </a>

                        {{-- Modifier + Supprimer uniquement si statut == 2 --}}
                        @if($projet->id_statut == 2)
                            {{-- Modifier --}}
                            <button type="button"
                                    class="btn-icon btn-icon--warning"
                                    onclick="window.location='{{ route('jeune_enfant.edit', $projet->id_projet) }}'"
                                    title="{{ __('site.btn_edit') }}" aria-label="{{ __('site.btn_edit') }}">
                                <i class="la la-edit"></i>
                            </button>

                            {{-- Supprimer --}}
                            <form action="{{ route('jeune_enfant.destroy', $projet->id_projet) }}" method="POST" class="d-inline">
                                @csrf
                                @method('DELETE')
                                <button type="button"
                                        onclick="confirmDelete(this.closest('form'))"
                                        class="btn-icon btn-icon--danger"
                                        title="{{ __('site.btn_delete') }}" aria-label="{{ __('site.btn_delete') }}">
                                    <i class="la la-trash"></i>
                                </button>
                            </form>
                        @endif
                    </div>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="5" class="text-center">{{ __('site.no_forms') }}</td>
            </tr>
        @endforelse
    </tbody>
</table>

                                </div>

                                {{-- Pagination --}}
                                <div class="mt-3">
                                    {{ $projets->links('pagination::bootstrap-5') }}
                                </div>

                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

{{-- Scripts --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
    function confirmEdit(url) {
        Swal.fire({
            title: "{{ __('site.confirm_edit_title') }}",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: "{{ __('site.confirm_yes') }}",
            cancelButtonText: "{{ __('site.confirm_cancel') }}"
        }).then((result) => {
            if (result.isConfirmed) {
                window.location.href = url;
            }
        });
    }

    function confirmDelete(form) {
        Swal.fire({
            title: "{{ __('site.confirm_delete_title') }}",
            icon: 'warning',
            showCancelButton: true,
            confirmButtonText: "{{ __('site.confirm_yes') }}",
            cancelButtonText: "{{ __('site.confirm_cancel') }}"
        }).then((result) => {
            if (result.isConfirmed) {
                form.submit();
            }
        });
    }
</script>

<script src="{{ asset('assets/js/index.js') }}"></script>
{{-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script> --}}
@endsection
