@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>{{ __('site.breadcrumb_home') }}</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('investissement_choix') }}">
                <span>{{ __('site.breadcrumb_investment') }}</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{route('jeune_enfant.index') }}">
                <span>{{ __('site.project_spaces_title') }}</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">{{ __('site.page_show_form') }}</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4" action="{{ route('jeune_enfant.update', $projet->id_projet) }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
    @method('PUT') 
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
        <div class="text-center mb-4">

                     <h3 class="fw-bold">{{trans_field($formulaire, 'type')}}</h3>
        </div>

        <div class="form-section">
            <h4>{{ __('site.investment.form.label.identity.title') ?? __('site.investment') }}</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.investment.form.label.full_name') }}</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="{{ old('nom_prenom', $projet->investissements->first()?->utilisateur->nom_prenom) }}" 
                            placeholder="{{ __('site.investment.form.label.full_name') }}" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.place_of_birth') }}</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="{{ old('lieu_naissance', $projet->investissements->first()?->utilisateur->lieu_naissance) }}" 
                           placeholder="{{ __('site.place_of_birth') }}">
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.date_of_birth') }}</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="{{ old('date_naissance', $projet->investissements->first()?->utilisateur->date_naissance) }}">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">{{ __('site.identity_type_label') }}</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput3()">
                        <option value="" disabled>{{ __('site.investment.form.placeholder.choose') }}</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}" 
                                {{ old('id_type_identite', $projet->investissements->first()?->utilisateur->id_type_identite) == $type->id_type ? 'selected' : '' }}>
                                {{trans_field($type, 'type')}}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:{{ $projet->investissements->first()?->utilisateur->id_type_identite == 1 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="cin_input" name="cin" 
                           value="{{ old('cin', $projet->investissements->first()?->utilisateur->cin) }}" 
                           placeholder="{{ __('site.cin_placeholder') }}" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:{{ $projet->investissements->first()?->utilisateur->id_type_identite == 2 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="passport_input" name="passport" 
                           value="{{ old('passport', $projet->investissements->first()?->utilisateur->passport) }}" 
                           placeholder="{{ __('site.passport_placeholder') }}" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:{{ $projet->investissements->first()?->utilisateur->id_type_identite == 3 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" 
                           value="{{ old('num_fiscal', $projet->investissements->first()?->utilisateur->num_fiscal) }}" 
                           placeholder="{{ __('site.fiscal_id_placeholder') }}" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3" id="cin_extra_fields" style="display:{{ $projet->investissements->first()?->utilisateur->id_type_identite == 1 ? 'flex' : 'none' }};">
                <label class="col-sm-2 col-form-label">{{ __('site.cin_issue_date_label') }}</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance_cin" name="date_delivrance_cin" 
                           value="{{ old('date_delivrance_cin', $projet->investissements->first()?->utilisateur->date_delivrance_cin) }}">
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.cin_issue_place_label') }}</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance_cin" name="lieu_delivrance_cin" 
                           value="{{ old('lieu_delivrance_cin', $projet->investissements->first()?->utilisateur->lieu_delivrance_cin) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.personal_address') }}</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="{{ old('adresse', $projet->investissements->first()?->utilisateur->adresse) }}" 
                           placeholder="{{ __('site.personal_address') }}" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.education_level') }}</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="{{ old('niveau_etude', $projet->investissements->first()?->utilisateur->niveau_etude) }}" 
                           placeholder="{{ __('site.education_level') }}">
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.last_degree') }}</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" 
                           value="{{ old('dernier_diplome', $projet->investissements->first()?->utilisateur->dernier_diplome) }}" 
                           placeholder="{{ __('site.last_degree') }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.experience_label') }}</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" 
                           value="{{ old('experience', $projet->investissements->first()?->utilisateur->experience) }}" 
                           placeholder="{{ __('site.experience_label') }}" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>{{ __('site.project_characteristics') }}</h4>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_spectacle" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_spectacle" name="espace_spectacle" value="1"
                       {{ old('espace_spectacle', $projet->espace_spectacle) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_spectacle">
                    {{ __('site.espace_spectacle_label') }}
                </label>
            </div>
            <div class="mt-3" id="caracteristique_group" style="display:{{ $projet->espace_spectacle ? 'block' : 'none' }};">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_spec" placeholder="{{ __('site.characteristics_placeholder') }}" rows="3">{{ old('caracteristique_spec', $projet->caracteristique_spec) }}</textarea>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_sportif" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_sportif" name="espace_sportif" value="1"
                       {{ old('espace_sportif', $projet->espace_sportif) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_sportif">{{ __('site.espace_sportif_label') }}</label>
            </div>
            <div class="mt-3" id="caracteristique_sportif_group" style="display:{{ $projet->espace_sportif ? 'block' : 'none' }};">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_sportif" rows="3">{{ old('caracteristique_sportif', $projet->caracteristique_sportif) }}</textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_service" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_service" name="espace_activite_service" value="1"
                       {{ old('espace_activite_service', $projet->espace_activite_service) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_activite_service">{{ __('site.espace_service_label') }}</label>
            </div>
            <div class="mt-3" id="caracteristique_activite_serv_group" style="display:{{ $projet->espace_activite_service ? 'block' : 'none' }};">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_serv" rows="3">{{ old('caracteristique_activite_serv', $projet->caracteristique_activite_serv) }}</textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_culturelle" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_culturelle" name="espace_activite_culturelle" value="1"
                       {{ old('espace_activite_culturelle', $projet->espace_activite_culturelle) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_activite_culturelle">{{ __('site.espace_culturel_label') }}</label>
            </div>
            <div class="mt-3" id="caracteristique_activite_cult_group" style="display:{{ $projet->espace_activite_culturelle ? 'block' : 'none' }};">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_cult" rows="3">{{ old('caracteristique_activite_cult', $projet->caracteristique_activite_cult) }}</textarea>
            </div>
        </div>
        <div class="form-section mt-4">
            <h4>{{ __('site.table_project_nature') }}</h4>
            <div class="row align-items-center">
                <div class="col-sm-2">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">{{ __('site.select_project_nature') }}</label>
                </div>
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled>{{ __('site.investment.form.placeholder.choose') }}</option>
                        @foreach($naturesProjet as $nature)
                            <option value="{{ $nature->id_nature_p }}" 
                                {{ old('nature_projet_id', $projet->nature_projet_id) == $nature->id_nature_p ? 'selected' : '' }}>
                                {{trans_field($nature, 'nature')}}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>{{ __('site.number_positions_title') }}</h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.holders_degree_label') }}</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_diplome_universitaire" 
                           value="{{ old('nbr_diplome_universitaire', $projet->nbr_diplome_universitaire) }}" 
                           placeholder="{{ __('site.holders_degree_label') }}">
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.others_label') }}</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_autre" 
                           value="{{ old('nbr_autre', $projet->nbr_autre) }}" placeholder="{{ __('site.others_label') }}">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>{{ __('site.director_title') }}</h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.investment.form.label.full_name') }}</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" 
                           value="{{ old('nom_prenom_d', $projet->directeur->nom_prenom_d) }}" maxlength="50">
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.cin_label') }}</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" 
                           value="{{ old('num_cin', $projet->directeur->num_cin) }}" maxlength="8">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.cin_issue_date_label') }}</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" name="date_delivrance" 
                           value="{{ old('date_delivrance', $projet->directeur->date_delivrance) }}">
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.cin_issue_place_label') }}</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="lieu_delivrance" 
                           value="{{ old('lieu_delivrance', $projet->directeur->lieu_delivrance) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.education_level') }}</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="{{ old('niveau_etude', $projet->directeur->niveau_etude) }}">
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.last_degree') }}</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome_obtenu" 
                           value="{{ old('dernier_diplome_obtenu', $projet->directeur->dernier_diplome_obtenu) }}">
                </div>
            </div>
        </div>

        <h4>{{ __('site.investment_finance_title') }}</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>{{ __('site.investment_label') }}</th>
                        <th>{{ __('site.amount_label') }}</th>
                        <th>{{ __('site.fund_sources_label') }}</th>
                        <th>{{ __('site.notes_label') }}</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    @foreach($projet->investissements as $index => $inv)
                    <tr>
                        <td data-label="{{ __('site.investment_label') }}">
                            <select class="form-control" name="investissements[{{ $index }}][secteur_invest_id]">
                                <option value="" disabled>{{ __('site.investment.form.placeholder.choose') }}</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}" 
                                        {{ $inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : '' }}>
                                        {{trans_field($secteur, 'secteur')}}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="{{ __('site.amount_label') }}">
                            <input type="number" name="investissements[{{ $index }}][montant_inv]" class="form-control" value="{{ $inv->montant_inv }}">
                        </td>
                        <td data-label="{{ __('site.fund_sources_label') }}">
                            <input type="text" name="investissements[{{ $index }}][source]" class="form-control" value="{{ $inv->source }}" maxlength="100">
                        </td>
                        <td data-label="{{ __('site.notes_label') }}">
                            <input type="text" name="investissements[{{ $index }}][remarques]" class="form-control" value="{{ $inv->remarques }}" maxlength="200">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>{{ __('site.btn_delete') ?? 'حذف' }}</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
            <button type="button" class="btn btn-success" onclick="addInvestissementRow()">
                {{ __('site.btn_add_request') ?? 'إضافة صف' }}
            </button>
        </div>

        <span class="text-muted">{{ __('site.funds_examples') }}</span>

        <div class="mt-3">
            <h4>{{ __('site.declaration_title') }}</h4>
            <span>
                {{ __('site.declaration_text') }}
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4>{{ __('site.remarks_title') }}</h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="{{ __('site.write_remarks_placeholder') }}">{{ old('remarques', $projet->remarques) }}</textarea>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-orange font-weight-medium" style="width:100px;margin-right:250px;">{{ __('site.profile_save_button') }}</button>
            </div>
           
        </div>
    </form>
</div>
</div>
<script>
document.addEventListener("DOMContentLoaded", function() {
    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
        textareaGroup.style.display = checkbox.checked ? "block" : "none";
        checkbox.addEventListener("change", function() {
            textareaGroup.style.display = this.checked ? "block" : "none";
        });
    }
    toggleTextarea("espace_spectacle", "caracteristique_group");
    toggleTextarea("espace_sportif", "caracteristique_sportif_group");
    toggleTextarea("espace_activite_service", "caracteristique_activite_serv_group");
    toggleTextarea("espace_activite_culturelle", "caracteristique_activite_cult_group");
});
</script>

<script>
let investIndex = {{ $projet->investissements->count() }};
function addInvestissementRow() {
    let tableBody = document.getElementById('investissement-body');
    let newRow = `
        <tr>
            <td data-label="${'{{ __('site.investment_label') }}'}">
                <select class="form-control" name="investissements[\${investIndex}][secteur_invest_id]">
                    <option value="" disabled selected>{{ __('site.investment.form.placeholder.choose') }}</option>
                    @foreach($secteurs as $secteur)
                        <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                    @endforeach
                </select>
            </td>
            <td data-label="${'{{ __('site.amount_label') }}'}">
                <input type="number" name="investissements[\${investIndex}][montant_inv]" class="form-control" placeholder="{{ __('site.amount_label') }}">
            </td>
            <td data-label="${'{{ __('site.fund_sources_label') }}'}">
                <input type="text" name="investissements[\${investIndex}][source]" class="form-control" placeholder="{{ __('site.fund_sources_label') }}" maxlength="100">
            </td>
            <td data-label="${'{{ __('site.notes_label') }}'}">
                <input type="text" name="investissements[\${investIndex}][remarques]" class="form-control" placeholder="{{ __('site.notes_label') }}" maxlength="200">
            </td>
            <td class="action-buttons">
                <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>{{ __('site.btn_delete') ?? 'حذف' }}</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    investIndex++;
}

function removeRow(button) {
    let row = button.closest('tr');
    row.remove();
}
</script>

@else
<script>
    window.location.href = "{{ route('login') }}";
</script>
@endif
@endsection
