@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
    <nav class="breadcrumb-nav" aria-label="breadcrumb">
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item">
                <a href="{{ route('dashboard') }}">
                    <i class="bi bi-house-fill"></i>
                    <span>{{ __('site.breadcrumb_home') }}</span>
                </a>
            </li>
            <li class="breadcrumb-item">
                <a href="{{ route('investissement_choix') }}">
                    <span>{{ __('site.breadcrumb_investment') }}</span>
                </a>
            </li>
            <li class="breadcrumb-item">
                <a href="{{ route('jeune_enfant.index') }}">
                    <span>{{ __('site.project_spaces_title') }}</span>
                </a>
            </li>
            <li class="breadcrumb-item active" aria-current="page">{{ __('site.add_form_title') }}</li>
        </ol>
    </nav>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">

    <form class="card shadow-sm p-4" action="{{ route('jeune_enfant.store') }}" method="POST" enctype="multipart/form-data" lang="{{ app()->getLocale() }}">
        @csrf
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">

        <div class="text-center mb-4">
            <h3 class="fw-bold">
                {{-- preserve DB value, but show as fallback --}}
                {{ $formulaire->{"type_" . (app()->getLocale() === 'ar' ? 'ar' : (app()->getLocale() === 'fr' ? 'fr' : 'en'))} ?? $formulaire->type_ar }}
            </h3>
        </div>

        <div class="form-section">
            <h4>{{ __('site.form_section_investor') }}</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_full_name') }}</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" value="{{ old('nom_prenom', Auth::user()->nom_prenom ?? '') }}" readonly>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_birth_place') }}</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="lieu_naissance" value="{{ old('lieu_naissance', Auth::user()->lieu_naissance ?? '') }}" readonly>
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.label_birth_date') }}</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" name="date_naissance" value="{{ old('date_naissance', Auth::user()->date_naissance ?? '') }}" readonly>
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">{{ __('site.label_identity') }}</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control"
                        value="{{ Auth::user()->{"typeIdentite"}?->{ 'type_' . (app()->getLocale() === 'ar' ? 'ar' : (app()->getLocale() === 'fr' ? 'fr' : 'en'))} ?? Auth::user()->typeIdentite->type_ar ?? '' }}"
                        readonly>
                </div>

                @php $user = Auth::user(); @endphp

                @if($user->id_type_identite == 1)
                    <div class="col-sm-6">
                        <input type="text" class="form-control" value="{{ $user->cin ?? '' }}" readonly>
                    </div>
                @elseif($user->id_type_identite == 2)
                    <div class="col-sm-6">
                        <input type="text" class="form-control" value="{{ $user->passport ?? '' }}" readonly>
                    </div>
                @elseif($user->id_type_identite == 3)
                    <div class="col-sm-6">
                        <input type="text" class="form-control" value="{{ $user->num_fiscal ?? '' }}" readonly>
                    </div>
                @endif
            </div>

            @if($user->id_type_identite == 1)
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_issue_date') }}</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control"
                        value="{{ $user->date_delivrance_cin ? \Carbon\Carbon::parse($user->date_delivrance_cin)->format('Y-m-d') : '' }}"
                        readonly>
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.label_issue_place') }}</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" value="{{ $user->lieu_delivrance_cin ?? '' }}" readonly>
                </div>
            </div>
            @endif

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_address') }}</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" value="{{ old('adresse', Auth::user()->adresse ?? '') }}" readonly>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_education_level') }}</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" value="{{ old('niveau_etude', Auth::user()->niveau_etude ?? '') }}" readonly>
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.label_last_degree') }}</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" value="{{ old('dernier_diplome', Auth::user()->dernier_diplome ?? '') }}" readonly>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_experience') }}</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" value="{{ old('experience', Auth::user()->experience ?? '') }}" readonly>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>{{ __('site.features_title') }}</h4>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_spectacle" value="0">
                <input class="form-check-input me-2" type="checkbox" id="espace_spectacle" name="espace_spectacle" value="1">
                <label class="col-sm-6 col-form-label" for="espace_spectacle">{{ __('site.espace_spectacle') }}</label>
            </div>
            <div class="mt-3" id="caracteristique_group" style="display:none;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_spec" placeholder="{{ __('site.caracteristique_placeholder') }}" rows="3"></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_sportif" value="0">
                <input class="form-check-input me-2" type="checkbox" id="espace_sportif" name="espace_sportif" value="1">
                <label class="col-sm-6 col-form-label" for="espace_sportif">{{ __('site.espace_sportif') }}</label>
            </div>
            <div class="mt-3" id="caracteristique_sportif_group" style="display:none;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_sportif" placeholder="{{ __('site.caracteristique_placeholder') }}" rows="3"></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_service" value="0">
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_service" name="espace_activite_service" value="1">
                <label class="col-sm-6 col-form-label" for="espace_activite_service">{{ __('site.espace_service') }}</label>
            </div>
            <div class="mt-3" id="caracteristique_activite_serv_group" style="display:none;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_serv" placeholder="{{ __('site.caracteristique_placeholder') }}" rows="3"></textarea>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_activite_culturelle" value="0">
                <input class="form-check-input me-2" type="checkbox" id="espace_activite_culturelle" name="espace_activite_culturelle" value="1">
                <label class="col-sm-6 col-form-label" for="espace_activite_culturelle">{{ __('site.espace_culturel') }}</label>
            </div>
            <div class="mt-3" id="caracteristique_activite_cult_group" style="display:none;">
                <textarea class="form-control shadow-sm rounded-3" name="caracteristique_activite_cult" placeholder="{{ __('site.caracteristique_placeholder') }}" rows="3"></textarea>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>{{ __('site.project_nature_title') }}</h4>
            <div class="row align-items-center">
                <div class="col-sm-2">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">{{ __('site.choose_nature') }}</label>
                </div>

                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled selected>{{ __('site.choose_placeholder') }}</option>
                        @foreach($naturesProjet as $nature)
                            <option value="{{ $nature->id_nature_p }}">
                                {{ $nature->{ 'nature_' . (app()->getLocale() === 'ar' ? 'ar' : (app()->getLocale() === 'fr' ? 'fr' : 'en')) } ?? $nature->nature_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>{{ __('site.number_places_expected') }}</h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.nbr_diplome_universitaire_label') }}</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_diplome_universitaire" placeholder="{{ __('site.nbr_diplome_universitaire_placeholder') }}">
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.nbr_autre_label') }}</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" name="nbr_autre" placeholder="{{ __('site.nbr_autre_placeholder') }}">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4>{{ __('site.section_manager_title') }}</h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_director_name') }}</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" placeholder="{{ __('site.label_director_name') }}" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_director_cin') }}</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" maxlength="8" placeholder="{{ __('site.label_director_cin') }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_issue_date') }}</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance" name="date_delivrance" placeholder="{{ __('site.label_issue_date') }}">
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.label_issue_place') }}</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance" name="lieu_delivrance" placeholder="{{ __('site.label_issue_place') }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">{{ __('site.label_education_level') }}</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" placeholder="{{ __('site.label_education_level') }}">
                </div>

                <label class="col-sm-2 col-form-label">{{ __('site.label_last_degree') }}</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome_obtenu" placeholder="{{ __('site.label_last_degree') }}">
                </div>
            </div>
        </div>

        <h4>{{ __('site.investment_financing_title') }}</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>{{ __('site.investment_table_invest') }}</th>
                        <th>{{ __('site.investment_table_amount') }}</th>
                        <th>{{ __('site.investment_table_sources') }}</th>
                        <th>{{ __('site.investment_table_remarks') }}</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <tr>
                        <td data-label="{{ __('site.investment_table_invest') }}">
                            <select class="form-control" name="investissements[0][secteur_invest_id]" id="secteur_invest_id_0">
                                <option value="" disabled selected>{{ __('site.choose_placeholder') }}</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}">
                                        {{ $secteur->{ 'secteur_' . (app()->getLocale() === 'ar' ? 'ar' : (app()->getLocale() === 'fr' ? 'fr' : 'en')) } ?? $secteur->secteur_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="{{ __('site.investment_table_amount') }}">
                            <input type="number" name="investissements[0][montant_inv]" class="form-control" placeholder="{{ __('site.investment_table_amount') }}">
                        </td>
                        <td data-label="{{ __('site.investment_table_sources') }}">
                            <input type="text" name="investissements[0][source]" class="form-control" placeholder="{{ __('site.investment_table_sources') }}" maxlength="100">
                        </td>
                        <td data-label="{{ __('site.investment_table_remarks') }}">
                            <input type="text" name="investissements[0][remarques]" class="form-control" placeholder="{{ __('site.investment_table_remarks') }}" maxlength="200">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)">{{ __('site.delete') }}</button>
                        </td>
                    </tr>
                </tbody>
            </table>

            <button type="button" class="btn btn-success" onclick="addInvestissementRow()">
                {{ __('site.add_row') }}
            </button>
        </div>

        <span class="text-muted">{{ __('site.financing_hint') }}</span>

        <div class="mt-3">
            <h4>{{ __('site.declaration_title') }}</h4>
            <span>{{ __('site.declaration_text') }}</span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4>{{ __('site.remarks_title') }}</h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="{{ __('site.remarks_placeholder') }}"></textarea>
        </div>

        <div class="form-group row text-center" style="padding-top:50px;">
            <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-success font-weight-medium">{{ __('site.form_submit') }}</button>
            </div>
        </div>
    </form>
    </div>
</div>

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeune-enfant-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });

        // Initialiser les toggles des zones de texte
        initializeToggles();
    });

    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;

        const updateVisibility = () => {
            textareaGroup.style.display = checkbox.checked ? 'block' : 'none';
        };

        checkbox.addEventListener('change', updateVisibility);
        updateVisibility(); // État initial
    }

    function initializeToggles() {
        toggleTextarea('espace_spectacle', 'caracteristique_group');
        toggleTextarea('espace_sportif', 'caracteristique_sportif_group');
        toggleTextarea('espace_activite_service', 'caracteristique_activite_serv_group');
        toggleTextarea('espace_activite_culturelle', 'caracteristique_activite_cult_group');
    }

    let investIndex = 1;
    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="${@json(__('site.investment_table_invest'))}">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>{{ __('site.choose_placeholder') }}</option>
                        @foreach($secteurs as $secteur)
                            <option value="{{ $secteur->id_secteur }}">{{ $secteur->{ 'secteur_' . (app()->getLocale() === 'ar' ? 'ar' : (app()->getLocale() === 'fr' ? 'fr' : 'en')) } ?? $secteur->secteur_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="${@json(__('site.investment_table_amount'))}">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" placeholder="{{ __('site.investment_table_amount') }}">
                </td>
                <td data-label="${@json(__('site.investment_table_sources'))}">
                    <input type="text" name="investissements[${investIndex}][source]" class="form-control" placeholder="{{ __('site.investment_table_sources') }}" maxlength="100">
                </td>
                <td data-label="${@json(__('site.investment_table_remarks'))}">
                    <input type="text" name="investissements[${investIndex}][remarques]" class="form-control" placeholder="{{ __('site.investment_table_remarks') }}" maxlength="200">
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)">{{ __('site.delete') }}</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        if (row) row.remove();
    }
</script>

<script src="{{ asset('assets/js/index.js') }}"></script>
{{-- <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script> --}}
@endsection

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif

@endsection
