@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125" >
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>{{ __('site.investment.breadcrumb.home') }}</span>
            </a>
        </li>

         <li class="breadcrumb-item">
            <a href="{{ route('formation.index') }}">
                <span>مركز التربصات و تكوين الرياضيين</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">عرض إستمارة</li>
    </ol>
</nav>
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4" action="{{ route('formation.update', $formation->id_inv_sport) }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
    @method('PUT')
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
    
        <h3>{{ $formulaire->type_ar }}</h3>
<br>
        <div>
            <div class="d-flex align-items-center mb-3">
                <h5 class="mb-0 fw-bold me-2">   الوضعية الحالية: </h5>
                @if($formation->id_statut == 1)
                    <span><strong> قبول </strong></span>
                @elseif($formation->id_statut == 3)
                    <span><strong> رفض </strong></span>
                @else
                    <span><strong> في الانتظار </strong></span>
                @endif
            </div>

            @if($formation->id_statut == 3 && !empty($formation->commentaire_motif))
                <div class="d-flex align-items-center mb-3">
                    <label class="fw-bold text-danger me-2 mb-0">سبب الرفض:</label>
                    <p class="mb-0 border p-2 rounded shadow-sm text-muted">{{ $formation->commentaire_motif }}</p>
                </div>
            @endif
        </div>

        <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">{{ $formation->investissements->first()?->utilisateur->nom_prenom ?? '-' }}</div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->investissements->first()?->utilisateur->lieu_naissance ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->investissements->first()?->utilisateur->date_naissance ?? '-' }}
                    </div>
                </div>
            </div>
            
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        {{ $formation->investissements->first()?->utilisateur->adresse ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->investissements->first()?->utilisateur->niveau_etude ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->investissements->first()?->utilisateur->dernier_diplome ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاقدمية في تعاطي النشاط</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        {{ $formation->investissements->first()?->utilisateur->experience ?? '-' }}
                    </div>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات المشروع </h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> المكونات  </strong>
                    </label>
                </div>
            </div>

            <div class="row align-items-center mb-3">
                <div class="col-sm-4">
                    <label class="col-sm-10 col-form-label">
                        <strong> الرجاء الاختيار </strong>
                    </label>
                </div>

                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $types_espace_es->firstWhere('id_type_es', $formation->type_espace_s_id)?->type_ar ?? 'غير محدد' }}
                    </div>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u> مميزات الفضاء  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عدد الغرف</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->nbr_chambre ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">عدد القاعات</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->nbr_salles ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عدد الملاعب</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->nbr_stade ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">عدد حجرات الملابس</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->nbr_vestiaire ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عدد مسالك الرياضية</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->nbr_stages_sportifs ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">قاعة تقوية العضلات</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->nbr_salle_renforcement_musculaire ?? '-' }}
                    </div>
                </div>
            </div>


            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>طاقة الاستعاب</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">بالمبيت</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->capacite_accueil_foyer ?? '-' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">الملاعب و فضاءات التنشيط</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->capacite_accueil_stade ?? '-' }}
                    </div>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <u> الخدمات التي تؤمنها المؤسسة  </u>
                    </label>
                </div>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_rest" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_rest" name="heberg_rest" value="1" disabled
                    {{ old('heberg_rest', $formation->heberg_rest) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="heberg_rest">
                    الإقامة والتغذية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="stage_activ" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="stage_activ" name="stage_activ" value="1" disabled
                    {{ old('stage_activ', $formation->stage_activ) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="stage_activ">
                    إيواء التربصات والأنشطة التكوينية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_exercice" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_exercice" name="espace_exercice" value="1" disabled
                    {{ old('espace_exercice', $formation->espace_exercice) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="espace_exercice">
                    فضاء التمارين
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="activite_culturel" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="activite_culturel" name="activite_culturel" value="1" disabled
                    {{ old('activite_culturel', $formation->activite_culturel) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="activite_culturel">
                    التنشيط الثقافي
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="manifestation_sportif" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="manifestation_sportif" name="manifestation_sportif" disabled value="1"
                    {{ old('manifestation_sportif', $formation->manifestation_sportif) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="manifestation_sportif">
                    التظاهرات الرياضية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="autres" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="autres" name="autres" value="1" disabled
                    {{ old('autres', $formation->autres) ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="autres">
                    غير ذلك
                </label>

                <div id="autres_services_wrapper" class="d-flex align-items-center">
                    <div class="form-control form-control-sm bg-white border-0" style="min-width: 300px;" dir="rtl">
                        {{ $formation->autres_services ?? 'غير محدد' }}
                    </div>
                </div>

            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->nom_projet ?? 'غير محدد' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">طبيعة المشروع</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $nature_projet->firstWhere('id_nature_p', $formation->nature_projet_id)?->nature_ar ?? 'غير محدد' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عدد مواطن الشغل</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->nbr_emplois ?? 'غير محدد' }}
                    </div>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>مدير المؤسسة</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        {{ $formation->directeur->nom_prenom_d ?? 'غير محدد' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        {{ $formation->directeur->num_cin ?? 'غير محدد' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->directeur->date_delivrance ?? 'غير محدد' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->directeur->lieu_delivrance ?? 'غير محدد' }}
                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->directeur->niveau_etude ?? 'غير محدد' }}
                    </div>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        {{ $formation->directeur->dernier_diplome_obtenu ?? 'غير محدد' }}
                    </div>
                </div>
            </div>

                    <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-section mt-4">
            <table class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($formation->investissements as $inv)
                    <tr>
                        <td>
                            {{ $secteurs->firstWhere('id_secteur', $inv->secteur_invest_id)?->secteur_ar ?? 'غير محدد' }}
                        </td>
                        <td>{{ $inv->montant_inv ?? 'غير محدد' }}</td>
                        <td>
                            {{ $source_fin->firstWhere('id_source', $inv->id_source_financement)?->source_ar ?? 'غير محدد' }}
                        </td>
                        <td>{{ $inv->montant_fin ?? 'غير محدد' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</h4>
            <textarea class="form-control mt-2 bg-white" name="remarques" readonly rows="6" placeholder="اكتب ملاحظاتك هنا...">{{ old('remarques', $formation->remarques) }}</textarea>
        </div>

        <div class="form-group row justify-content-center action-buttons d-print-none" style="padding-top:50px;">
            <div class="col-auto">
                <button type="button" onclick="window.print()" class="btn btn-outline-success stylish-btn">
                    <i class="fa fa-print me-2"></i> طباعة 
                </button>
            </div>
           
        </div>

    </form>
</div>
</div>
@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection