@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
        <li class="breadcrumb-item">
            <a href="{{ route('dashboard') }}">
                <i class="bi bi-house-fill"></i>
                <span>الرئيسية</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('investissement_choix') }}">
                <span>الاستثمار</span>
            </a>
        </li>
        <li class="breadcrumb-item">
            <a href="{{ route('formation.index') }}">
                <span>مركز التربصات و تكوين الرياضيين</span>
            </a>
        </li>
        <li class="breadcrumb-item active" aria-current="page">إضافة استمارة</li>
    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
	<form class="card shadow-sm p-4" action="{{ route('formation.store') }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
     

        <h3>{{ $formulaire->type_ar }}</h3>
        <div class="form-section">
            <h4>المستثمر</h4>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" value="{{ old('nom_prenom', Auth::user()->nom_prenom ?? '') }}" readonly>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="lieu_naissance" value="{{ old('lieu_naissance', Auth::user()->lieu_naissance ?? '') }}" readonly>
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" name="date_naissance"  value="{{ old('date_naissance', Auth::user()->date_naissance ?? '') }}" readonly>
                </div>
            </div>
            
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" value="{{ old('adresse', Auth::user()->adresse ?? '') }}" readonly>
                </div>
            </div>      

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" value="{{ old('niveau_etude', Auth::user()->niveau_etude ?? '') }}" readonly>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" value="{{ old('dernier_diplome', Auth::user()->dernier_diplome ?? '') }}" readonly>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" value="{{ old('experience', Auth::user()->experience ?? '') }}" readonly>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات المشروع </h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> المكونات  </strong>
                    </label>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-2">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <strong> الرجاء الاختبار </strong>
                    </label>
                </div>
        
                <div class="col-sm-4">
                    <select required class="form-control" id="type_espace_s_id" name="type_espace_s_id">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($types_espace_es as $type)
                            <option value="{{ $type->id_type_es }}">
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>


            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u> مميزات الفضاء  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الغرف </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_chambre" name="nbr_chambre" min=1>
                </div>

                <label class="col-sm-2 col-form-label"> عدد القاعات </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_salles" name="nbr_salles" min=1>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الملاعب </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_stade" name="nbr_stade" min=1>
                </div>

                <label class="col-sm-2 col-form-label"> عدد حجرات الملابس </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_vestiaire" name="nbr_vestiaire" min=1>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد مسالك الرياضية </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_stages_sportifs" name="nbr_stages_sportifs" min=1>
                </div>

                <label class="col-sm-2 col-form-label"> قاعة تقوية العضلات </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_salle_renforcement_musculaire" name="nbr_salle_renforcement_musculaire" min=1>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>طاقة الاستعاب</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  بالمبيت </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_foyer" name="capacite_accueil_foyer" min=1>
                </div>

                <label class="col-sm-2 col-form-label">  الملاعب و فضاءات التنشيط  </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_stade" name="capacite_accueil_stade" min=1>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <u> الخدمات التي تؤمنها المؤسسة  </u>
                    </label>
                </div>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_rest" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_rest" name="heberg_rest" value="1">
                <label class="col-sm-6 col-form-label" for="heberg_rest">
                 الإقامة والتغذية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="stage_activ" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="stage_activ" name="stage_activ" value="1">
                <label class="col-sm-6 col-form-label" for="stage_activ">
                إيواء التربصات والأنشطة التكوينية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="espace_exercice" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="espace_exercice" name="espace_exercice" value="1">
                <label class="col-sm-6 col-form-label" for="espace_exercice">
                    فضاء التمارين
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="activite_culturel" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="activite_culturel" name="activite_culturel" value="1">
                <label class="col-sm-6 col-form-label" for="activite_culturel">
                التنشيط الثقافي
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="manifestation_sportif" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="manifestation_sportif" name="manifestation_sportif" value="1">
                <label class="col-sm-6 col-form-label" for="manifestation_sportif">
                  التظاهرات الرياضية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="autres" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="autres" name="autres" value="1">
                <label class="col-sm-6 col-form-label" for="autres">
                 غير ذلك
                </label>

                <div id="autres_services_wrapper" class="d-none">
                    <input
                        class="form-control form-control-sm"
                        type="text"
                        id="autres_services"
                        name="autres_services"
                        placeholder="أدخل الخدمة الأخرى"
                        dir="rtl"
                        value="{{ old('autres_services', $activite->autres_services ?? '') }}"
                        style="min-width: 300px;"
                    >
                </div>
            </div>

            <script>
                document.addEventListener('DOMContentLoaded', function () {
                    const checkbox = document.getElementById('autres');
                    const wrapper  = document.getElementById('autres_services_wrapper');

                    if (!checkbox || !wrapper) return; 

                    function toggleAutres() {
                        if (checkbox.checked) {
                            wrapper.classList.remove('d-none'); 
                            wrapper.classList.add('d-flex', 'align-items-center');
                        } else {
                            wrapper.classList.add('d-none'); 
                            wrapper.classList.remove('d-flex', 'align-items-center');
                        }
                    }
                    checkbox.addEventListener('change', toggleAutres);
                    toggleAutres();
                });
            </script>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" placeholder="الاسم التجاري للمشروع " maxlength="50">
                </div>
                <label class="col-sm-2 col-form-label" for="nature_projet_id">طبيعة المشروع</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($nature_projet as $nature)
                            <option value="{{ $nature->id_nature_p }}">
                                {{ $nature->nature_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  عدد مواطن الشغل </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_emplois" name="nbr_emplois" min=1>
                </div>
            </div>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>  مدير المؤسسة  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" placeholder="الاسم و اللقب   " maxlength="50">
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية  </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" maxlength="8">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance" name="date_delivrance" placeholder="تاريخ إصدار البطاقة">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance" name="lieu_delivrance" placeholder="مكان الإصدار">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome_obtenu" placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>
        </div>

        <h4>جدول الاستثمار _ التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>  مبلغ الإستثمار </th>
                        <th> التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[0][secteur_invest_id]" id="secteur_invest_id_0">
                                <option value="" disabled selected>اختر...</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[0][montant_inv]" class="form-control" min=1>
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[0][id_source_financement]" id="id_source_financement">
                                <option value="" disabled selected>اختر...</option>
                                @foreach($source_fin as $source)
                                    <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[0][montant_fin]" class="form-control" min=1>
                        </td>
                          <td class="action-buttons">
                            <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                        </td>
                    </tr>
                </tbody>
            </table>
            <button type="button" class="btn btn-success" onclick="addInvestissementRow()">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا..."></textarea>
        </div>

         <div class="form-group row text-center" style="padding-top:50px;">
          <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-success font-weight-medium" >إرسال</button>
            </div>
          
        </div>
    </form>
</div>
            </div>


<script>
    document.addEventListener("DOMContentLoaded", function() {
    function toggleTextarea(checkboxId, textareaGroupId) {
        const checkbox = document.getElementById(checkboxId);
        const textareaGroup = document.getElementById(textareaGroupId);
        if (!checkbox || !textareaGroup) return;
            textareaGroup.style.display = checkbox.checked ? "block" : "none";
            checkbox.addEventListener("change", function() {
                textareaGroup.style.display = this.checked ? "block" : "none";
            });
        }
        toggleTextarea("espace_spectacle", "caracteristique_group");
        toggleTextarea("espace_sportif", "caracteristique_sportif_group");
        toggleTextarea("espace_activite_service", "caracteristique_activite_serv_group");
        toggleTextarea("espace_activite_culturelle", "caracteristique_activite_cult_group");

    });
</script>

<script>
    let investIndex = 1; 
    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($secteurs as $secteur)
                            <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="الإستثمارالمبلغ ">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($source_fin as $source)
                            <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                  <td class="action-buttons">
                            <button type="button" class="btn-icon btn-icon--danger" onclick="removeRow(this)"><i class="la la-trash"></i>حذف</button>
                        </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>
<script src="{{ asset('BackOfficeAR/js/script.js') }}"></script>
@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection