@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')


@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
   <li class="breadcrumb-item">
    <a href="{{ route('dashboard') }}">
        <i class="bi bi-house-fill"></i>
        <span>{{ __('site.investment.breadcrumb.home') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
    <a href="{{ route('investissement_choix') }}">
        <span>{{ __('site.investment.breadcrumb.index') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
            <a href="{{ route('exoneration_choix') }}">
                <span>مشاريع الإعفاء الجبائي</span>
            </a>
        </li>
		<li class="breadcrumb-item">
    <a href="{{ route('exoneration.index') }}">
        <span>قائمة المشاريع</span>
    </a>
</li>
<li class="breadcrumb-item active" aria-current="page">{{ __('site.investment.breadcrumb.modif_exo') }}</li>

    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4" action="{{ route('exoneration.update', $document->id_doc) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
        <input type="hidden" name="id_type_formulaire" value="{{ $formulaire2?->id_type }}">       
      
        <h4 style="text-align:center;padding-top:20px;">إستمارة تسجيل الإنتفاع بإعفاء جبائي</h4>
        <br>
        <div class="form-section">
            <h4>هوية صاحب المشروع</h4>

            <div class="form-group row mb-3" style="padding-top:20px;">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_prenom" maxlength="50"
                           value="{{ old('nom_prenom', $document->utilisateur->nom_prenom) }}">
                </div>

                <label class="col-sm-2 col-form-label"> رقم الهاتف </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="tel"
                           value="{{ old('tel', $document->utilisateur->tel) }}">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput4()">
                        <option value="" disabled>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}" {{ $document->utilisateur->id_type_identite == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="{{ $document->utilisateur->cin ? '' : 'display:none;' }}">
                    <input type="text" class="form-control" id="cin_input" name="cin" placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8"
                           value="{{ old('cin', $document->utilisateur->cin) }}">
                </div>
                <div class="col-sm-6" id="passport_field" style="{{ $document->utilisateur->passport ? '' : 'display:none;' }}">
                    <input type="text" class="form-control" id="passport_input" name="passport" placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12"
                           value="{{ old('passport', $document->utilisateur->passport) }}">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="{{ $document->utilisateur->num_fiscal ? '' : 'display:none;' }}">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12"
                           value="{{ old('num_fiscal', $document->utilisateur->num_fiscal) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="adresse" maxlength="50"
                           value="{{ old('adresse', $document->utilisateur->adresse) }}">
                </div>

                <label class="col-sm-2 col-form-label"> البريد الالكتروني </label>
                <div class="col-sm-4">
                    <input required type="email" class="form-control" name="email"
                           value="{{ old('email', $document->utilisateur->email) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عنوان المشروع  </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet"
                           value="{{ old('nom_projet', $document->nom_projet) }}">
                </div>

                <label class="col-sm-2 col-form-label"> مكان المشروع </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="adresse_projet"
                           value="{{ old('adresse_projet', $document->adresse_projet) }}">
                </div>
            </div>

        </div>

        <div class="form-section mt-4">
    <h4> إضافة الوثائق المطلوبة </h4>

    {{-- 1 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">1- نسخة من كراس الشروط</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="copie_cahier_des_charges">
            @if(!empty($document->copie_cahier_des_charges))
                <a href="{{ asset('storage/'.$document->copie_cahier_des_charges) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>
    <span> مؤشر عليها في جميع صفحاتها ...</span>

    {{-- 2 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">2- الاصل من شهادة ايداع التصريح</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="copie_originale">
            @if(!empty($document->copie_originale))
                <a href="{{ asset('storage/'.$document->copie_originale) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>
    <span> مسلمة من قبل مصالح وكالة النهوض بالصناعة ...</span>

    {{-- 3 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">3- فاتورة</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="facture">
            @if(!empty($document->facture))
                <a href="{{ asset('storage/'.$document->facture) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>
    <span> فاتورة نهائية باللغة العربية ...</span>

    {{-- 4 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">4- عقد بين المشتري و المورد</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="contrat">
            @if(!empty($document->contrat))
                <a href="{{ asset('storage/'.$document->contrat) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>
    <span> يحتوي على كل البيانات ...</span>

    {{-- 5 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">5- وثيقة الاعلام بالوصول</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="fichier_arrivage">
            @if(!empty($document->fichier_arrivage))
                <a href="{{ asset('storage/'.$document->fichier_arrivage) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>
    <span> تسلم من قبل الناقل </span>

    {{-- 6 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">6- وثيقة الشحن</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="fichier_colisage">
            @if(!empty($document->fichier_colisage))
                <a href="{{ asset('storage/'.$document->fichier_colisage) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>

    {{-- 7 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">7- نسخة من بطاقة التعريف الجبائي</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="copie_registre_fiscal">
            @if(!empty($document->copie_registre_fiscal))
                <a href="{{ asset('storage/'.$document->copie_registre_fiscal) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>

    {{-- 8 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">8- نسخة من مضمون السجل الوطني للمؤسسات</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="copie_registre_national_institutions">
            @if(!empty($document->copie_registre_national_institutions))
                <a href="{{ asset('storage/'.$document->copie_registre_national_institutions) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>

    {{-- 9 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">9- نسخة من شهادة الملكية</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="copie_certificat_propriete">
            @if(!empty($document->copie_certificat_propriete))
                <a href="{{ asset('storage/'.$document->copie_certificat_propriete) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>
    <span> او نسخة منعقد بيع ...</span>

    {{-- 10 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">10- تعهد</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="engagement">
            @if(!empty($document->engagement))
                <a href="{{ asset('storage/'.$document->engagement) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>
    <span> معرف بالامضاء بعدم التفويت ...</span>

    {{-- 11 --}}
    <div class="form-group row mb-3">
        <label class="col-sm-6 col-form-label">11- مثال هندسي للمشروع</label>
        <div class="col-sm-10">
            <input type="file" class="form-control" name="exemple_projet">
            @if(!empty($document->exemple_projet))
                <a href="{{ asset('storage/'.$document->exemple_projet) }}" target="_blank" class="btn btn-link">مشاهدة الملف الحالي</a>
            @endif
        </div>
    </div>
    <span> معد من قبل مهندس معماري ...</span>
</div>


         <div class="form-group row text-center" style="padding-top:50px;">
            <div class="d-flex justify-content-end mb-4">
                               <button type="submit" class="btn btn-orange font-weight-medium" >
                    تحيين
                </button>
            </div>
          
        </div>
    </form>
</div>
</div>
    @else
        <script>
            window.location.href = "{{ route('login') }}";
        </script>
    @endif
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeunesse-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });

        // Prévisualisation des fichiers
        const fileInputs = document.querySelectorAll('input[type="file"]');
        fileInputs.forEach(input => {
            input.addEventListener('change', function(e) {
                const fileName = e.target.files[0]?.name;
                if (fileName) {
                    const label = input.closest('.form-group').querySelector('.col-form-label');
                    label.setAttribute('title', `Fichier sélectionné : ${fileName}`);
                }
            });
        });

        // Gestion des champs d'identité
        function showTypeIdentiteInput4() {
            const selectedType = document.getElementById('id_type_identite').value;
            document.getElementById('cin_input_wrapper').style.display = selectedType === '1' ? '' : 'none';
            document.getElementById('passport_field').style.display = selectedType === '2' ? '' : 'none';
            document.getElementById('fiscal_field').style.display = selectedType === '3' ? '' : 'none';
        }

        // Initialiser l'affichage des champs d'identité
        if (document.getElementById('id_type_identite')) {
            showTypeIdentiteInput4();
            document.getElementById('id_type_identite').addEventListener('change', showTypeIdentiteInput4);
        }
    });
</script>
@endsection
