@extends('layouts.app')

@section('styles')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire_edit.css') }}">
@endsection

@section('content')


@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="salle-sport-edit it-about-3-area p-relative pt-30 pb-125">
    <img class="it-about-shape-1" src="{{ asset('assets/img/shape/about-1-1.png') }}" alt="">
    <div class="container">
	<nav class="breadcrumb-nav" aria-label="breadcrumb">
    <ol class="breadcrumb mb-0">
   <li class="breadcrumb-item">
    <a href="{{ route('dashboard') }}">
        <i class="bi bi-house-fill"></i>
        <span>{{ __('site.investment.breadcrumb.home') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
    <a href="{{ route('investissement_choix') }}">
        <span>{{ __('site.investment.breadcrumb.index') }}</span>
    </a>
</li>
<li class="breadcrumb-item">
            <a href="{{ route('exoneration_choix') }}">
                <span>مشاريع الإعفاء الجبائي</span>
            </a>
        </li>
		<li class="breadcrumb-item">
    <a href="{{ route('exoneration.index') }}">
        <span>قائمة المشاريع</span>
    </a>
</li>
<li class="breadcrumb-item active" aria-current="page">{{ __('site.investment.breadcrumb.add_exo') }}</li>

    </ol>
</nav>

<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css" rel="stylesheet">
<form class="card shadow-sm p-4"  action="{{ route('exoneration.store') }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
            <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
            <input type="hidden" name="id_type_formulaire" value="{{ $id_type_formulaire ?? $formulaire2?->id_type }}">
            <input type="hidden" name="immobilier_id" value="{{ $immobilier_id }}"> 
            
            <h4 style="text-align:center;padding-top:20px;">إستمارة تسجيل الإنتفاع بإعفاء جبائي</h4>
            <br>
            <div class="form-section">
                <h4>هوية صاحب المشروع</h4>

                <div class="form-group row mb-3"  style="padding-top:20px;">
                    <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="nom_prenom" value="{{ old('nom_prenom', Auth::user()->nom_prenom ?? '') }}" readonly>
                    </div>

                    <label class="col-sm-2 col-form-label"> رقم الهاتف </label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="tel" value="{{ old('tel', Auth::user()->tel ?? '') }}" readonly>
                    </div>
                </div>

                <div class="form-group row align-items-center">
                    <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                    <div class="col-sm-4">
                        <input type="text" class="form-control" 
                            value="{{ Auth::user()->typeIdentite->type_ar ?? '' }}" 
                            readonly>
                    </div>

                    @php $user = Auth::user(); @endphp

                    @if($user->id_type_identite == 1)
                        <div class="col-sm-6">
                            <input type="text" class="form-control" value="{{ $user->cin ?? '' }}" readonly>
                        </div>
                    @elseif($user->id_type_identite == 2)
                        <div class="col-sm-6">
                               <input type="text" class="form-control" value="{{ $user->passport ?? '' }}" readonly>
                        </div>
                    @elseif($user->id_type_identite == 3)
                        <div class="col-sm-6">
                            <input type="text" class="form-control" value="{{ $user->num_fiscal ?? '' }}" readonly>
                        </div>
                    @endif
                </div>
                
                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="adresse" value="{{ old('adresse', Auth::user()->adresse ?? '') }}" readonly >
                    </div>

                    <label class="col-sm-2 col-form-label">  البريد الالكتروني </label>
                    <div class="col-sm-4">
                        <input required type="email" class="form-control" name="email" value="{{ old('email', Auth::user()->email ?? '') }}" readonly>
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-2 col-form-label"> عنوان المشروع  </label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="nom_projet">
                    </div>

                    <label class="col-sm-2 col-form-label">  مكان المشروع </label>
                    <div class="col-sm-4">
                        <input required type="text" class="form-control" name="adresse_projet">
                    </div>
                </div>

            </div>

            <div class="form-section mt-4">
                <h4> إضافة الوثائق المطلوبة </h4>
                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label"> 1- نسخة من كراس الشروط  </label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_cahier_des_charges" name="copie_cahier_des_charges">
                    </div>
                </div>
                <span> مؤشر عليها في جميع صفحاتها من قبل الباعث الخاص و مصحوبة بنسخة من وصل الإيداع او تحتوي على ختم المندوبية الجهوية للشباب و الرياضة مرجع النظر ترابيا لمكان تركيز المشروع</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">2- الاصل من شهادة ايداع التصريح</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_originale" name="copie_originale">
                    </div>
                </div>
                <span> مسلمة من قبل مصالح وكالة النهوض بالصناعة و التحديد مرجع النظر ترابيا لمكان تركيز المشروع على قائمة التجهيزات التي سيتم اقتنائها فعليا </span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">3- فاتورة</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="facture" name="facture" >
                    </div>
                </div>
                <span> فاتورة نهائية باللغة العربية او الفرنسية تحتوي حصرا على قائمة التجهيزات المزمن اقتنائها موضوع طلب الامتياز الجبائي و مطابقة للقائمة المضمنة بشهادة ايداع التصريح</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">4- عقد بين المشتري و المورد</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="contrat" name="contrat">
                    </div>
                </div>
                <span> يحتوي على كل البيانات الافصال و الكمية و الثمن و العلامة التجارية للتجهيزات ممضى من قبل الطرفين</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">5- وثيقة الاعلام بالوصول</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="fichier_arrivage" name="fichier_arrivage">
                    </div>      
                </div>
                <span>تسلم من قبل الناقل</span>
                

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">6- وثيقة الشحن</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="fichier_colisage" name="fichier_colisage">
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">7- نسخة من بطاقة التعريف الجبائي</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_registre_fiscal" name="copie_registre_fiscal" >
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">8- نسخة من مضمون السجل الوطني للمؤسسات</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_registre_national_institutions" name="copie_registre_national_institutions">
                    </div>
                </div>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">9- نسخة من شهادة الملكية </label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="copie_certificat_propriete" name="copie_certificat_propriete">
                    </div>
                </div>
                <span> او نسخة منعقد بيع او هبة او كراء للعقار الموظف لتركيز المشروع ساري المفعول مسجل بالقباضة المالية</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">10- تعهد</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="engagement" name="engagement">
                    </div>
                </div>
                <span>معرف بالامضاء بعدم التفويت في التجهيزات المقتناة لمدة 5 سنوات مع ذكر التجهيزات بالتفصيل</span>

                <div class="form-group row mb-3">
                    <label class="col-sm-6 col-form-label">11- مثال هندسي للمشروع</label>
                    <div class="col-sm-10">
                        <input type="file" class="form-control" id="exemple_projet" name="exemple_projet">
                    </div>
                </div>
                <span> معد من قبل مهندس معماري يحتوي على مثال لتركيز التجهيزات و يحمل ختمه و امضاءه مع ادراج بيانات المشروع </span>

            </div>   

           <div class="form-group row text-center" style="padding-top:50px;">
          <div class="d-flex justify-content-end mb-4">
                <button type="submit" class="btn btn-success font-weight-medium" >إرسال</button>
            </div>
          
        </div>
        </form>
    </div>
</div>
    @else
        <script>
            window.location.href = "{{ route('login') }}";
        </script>
    @endif
</div>
@endsection

@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
        // Désactiver nice-select pour tous les selects dans le formulaire
        const formSelects = document.querySelectorAll('.jeunesse-form select');
        formSelects.forEach(select => {
            const niceSelect = select.nextElementSibling;
            if (niceSelect && niceSelect.classList.contains('nice-select')) {
                niceSelect.remove();
            }
        });

        // Prévisualisation des fichiers
        const fileInputs = document.querySelectorAll('input[type="file"]');
        fileInputs.forEach(input => {
            input.addEventListener('change', function(e) {
                const fileName = e.target.files[0]?.name;
                if (fileName) {
                    const label = input.closest('.form-group').querySelector('.col-form-label');
                    label.setAttribute('title', `Fichier sélectionné : ${fileName}`);
                }
            });
        });
    });
</script>
@endsection