@extends('backoffice.dashboard')

@section('content')

@if(Auth::check())
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0">القوائم الرئيسية</h2>
                    <a class="btn btn-success font-weight-medium" href="#">
                        <i class="la la-plus mr-1"></i> إضافة قائمة
                    </a>
                </div>

                @if(session('ok'))
                    <div class="alert alert-success">{{ session('ok') }}</div>
                @endif

                <div class="block-card-body">
                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th width="10%">#</th>
                                    <th width="30%">الاسم بالعربية</th>
                                    <th width="30%">الاسم بالفرنسية</th>
                                    <th width="30%">الاسم بالإنجليزية</th>
                                    <th width="20%">العمليات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($types as $type)
                                    <tr>
                                        <td>{{ $type->id_type }}</td>
                                        <td>{{ $type->type_ar }}</td>
                                        <td>{{ $type->type_fr }}</td>
                                        <td>{{ $type->type_en }}</td>
                                        <td class="btn-group">
                                            <a class="btn btn-orange btn-sm mr-2"
                                               onclick="return confirmAction('هل تريد تعديل هذه القائمة ؟', '{{ route('types.edit', $type->id_type ?? 0) }}', null)">
                                                <i class="la la-edit mr-1"></i> تعديل
                                            </a>
                                            <form action="{{ route('types.destroy', $type->id_type ?? 0) }}" method="POST" style="display:inline;">
                                                @csrf
                                                @method('DELETE')
                                                <button type="button"
                                                    onclick="return confirmAction('هل تريد حذف هذه القائمة ؟', null, this.closest('form'))"
                                                    class="btn bg-rgb-primary1 font-weight-medium">
                                                    <i class="la la-trash mr-1"></i> حذف
                                                </button>
                                            </form>
                                        </td>
                                    </tr>
                                @empty
                                    <tr><td colspan="5" class="text-center">لا توجد قوائم.</td></tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        {{ $types->links() }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>
@else
<script>
    window.location.href = "{{ route('admin') }}";
</script>
@endif

@endsection
